/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui.evaluation;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import unbbayes.controller.FileController;
import unbbayes.controller.IconController;
import unbbayes.controller.JavaHelperController;
import unbbayes.datamining.classifiers.BayesianNetwork;
import unbbayes.datamining.classifiers.Classifier;
import unbbayes.datamining.classifiers.CombinatorialNeuralModel;
import unbbayes.datamining.classifiers.DistributionClassifier;
import unbbayes.datamining.classifiers.NeuralNetwork;
import unbbayes.datamining.classifiers.decisiontree.DecisionTreeLearning;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.gui.evaluation.EvaluationPanel;
import unbbayes.gui.FileIcon;
import unbbayes.gui.SimpleFileFilter;
import unbbayes.prs.bn.ProbabilisticNetwork;

public class EvaluationMain
extends JInternalFrame {
    private static final long serialVersionUID = 0L;
    private ResourceBundle resource;
    private ImageIcon abrirIcon;
    private ImageIcon helpIcon;
    private JPanel contentPane;
    private JMenuBar jMenuBar1 = new JMenuBar();
    private JMenu jMenuFile = new JMenu();
    private JMenu jMenuHelp = new JMenu();
    private JMenuItem jMenuHelpAbout = new JMenuItem();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel jPanel41 = new JPanel();
    private TitledBorder titledBorder5;
    private Border border5;
    private EvaluationPanel jPanel2 = new EvaluationPanel(this);
    private JLabel statusBar = new JLabel();
    private BorderLayout borderLayout2 = new BorderLayout();
    private InstanceSet inst;
    private ProbabilisticNetwork net;
    private Classifier classifier;
    private File selectedFile;
    private boolean instOK = false;
    private JMenuItem jMenuFileExit = new JMenuItem();
    private JFileChooser fileChooser;
    private JToolBar jToolBar1 = new JToolBar();
    private JMenuItem jMenuItem2 = new JMenuItem();
    private JButton helpButton = new JButton();
    private JButton openButton = new JButton();

    public EvaluationMain() {
        super("", true, true, true, true);
        this.resource = ResourceBundle.getBundle("unbbayes.datamining.gui.evaluation.resources.EvaluationResource");
        this.setTitle(this.resource.getString("title"));
        this.enableEvents(64L);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        IconController iconController = IconController.getInstance();
        this.abrirIcon = iconController.getOpenIcon();
        this.helpIcon = iconController.getHelpIcon();
        this.contentPane = (JPanel)this.getContentPane();
        this.titledBorder5 = new TitledBorder(this.border5, this.resource.getString("selectProgram"));
        this.border5 = BorderFactory.createLineBorder(new Color(153, 153, 153), 1);
        this.contentPane.setLayout(this.borderLayout1);
        this.setSize(new Dimension(640, 480));
        this.jMenuFile.setMnemonic(((Character)this.resource.getObject("fileMnemonic")).charValue());
        this.jMenuFile.setText(this.resource.getString("file"));
        this.jMenuHelp.setMnemonic(((Character)this.resource.getObject("helpMnemonic")).charValue());
        this.jMenuHelp.setText(this.resource.getString("help"));
        this.jMenuHelpAbout.setIcon(this.helpIcon);
        this.jMenuHelpAbout.setMnemonic(((Character)this.resource.getObject("helpTopicsMnemonic")).charValue());
        this.jMenuHelpAbout.setText(this.resource.getString("helpTopics"));
        this.jMenuHelpAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EvaluationMain.this.jMenuHelpAbout_actionPerformed(e);
            }
        });
        this.jPanel41.setLayout(this.borderLayout2);
        this.jPanel41.setBorder(this.titledBorder5);
        this.titledBorder5.setTitle(this.resource.getString("status"));
        this.statusBar.setText(this.resource.getString("welcome"));
        this.jMenuFileExit.setMnemonic(((Character)this.resource.getObject("fileExitMnemonic")).charValue());
        this.jMenuFileExit.setText(this.resource.getString("exit"));
        this.jMenuFileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EvaluationMain.this.jMenuFileExit_actionPerformed(e);
            }
        });
        this.jToolBar1.setFloatable(false);
        this.jMenuItem2.setIcon(this.abrirIcon);
        this.jMenuItem2.setMnemonic(((Character)this.resource.getObject("openModelMnemonic")).charValue());
        this.jMenuItem2.setText(this.resource.getString("openModelDialog"));
        this.jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EvaluationMain.this.jMenuItem2_actionPerformed(e);
            }
        });
        this.helpButton.setIcon(this.helpIcon);
        this.helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EvaluationMain.this.helpButton_actionPerformed(e);
            }
        });
        this.openButton.setToolTipText(this.resource.getString("openModel"));
        this.openButton.setIcon(this.abrirIcon);
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EvaluationMain.this.openButton_actionPerformed(e);
            }
        });
        this.jMenuFile.add(this.jMenuItem2);
        this.jMenuFile.add(this.jMenuFileExit);
        this.jMenuHelp.add(this.jMenuHelpAbout);
        this.jMenuBar1.add(this.jMenuFile);
        this.jMenuBar1.add(this.jMenuHelp);
        this.setJMenuBar(this.jMenuBar1);
        this.contentPane.add((Component)this.jPanel41, "South");
        this.jPanel41.add((Component)this.statusBar, "Center");
        this.contentPane.add((Component)this.jPanel2, "Center");
        this.contentPane.add((Component)this.jToolBar1, "North");
        this.jToolBar1.add((Component)this.openButton, null);
        this.jToolBar1.add((Component)this.helpButton, null);
    }

    public void jMenuFileExit_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
        try {
            JavaHelperController.getInstance().openHelp(this);
        }
        catch (Exception evt) {
            this.statusBar.setText(String.valueOf(this.resource.getString("error2")) + evt.getMessage() + " " + this.getClass().getName());
        }
    }

    public void setStatusBar(String text) {
        this.statusBar.setText(text);
    }

    void openTest() {
        this.setCursor(new Cursor(3));
        String[] s1 = new String[]{"ARFF"};
        String[] s2 = new String[]{"TXT"};
        this.fileChooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        this.fileChooser.setDialogTitle("Open Test Instance Set");
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileView(new FileIcon(this));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s2, "TxtFiles (*.txt)"));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s1, "ArffFiles (*.arff)"));
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.selectedFile = this.fileChooser.getSelectedFile();
            this.openFile(this.selectedFile);
            this.statusBar.setText("Test Instance Set opened successfully");
            FileController.getInstance().setCurrentDirectory(this.fileChooser.getCurrentDirectory());
        } else {
            this.statusBar.setText("Open Test Instance Set canceled");
            this.instOK = false;
        }
        this.setCursor(new Cursor(0));
    }

    private void openFile(File selectedFile) {
        try {
            this.inst = FileController.getInstance().getInstanceSet(selectedFile, this);
            if (this.inst != null) {
                boolean bool = this.inst.checkNumericAttributes();
                if (bool) {
                    throw new Exception(this.resource.getString("numericAttributesException"));
                }
                this.instOK = true;
                this.statusBar.setText("Test file opened sucessfully");
            } else {
                this.statusBar.setText("Opera\ufffd\ufffdo cancelada");
            }
        }
        catch (NullPointerException npe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("errorDB")) + npe.getMessage());
        }
        catch (FileNotFoundException fnfe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("fileNotFound")) + fnfe.getMessage());
        }
        catch (IOException ioe) {
            this.statusBar.setText(String.valueOf(this.resource.getString("errorOpen")) + ioe.getMessage());
        }
        catch (Exception e) {
            this.statusBar.setText(String.valueOf(this.resource.getString("error")) + e.getMessage());
        }
    }

    void helpButton_actionPerformed(ActionEvent e) {
        this.jMenuHelpAbout_actionPerformed(e);
    }

    void openButton_actionPerformed(ActionEvent e) {
        this.jMenuItem2_actionPerformed(e);
    }

    void jMenuItem2_actionPerformed(ActionEvent evt) {
        this.classifier = null;
        this.openModel();
        if (this.instOK) {
            this.openTest();
        }
        if (this.instOK && this.classifier == null) {
            try {
                BayesianNetwork bayesianNetwork = new BayesianNetwork(this.net, this.inst);
                this.classifier = bayesianNetwork;
            }
            catch (Exception e) {
                this.statusBar.setText(e.getMessage());
                this.instOK = false;
            }
        }
        if (this.instOK) {
            this.jPanel2.setModel(this.classifier, this.inst);
            this.setTitle("Evaluation - " + this.selectedFile.getName());
        }
    }

    private void openModel() {
        this.setCursor(new Cursor(3));
        String[] s2 = new String[]{"NET"};
        String[] s1 = new String[]{"ID3"};
        String[] s3 = new String[]{"CNM"};
        String[] s4 = new String[]{"BPN"};
        this.fileChooser = new JFileChooser(FileController.getInstance().getCurrentDirectory());
        this.fileChooser.setDialogTitle("Open model");
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.setFileView(new FileIcon(this));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s2, "Networks (*.net)"));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s1, "ID3 Models (*.id3)"));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s3, "CNM Models (*.cnm)"));
        this.fileChooser.addChoosableFileFilter(new SimpleFileFilter(s4, "BPN Models (*.bpn)"));
        int returnVal = this.fileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.selectedFile = this.fileChooser.getSelectedFile();
            this.setModelFromFile(this.selectedFile);
            this.instOK = true;
            this.statusBar.setText(this.resource.getString("modelOpened"));
            FileController.getInstance().setCurrentDirectory(this.fileChooser.getCurrentDirectory());
        } else {
            this.statusBar.setText("Open model canceled");
            this.instOK = false;
        }
        this.setCursor(new Cursor(0));
    }

    private void setModelFromFile(File f) {
        block9: {
            try {
                String fileName = f.getName();
                fileName.toLowerCase();
                if (fileName.regionMatches(true, fileName.length() - 4, ".id3", 0, 4)) {
                    ObjectInputStream in = new ObjectInputStream(new FileInputStream(f));
                    this.classifier = (DecisionTreeLearning)in.readObject();
                    break block9;
                }
                if (fileName.regionMatches(true, fileName.length() - 4, ".net", 0, 4)) {
                    ObjectInputStream in = new ObjectInputStream(new FileInputStream(f));
                    this.classifier = (DistributionClassifier)in.readObject();
                    break block9;
                }
                if (fileName.regionMatches(true, fileName.length() - 4, ".cnm", 0, 4)) {
                    ObjectInputStream in = new ObjectInputStream(new FileInputStream(f));
                    this.classifier = (CombinatorialNeuralModel)in.readObject();
                    break block9;
                }
                if (fileName.regionMatches(true, fileName.length() - 4, ".bpn", 0, 4)) {
                    ObjectInputStream in = new ObjectInputStream(new FileInputStream(f));
                    this.classifier = (NeuralNetwork)in.readObject();
                    break block9;
                }
                throw new IOException(this.resource.getString("fileExtensionNotKnown"));
            }
            catch (NullPointerException npe) {
                this.statusBar.setText(String.valueOf(this.resource.getString("errorDB")) + npe.getMessage());
            }
            catch (FileNotFoundException fnfe) {
                this.statusBar.setText(String.valueOf(this.resource.getString("fileNotFound")) + fnfe.getMessage());
            }
            catch (IOException ioe) {
                this.statusBar.setText(String.valueOf(this.resource.getString("errorOpen")) + ioe.getMessage());
            }
            catch (Exception e) {
                this.statusBar.setText(String.valueOf(this.resource.getString("error")) + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

