/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import unbbayes.controller.IconController;
import unbbayes.controller.JavaHelperController;
import unbbayes.datamining.datamanipulation.Options;
import unbbayes.datamining.gui.GlobalOptions;
import unbbayes.datamining.gui.bayesianlearning.BayesianLearningMain;
import unbbayes.datamining.gui.evaluation.EvaluationMain;
import unbbayes.datamining.gui.evaluation.batchEvaluation.BatchEvaluationMain;
import unbbayes.datamining.gui.id3.DecisionTreeMain;
import unbbayes.datamining.gui.naivebayes.NaiveBayesMain;
import unbbayes.datamining.gui.neuralmodel.NeuralModelController;
import unbbayes.datamining.gui.neuralnetwork.NeuralNetworkController;
import unbbayes.datamining.gui.preprocessor.PreprocessorMain;
import unbbayes.datamining.gui.preprocessor.janeladiscret;
import unbbayes.gui.MDIDesktopPane;

public class InvokerMain
extends JFrame {
    private static final long serialVersionUID = 0L;
    private JPanel contentPane;
    private MDIDesktopPane desktop = new MDIDesktopPane();
    private ImageIcon metalIcon;
    private ImageIcon motifIcon;
    private ImageIcon windowsIcon;
    private ImageIcon cascadeIcon;
    private ImageIcon tileIcon;
    private ImageIcon helpIcon;
    private ImageIcon opcaoglobalIcon;
    private int defaultStates = 40;
    private int confidenceLimit = 100;
    private String defaultLanguage = "Portuguese";
    private String defaultLaf = "Windows";
    private ResourceBundle resource = ResourceBundle.getBundle("unbbayes.datamining.gui.resources.GuiResource");
    private InvokerMain reference = this;
    private IconController iconController = IconController.getInstance();
    private JPanel topPanel = new JPanel(new FlowLayout(0));
    private JToolBar jtbView;
    private JToolBar jtbPreferences;
    private JToolBar jtbWindow;
    private JToolBar jtbHelp;
    private JButton metal = new JButton();
    private JButton motif = new JButton();
    private JButton windows = new JButton();
    private JButton tile = new JButton();
    private JButton cascade = new JButton();
    private JButton help = new JButton();
    private JButton preferences = new JButton();
    private ActionListener alNaiveBayes;
    private ActionListener alPreProcessor;
    private ActionListener alId3;
    private ActionListener alEvaluation;
    private ActionListener alCnm;
    private ActionListener alC45;
    private ActionListener alBayesianLearning;
    private ActionListener alPreferences;
    private ActionListener alTbPreferences;
    private ActionListener alTbView;
    private ActionListener alTbWindow;
    private ActionListener alTbHelp;
    private ActionListener alMetal;
    private ActionListener alMotif;
    private ActionListener alWindows;
    private ActionListener alCascade;
    private ActionListener alTile;
    private ActionListener alHelp;
    private ActionListener alNeuralNetwork;
    private ActionListener alBatchEvaluation;
    private ActionListener alDiscretize;

    public InvokerMain() {
        this.openDefaultOptions();
        this.metalIcon = this.iconController.getMetalIcon();
        this.motifIcon = this.iconController.getMotifIcon();
        this.windowsIcon = this.iconController.getWindowsIcon();
        this.cascadeIcon = this.iconController.getCascadeIcon();
        this.tileIcon = this.iconController.getTileIcon();
        this.helpIcon = this.iconController.getHelpIcon();
        this.opcaoglobalIcon = this.iconController.getGlobalOptionIcon();
        this.createActionListeners();
        this.createToolBars();
        this.createMenu();
        this.contentPane = (JPanel)this.getContentPane();
        this.contentPane.add((Component)this.topPanel, "North");
        this.topPanel.setBorder(null);
        this.contentPane.add((Component)new JScrollPane(this.desktop), "Center");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(screenSize);
        this.setTitle("UnBMiner");
        Options.getInstance().setNumberStatesAllowed(this.defaultStates);
        Options.getInstance().setConfidenceLimit(this.confidenceLimit);
        if (this.defaultLaf.equals("Metal")) {
            this.setLnF("javax.swing.plaf.metal.MetalLookAndFeel");
        } else if (this.defaultLaf.equals("Motif")) {
            this.setLnF("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        } else if (this.defaultLaf.equals("Windows")) {
            this.setLnF("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        super.processWindowEvent(e);
        if (e.getID() == 201) {
            System.exit(0);
        }
    }

    private void openDefaultOptions() {
        try {
            BufferedReader r = new BufferedReader(new FileReader(new File("DataMining.ini")));
            String header = r.readLine();
            if (header.equals("[data mining]")) {
                String laf;
                String language;
                String confidence;
                String states = r.readLine();
                if (states.substring(0, 17).equals("Maximum states = ")) {
                    this.defaultStates = Integer.parseInt(states.substring(17));
                }
                if ((confidence = r.readLine()).substring(0, 19).equals("Confidence limit = ")) {
                    this.confidenceLimit = Integer.parseInt(confidence.substring(19));
                }
                if ((language = r.readLine()).substring(0, 11).equals("Language = ")) {
                    if ((language = language.substring(11)).equals("English")) {
                        Locale.setDefault(new Locale("en", ""));
                        this.defaultLanguage = language;
                    } else if (language.equals("Potuguese")) {
                        Locale.setDefault(new Locale("pt", ""));
                        this.defaultLanguage = language;
                    }
                }
                if ((laf = r.readLine()).substring(0, 16).equals("Look and Feel = ")) {
                    if ((laf = laf.substring(16)).equals("Metal")) {
                        this.defaultLaf = laf;
                    } else if (laf.equals("Motif")) {
                        this.defaultLaf = laf;
                    } else if (laf.equals("Windows")) {
                        this.defaultLaf = laf;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setLnF(String lnfName) {
        try {
            UIManager.setLookAndFeel(lnfName);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (UnsupportedLookAndFeelException ex1) {
            System.err.println(String.valueOf(this.resource.getString("unsupportedLookAndFeelException")) + lnfName);
        }
        catch (ClassNotFoundException ex2) {
            System.err.println(String.valueOf(this.resource.getString("classNotFoundException")) + lnfName);
        }
        catch (InstantiationException ex3) {
            System.err.println(String.valueOf(this.resource.getString("instanciationException")) + lnfName);
        }
        catch (IllegalAccessException ex4) {
            System.err.println(String.valueOf(this.resource.getString("illegalAccessException")) + lnfName);
        }
    }

    public JInternalFrame getSelectedWindow() {
        return this.desktop.getSelectedFrame();
    }

    public void addWindow(JInternalFrame newWindow) {
        this.desktop.add(newWindow);
    }

    public void createActionListeners() {
        this.alNaiveBayes = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                InvokerMain.this.setCursor(new Cursor(3));
                NaiveBayesMain naive = new NaiveBayesMain();
                InvokerMain.this.addWindow(naive);
                InvokerMain.this.setCursor(new Cursor(0));
            }
        };
        this.alPreferences = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                InvokerMain.this.setCursor(new Cursor(3));
                GlobalOptions options = new GlobalOptions();
                options.setDefaultOptions(Options.getInstance().getNumberStatesAllowed(), Options.getInstance().getConfidenceLimit(), InvokerMain.this.defaultLanguage, InvokerMain.this.defaultLaf);
                InvokerMain.this.addWindow(options);
                InvokerMain.this.setCursor(new Cursor(0));
            }
        };
        this.alPreProcessor = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                InvokerMain.this.setCursor(new Cursor(3));
                PreprocessorMain preprocessor = new PreprocessorMain();
                InvokerMain.this.addWindow(preprocessor);
                InvokerMain.this.setCursor(new Cursor(0));
            }
        };
        this.alId3 = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                InvokerMain.this.setCursor(new Cursor(3));
                DecisionTreeMain id3 = new DecisionTreeMain();
                InvokerMain.this.addWindow(id3);
                InvokerMain.this.setCursor(new Cursor(0));
            }
        };
        this.alC45 = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                InvokerMain.this.setCursor(new Cursor(3));
                unbbayes.datamining.gui.c45.DecisionTreeMain c45 = new unbbayes.datamining.gui.c45.DecisionTreeMain(InvokerMain.this.desktop);
                InvokerMain.this.addWindow(c45);
                InvokerMain.this.setCursor(new Cursor(0));
            }
        };
        this.alEvaluation = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                InvokerMain.this.setCursor(new Cursor(3));
                EvaluationMain evaluation = new EvaluationMain();
                InvokerMain.this.addWindow(evaluation);
                InvokerMain.this.setCursor(new Cursor(0));
            }
        };
        this.alCnm = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                InvokerMain.this.setCursor(new Cursor(3));
                NeuralModelController cnm = new NeuralModelController();
                InvokerMain.this.addWindow(cnm.getCnmFrame());
                InvokerMain.this.setCursor(new Cursor(0));
            }
        };
        this.alNeuralNetwork = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                InvokerMain.this.setCursor(new Cursor(3));
                NeuralNetworkController neuralNetworkContoller = new NeuralNetworkController();
                InvokerMain.this.addWindow(neuralNetworkContoller.getMainFrame());
                InvokerMain.this.setCursor(new Cursor(0));
            }
        };
        this.alBayesianLearning = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                InvokerMain.this.setCursor(new Cursor(3));
                BayesianLearningMain bayesianLearning = new BayesianLearningMain();
                InvokerMain.this.addWindow(bayesianLearning);
                InvokerMain.this.setCursor(new Cursor(0));
            }
        };
        this.alBatchEvaluation = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                InvokerMain.this.setCursor(new Cursor(3));
                BatchEvaluationMain batchEvaluation = new BatchEvaluationMain();
                InvokerMain.this.addWindow(batchEvaluation);
                InvokerMain.this.setCursor(new Cursor(0));
            }
        };
        this.alTbView = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InvokerMain.this.setCursor(new Cursor(3));
                if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                    InvokerMain.this.topPanel.add(InvokerMain.this.jtbView);
                } else {
                    InvokerMain.this.topPanel.remove(InvokerMain.this.jtbView);
                }
                InvokerMain.this.validate();
                InvokerMain.this.setCursor(new Cursor(0));
            }
        };
        this.alTbPreferences = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InvokerMain.this.setCursor(new Cursor(3));
                if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                    InvokerMain.this.topPanel.add(InvokerMain.this.jtbPreferences);
                } else {
                    InvokerMain.this.topPanel.remove(InvokerMain.this.jtbPreferences);
                }
                InvokerMain.this.validate();
                InvokerMain.this.setCursor(new Cursor(0));
            }
        };
        this.alTbWindow = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InvokerMain.this.setCursor(new Cursor(3));
                if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                    InvokerMain.this.topPanel.add(InvokerMain.this.jtbWindow);
                } else {
                    InvokerMain.this.topPanel.remove(InvokerMain.this.jtbWindow);
                }
                InvokerMain.this.validate();
                InvokerMain.this.setCursor(new Cursor(0));
            }
        };
        this.alTbHelp = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InvokerMain.this.setCursor(new Cursor(3));
                if (((JCheckBoxMenuItem)e.getSource()).getState()) {
                    InvokerMain.this.topPanel.add(InvokerMain.this.jtbHelp);
                } else {
                    InvokerMain.this.topPanel.remove(InvokerMain.this.jtbHelp);
                }
                InvokerMain.this.validate();
                InvokerMain.this.setCursor(new Cursor(0));
            }
        };
        this.alMetal = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InvokerMain.this.setCursor(new Cursor(3));
                InvokerMain.this.setLnF("javax.swing.plaf.metal.MetalLookAndFeel");
                InvokerMain.this.setCursor(new Cursor(0));
            }
        };
        this.alMotif = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InvokerMain.this.setCursor(new Cursor(3));
                InvokerMain.this.setLnF("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                InvokerMain.this.setCursor(new Cursor(0));
            }
        };
        this.alWindows = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InvokerMain.this.setCursor(new Cursor(3));
                InvokerMain.this.setLnF("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                InvokerMain.this.setCursor(new Cursor(0));
            }
        };
        this.alCascade = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InvokerMain.this.desktop.cascadeFrames();
            }
        };
        this.alTile = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InvokerMain.this.desktop.tileFrames();
            }
        };
        this.alHelp = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                InvokerMain.this.setCursor(new Cursor(3));
                try {
                    JavaHelperController.getInstance().openHelp(InvokerMain.this.reference);
                }
                catch (Exception evt) {
                    System.out.println("Error= " + evt.getMessage() + " " + this.getClass().getName());
                }
                InvokerMain.this.setCursor(new Cursor(0));
            }
        };
        this.alDiscretize = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                janeladiscret janela = new janeladiscret();
                janela.setVisible(true);
            }
        };
    }

    public void createMenu() {
        JMenuBar menu = new JMenuBar();
        JMenu programMenu = new JMenu(this.resource.getString("selectProgram"));
        JMenu lafMenu = new JMenu(this.resource.getString("lookAndFeel"));
        JMenu viewMenu = new JMenu(this.resource.getString("view"));
        JMenu tbMenu = new JMenu(this.resource.getString("toolsbar"));
        JMenu preferencesMenu = new JMenu(this.resource.getString("globalOptions"));
        JMenu windowMenu = new JMenu(this.resource.getString("window"));
        JMenu helpMenu = new JMenu(this.resource.getString("help"));
        programMenu.setMnemonic(((Character)this.resource.getObject("selectMnemonic")).charValue());
        lafMenu.setMnemonic(((Character)this.resource.getObject("lafMnemonic")).charValue());
        preferencesMenu.setMnemonic(((Character)this.resource.getObject("globalOptionsMnemonic")).charValue());
        viewMenu.setMnemonic(((Character)this.resource.getObject("viewMnemonic")).charValue());
        windowMenu.setMnemonic(((Character)this.resource.getObject("windowMnemonic")).charValue());
        helpMenu.setMnemonic(((Character)this.resource.getObject("helpMnemonic")).charValue());
        tbMenu.setMnemonic(((Character)this.resource.getObject("tbMenuMnemonic")).charValue());
        JMenuItem preprocessorItem = new JMenuItem(this.resource.getString("instancesPreprocessor"));
        JMenuItem id3Item = new JMenuItem(this.resource.getString("id3Classifier"));
        JMenuItem naiveBayesItem = new JMenuItem(this.resource.getString("naiveBayesClassifier"));
        JMenuItem evaluationItem = new JMenuItem(this.resource.getString("evaluation"));
        JMenuItem optionsItem = new JMenuItem(this.resource.getString("preferences"), this.opcaoglobalIcon);
        JMenuItem discretizeItem = new JMenuItem("Discretizar");
        JMenuItem cnmItem = new JMenuItem("Combinatorial Neural Model");
        JMenuItem c45Item = new JMenuItem("C4.5 Classifier");
        JMenuItem bayesianItem = new JMenuItem("Bayesian Learning");
        JMenuItem neuralNetworkItem = new JMenuItem("Neural Network");
        JMenuItem batchEvaluationItem = new JMenuItem(this.resource.getString("batchEvaluation"));
        JMenuItem metalItem = new JMenuItem("Metal", this.metalIcon);
        JMenuItem motifItem = new JMenuItem("Motif", this.motifIcon);
        JMenuItem windowsItem = new JMenuItem("Windows", this.windowsIcon);
        JMenuItem cascadeItem = new JMenuItem(this.resource.getString("cascade"), this.cascadeIcon);
        JMenuItem tileItem = new JMenuItem(this.resource.getString("tile"), this.tileIcon);
        JMenuItem helpItem = new JMenuItem(this.resource.getString("helpTopics"), this.helpIcon);
        JCheckBoxMenuItem tbPreferences = new JCheckBoxMenuItem(this.resource.getString("tbPreferences"), true);
        JCheckBoxMenuItem tbView = new JCheckBoxMenuItem(this.resource.getString("tbView"), true);
        JCheckBoxMenuItem tbWindow = new JCheckBoxMenuItem(this.resource.getString("tbWindow"), true);
        JCheckBoxMenuItem tbHelp = new JCheckBoxMenuItem(this.resource.getString("tbHelp"), true);
        preprocessorItem.setMnemonic(((Character)this.resource.getObject("preprocessorMnemonic")).charValue());
        id3Item.setMnemonic(((Character)this.resource.getObject("id3Mnemonic")).charValue());
        naiveBayesItem.setMnemonic(((Character)this.resource.getObject("naiveBayesMnemonic")).charValue());
        evaluationItem.setMnemonic(((Character)this.resource.getObject("evaluationMnemonic")).charValue());
        optionsItem.setMnemonic(((Character)this.resource.getObject("preferencesMnemonic")).charValue());
        cnmItem.setMnemonic('N');
        c45Item.setMnemonic('C');
        bayesianItem.setMnemonic('B');
        batchEvaluationItem.setMnemonic(((Character)this.resource.getObject("batchEvaluationMnemonic")).charValue());
        metalItem.setMnemonic('M');
        motifItem.setMnemonic('O');
        windowsItem.setMnemonic('W');
        cascadeItem.setMnemonic(((Character)this.resource.getObject("cascadeMnemonic")).charValue());
        tileItem.setMnemonic(((Character)this.resource.getObject("tileMnemonic")).charValue());
        helpItem.setMnemonic(((Character)this.resource.getObject("helpTopicsMnemonic")).charValue());
        tbPreferences.setMnemonic(((Character)this.resource.getObject("tbPreferencesMnemonic")).charValue());
        tbView.setMnemonic(((Character)this.resource.getObject("tbViewMnemonic")).charValue());
        tbWindow.setMnemonic(((Character)this.resource.getObject("tbWindowMnemonic")).charValue());
        tbHelp.setMnemonic(((Character)this.resource.getObject("tbHelpMnemonic")).charValue());
        tbPreferences.addActionListener(this.alTbPreferences);
        tbView.addActionListener(this.alTbView);
        tbWindow.addActionListener(this.alTbWindow);
        tbHelp.addActionListener(this.alTbHelp);
        preprocessorItem.addActionListener(this.alPreProcessor);
        id3Item.addActionListener(this.alId3);
        c45Item.addActionListener(this.alC45);
        naiveBayesItem.addActionListener(this.alNaiveBayes);
        evaluationItem.addActionListener(this.alEvaluation);
        cnmItem.addActionListener(this.alCnm);
        neuralNetworkItem.addActionListener(this.alNeuralNetwork);
        batchEvaluationItem.addActionListener(this.alBatchEvaluation);
        bayesianItem.addActionListener(this.alBayesianLearning);
        metalItem.addActionListener(this.alMetal);
        motifItem.addActionListener(this.alMotif);
        windowsItem.addActionListener(this.alWindows);
        cascadeItem.addActionListener(this.alCascade);
        tileItem.addActionListener(this.alTile);
        helpItem.addActionListener(this.alHelp);
        optionsItem.addActionListener(this.alPreferences);
        discretizeItem.addActionListener(this.alDiscretize);
        programMenu.add(preprocessorItem);
        programMenu.add(id3Item);
        programMenu.add(c45Item);
        programMenu.add(naiveBayesItem);
        programMenu.add(bayesianItem);
        programMenu.add(cnmItem);
        programMenu.add(neuralNetworkItem);
        programMenu.add(evaluationItem);
        programMenu.add(discretizeItem);
        programMenu.add(batchEvaluationItem);
        lafMenu.add(metalItem);
        lafMenu.add(motifItem);
        lafMenu.add(windowsItem);
        tbMenu.add(tbView);
        tbMenu.add(tbPreferences);
        tbMenu.add(tbWindow);
        tbMenu.add(tbHelp);
        viewMenu.add(tbMenu);
        viewMenu.addSeparator();
        viewMenu.add(lafMenu);
        windowMenu.add(cascadeItem);
        windowMenu.add(tileItem);
        helpMenu.add(helpItem);
        preferencesMenu.add(optionsItem);
        menu.add(programMenu);
        menu.add(viewMenu);
        menu.add(preferencesMenu);
        menu.add(windowMenu);
        menu.add(helpMenu);
        this.setJMenuBar(menu);
    }

    public void createToolBars() {
        this.createButtons();
        this.jtbView = new JToolBar();
        this.jtbView.setFloatable(false);
        this.jtbPreferences = new JToolBar();
        this.jtbPreferences.setFloatable(false);
        this.jtbWindow = new JToolBar();
        this.jtbWindow.setFloatable(false);
        this.jtbHelp = new JToolBar();
        this.jtbHelp.setFloatable(false);
        this.jtbView.add(this.metal);
        this.jtbView.add(this.motif);
        this.jtbView.add(this.windows);
        this.jtbPreferences.add(this.preferences);
        this.jtbWindow.add(this.cascade);
        this.jtbWindow.add(this.tile);
        this.jtbHelp.add(this.help);
        this.topPanel.add(this.jtbView);
        this.topPanel.add(this.jtbPreferences);
        this.topPanel.add(this.jtbWindow);
        this.topPanel.add(this.jtbHelp);
    }

    public void createButtons() {
        this.createButton(this.metal, this.metalIcon, "", this.alMetal);
        this.createButton(this.motif, this.motifIcon, "", this.alMotif);
        this.createButton(this.windows, this.windowsIcon, "", this.alWindows);
        this.createButton(this.tile, this.tileIcon, "", this.alTile);
        this.createButton(this.cascade, this.cascadeIcon, "", this.alCascade);
        this.createButton(this.help, this.helpIcon, "", this.alHelp);
        this.createButton(this.preferences, this.opcaoglobalIcon, "", this.alPreferences);
    }

    private void createButton(JButton button, ImageIcon icon, String toolTip, ActionListener al) {
        button.setIcon(icon);
        button.setToolTipText(toolTip);
        button.addActionListener(al);
    }
}

