/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.InstanceSet;

public class AttributePanel
extends JPanel {
    private static final long serialVersionUID = 0L;
    private BorderLayout borderLayout1 = new BorderLayout();
    private JTree leftTree;
    private JTree rightTree;
    private JSplitPane jSplitPane = new JSplitPane();
    private JPanel rigthPanel = new JPanel();
    private JScrollPane rightScrollPane = new JScrollPane();
    private BorderLayout borderLayout2 = new BorderLayout();
    private JPanel leftPanel = new JPanel();
    private JScrollPane leftScrollPane = new JScrollPane();
    private BorderLayout borderLayout3 = new BorderLayout();
    private JPanel classPanel = new JPanel();
    private JComboBox classComboBox = new JComboBox();
    private JLabel classLabel = new JLabel();
    private InstanceSet instances;
    private ResourceBundle resource = ResourceBundle.getBundle("unbbayes.datamining.gui.resources.GuiResource");

    public AttributePanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.rigthPanel.setLayout(this.borderLayout2);
        this.rigthPanel.setBackground(Color.white);
        this.leftPanel.setLayout(this.borderLayout3);
        this.leftPanel.setBackground(Color.white);
        this.classLabel.setText(this.resource.getString("selectClass"));
        this.classComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AttributePanel.this.classComboBox_actionPerformed(e);
            }
        });
        this.classComboBox.setEnabled(false);
        this.jSplitPane.setEnabled(false);
        this.add((Component)this.jSplitPane, "Center");
        this.jSplitPane.add((Component)this.rigthPanel, "bottom");
        this.rigthPanel.add((Component)this.rightScrollPane, "Center");
        this.jSplitPane.add((Component)this.leftPanel, "top");
        this.leftPanel.add((Component)this.leftScrollPane, "Center");
        this.add((Component)this.classPanel, "North");
        this.classPanel.add((Component)this.classLabel, null);
        this.classPanel.add((Component)this.classComboBox, null);
    }

    public void setInstances(InstanceSet instances) {
        this.instances = instances;
        int numAtt = instances.numAttributes();
        this.classComboBox.removeAllItems();
        int i = 0;
        while (i < numAtt) {
            this.classComboBox.addItem(instances.getAttribute(i).getAttributeName());
            if (i == numAtt - 1) {
                this.classComboBox.setSelectedItem(instances.getAttribute(i).getAttributeName());
            }
            ++i;
        }
        this.buildTrees(numAtt - 1);
        this.jSplitPane.setEnabled(true);
        this.jSplitPane.setDividerLocation(0.3);
    }

    private void buildTrees(int index) {
        this.instances.setClass(this.instances.getAttribute(index));
        DefaultTreeModel treeModel = new DefaultTreeModel(this.mountClassTree());
        this.leftTree = new JTree(treeModel);
        this.leftScrollPane.getViewport().add((Component)this.leftTree, null);
        treeModel = new DefaultTreeModel(this.mountAttributeTree());
        this.rightTree = new JTree(treeModel);
        this.rightScrollPane.getViewport().add((Component)this.rightTree, null);
    }

    private DefaultMutableTreeNode mountClassTree() {
        Attribute att = this.instances.getClassAttribute();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(String.valueOf(this.resource.getString("class")) + att.getAttributeName());
        this.insertAttributeTree(att, root);
        return root;
    }

    private DefaultMutableTreeNode mountAttributeTree() {
        int numAtt = this.instances.numAttributes();
        int numClass = this.instances.getClassAttribute().getIndex();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(this.resource.getString("attributes"));
        int i = 0;
        while (i < numAtt) {
            if (i != numClass) {
                DefaultMutableTreeNode leaf = new DefaultMutableTreeNode(this.instances.getAttribute(i).getAttributeName());
                root.add(leaf);
                Attribute att = this.instances.getAttribute(i);
                this.insertAttributeTree(att, leaf);
            }
            ++i;
        }
        return root;
    }

    private void insertAttributeTree(Attribute att, DefaultMutableTreeNode node) {
        if (!att.isNominal()) {
            DefaultMutableTreeNode leaf = new DefaultMutableTreeNode("numeric");
            node.add(leaf);
        } else {
            Enumeration enumeration = att.enumerateValues();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode leaf = new DefaultMutableTreeNode(enumeration.nextElement());
                node.add(leaf);
            }
        }
    }

    void classComboBox_actionPerformed(ActionEvent e) {
        if (this.classComboBox.getSelectedIndex() >= 0) {
            this.buildTrees(this.classComboBox.getSelectedIndex());
        }
    }

    public void enableComboBox(boolean bool) {
        this.classComboBox.setEnabled(bool);
    }
}

