/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.evaluation.batchEvaluation;

import unbbayes.datamining.classifiers.Classifier;
import unbbayes.datamining.classifiers.DistributionClassifier;
import unbbayes.datamining.classifiers.NaiveBayes;
import unbbayes.datamining.classifiers.decisiontree.C45;
import unbbayes.datamining.classifiers.decisiontree.DecisionTreeLearning;
import unbbayes.datamining.datamanipulation.InstanceSet;

public class Classifiers {
    private static String[] classifierNames = new String[20];
    private static int numClassifiers = 1;

    public static Classifier newClassifier(int classifierID) throws Exception {
        Classifier classifier = null;
        switch (classifierID) {
            case 1: {
                classifier = new NaiveBayes();
                Classifiers.classifierNames[classifierID] = "naive";
                break;
            }
            case 0: {
                classifier = new C45();
                Classifiers.classifierNames[classifierID] = "c45";
            }
        }
        return classifier;
    }

    public static void buildClassifier(InstanceSet train, Classifier classifier, float[] distribution, int positiveClass) throws Exception {
        if (classifier instanceof DecisionTreeLearning) {
            ((DecisionTreeLearning)classifier).setPositiveClass(positiveClass);
        } else if (classifier instanceof DistributionClassifier) {
            ((DistributionClassifier)classifier).setOriginalDistribution(distribution);
        }
        classifier.buildClassifier(train);
    }

    public static String getClassifierName(int classifierID) {
        return classifierNames[classifierID];
    }

    public static int getNumClassifiers() {
        return numClassifiers;
    }
}

