/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.discretize;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Enumeration;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.Utils;
import unbbayes.datamining.discretize.IDiscretization;

public class FrequencyDiscretization
implements IDiscretization {
    private int numThresholds;
    private InstanceSet inst;

    public FrequencyDiscretization(InstanceSet inst) {
        this.inst = new InstanceSet(inst);
    }

    public void discretizeAttribute(Attribute att) throws Exception {
        this.discretizeAttribute(att, 10);
    }

    public void discretizeAttribute(Attribute att, int numThresholds) throws Exception {
        if (!att.isNumeric()) {
            throw new IllegalArgumentException("Attribute not numeric");
        }
        int numInstances = this.inst.numInstances();
        if (numInstances == 0) {
            return;
        }
        if (numThresholds < 1) {
            numThresholds = 1;
        }
        try {
            int position = att.getIndex();
            Attribute newAttribute = new Attribute(att.getAttributeName(), 1, true, numThresholds, position);
            float[] values = new float[numInstances];
            Enumeration enumInst = this.inst.enumerateInstances();
            int i = 0;
            int j = 0;
            while (enumInst.hasMoreElements()) {
                Instance instance = (Instance)enumInst.nextElement();
                values[i] = instance.getValue(att);
                ++i;
            }
            float sum = Utils.sum(values);
            float result = sum / (float)numThresholds;
            float[] values2 = new float[numInstances];
            System.arraycopy(values, 0, values2, 0, values.length);
            float[] changedValues = Utils.getDistribution(values);
            if (changedValues.length < numThresholds) {
                throw new Exception("N\ufffdmero de thresholds maior que a frequencia dos valores");
            }
            float[] freq = Utils.getFrequency(values);
            float[] breakPoint = new float[numThresholds];
            int inicialValue = 0;
            int actualValue = 0;
            i = 0;
            while (i < numThresholds) {
                if (changedValues[actualValue] < result) {
                    double result2 = result;
                    while (result2 >= 0.0) {
                        if ((result2 -= (double)changedValues[actualValue]) < 0.0) {
                            result2 += (double)changedValues[actualValue];
                            break;
                        }
                        ++actualValue;
                    }
                } else {
                    ++actualValue;
                }
                DecimalFormat df = new DecimalFormat("0.0#");
                DecimalFormatSymbols dfs = new DecimalFormatSymbols();
                dfs.setDecimalSeparator('.');
                df.setDecimalFormatSymbols(dfs);
                if (i != numThresholds - 1) {
                    breakPoint[i] = changedValues[actualValue] / freq[actualValue];
                    newAttribute.addValue(String.valueOf(df.format(changedValues[inicialValue] / freq[inicialValue])) + "to" + df.format(breakPoint[i]));
                } else {
                    breakPoint[i] = values[values.length - 1];
                    newAttribute.addValue(String.valueOf(df.format(changedValues[inicialValue] / freq[inicialValue])) + "to" + df.format(breakPoint[i]));
                }
                inicialValue = actualValue;
                ++i;
            }
            this.inst.setAttributeAt(newAttribute, position);
            i = 0;
            while (i < numInstances) {
                byte newValue = 0;
                j = 0;
                while (j < breakPoint.length) {
                    if (values2[i] <= breakPoint[j]) {
                        newValue = (byte)j;
                        break;
                    }
                    ++j;
                }
                this.inst.getInstance(i).setValue(position, (float)newValue);
                ++i;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void autoDiscretize() throws Exception {
        this.autoDiscretize(10);
    }

    public void autoDiscretize(int numThresholds) throws Exception {
        int numAttributes = this.inst.numAttributes();
        int i = 0;
        while (i < numAttributes) {
            Attribute att = this.inst.getAttribute(i);
            if (att.isNumeric()) {
                this.discretizeAttribute(att, numThresholds);
            }
            ++i;
        }
    }

    public InstanceSet getInstances() {
        return this.inst;
    }
}

