/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.discretize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import unbbayes.datamining.discretize.DiscretizationValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscretizationGroup {
    private Map<Float, DiscretizationValue> map = new HashMap<Float, DiscretizationValue>();

    public void addValue(DiscretizationValue dv) {
        if (!this.map.containsKey(Float.valueOf(dv.getValue()))) {
            this.map.put(Float.valueOf(dv.getValue()), dv);
        } else {
            this.map.get(Float.valueOf(dv.getValue())).getClassValue().add(dv.getClassValue().get(0));
        }
    }

    public List<Float> removeValue(float value) {
        Set<Float> set = this.map.keySet();
        ArrayList<Float> dumpList = new ArrayList<Float>();
        for (Float f : set) {
            if (!(f.floatValue() > value)) continue;
            dumpList.add(f);
        }
        for (float f : dumpList) {
            this.map.remove(Float.valueOf(f));
        }
        return dumpList;
    }

    public Collection<DiscretizationValue> getCollection() {
        return this.map.values();
    }

    public List<DiscretizationValue> getList() {
        ArrayList<DiscretizationValue> list = new ArrayList<DiscretizationValue>();
        for (DiscretizationValue value : this.getCollection()) {
            list.add(value);
        }
        return list;
    }

    public List<DiscretizationValue> sortValuesAsc() {
        List<DiscretizationValue> list = this.getList();
        int j = 1;
        while (j < list.size()) {
            DiscretizationValue key = list.get(j);
            int i = j - 1;
            while (i > -1 && list.get(i).getValue() > key.getValue()) {
                list.set(i + 1, list.get(i));
                --i;
            }
            list.set(i + 1, key);
            ++j;
        }
        return list;
    }

    public List<Float> computeInfoPoints(List<DiscretizationValue> list) {
        ArrayList<Float> points = new ArrayList<Float>();
        int size = list.size();
        int i = 1;
        while (i < size) {
            DiscretizationValue valueBefore = list.get(i - 1);
            DiscretizationValue value = list.get(i);
            boolean diferentClass = false;
            block1: for (byte vb : valueBefore.getClassValue()) {
                for (byte v : value.getClassValue()) {
                    if (vb == v) continue;
                    diferentClass = true;
                    break block1;
                }
            }
            if (diferentClass) {
                points.add(Float.valueOf((valueBefore.getValue() + value.getValue()) / 2.0f));
            }
            ++i;
        }
        return points;
    }

    public float[] countClassesBefore(float infoPoint, List<DiscretizationValue> list, int numClasses) {
        float[] result = new float[numClasses];
        for (DiscretizationValue value : list) {
            if (!(value.getValue() < infoPoint)) continue;
            Iterator<Byte> iterator = value.getClassValue().iterator();
            while (iterator.hasNext()) {
                byte classValue;
                byte by = classValue = iterator.next().byteValue();
                result[by] = result[by] + 1.0f;
            }
        }
        return result;
    }

    public float[] countClassesAfter(float infoPoint, List<DiscretizationValue> list, int numClasses) {
        float[] result = new float[numClasses];
        for (DiscretizationValue value : list) {
            if (!(value.getValue() > infoPoint)) continue;
            Iterator<Byte> iterator = value.getClassValue().iterator();
            while (iterator.hasNext()) {
                byte classValue;
                byte by = classValue = iterator.next().byteValue();
                result[by] = result[by] + 1.0f;
            }
        }
        return result;
    }
}

