/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.datamanipulation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.ResourceBundle;
import unbbayes.datamining.datamanipulation.ArrayListEnumeration;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.AttributeStats;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.UnassignedClassException;
import unbbayes.datamining.datamanipulation.Utils;

public class InstanceSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final float DEFAULT_NUM_PRECISION = 0.01f;
    private String relationName;
    private String counterAttributeName;
    public Attribute[] attributes;
    public byte[] attributeType;
    public static final byte NUMERIC = 0;
    public static final byte NOMINAL = 1;
    public static final byte CYCLIC = 2;
    public static final byte MIXED = 2;
    public int numAttributes;
    public int numNominalAttributes;
    public int numNumericAttributes;
    public int numCyclicAttributes;
    public Instance[] instances;
    public int classIndex;
    public int counterIndex;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.datamining.datamanipulation.resources.DataManipulationResource");
    public int numInstances = 0;
    public int numWeightedInstances;
    private boolean compactedFile;
    private boolean[] attributeHasChanged;
    private AttributeStats[] attributeStats;
    private int instanceSetType;
    private static Random rnd;
    private boolean hasChanged;
    private float[] distribution;
    public Hashtable<Integer, Integer> instancesIDs;

    public InstanceSet(int capacity, Attribute[] newAttributes) {
        if (capacity < 0) {
            capacity = 0;
        }
        this.attributes = newAttributes;
        this.numAttributes = this.attributes.length;
        this.numInstances = 0;
        this.numWeightedInstances = 0;
        this.classIndex = -1;
        this.counterIndex = this.numAttributes;
        this.instances = new Instance[capacity];
        this.attributeType = new byte[this.numAttributes];
        this.instancesIDs = new Hashtable();
        this.numNominalAttributes = 0;
        this.numNumericAttributes = 0;
        this.numCyclicAttributes = 0;
        int att = 0;
        while (att < this.numAttributes) {
            this.attributeType[att] = newAttributes[att].getAttributeType();
            this.attributes[att].setInstanceSet(this);
            switch (this.attributeType[att]) {
                case 1: {
                    ++this.numNominalAttributes;
                    break;
                }
                case 0: {
                    ++this.numNumericAttributes;
                    break;
                }
                case 2: {
                    ++this.numCyclicAttributes;
                }
            }
            ++att;
        }
        this.attributeHasChanged = new boolean[this.numAttributes];
        Arrays.fill(this.attributeHasChanged, true);
        this.hasChanged = true;
    }

    public InstanceSet(InstanceSet source, int capacity) {
        this.classIndex = source.classIndex;
        this.relationName = source.relationName;
        this.counterIndex = source.counterIndex;
        if (source.counterAttributeName != null) {
            this.counterAttributeName = new String(source.counterAttributeName);
        }
        this.numAttributes = source.numAttributes;
        this.numCyclicAttributes = source.numCyclicAttributes;
        this.numNominalAttributes = source.numNominalAttributes;
        this.numNumericAttributes = source.numNumericAttributes;
        this.instanceSetType = source.instanceSetType;
        this.attributeHasChanged = new boolean[this.numAttributes];
        this.attributeType = new byte[this.numAttributes];
        this.attributes = new Attribute[this.numAttributes];
        this.instances = new Instance[capacity];
        this.attributeStats = new AttributeStats[this.numAttributes];
        this.instancesIDs = new Hashtable();
        int att = 0;
        while (att < this.numAttributes) {
            this.attributes[att] = new Attribute(source.attributes[att]);
            this.attributes[att].setInstanceSet(this);
            this.attributeType[att] = source.attributeType[att];
            this.attributeHasChanged[att] = true;
            ++att;
        }
        this.hasChanged = true;
    }

    public InstanceSet(InstanceSet source) {
        this(source, source.numInstances);
        source.copyInstancesTo(this, 0, source.numInstances);
    }

    public InstanceSet(InstanceSet source, int first, int numToCopy) {
        this(source, numToCopy);
        if (first < 0 || first + numToCopy > source.numInstances) {
            String exception = resource.getString("outOfRange");
            throw new IllegalArgumentException(exception);
        }
        source.copyInstancesTo(this, first, numToCopy);
    }

    public InstanceSet(InstanceSet source, int[] instancesIDs) {
        this(source, instancesIDs.length);
        source.copyInstancesTo(this, instancesIDs);
    }

    public final String getRelationName() {
        return this.relationName;
    }

    public final void setRelationName(String newName) {
        this.relationName = newName;
    }

    public final String getCounterAttributeName() {
        return this.counterAttributeName;
    }

    public void setCounterAttributeName(String counterAttributeName) {
        if (counterAttributeName != null) {
            this.counterAttributeName = counterAttributeName;
        }
    }

    public final int numAttributes() {
        return this.numAttributes;
    }

    public Attribute[] getAttributes() {
        return this.attributes;
    }

    public final void removeInstance(int index) {
        if (index >= 0 && index < this.numInstances) {
            this.numWeightedInstances = (int)((float)this.numWeightedInstances - this.instances[index].data[this.counterIndex]);
            --this.numInstances;
            Instance[] newInstanceSet = new Instance[this.numInstances];
            int inst = 0;
            while (inst < index) {
                newInstanceSet[inst] = this.instances[inst];
                ++inst;
            }
            while (inst < this.numInstances) {
                this.instances[inst] = this.instances[inst + 1];
                newInstanceSet[inst] = this.instances[inst + 1];
                ++inst;
            }
            this.instances = newInstanceSet;
            Arrays.fill(this.attributeHasChanged, true);
            this.hasChanged = true;
        }
    }

    public final void removeInstances(int[] instancesIDs) {
        boolean[] deleteIndex = new boolean[this.numInstances];
        Arrays.fill(deleteIndex, false);
        int i = 0;
        while (i < instancesIDs.length) {
            deleteIndex[instancesIDs[i]] = true;
            ++i;
        }
        this.removeInstances(deleteIndex);
    }

    public final void removeInstances(boolean[] deleteIndex) {
        int currentSize = this.instances.length;
        int deleteSize = deleteIndex.length;
        int numInstancesToBeRemoved = 0;
        int inst = 0;
        while (inst < deleteSize) {
            if (deleteIndex[inst]) {
                ++numInstancesToBeRemoved;
            }
            ++inst;
        }
        if (numInstancesToBeRemoved == 0) {
            return;
        }
        int newSize = currentSize - numInstancesToBeRemoved;
        Instance[] newInstanceSet = new Instance[newSize];
        this.instancesIDs = new Hashtable(newSize);
        int newInstanceIndex = 0;
        int inst2 = 0;
        while (inst2 < deleteSize) {
            if (deleteIndex[inst2]) {
                --this.numInstances;
                this.numWeightedInstances = (int)((float)this.numWeightedInstances - this.instances[inst2].data[this.counterIndex]);
            } else {
                newInstanceSet[newInstanceIndex] = this.instances[inst2];
                this.instancesIDs.put(this.instances[inst2].getInstanceID(), newInstanceIndex);
                ++newInstanceIndex;
            }
            ++inst2;
        }
        if (deleteSize < currentSize) {
            inst2 = deleteSize;
            while (inst2 < currentSize) {
                newInstanceSet[newInstanceIndex] = this.instances[inst2];
                this.instancesIDs.put(this.instances[inst2].getInstanceID(), newInstanceIndex);
                ++newInstanceIndex;
                ++inst2;
            }
        }
        this.instances = newInstanceSet;
        Arrays.fill(this.attributeHasChanged, true);
        this.hasChanged = true;
    }

    public final void removeAttribute(int index) {
        if (index >= 0 && index < this.numAttributes) {
            switch (this.attributeType[index]) {
                case 1: {
                    --this.numNominalAttributes;
                    break;
                }
                case 0: {
                    --this.numNumericAttributes;
                    break;
                }
                case 2: {
                    --this.numCyclicAttributes;
                }
            }
            --this.numAttributes;
            Attribute[] newAttributes = new Attribute[this.numAttributes];
            byte[] newAttributeType = new byte[this.numAttributes];
            boolean[] newAttributeHasChanged = new boolean[this.numAttributes];
            int att = 0;
            while (att < index) {
                newAttributes[att] = this.attributes[att];
                newAttributeType[att] = this.attributeType[att];
                newAttributeHasChanged[att] = this.attributeHasChanged[att];
                ++att;
            }
            while (att < this.numAttributes) {
                newAttributes[att] = this.attributes[att + 1];
                newAttributes[att].setIndex(att);
                newAttributeType[att] = this.attributeType[att + 1];
                newAttributeHasChanged[att] = this.attributeHasChanged[att + 1];
                ++att;
            }
            this.attributes = newAttributes;
            this.attributeType = newAttributeType;
            this.attributeHasChanged = newAttributeHasChanged;
            int inst = 0;
            while (inst < this.numInstances) {
                this.instances[inst].removeAttribute(index);
                ++inst;
            }
            this.hasChanged = true;
        }
    }

    public final int numClasses() {
        if (this.classIndex < 0) {
            String exception = resource.getString("runtimeException2");
            throw new UnassignedClassException(exception);
        }
        if (this.attributeType[this.classIndex] != 1) {
            return 1;
        }
        return this.attributes[this.classIndex].numValues();
    }

    public final int numInstances() {
        return this.numInstances;
    }

    public final int numWeightedInstances() {
        return this.numWeightedInstances;
    }

    public final Attribute getAttribute(int index) {
        return this.attributes[index];
    }

    public final Enumeration enumerateAttributes() {
        return new ArrayListEnumeration(this.attributes, this.classIndex);
    }

    public final Enumeration enumerateInstances() {
        return new ArrayListEnumeration(this.instances);
    }

    public final Instance getInstance(int index) {
        return this.instances[index];
    }

    public final Instance getInstanceByID(int instanceID) {
        return this.instances[this.instancesIDs.get(instanceID)];
    }

    public void setAttributeAt(Attribute att, int position) {
        if (position < 0 || position > this.numAttributes) {
            String exception = resource.getString("setAttributeAtException");
            throw new IllegalArgumentException(exception);
        }
        this.attributes[position] = att;
        this.attributes[position].setInstanceSet(this);
        att.setFinal();
        this.attributeHasChanged[position] = true;
        int i = 0;
        while (i < this.numInstances) {
            this.instances[i].setMissing(att);
            ++i;
        }
        this.hasChanged = true;
    }

    public void insertInstance(Instance newInstance) {
        this.instances[this.numInstances] = newInstance;
        newInstance.setInstanceSet(this);
        this.instancesIDs.put(newInstance.getInstanceID(), this.numInstances);
        ++this.numInstances;
        this.numWeightedInstances = (int)((float)this.numWeightedInstances + newInstance.data[this.counterIndex]);
        Arrays.fill(this.attributeHasChanged, true);
        this.hasChanged = true;
    }

    public void insertInstance(float[] values) {
        this.insertInstance(new Instance(values, this.numInstances));
    }

    public final void setClass(Attribute att) {
        this.classIndex = att.getIndex();
        this.hasChanged = true;
    }

    public final int getClassIndex() {
        return this.classIndex;
    }

    public final void setClassIndex(int classIndex) {
        if (classIndex >= this.numAttributes) {
            String exception = resource.getString("setClassIndexException");
            throw new IllegalArgumentException(String.valueOf(exception) + classIndex);
        }
        this.classIndex = classIndex;
        this.hasChanged = true;
    }

    public boolean isMultiClass() {
        return this.numClasses() > 2;
    }

    public final Attribute getClassAttribute() {
        if (this.classIndex < 0) {
            String exception = resource.getString("runtimeException2");
            throw new UnassignedClassException(exception);
        }
        return this.attributes[this.classIndex];
    }

    public final void deleteWithMissingClass() {
        if (this.classIndex < 0) {
            String exception = resource.getString("runtimeException2");
            throw new UnassignedClassException(exception);
        }
        this.deleteWithMissing(this.classIndex);
    }

    public final void deleteWithMissing(int attIndex) {
        int inst = 0;
        while (inst < this.numInstances) {
            if (this.getInstance(inst).isMissing(attIndex)) {
                this.removeInstance(inst);
            }
            ++inst;
        }
        Arrays.fill(this.attributeHasChanged, true);
        this.hasChanged = true;
    }

    public void copyInstancesTo(InstanceSet destination, int start, int qtd) {
        if (qtd > this.numInstances || qtd < 0) {
            qtd = this.numInstances;
        }
        int inst = start;
        int counter = 0;
        while (counter < qtd) {
            destination.insertInstance(new Instance(this.instances[inst]));
            ++inst;
            ++counter;
        }
        Arrays.fill(destination.attributeHasChanged, true);
        destination.hasChanged = true;
    }

    public void copyInstancesTo(InstanceSet destination, int[] instancesIDs) {
        int numInstancesIDs = instancesIDs.length;
        int i = 0;
        while (i < numInstancesIDs) {
            int inst = instancesIDs[i];
            destination.insertInstance(new Instance(this.instances[inst]));
            ++i;
        }
        Arrays.fill(destination.attributeHasChanged, true);
        destination.hasChanged = true;
    }

    public AttributeStats[] getAttributeStats() {
        if (this.attributeStats == null) {
            this.attributeStats = new AttributeStats[this.numAttributes];
            Arrays.fill(this.attributeHasChanged, true);
        }
        int att = 0;
        while (att < this.numAttributes) {
            if (this.attributeHasChanged[att]) {
                this.attributeStats[att] = new AttributeStats(this, this.attributes[att]);
            }
            ++att;
        }
        Arrays.fill(this.attributeHasChanged, false);
        return this.attributeStats;
    }

    public AttributeStats getAttributeStats(int attIndex) {
        if (this.attributeStats == null || this.attributeStats[attIndex] == null) {
            this.attributeStats = new AttributeStats[this.numAttributes];
            Arrays.fill(this.attributeHasChanged, true);
        }
        this.attributeStats[attIndex] = new AttributeStats(this, this.attributes[attIndex]);
        this.attributeHasChanged[attIndex] = false;
        return this.attributeStats[attIndex];
    }

    public final void randomize(Random random) {
        this.instancesIDs = new Hashtable(this.numInstances);
        int i = this.numInstances - 1;
        while (i > 0) {
            int index = (int)(random.nextDouble() * (double)i);
            Instance temp = this.instances[i];
            this.instances[i] = this.instances[index];
            this.instances[index] = temp;
            this.instancesIDs.put(this.instances[index].getInstanceID(), index);
            --i;
        }
    }

    public final int[] randomizeIndex(Random random) {
        int[] index = new int[this.numInstances];
        int i = this.numInstances - 1;
        while (i > 0) {
            index[i] = (int)(random.nextDouble() * (double)i);
            --i;
        }
        return index;
    }

    public final void swap(int first, int second) {
        this.instancesIDs.remove(this.instances[first].getInstanceID());
        this.instancesIDs.remove(this.instances[second].getInstanceID());
        Instance temp = this.instances[first];
        this.instances[first] = this.instances[second];
        this.instances[second] = temp;
        this.instancesIDs.put(this.instances[first].getInstanceID(), first);
        this.instancesIDs.put(this.instances[second].getInstanceID(), second);
    }

    public boolean checkNumericAttributes() {
        int i = 0;
        while (i < this.numAttributes) {
            if (this.getAttribute(i).isNumeric()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final String toString() {
        StringBuffer text = new StringBuffer();
        text.append("@relation " + this.relationName + "\n\n");
        int i = 0;
        while (i < this.numAttributes) {
            text.append(this.getAttribute(i) + "\n");
            ++i;
        }
        text.append("\n@data\n");
        int lastPosition = this.numInstances - 1;
        int i2 = 0;
        while (i2 < lastPosition) {
            text.append(this.instances[i2]);
            text.append('\n');
            ++i2;
        }
        text.append(this.getInstance(lastPosition));
        return text.toString();
    }

    public int find(float[] data) {
        boolean equal = true;
        int inst = 0;
        while (inst < this.numInstances) {
            equal = true;
            int att = 0;
            while (att < this.numAttributes) {
                if (this.instances[inst].data[att] != data[att]) {
                    equal = false;
                    break;
                }
                ++att;
            }
            if (equal) {
                return inst;
            }
            ++inst;
        }
        return -1;
    }

    public final int classValue(int inst) {
        if (this.classIndex < 0) {
            String exception = resource.getString("runtimeException2");
            throw new UnassignedClassException(exception);
        }
        return (int)this.instances[inst].data[this.classIndex];
    }

    public String stringValue(int inst, int att) {
        return this.attributes[att].value((int)this.instances[inst].data[att]);
    }

    public void setFinal() {
        int i = 0;
        while (i < this.numAttributes) {
            this.attributes[i].setInstanceSet(this);
            if (this.attributeType[i] == 1) {
                this.attributes[i].setFinal();
            }
            ++i;
        }
        this.setInstanceSetType();
        Arrays.fill(this.attributeHasChanged, true);
        this.hasChanged = true;
    }

    public void sizeUp(int num) {
        Instance[] newInstances = new Instance[this.numInstances + num];
        int inst = 0;
        while (inst < this.numInstances) {
            newInstances[inst] = this.instances[inst];
            ++inst;
        }
        this.instances = newInstances;
    }

    public void compact() {
        int[] instancesIDs = this.sortAscending();
        boolean[] remove = new boolean[this.numInstances];
        Arrays.fill(remove, false);
        int inst = 0;
        while (inst < this.numInstances) {
            boolean match = true;
            int head = inst++;
            float packWeight = this.instances[instancesIDs[head]].data[this.counterIndex];
            while (match && inst < this.numInstances) {
                float[] currentInstance = this.instances[instancesIDs[inst]].data;
                float[] headInstance = this.instances[instancesIDs[head]].data;
                int att = 0;
                while (att < this.numAttributes) {
                    if (currentInstance[att] != headInstance[att]) {
                        match = false;
                        break;
                    }
                    ++att;
                }
                if (!match) continue;
                packWeight += currentInstance[this.counterIndex];
                this.numWeightedInstances = (int)((float)this.numWeightedInstances + currentInstance[this.counterIndex]);
                remove[instancesIDs[inst]] = true;
                ++inst;
            }
            this.instances[instancesIDs[head]].data[this.counterIndex] = packWeight;
        }
        this.removeInstances(remove);
        this.hasChanged = true;
    }

    public InstanceSet buildTrainTestSet(float proportion, boolean compact, int classIndex) {
        int numClasses;
        Random randomizer = new Random(new Date().getTime());
        int testSize = Math.round((float)this.numInstances * proportion);
        int[] count = null;
        Object instancesIDs = null;
        if (classIndex != -1) {
            int classValue;
            numClasses = this.attributes[classIndex].numValues();
            count = new int[numClasses];
            Arrays.fill(count, 0);
            int inst = 0;
            while (inst < this.numInstances) {
                int n = classValue = (int)this.instances[inst].data[classIndex];
                count[n] = count[n] + 1;
                ++inst;
            }
            instancesIDs = new int[numClasses][];
            classValue = 0;
            while (classValue < numClasses) {
                instancesIDs[classValue] = new int[count[classValue]];
                ++classValue;
            }
            Arrays.fill(count, 0);
            inst = 0;
            while (inst < this.numInstances) {
                classValue = (int)this.instances[inst].data[classIndex];
                instancesIDs[classValue][count[classValue]] = inst++;
                int n = classValue;
                count[n] = count[n] + 1;
            }
        } else {
            numClasses = 1;
            count = new int[]{this.numInstances};
            instancesIDs = new int[1][this.numInstances];
            int inst = 0;
            while (inst < this.numInstances) {
                instancesIDs[0][inst] = inst;
                ++inst;
            }
        }
        InstanceSet testSet = new InstanceSet(this, testSize);
        testSet.setCounterAttributeName(this.counterAttributeName);
        boolean[] testSetIndex = new boolean[this.numInstances];
        Arrays.fill(testSetIndex, false);
        boolean[] notUsed = new boolean[this.numInstances];
        Arrays.fill(notUsed, true);
        int index = 0;
        int classValue = 0;
        while (classValue < numClasses) {
            int counter = 0;
            int max = Math.round((float)count[classValue] * proportion);
            while (counter < max) {
                int inst = randomizer.nextInt(count[classValue]);
                if (!notUsed[inst = instancesIDs[classValue][inst]]) continue;
                testSet.instances[index] = this.instances[inst];
                testSet.instances[index].setInstanceSet(testSet);
                ++testSet.numInstances;
                testSet.numWeightedInstances = (int)((float)testSet.numWeightedInstances + this.instances[inst].data[this.counterIndex]);
                testSetIndex[inst] = true;
                ++counter;
                ++index;
                notUsed[inst] = false;
            }
            ++classValue;
        }
        this.removeInstances(testSetIndex);
        if (compact) {
            this.compact();
            testSet.compact();
        }
        Arrays.fill(this.attributeHasChanged, true);
        Arrays.fill(testSet.attributeHasChanged, true);
        this.hasChanged = true;
        testSet.hasChanged = true;
        return testSet;
    }

    public void buildSample(float proportion, boolean compact, int classIndex) {
        int numClasses;
        proportion = 1.0f - proportion;
        Random randomizer = new Random(new Date().getTime());
        int[] count = null;
        Object instancesIDs = null;
        if (classIndex != -1) {
            int classValue;
            numClasses = this.attributes[classIndex].numValues();
            count = new int[numClasses];
            Arrays.fill(count, 0);
            int inst = 0;
            while (inst < this.numInstances) {
                int n = classValue = (int)this.instances[inst].data[classIndex];
                count[n] = count[n] + 1;
                ++inst;
            }
            instancesIDs = new int[numClasses][];
            classValue = 0;
            while (classValue < numClasses) {
                instancesIDs[classValue] = new int[count[classValue]];
                ++classValue;
            }
            Arrays.fill(count, 0);
            inst = 0;
            while (inst < this.numInstances) {
                classValue = (int)this.instances[inst].data[classIndex];
                instancesIDs[classValue][count[classValue]] = inst++;
                int n = classValue;
                count[n] = count[n] + 1;
            }
        } else {
            numClasses = 1;
            count = new int[]{this.numInstances};
            instancesIDs = new int[1][this.numInstances];
            int inst = 0;
            while (inst < this.numInstances) {
                instancesIDs[0][inst] = inst;
                ++inst;
            }
        }
        boolean[] removeIndex = new boolean[this.numInstances];
        Arrays.fill(removeIndex, false);
        boolean[] notUsed = new boolean[this.numInstances];
        Arrays.fill(notUsed, true);
        int index = 0;
        int classValue = 0;
        while (classValue < numClasses) {
            int counter = 0;
            int max = Math.round((float)count[classValue] * proportion);
            while (counter < max) {
                int inst = randomizer.nextInt(count[classValue]);
                if (!notUsed[inst = instancesIDs[classValue][inst]]) continue;
                removeIndex[inst] = true;
                ++counter;
                ++index;
                notUsed[inst] = false;
            }
            ++classValue;
        }
        this.removeInstances(removeIndex);
        if (compact) {
            this.compact();
        }
        Arrays.fill(this.attributeHasChanged, true);
        this.hasChanged = true;
    }

    public int[] insertInstances(float[][] newInstanceSet) {
        int increaseSize = newInstanceSet.length;
        int oldSize = this.numInstances;
        int[] newInstancesIDs = new int[increaseSize];
        this.sizeUp(increaseSize);
        int i = 0;
        while (i < increaseSize) {
            this.insertInstance(newInstanceSet[i]);
            newInstancesIDs[i] = oldSize + i;
            ++i;
        }
        Arrays.fill(this.attributeHasChanged, true);
        this.hasChanged = true;
        return newInstancesIDs;
    }

    public int[] sortAscending() {
        return this.sort(false, -1);
    }

    public int[] sortAscending(int att) {
        return this.sort(false, att);
    }

    public int[] sortDescending() {
        return this.sort(true, -1);
    }

    public int[] sortDescending(int att) {
        return this.sort(true, att);
    }

    private int[] sort(boolean descending, int att) {
        float[][][] arrays = new float[this.numInstances][][];
        int inst = 0;
        while (inst < this.numInstances) {
            arrays[inst] = new float[2][];
            arrays[inst][0] = this.instances[inst].data;
            float[] aux = new float[]{inst};
            arrays[inst][1] = aux;
            ++inst;
        }
        if (att == -1) {
            this.sort(arrays);
        } else {
            this.sort(arrays, att);
        }
        int[] index = new int[this.numInstances];
        if (descending) {
            int inst2 = 0;
            while (inst2 < this.numInstances) {
                index[inst2] = (int)arrays[this.numInstances - inst2 - 1][1][0];
                ++inst2;
            }
        } else {
            int inst3 = 0;
            while (inst3 < this.numInstances) {
                index[inst3] = (int)arrays[inst3][1][0];
                ++inst3;
            }
        }
        return index;
    }

    private void sort(float[][][] array) {
        Arrays.sort(array, new Comparator<float[][]>(){

            @Override
            public int compare(float[][] arg0, float[][] arg1) {
                float x;
                float[][] p1 = arg0;
                float[][] p2 = arg1;
                int i = 0;
                while (i < InstanceSet.this.numAttributes) {
                    x = p1[0][i] - p2[0][i];
                    if (x < 0.0f) {
                        return -1;
                    }
                    if (x > 0.0f) {
                        return 1;
                    }
                    ++i;
                }
                x = p1[1][0] - p2[1][0];
                if (x < 0.0f) {
                    return -1;
                }
                if (x > 0.0f) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private void sort(float[][][] array, final int att) {
        Arrays.sort(array, new Comparator<float[][]>(){

            @Override
            public int compare(float[][] arg0, float[][] arg1) {
                float[][] p1 = arg0;
                float[][] p2 = arg1;
                float x = p1[0][att] - p2[0][att];
                if (x < 0.0f) {
                    return -1;
                }
                if (x > 0.0f) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public void setCounterIndex(int counterIndex) {
        this.counterIndex = counterIndex;
        this.hasChanged = true;
    }

    public int getCounterIndex() {
        return this.counterIndex;
    }

    public void setCompacted(boolean compactedFile) {
        this.compactedFile = compactedFile;
    }

    public boolean isCompacted() {
        return this.compactedFile;
    }

    public void stratify(int numFolds) {
        int inst;
        int aux;
        int classLabel;
        int[] instancesIDs = new int[this.numInstances];
        int numClasses = this.numClasses();
        int[][] stratifiedIndex = new int[numClasses][];
        int[] counter = new int[numClasses];
        Arrays.fill(counter, 0);
        int inst2 = 0;
        while (inst2 < this.numInstances) {
            int n = classLabel = (int)this.instances[inst2].data[this.classIndex];
            counter[n] = counter[n] + 1;
            ++inst2;
        }
        classLabel = 0;
        while (classLabel < numClasses) {
            stratifiedIndex[classLabel] = new int[counter[classLabel]];
            ++classLabel;
        }
        Arrays.fill(counter, 0);
        inst2 = 0;
        while (inst2 < this.numInstances) {
            classLabel = (int)this.instances[inst2].data[this.classIndex];
            stratifiedIndex[classLabel][counter[classLabel]] = inst2++;
            int n = classLabel;
            counter[n] = counter[n] + 1;
        }
        classLabel = 0;
        while (classLabel < numClasses) {
            rnd = new Random(new Date().getTime());
            Utils.randomize(stratifiedIndex[classLabel], rnd);
            ++classLabel;
        }
        int[][] maxPerFoldPerClass = new int[numFolds][numClasses];
        maxPerFoldPerClass[0] = new int[numClasses];
        Arrays.fill(maxPerFoldPerClass[0], 0);
        int classLabel2 = 0;
        while (classLabel2 < numClasses) {
            maxPerFoldPerClass[0][classLabel2] = aux = counter[classLabel2] / numFolds;
            if (counter[classLabel2] % numFolds > 0) {
                int[] nArray = maxPerFoldPerClass[0];
                int n = classLabel2;
                nArray[n] = nArray[n] + 1;
            }
            ++classLabel2;
        }
        int fold = 1;
        while (fold < numFolds) {
            maxPerFoldPerClass[fold] = new int[numClasses];
            Arrays.fill(maxPerFoldPerClass[fold], 0);
            int classLabel3 = 0;
            while (classLabel3 < numClasses) {
                aux = counter[classLabel3] / numFolds;
                if (fold < counter[classLabel3] % numFolds) {
                    ++aux;
                }
                maxPerFoldPerClass[fold][classLabel3] = aux += maxPerFoldPerClass[fold - 1][classLabel3];
                ++classLabel3;
            }
            ++fold;
        }
        Arrays.fill(counter, 0);
        int num = 0;
        int fold2 = 0;
        while (fold2 < numFolds) {
            int classLabel4 = 0;
            while (classLabel4 < numClasses) {
                int max = maxPerFoldPerClass[fold2][classLabel4];
                while (counter[classLabel4] < max) {
                    instancesIDs[num] = inst = stratifiedIndex[classLabel4][counter[classLabel4]];
                    int n = classLabel4;
                    counter[n] = counter[n] + 1;
                    ++num;
                }
                ++classLabel4;
            }
            ++fold2;
        }
        this.instancesIDs = new Hashtable(this.numInstances);
        Instance[] newInstances = new Instance[this.numInstances];
        int i = 0;
        while (i < this.numInstances) {
            inst = instancesIDs[i];
            newInstances[i] = this.instances[inst];
            this.instancesIDs.put(newInstances[i].getInstanceID(), i);
            ++i;
        }
        this.instances = newInstances;
    }

    public boolean classIsNominal() {
        return this.attributes[this.classIndex].isNominal();
    }

    public double meanOrMode(int attIndex) {
        if (this.attributes[attIndex].isNumeric()) {
            double found = 0.0;
            double result = 0.0;
            int i = 0;
            while (i < this.numInstances()) {
                if (!this.instances[i].isMissing(attIndex)) {
                    double value = this.instances[i].data[attIndex];
                    double weight = this.instances[i].data[this.counterIndex];
                    found += weight;
                    result += value * weight;
                }
                ++i;
            }
            if (found <= 0.0) {
                return 0.0;
            }
            return result / found;
        }
        if (this.attributes[attIndex].isNominal()) {
            int[] counts = new int[this.attributes[attIndex].numValues()];
            int j = 0;
            while (j < this.numInstances()) {
                double value = this.instances[j].data[attIndex];
                double weight = this.instances[j].data[this.counterIndex];
                int n = (int)value;
                counts[n] = (int)((double)counts[n] + weight);
                ++j;
            }
            return Utils.maxIndex(counts);
        }
        return 0.0;
    }

    public double meanOrMode(Attribute att) {
        return this.meanOrMode(att.getIndex());
    }

    public double variance(int attIndex) {
        double sum = 0.0;
        double sumSquared = 0.0;
        double sumOfWeights = 0.0;
        if (!this.attributes[attIndex].isNumeric()) {
            throw new IllegalArgumentException("Can't compute variance because attribute is not numeric!");
        }
        int i = 0;
        while (i < this.numInstances()) {
            if (!this.instances[i].isMissing(attIndex)) {
                double value = this.instances[i].data[attIndex];
                double weight = this.instances[i].data[this.counterIndex];
                sum += value * weight;
                sumSquared += value * value * weight;
                sumOfWeights += weight;
            }
            ++i;
        }
        if (sumOfWeights <= 1.0) {
            return 0.0;
        }
        double result = sumSquared - sum * sum / sumOfWeights;
        if ((result /= sumOfWeights - 1.0) < 0.0) {
            return 0.0;
        }
        return result;
    }

    public double variance(Attribute att) {
        return this.variance(att.getIndex());
    }

    public void setInstanceSetType() {
        boolean numeric = false;
        boolean nominal = false;
        boolean mixed = false;
        if (this.numNumericAttributes > 0) {
            numeric = true;
        }
        if (this.numCyclicAttributes > 0 || this.numNominalAttributes > 1 || this.classIndex > -1 && !this.classIsNominal() && this.numNominalAttributes > 0) {
            nominal = true;
        }
        if (nominal && numeric) {
            mixed = true;
        }
        this.instanceSetType = mixed ? 2 : (nominal ? 1 : 0);
    }

    public int getInstanceSetType() {
        return this.instanceSetType;
    }

    public boolean isNumeric() {
        return this.instanceSetType == 0;
    }

    public boolean isNominal() {
        return this.instanceSetType == 1;
    }

    public boolean isMixed() {
        return this.instanceSetType == 2;
    }

    public float[] getClassDistribution() {
        if (this.distribution != null) {
            return (float[])this.distribution.clone();
        }
        return this.getClassDistribution(true);
    }

    public float[] getClassDistribution(boolean force) {
        if (this.hasChanged || force) {
            int numClasses = this.numClasses();
            this.distribution = new float[numClasses];
            int i = 0;
            while (i < numClasses) {
                this.distribution[i] = 0.0f;
                ++i;
            }
            int i2 = 0;
            while (i2 < this.numInstances) {
                int classValue;
                int n = classValue = (int)this.instances[i2].data[this.classIndex];
                this.distribution[n] = this.distribution[n] + this.instances[i2].data[this.counterIndex];
                ++i2;
            }
            this.hasChanged = false;
        }
        return (float[])this.distribution.clone();
    }

    public float getClassFrequency(int classValue) {
        return this.getClassDistribution(false)[classValue] / (float)this.numWeightedInstances;
    }

    public void setAttributeHasChanged(int att) {
        this.attributeHasChanged[att] = true;
    }

    public float[] computePrecision() {
        int[] instancesIDs = new int[this.numInstances];
        int i = 0;
        while (i < this.numInstances) {
            instancesIDs[i] = i;
            ++i;
        }
        return this.computePrecision(instancesIDs);
    }

    public float[] computePrecision(int[] instancesIDs) {
        int inst;
        float[] precision = new float[this.numNumericAttributes];
        Hashtable<Integer, Integer> validInstances = new Hashtable<Integer, Integer>();
        float lastValue = 0.0f;
        int i = 0;
        while (i < instancesIDs.length) {
            inst = instancesIDs[i];
            validInstances.put(inst, i);
            ++i;
        }
        int attIndex = 0;
        int att = 0;
        while (att < this.numNumericAttributes) {
            if (this.attributeType[att] == 0) {
                precision[attIndex] = 0.01f;
                int[] pos = this.sortAscending(att);
                int distinct = 0;
                float deltaSum = 0.0f;
                lastValue = this.instances[pos[0]].data[att];
                int i2 = 1;
                while (i2 < this.numInstances) {
                    float value;
                    inst = pos[i2];
                    if (validInstances.containsKey(inst) && (value = this.instances[inst].data[att]) != lastValue) {
                        deltaSum += value - lastValue;
                        lastValue = value;
                        ++distinct;
                    }
                    ++i2;
                }
                if (distinct > 0) {
                    precision[attIndex] = deltaSum / (float)distinct;
                }
                ++attIndex;
            }
            ++att;
        }
        return precision;
    }

    public int[] getArrayOfInstancesPos(int[] misclassifiedInstancesIDs) {
        int[] instancesPos = new int[this.numInstances];
        int i = 0;
        while (i < this.numInstances) {
            instancesPos[i] = this.instancesIDs.get(misclassifiedInstancesIDs[i]);
            ++i;
        }
        return instancesPos;
    }

    public int getInstancePos(int instanceID) {
        if (this.instancesIDs.containsKey(instanceID)) {
            return this.instancesIDs.get(instanceID);
        }
        return -1;
    }

    public int[] getInstancesPosFromClass(int classValue) {
        int counter = 0;
        int[] instancesIDsTmp = new int[this.numInstances];
        int inst = 0;
        while (inst < this.numInstances) {
            if (this.instances[inst].data[this.classIndex] == (float)classValue) {
                instancesIDsTmp[counter] = inst;
                ++counter;
            }
            ++inst;
        }
        int[] instancesPos = new int[counter];
        int i = 0;
        while (i < counter) {
            instancesPos[i] = instancesIDsTmp[i];
            ++i;
        }
        return instancesPos;
    }

    public void rebuildInstancesIDs() {
        this.instancesIDs = new Hashtable();
        int i = 0;
        while (i < this.numInstances) {
            this.instancesIDs.put(i, i);
            this.instances[i].assignID(i);
            ++i;
        }
    }

    public void assume(InstanceSet instanceSet) {
        this.relationName = instanceSet.relationName;
        this.counterAttributeName = instanceSet.counterAttributeName;
        this.attributes = instanceSet.attributes;
        this.attributeType = instanceSet.attributeType;
        this.numAttributes = instanceSet.numAttributes;
        this.numNominalAttributes = instanceSet.numNominalAttributes;
        this.numNumericAttributes = instanceSet.numNumericAttributes;
        this.numCyclicAttributes = instanceSet.numCyclicAttributes;
        this.instances = instanceSet.instances;
        this.classIndex = instanceSet.classIndex;
        this.counterIndex = instanceSet.counterIndex;
        this.numInstances = instanceSet.numInstances;
        this.numWeightedInstances = instanceSet.numWeightedInstances;
        this.compactedFile = instanceSet.compactedFile;
        this.attributeHasChanged = instanceSet.attributeHasChanged;
        this.attributeStats = instanceSet.attributeStats;
        this.instanceSetType = instanceSet.instanceSetType;
        this.hasChanged = instanceSet.hasChanged;
        this.distribution = instanceSet.distribution;
        this.instancesIDs = instanceSet.instancesIDs;
    }

    public int getPositiveClass() {
        this.getClassDistribution();
        if (this.distribution[0] < this.distribution[1]) {
            return 0;
        }
        return 1;
    }

    public int getNegativeClass() {
        return Math.abs(1 - this.getPositiveClass());
    }
}

