/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.datamanipulation;

import java.io.Serializable;
import java.util.ResourceBundle;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.UnassignedClassException;

public class Instance
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.datamining.datamanipulation.resources.DataManipulationResource");
    private InstanceSet instanceSet;
    public float[] data;
    protected int counterIndex;
    private int numAttributes;
    private int instanceID;
    public static final float MISSING_VALUE = Float.NaN;

    public Instance(Instance instance) {
        this.numAttributes = instance.numAttributes;
        this.counterIndex = instance.counterIndex;
        this.instanceSet = instance.instanceSet;
        this.instanceID = instance.instanceID;
        int size = instance.data.length;
        this.data = new float[size];
        int att = 0;
        while (att < size) {
            this.data[att] = instance.data[att];
            ++att;
        }
    }

    public Instance(int numAttributes) {
        this.numAttributes = numAttributes;
        this.data = new float[numAttributes + 1];
        this.counterIndex = numAttributes;
        this.instanceSet = null;
    }

    public Instance(float[] data, int instanceID) {
        this.data = data;
        this.instanceID = instanceID;
        this.instanceSet = null;
        this.numAttributes = data.length - 1;
        this.counterIndex = data.length - 1;
    }

    public final void setWeight(float weight) {
        this.data[this.counterIndex] = weight;
    }

    public final float getWeight() {
        return this.data[this.counterIndex];
    }

    public final int getClassIndex() {
        return this.instanceSet.classIndex;
    }

    public final boolean classIsMissing() {
        if (this.instanceSet.classIndex < 0) {
            throw new UnassignedClassException(resource.getString("runtimeException2"));
        }
        return this.data[this.instanceSet.classIndex] == Float.NaN;
    }

    public final int getClassValue() {
        if (this.instanceSet.classIndex < 0) {
            throw new UnassignedClassException(resource.getString("runtimeException2"));
        }
        return (int)this.data[this.instanceSet.classIndex];
    }

    public final boolean isMissing(int attIndex) {
        return this.data[attIndex] == Float.NaN;
    }

    public final boolean isMissing(Attribute att) {
        return this.data[att.getIndex()] == Float.NaN;
    }

    public static final boolean isMissingValue(float val) {
        return Float.isNaN(val);
    }

    public static final float missingValue() {
        return Float.NaN;
    }

    public void setClassMissing() {
        if (this.instanceSet.classIndex < 0) {
            throw new UnassignedClassException(resource.getString("runtimeException2"));
        }
        this.setMissing(this.instanceSet.classIndex);
    }

    public void setMissing(int attIndex) {
        this.data[attIndex] = Float.NaN;
    }

    public void setMissing(Attribute att) {
        this.data[att.getIndex()] = Float.NaN;
    }

    public final InstanceSet getInstanceSet() {
        return this.instanceSet;
    }

    public String stringValue(int attIndex) {
        if (this.instanceSet.attributeType[attIndex] == 1) {
            return this.instanceSet.attributes[attIndex].value((int)this.data[attIndex]);
        }
        return String.valueOf(this.data[attIndex]);
    }

    public String stringValue(Attribute att) {
        return this.stringValue(att.getIndex());
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        if (this.numAttributes > 1) {
            int i = 0;
            while (i < this.numAttributes) {
                if (i != 0) {
                    text.append(",");
                }
                if (this.data[i] == Float.NaN) {
                    text.append("?");
                } else {
                    text.append(this.stringValue(i));
                }
                ++i;
            }
        }
        text.append(" W " + this.data[this.counterIndex]);
        return text.toString();
    }

    public final float getValue(int attIndex) {
        return this.data[attIndex];
    }

    public final void setValue(int attIndex, float newValue) {
        this.data[attIndex] = newValue;
    }

    public final float getValue(Attribute att) {
        return this.data[att.getIndex()];
    }

    public final void setValue(Attribute att, float newValue) {
        this.data[att.getIndex()] = newValue;
    }

    public void addWeight(float weight) {
        int n = this.counterIndex;
        this.data[n] = this.data[n] + weight;
    }

    public final void setInstance(float[] data) {
        this.data = data;
    }

    public void setInstanceSet(InstanceSet instanceSet) {
        this.instanceSet = instanceSet;
    }

    public void removeAttribute(int index) {
        int inst = index;
        while (inst < this.data.length - 1) {
            this.data[inst] = this.data[inst + 1];
            ++inst;
        }
        --this.numAttributes;
        --this.counterIndex;
    }

    public void setClassValue(int value) {
        this.data[this.instanceSet.classIndex] = value;
    }

    public int getInstanceID() {
        return this.instanceID;
    }

    public void assignID(int instanceID) {
        this.instanceID = instanceID;
    }
}

