/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.datamanipulation;

import java.util.Hashtable;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.Stats;

public class AttributeStats {
    private int missingCount = 0;
    private int missingCountWeighted = 0;
    private int distinctCount = 0;
    private Stats numericStats;
    private int[] nominalCounts;
    public float[] nominalCountsWeighted;
    private static final byte NUMERIC = 0;
    private static final byte NOMINAL = 1;
    private static final byte CYCLIC = 2;
    private byte attributeType;
    private Attribute attribute;
    private InstanceSet instanceSet;

    public AttributeStats(InstanceSet instanceSet, Attribute attribute) {
        this.instanceSet = instanceSet;
        this.attribute = attribute;
        this.attributeType = attribute.getAttributeType();
        if (this.attributeType == 1) {
            int numValues = attribute.numValues();
            this.nominalCounts = new int[numValues];
            this.nominalCountsWeighted = new float[numValues];
            this.computeNominalStatistics();
        } else {
            this.computeNumericStatistics();
        }
    }

    private void computeNominalStatistics() {
        int att = this.attribute.getIndex();
        int numInstances = this.instanceSet.numInstances();
        int counterIndex = this.instanceSet.counterIndex;
        int numValues = this.attribute.numValues();
        int[] countWeightResults = new int[numValues + 1];
        int[] countResults = new int[numValues + 1];
        int missingIndex = numValues;
        int inst = 0;
        while (inst < numInstances) {
            float value = this.instanceSet.instances[inst].data[att];
            int weight = (int)this.instanceSet.instances[inst].data[counterIndex];
            if (Instance.isMissingValue(value)) {
                int n = missingIndex;
                countWeightResults[n] = countWeightResults[n] + weight;
                int n2 = missingIndex;
                countResults[n2] = countResults[n2] + 1;
            } else {
                int n = (int)value;
                countWeightResults[n] = countWeightResults[n] + weight;
                int n3 = (int)value;
                countResults[n3] = countResults[n3] + 1;
            }
            ++inst;
        }
        this.missingCount = countResults[missingIndex];
        this.missingCountWeighted = countWeightResults[missingIndex];
        inst = 0;
        while (inst < numValues) {
            this.nominalCounts[inst] = countResults[inst];
            this.nominalCountsWeighted[inst] = countWeightResults[inst];
            ++this.distinctCount;
            ++inst;
        }
    }

    private void computeNumericStatistics() {
        int att = this.attribute.getIndex();
        int counterIndex = this.instanceSet.counterIndex;
        this.numericStats = new Stats(this.instanceSet, att);
        Hashtable<Float, Integer> hashtable = new Hashtable<Float, Integer>();
        int numInstances = this.instanceSet.numInstances;
        this.distinctCount = 0;
        this.missingCount = 0;
        this.missingCountWeighted = 0;
        int inst = 0;
        while (inst < numInstances) {
            float value = this.instanceSet.instances[inst].data[att];
            if (Instance.isMissingValue(value)) {
                ++this.missingCount;
                this.missingCountWeighted = (int)((float)this.missingCountWeighted + this.instanceSet.instances[inst].data[counterIndex]);
            } else if (!hashtable.containsKey(Float.valueOf(value))) {
                ++this.distinctCount;
                hashtable.put(Float.valueOf(value), 0);
            }
            ++inst;
        }
    }

    public int getDistinctCount() {
        return this.distinctCount;
    }

    public int getMissingCount() {
        return this.missingCount;
    }

    public int getMissingCountWeighted() {
        return this.missingCountWeighted;
    }

    public int[] getNominalCounts() {
        if (this.attributeType == 0) {
            return null;
        }
        return this.nominalCounts;
    }

    public float[] getNominalCountsWeighted() {
        if (this.attributeType == 0) {
            return null;
        }
        return (float[])this.nominalCountsWeighted.clone();
    }

    public Stats getNumericStats() {
        if (this.attributeType == 1) {
            return null;
        }
        return this.numericStats;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Missing Count " + this.missingCount + '\n');
        result.append("Missing Count Weighted " + this.missingCountWeighted + '\n');
        result.append("Distinct Count " + this.distinctCount + '\n');
        result.append("Counts ");
        int i = 0;
        while (i < this.nominalCounts.length) {
            result.append(String.valueOf(this.nominalCounts[i]) + " ");
            ++i;
        }
        result.append("\n");
        result.append("Counts Weighted");
        i = 0;
        while (i < this.nominalCountsWeighted.length) {
            result.append(String.valueOf(this.nominalCountsWeighted[i]) + " ");
            ++i;
        }
        result.append("\n");
        return result.toString();
    }
}

