/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.clustering;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import unbbayes.datamining.clustering.Clustering;
import unbbayes.datamining.datamanipulation.InstanceSet;

public class Squeezer
extends Clustering {
    private ArrayList<float[]>[][] summaries;
    double[] weight;
    private double s;
    private boolean useAverageSimilarity;

    public Squeezer(InstanceSet instanceSet) {
        this.instanceSet = instanceSet;
    }

    protected void run() throws Exception {
        if (this.numNominalAttributes < 1 && this.numCyclicAttributes < 1) {
            String exceptionMsg = "Squeezer needs at least one nominal attribute";
            throw new Exception(exceptionMsg);
        }
        this.assignmentMatrix = new int[this.instanceSet.numInstances];
        this.summaries = new ArrayList[this.numInstances][this.numNominalAttributes];
        this.clustersSize = new double[this.numInstances];
        if (this.weight == null) {
            this.weight = new double[this.numNominalAttributes];
            int att = 0;
            while (att < this.numNominalAttributes) {
                this.weight[att] = 1.0;
                ++att;
            }
        }
        if (this.useAverageSimilarity) {
            int max = 1000;
            if (this.numInstances < max) {
                max = this.numInstances;
            }
            this.s = this.averageSimilarity((double)max / (double)this.numInstances) + 1.5;
        }
        Arrays.fill(this.assignmentMatrix, -1);
        this.numClusters = 0;
        this.addNewClusterStructure(0);
        int simMaxIndex = 0;
        int inst = 1;
        while (inst < this.numInstances) {
            float simMax = 0.0f;
            int clusterID = 0;
            while (clusterID < this.numClusters) {
                float sim = this.similarity(clusterID, inst);
                if (sim > simMax) {
                    simMax = sim;
                    simMaxIndex = clusterID;
                }
                ++clusterID;
            }
            if ((double)simMax >= this.s) {
                this.addInstanceToCluster(inst, simMaxIndex);
            } else {
                this.addNewClusterStructure(inst);
            }
            ++inst;
        }
        double[] clustersSizeTmp = new double[this.numClusters];
        System.arraycopy(this.clustersSize, 0, clustersSizeTmp, 0, this.numClusters);
        this.clustersSize = clustersSizeTmp;
    }

    private void addInstanceToCluster(int i, int clusterID) {
        ArrayList<float[]>[] vS = this.summaries[clusterID];
        int inst = this.instancesIDs[i];
        int attIndex = 0;
        int att = 0;
        while (att < this.numAttributes) {
            if (this.instanceSet.attributeType[att] == 1) {
                int numValues = vS[attIndex].size();
                boolean newValue = true;
                int v = 0;
                while (v < numValues) {
                    if (this.instances[inst].data[att] == vS[attIndex].get(v)[0]) {
                        float[] fArray = vS[attIndex].get(v);
                        fArray[1] = fArray[1] + this.instances[inst].data[this.counterIndex];
                        newValue = false;
                        break;
                    }
                    ++v;
                }
                if (newValue) {
                    float[] vSi = new float[]{this.instances[inst].data[att], this.instances[inst].data[this.counterIndex]};
                    vS[attIndex].add(vSi);
                }
                ++attIndex;
            }
            ++att;
        }
        int n = clusterID;
        this.clustersSize[n] = this.clustersSize[n] + (double)this.instances[inst].data[this.counterIndex];
        this.assignmentMatrix[inst] = clusterID;
    }

    private void addNewClusterStructure(int i) {
        int inst = this.instancesIDs[i];
        int attIndex = 0;
        int att = 0;
        while (att < this.numAttributes) {
            if (this.instanceSet.attributeType[att] == 1) {
                float[] vSi = new float[]{this.instances[inst].data[att], this.instances[inst].data[this.counterIndex]};
                ArrayList<float[]> vS = new ArrayList<float[]>();
                vS.add(vSi);
                this.summaries[this.numClusters][attIndex] = vS;
                ++attIndex;
            }
            ++att;
        }
        this.clustersSize[this.numClusters] = this.instances[inst].data[this.counterIndex];
        this.assignmentMatrix[inst] = this.numClusters++;
    }

    private float similarity(int clusterID, int i) {
        ArrayList<float[]>[] vS = this.summaries[clusterID];
        int inst = this.instancesIDs[i];
        float sim = 0.0f;
        int attIndex = 0;
        int att = 0;
        while (att < this.numAttributes) {
            if (this.instanceSet.attributeType[att] == 1) {
                double match = 0.0;
                int numValues = vS[attIndex].size();
                int v = 0;
                while (v < numValues) {
                    if (this.instances[inst].data[att] == vS[attIndex].get(v)[0]) {
                        match += this.weight[attIndex] * (double)vS[attIndex].get(v)[1];
                    }
                    ++v;
                }
                sim += (float)(match / this.clustersSize[clusterID]);
                ++attIndex;
            }
            ++att;
        }
        return sim;
    }

    public double averageSimilarity(double proportion) {
        int numCandidates = (int)Math.round((double)this.numInstances * proportion);
        int[] candidates = new int[numCandidates];
        Random randomizer = new Random();
        int counter = 0;
        boolean[] exists = new boolean[this.instanceSet.numInstances];
        Arrays.fill(exists, false);
        while (counter < numCandidates) {
            int inst = this.instancesIDs[randomizer.nextInt(this.numInstances)];
            if (exists[inst]) continue;
            candidates[counter] = inst;
            exists[inst] = true;
            ++counter;
        }
        int similarity = 0;
        int i = 0;
        while (i < numCandidates) {
            float[] instanceI = this.instances[candidates[i]].data;
            int j = 0;
            while (j != i && j < numCandidates) {
                float[] instanceJ = this.instances[candidates[j]].data;
                int att = 0;
                while (att < this.numAttributes) {
                    if (this.instanceSet.attributeType[att] == 1 && instanceI[att] == instanceJ[att]) {
                        ++similarity;
                    }
                    ++att;
                }
                ++j;
            }
            ++i;
        }
        double avgSimilarity = similarity;
        return avgSimilarity /= (double)numCandidates * (double)(numCandidates - 1);
    }

    public void setWeight(double[] weight) {
        this.weight = weight;
    }

    public void setS(double s) {
        this.s = s;
    }

    public void setUseAverageSimilarity(boolean useAverageSimilarity) {
        this.useAverageSimilarity = useAverageSimilarity;
    }
}

