/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.classifiers.neuralnetwork;

import java.io.Serializable;
import java.util.Arrays;
import unbbayes.datamining.classifiers.neuralnetwork.ActivationFunction;
import unbbayes.datamining.classifiers.neuralnetwork.Neuron;
import unbbayes.datamining.classifiers.neuralnetwork.OutputNeuron;

public class HiddenNeuron
extends Neuron
implements Serializable {
    private static final long serialVersionUID = 0L;
    public transient float outputValue;
    public transient float errorTerm;
    public transient float momentum;

    public HiddenNeuron(ActivationFunction activationFunction, int numberOfInputs, float momentum) {
        this.activationFunction = activationFunction;
        this.weights = new float[numberOfInputs + 1];
        this.deltaW = new float[numberOfInputs + 1];
        this.momentum = momentum;
        this.startWeights();
        Arrays.fill(this.deltaW, 0.0f);
    }

    public float outputValue() {
        return this.outputValue;
    }

    public void updateWeights(float learningRate, float[] inputValues) {
        float learningRateXErrorTerm = learningRate * this.errorTerm;
        this.deltaW[0] = this.momentum * this.deltaW[0] + learningRateXErrorTerm;
        this.weights[0] = this.weights[0] + this.deltaW[0];
        int i = 1;
        while (i < this.weights.length) {
            this.deltaW[i] = this.momentum * this.deltaW[i] + learningRateXErrorTerm * inputValues[i - 1];
            this.weights[i] = this.weights[i] + this.deltaW[i];
            ++i;
        }
    }

    public float getErrorTerm() {
        return this.errorTerm;
    }

    public void calculateOutputValue(float[] inputValues) {
        float net = this.weights[0];
        int i = 0;
        while (i < inputValues.length) {
            net += inputValues[i] * this.weights[i + 1];
            ++i;
        }
        this.outputValue = (float)this.activationFunction.functionValue(net);
    }

    public void calculateErrorTerm(OutputNeuron[] outputLayer, int neuronIndex) {
        float sum = 0.0f;
        int i = 0;
        while (i < outputLayer.length) {
            sum += outputLayer[i].errorTerm * outputLayer[i].getWeight(neuronIndex);
            ++i;
        }
        this.errorTerm = (float)this.activationFunction.hiddenErrorTerm(this.outputValue, sum);
    }
}

