/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.classifiers.decisiontree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import unbbayes.datamining.classifiers.decisiontree.DecisionTreeLearning;
import unbbayes.datamining.classifiers.decisiontree.Leaf;
import unbbayes.datamining.classifiers.decisiontree.Node;
import unbbayes.datamining.classifiers.decisiontree.NominalNode;
import unbbayes.datamining.classifiers.decisiontree.NumericNode;
import unbbayes.datamining.classifiers.decisiontree.SplitObject;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.ClassifierUtils;
import unbbayes.datamining.datamanipulation.Instance;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.datamining.datamanipulation.Options;
import unbbayes.datamining.datamanipulation.PrunningUtils;
import unbbayes.datamining.datamanipulation.Utils;

public class C45
extends DecisionTreeLearning
implements Serializable {
    private static final long serialVersionUID = 0L;
    private transient ResourceBundle resource;
    private Node xRootNode;
    private Node infoRootNode;

    public void buildClassifier(InstanceSet data) throws Exception {
        this.resource = ResourceBundle.getBundle("unbbayes.datamining.classifiers.resources.ClassifiersResource");
        if (!data.getClassAttribute().isNominal()) {
            throw new Exception(this.resource.getString("exception1"));
        }
        this.makeTree(data);
    }

    protected void makeTree(InstanceSet data) throws Exception {
        int numInstances = data.numInstances();
        int numAttributes = data.numAttributes();
        int numClasses = data.numClasses();
        Attribute classAttribute = data.getClassAttribute();
        int classIndex = classAttribute.getIndex();
        ClassifierUtils utils = new ClassifierUtils(data);
        ArrayList<QueueComponent> queue = new ArrayList<QueueComponent>();
        ArrayList actualInst = new ArrayList(numInstances);
        Integer[] actualAtt = new Integer[numAttributes];
        int i = 0;
        while (i < numInstances) {
            actualInst.add(new Integer(i));
            ++i;
        }
        i = 0;
        while (i < numAttributes) {
            actualAtt[i] = new Integer(i);
            ++i;
        }
        SplitObject split = new SplitObject(actualInst, actualAtt);
        Node xNode = this.xRootNode = new Node(null);
        queue.add(new QueueComponent(xNode, split));
        while (!queue.isEmpty()) {
            SplitObject[] splitData;
            Leaf leaf;
            QueueComponent queueComponent = (QueueComponent)queue.remove(0);
            xNode = queueComponent.getNodeParent();
            split = queueComponent.splitObject;
            actualInst = split.getInstances();
            numInstances = actualInst.size();
            actualAtt = split.getAttributes();
            numAttributes = actualAtt.length;
            if (numInstances == 0) {
                leaf = new Leaf(classAttribute, xNode.distribution, this.threshold, this.positiveClass);
                xNode.add(leaf);
                continue;
            }
            double[] splitValues = new double[actualAtt.length];
            ArrayList numericDataList = new ArrayList();
            double[] infoGains = utils.computeInfoGain(split, splitValues, numericDataList);
            if (Options.getInstance().getIfUsingGainRatio()) {
                double meanInfoGains = Utils.sum(infoGains) / (double)infoGains.length;
                int i2 = 0;
                int decr = 0;
                while (i2 < numAttributes) {
                    Attribute att;
                    if (actualAtt[i2] == classIndex) {
                        ++decr;
                    } else if (infoGains[i2 - decr] > meanInfoGains && (att = data.getAttribute(actualAtt[i2])).isNominal()) {
                        int n = i2 - decr;
                        infoGains[n] = infoGains[n] / utils.computeSplitInformation(split, i2);
                    }
                    ++i2;
                }
            }
            int attributeIndex = Utils.maxIndex(infoGains);
            int realAttribute = -1;
            int realIndex = 0;
            while (realIndex < numAttributes) {
                if (actualAtt[realIndex] != classIndex && ++realAttribute == attributeIndex) break;
                ++realIndex;
            }
            xNode.setInstrumentationData(split, infoGains, numericDataList);
            float[] distribution = new float[numClasses];
            int i3 = 0;
            while (i3 < numInstances) {
                Instance inst = utils.getInstance(actualInst, i3);
                int n = inst.getClassValue();
                distribution[n] = distribution[n] + inst.getWeight();
                ++i3;
            }
            int distributionClass = Utils.maxIndex(distribution);
            if (Utils.eq(infoGains[attributeIndex], 0.0) || ClassifierUtils.sumNonClassDistribution(distribution, distributionClass) < 1.0) {
                leaf = new Leaf(classAttribute, distribution, this.threshold, this.positiveClass);
                xNode.add(leaf);
                continue;
            }
            Attribute splitAttribute = data.getAttribute(actualAtt[realIndex]);
            if (splitAttribute.isNominal()) {
                splitData = utils.splitData(split, realIndex);
                int j = 0;
                while (j < splitData.length) {
                    NominalNode nominalNode = new NominalNode(splitAttribute, j, distribution);
                    xNode.add(nominalNode);
                    queue.add(new QueueComponent(nominalNode, splitData[j]));
                    ++j;
                }
                continue;
            }
            double splitValue = splitValues[realIndex];
            splitData = utils.splitNumericData(split, realIndex, splitValue);
            NumericNode numericNode = new NumericNode(splitAttribute, splitValue, true, distribution);
            xNode.add(numericNode);
            queue.add(new QueueComponent(numericNode, splitData[0]));
            numericNode = new NumericNode(splitAttribute, splitValue, false, distribution);
            xNode.add(numericNode);
            queue.add(new QueueComponent(numericNode, splitData[1]));
        }
        this.infoRootNode = this.xRootNode;
        if (Options.getInstance().getIfUsingPrunning()) {
            PrunningUtils pruner = new PrunningUtils();
            this.xRootNode = pruner.pruneTree(this.xRootNode, classAttribute);
        }
    }

    public JTree getTree() {
        DefaultMutableTreeNode text2;
        Stack<Object> stackObj = new Stack<Object>();
        Stack<DefaultMutableTreeNode> stackTree = new Stack<DefaultMutableTreeNode>();
        DefaultMutableTreeNode treeNode = text2 = new DefaultMutableTreeNode("root");
        ArrayList<Object> root = this.xRootNode.children;
        int size = root.size();
        int i = 0;
        while (i < size) {
            stackObj.push(root.get(i));
            stackTree.push(treeNode);
            ++i;
        }
        while (!stackObj.empty()) {
            Object obj = stackObj.pop();
            treeNode = (DefaultMutableTreeNode)stackTree.pop();
            if (obj instanceof Leaf) {
                Leaf leaf = (Leaf)obj;
                treeNode.add(new DefaultMutableTreeNode(leaf.toString()));
                continue;
            }
            Node node = (Node)obj;
            DefaultMutableTreeNode treeNodeChild = new DefaultMutableTreeNode(node.toString());
            treeNode.add(treeNodeChild);
            treeNode = treeNodeChild;
            ArrayList<Object> children = node.children;
            size = children.size();
            int i2 = 0;
            while (i2 < size) {
                stackObj.push(children.get(i2));
                stackTree.push(treeNode);
                ++i2;
            }
        }
        return new JTree(text2);
    }

    public String toString() {
        return this.getStringTree(this.xRootNode);
    }

    public String getStringInfoTree() {
        return this.getStringTree(this.infoRootNode);
    }

    private String getStringTree(Node rootNode) {
        Stack<Object> stackObj = new Stack<Object>();
        Stack<Integer> stackLevel = new Stack<Integer>();
        StringBuffer text = new StringBuffer();
        ArrayList<Object> root = rootNode.children;
        int size = root.size();
        int i = 0;
        while (i < size) {
            stackObj.push(root.get(i));
            stackLevel.push(new Integer(1));
            ++i;
        }
        while (!stackObj.empty()) {
            Object obj = stackObj.pop();
            Integer level = (Integer)stackLevel.pop();
            if (obj instanceof Leaf) {
                Leaf leaf = (Leaf)obj;
                text.append(": " + leaf.toString());
                continue;
            }
            Node node = (Node)obj;
            if (level != 0) {
                text.append("\n");
                i = 0;
                while (i < level - 1) {
                    text.append("| ");
                    ++i;
                }
                text.append(node.toString());
            }
            ArrayList<Object> children = node.children;
            size = children.size();
            int i2 = 0;
            while (i2 < size) {
                stackObj.push(children.get(i2));
                stackLevel.push(new Integer(level + 1));
                ++i2;
            }
        }
        return text.toString();
    }

    protected Leaf classifyInstanceAux(Instance instance) {
        Node treeNode = this.xRootNode;
        while (!(treeNode.children.get(0) instanceof Leaf)) {
            Node node = (Node)treeNode.children.get(0);
            Attribute att = node.getAttribute();
            if (att.isNominal()) {
                int index = (int)instance.getValue(node.getAttribute());
                treeNode = (NominalNode)treeNode.children.get(index);
                continue;
            }
            double splitValue = ((NumericNode)node).getSplitValue();
            treeNode = (double)instance.getValue(att.getIndex()) >= splitValue ? (NumericNode)treeNode.children.get(0) : (NumericNode)treeNode.children.get(1);
        }
        return (Leaf)treeNode.children.get(0);
    }

    public Node getRootNode() {
        return this.xRootNode;
    }

    public Node getInfoRootNode() {
        return this.infoRootNode;
    }

    private class QueueComponent {
        private SplitObject splitObject;
        private Node nodeParent;

        public QueueComponent(Node newParent, SplitObject splitObject) {
            this.nodeParent = newParent;
            this.splitObject = splitObject;
        }

        public Node getNodeParent() {
            return this.nodeParent;
        }

        public SplitObject getSplitObject() {
            return this.splitObject;
        }
    }
}

