/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.datamining.classifiers.bayesianlearning;

import java.util.ArrayList;
import unbbayes.datamining.classifiers.bayesianlearning.ParametricLearning;
import unbbayes.datamining.datamanipulation.Attribute;
import unbbayes.datamining.datamanipulation.InstanceSet;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.exception.InvalidParentException;

public class K2 {
    private ParametricLearning m_pl;
    private ArrayList<int[]> finalConfiguration = new ArrayList();
    private InstanceSet instanceSet;

    public K2(InstanceSet instanceSet, ParametricLearning pl) {
        this.m_pl = pl;
        this.instanceSet = instanceSet;
        int numAttributes = instanceSet.numAttributes();
        Attribute[] attributes = new Attribute[numAttributes];
        int[][] parents = new int[numAttributes][0];
        int i = 0;
        while (i < numAttributes) {
            attributes[i] = instanceSet.getAttribute(i);
            if (i > 0) {
                double g = this.gh(attributes[i], parents[i]);
                System.out.println("attribute = " + attributes[i] + " g = " + g);
                boolean flag = true;
                int numPredessors = attributes[i].getIndex();
                while (flag && parents[i].length <= numPredessors) {
                    Object[] results = this.maxGh(attributes[i], parents[i]);
                    Attribute z = (Attribute)results[0];
                    double gx = (Double)results[1];
                    System.out.println("attribute = " + z + " gx = " + gx);
                    double dif = gx - g;
                    if (dif > 0.0) {
                        int[] parentsTemp = new int[parents[i].length + 1];
                        System.arraycopy(parents[i], 0, parentsTemp, 0, parents[i].length);
                        parentsTemp[parents[i].length] = z.getIndex();
                        parents[i] = parentsTemp;
                        continue;
                    }
                    flag = false;
                    System.out.println("false");
                }
            }
            this.finalConfiguration.add(parents[i]);
            ++i;
        }
    }

    private Object[] maxGh(Attribute attribute, int[] actualParents) {
        Attribute z = null;
        double max = -1.7976931348623157E308;
        double maxAux = 0.0;
        int i = 0;
        while (i < attribute.getIndex()) {
            int[] newParents = this.union(actualParents, i);
            maxAux = this.gh(attribute, newParents);
            System.out.println("attribute = " + attribute + " i = " + i + " maxAux " + maxAux);
            if (max < maxAux) {
                max = maxAux;
                z = this.instanceSet.getAttribute(i);
            }
            ++i;
        }
        System.out.println("retorno = " + z + " max = " + max);
        return new Object[]{z, new Double(max)};
    }

    private int[] union(int[] actualParents, int i) {
        int j = 0;
        while (j < actualParents.length) {
            if (actualParents[j] == i) {
                return actualParents;
            }
            ++j;
        }
        int[] parentsTemp = new int[actualParents.length + 1];
        System.arraycopy(actualParents, 0, parentsTemp, 0, actualParents.length);
        parentsTemp[actualParents.length] = i;
        return parentsTemp;
    }

    public ProbabilisticNetwork getProbabilisticNetwork() throws InvalidParentException {
        return this.m_pl.getProbabilisticNetwork(this.finalConfiguration);
    }

    double gh(Attribute i, int[] pais) {
        int qi = this.m_pl.computeQ(pais);
        int ri = i.numValues();
        int[][] Nijk = this.m_pl.computeNijk(i.getIndex(), pais);
        int width = Nijk.length;
        int heigth = Nijk[0].length;
        int[] Nij = new int[width];
        int x = 0;
        while (x < width) {
            Nij[x] = 0;
            int y = 0;
            while (y < heigth) {
                int n = x;
                Nij[n] = Nij[n] + Nijk[x][y];
                ++y;
            }
            ++x;
        }
        float a = 0.0f;
        int j = 0;
        while (j < qi) {
            a = (float)((double)a + this.logfat(ri + Nij[j] - 1));
            ++j;
        }
        float b = 0.0f;
        int j2 = 0;
        while (j2 < qi) {
            int k = 0;
            while (k < ri) {
                b = (float)((double)b + this.logfat(Nijk[j2][k]));
                ++k;
            }
            ++j2;
        }
        return (double)qi * this.logfat(ri - 1) - (double)a + (double)b;
    }

    private double logfat(int n) {
        if (n <= 100) {
            return this.logfatorial(n);
        }
        return this.logstirling(n);
    }

    private double logfatorial(int n) {
        double f = 0.0;
        int i = 1;
        while (i <= n) {
            f += Math.log(i);
            ++i;
        }
        return f;
    }

    private double logstirling(int n) {
        return 0.5 * Math.log(Math.PI * 2) + ((double)n + 0.5) * Math.log(n) - (double)n * Math.log(Math.E);
    }
}

