/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.controller.oobn;

import java.awt.Component;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JInternalFrame;
import unbbayes.controller.NetworkController;
import unbbayes.gui.NetworkWindow;
import unbbayes.gui.UnBBayesFrame;
import unbbayes.gui.oobn.OOBNClassWindow;
import unbbayes.gui.oobn.OOBNWindow;
import unbbayes.gui.oobn.node.OOBNNodeGraphicalWrapper;
import unbbayes.io.oobn.impl.DefaultOOBNIO;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.msbn.AbstractMSBN;
import unbbayes.prs.oobn.IOOBNClass;
import unbbayes.prs.oobn.IOOBNNode;
import unbbayes.prs.oobn.IObjectOrientedBayesianNetwork;
import unbbayes.prs.oobn.compiler.impl.OOBNToSingleAgentMSBNCompiler;
import unbbayes.prs.oobn.impl.DefaultOOBNClass;
import unbbayes.prs.oobn.impl.OOBNClassSingleEntityNetworkWrapper;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OOBNController
extends NetworkController {
    private static int FIRST_NETWORK_INDEX = 0;
    private IObjectOrientedBayesianNetwork oobn;
    private OOBNWindow window;
    private OOBNClassWindow active;
    private IOOBNClass selectedClass = null;
    private UnBBayesFrame upperUnBBayesFrame = null;

    protected OOBNController() {
        super((SingleEntityNetwork)null, (NetworkWindow)null);
    }

    protected OOBNController(IObjectOrientedBayesianNetwork oobn, UnBBayesFrame upperUnBBayesFrame) {
        super(oobn.getSingleEntityNetwork(), null);
        this.oobn = oobn;
        this.setUpperUnBBayesFrame(upperUnBBayesFrame);
        this.window = OOBNWindow.newInstance(oobn, this);
        this.init();
    }

    public static OOBNController newInstance(IObjectOrientedBayesianNetwork oobn, UnBBayesFrame upperContainer) {
        return new OOBNController(oobn, upperContainer);
    }

    public JInternalFrame getPanel() {
        return this.window;
    }

    private void init() {
        this.window.setController(this);
        this.window.getNetList().setSelectedIndex(0);
        if (this.getOobn().getOOBNClassCount() > 0) {
            this.changeActiveOOBNClass(OOBNClassWindow.newInstance(this.getOobn().getOOBNClassList().get(FIRST_NETWORK_INDEX)));
        }
    }

    public void changeActiveOOBNClass(OOBNClassWindow newWindow) {
        if (this.active != null) {
            SingleEntityNetwork net = this.active.getSingleEntityNetwork();
            int i = 0;
            while (i < net.getNodeCount()) {
                net.getNodeAt(i).setSelected(false);
                ++i;
            }
            this.window.getContentPane().remove(this.active.getContentPane());
        }
        this.active = newWindow;
        if (newWindow == null) {
            return;
        }
        this.window.getContentPane().add((Component)this.active.getContentPane(), "Center");
        this.window.updateUI();
    }

    public void addNewOOBNClass(String name) {
        this.addOOBNClass(DefaultOOBNClass.newInstance(name));
    }

    public void removeClassAt(int index) {
        try {
            this.getOobn().getOOBNClassList().remove(index);
        }
        catch (Exception e) {
            Debug.println(this.getClass(), "Trying to remove invalid OOBN class", e);
        }
        if (this.getOobn().getOOBNClassCount() <= 0) {
            this.changeActiveOOBNClass(null);
        } else {
            this.changeActiveOOBNClass(OOBNClassWindow.newInstance(this.getOobn().getOOBNClassList().get(0)));
        }
    }

    public AbstractMSBN compileActiveOOBNClassToMSBN() {
        OOBNToSingleAgentMSBNCompiler compiler = OOBNToSingleAgentMSBNCompiler.newInstance();
        AbstractMSBN msbn = (AbstractMSBN)compiler.compile(this.getOobn(), OOBNClassSingleEntityNetworkWrapper.newInstance((SingleEntityNetwork)this.getActive().getNetworkController().getNetwork()));
        return msbn;
    }

    public Set<IOOBNClass> loadOOBNClassesFromFile(File file) {
        Debug.println(this.getClass(), "File loader not yet implemented");
        HashSet<IOOBNClass> ret = new HashSet<IOOBNClass>();
        DefaultOOBNIO io = DefaultOOBNIO.newInstance();
        try {
            IObjectOrientedBayesianNetwork returnedOOBN = io.loadOOBN(file);
            for (IOOBNClass loadedOOBN : returnedOOBN.getOOBNClassList()) {
                ret.add(loadedOOBN);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public void addOOBNClass(IOOBNClass newClass) {
        this.getOobn().getOOBNClassList().add(newClass);
        if (this.getOobn().getOOBNClassList().size() == 1) {
            this.changeActiveOOBNClass(OOBNClassWindow.newInstance(this.getOobn().getOOBNClassList().get(0)));
        }
    }

    public boolean containsOOBNClassByName(String className) {
        for (IOOBNClass oobnClass : this.getOobn().getOOBNClassList()) {
            if (!className.equals(oobnClass.getClassName())) continue;
            return true;
        }
        return false;
    }

    public OOBNNodeGraphicalWrapper getOOBNNodeFromNames(String className, String nodeName) {
        for (IOOBNClass oobnClass : this.getOobn().getOOBNClassList()) {
            if (!nodeName.equals(oobnClass.getClassName())) continue;
            for (IOOBNNode node : oobnClass.getAllNodes()) {
                if (!nodeName.equals(node.getName())) continue;
                return OOBNNodeGraphicalWrapper.newInstance(node);
            }
        }
        return null;
    }

    public IObjectOrientedBayesianNetwork getOobn() {
        return this.oobn;
    }

    public void setOobn(IObjectOrientedBayesianNetwork oobn) {
        this.oobn = oobn;
    }

    public OOBNWindow getWindow() {
        return this.window;
    }

    public void setWindow(OOBNWindow window) {
        this.window = window;
    }

    public OOBNClassWindow getActive() {
        return this.active;
    }

    public void setActive(OOBNClassWindow active) {
        this.active = active;
    }

    public UnBBayesFrame getUpperUnBBayesFrame() {
        return this.upperUnBBayesFrame;
    }

    public void setUpperUnBBayesFrame(UnBBayesFrame upperUnBBayesFrame) {
        this.upperUnBBayesFrame = upperUnBBayesFrame;
    }

    public IOOBNClass getSelectedClass() {
        return this.selectedClass;
    }

    public void setSelectedClass(IOOBNClass selectedClass) {
        this.selectedClass = selectedClass;
    }
}

