/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.controller;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import unbbayes.gui.ExplanationProperties;
import unbbayes.gui.NetworkWindow;
import unbbayes.gui.continuous.ContinuousNormalDistributionPane;
import unbbayes.gui.table.GUIPotentialTable;
import unbbayes.gui.table.ReplaceTextCellEditor;
import unbbayes.prs.Edge;
import unbbayes.prs.Node;
import unbbayes.prs.bn.ITabledVariable;
import unbbayes.prs.bn.PotentialTable;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.prs.bn.ProbabilisticNode;
import unbbayes.prs.bn.SingleEntityNetwork;
import unbbayes.prs.exception.InvalidParentException;
import unbbayes.prs.hybridbn.CNNormalDistribution;
import unbbayes.prs.hybridbn.ContinuousNode;
import unbbayes.prs.hybridbn.GaussianMixture;
import unbbayes.prs.id.DecisionNode;
import unbbayes.prs.id.UtilityNode;
import unbbayes.simulation.likelihoodweighting.inference.LikelihoodWeightingInference;

public class SENController {
    private NetworkWindow screen;
    private SingleEntityNetwork singleEntityNetwork;
    private NumberFormat df;
    protected LikelihoodWeightingInference lwInference;
    protected GaussianMixture gmInference;
    private InferenceAlgorithmEnum inferenceAlgorithm = InferenceAlgorithmEnum.JUNCTION_TREE;
    private static ResourceBundle resource = ResourceBundle.getBundle("unbbayes.controller.resources.ControllerResources");

    public InferenceAlgorithmEnum getInferenceAlgorithm() {
        return this.inferenceAlgorithm;
    }

    public void setInferenceAlgorithm(InferenceAlgorithmEnum inferenceAlgorithm) {
        this.inferenceAlgorithm = inferenceAlgorithm;
    }

    public SENController(SingleEntityNetwork singleEntityNetwork, NetworkWindow screen) {
        this.singleEntityNetwork = singleEntityNetwork;
        this.screen = screen;
        this.df = NumberFormat.getInstance(Locale.getDefault());
        this.df.setMaximumFractionDigits(4);
    }

    public void insertState(Node node) {
        if (node instanceof ProbabilisticNode) {
            node.appendState(String.valueOf(resource.getString("stateProbabilisticName")) + node.getStatesSize());
            for (Node child : node.getChildren()) {
                if (child.getType() != 5) continue;
                ((ContinuousNode)child).getCnNormalDistribution().refreshParents();
            }
        } else if (node instanceof DecisionNode) {
            node.appendState(String.valueOf(resource.getString("stateDecisionName")) + node.getStatesSize());
        }
        this.screen.setTable(this.makeTable(node));
    }

    public void removeState(Node node) {
        node.removeLastState();
        for (Node child : node.getChildren()) {
            if (child.getType() != 5) continue;
            ((ContinuousNode)child).getCnNormalDistribution().refreshParents();
        }
        this.screen.setTable(this.makeTable(node));
    }

    public void initialize() {
        try {
            if (this.getInferenceAlgorithm() == InferenceAlgorithmEnum.JUNCTION_TREE) {
                this.singleEntityNetwork.initialize();
            } else if (this.getInferenceAlgorithm() == InferenceAlgorithmEnum.LIKELIHOOD_WEIGHTING) {
                this.singleEntityNetwork.resetEvidences();
                this.lwInference.run();
            } else if (this.getInferenceAlgorithm() == InferenceAlgorithmEnum.GAUSSIAN_MIXTURE) {
                this.singleEntityNetwork.resetEvidences();
                this.gmInference.run();
            }
            this.screen.getEvidenceTree().updateTree();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void propagate() {
        this.screen.setCursor(new Cursor(3));
        if (this.getInferenceAlgorithm() == InferenceAlgorithmEnum.JUNCTION_TREE) {
            boolean temLikeliHood = false;
            try {
                this.singleEntityNetwork.updateEvidences();
                if (!temLikeliHood) {
                    this.screen.setStatus(String.valueOf(resource.getString("statusEvidenceProbabilistic")) + this.df.format((double)this.singleEntityNetwork.PET() * 100.0));
                }
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.screen, e.getMessage(), resource.getString("statusError"), 0);
            }
        } else if (this.getInferenceAlgorithm() == InferenceAlgorithmEnum.LIKELIHOOD_WEIGHTING) {
            this.lwInference.run();
        } else if (this.getInferenceAlgorithm() == InferenceAlgorithmEnum.GAUSSIAN_MIXTURE) {
            JOptionPane.showMessageDialog(this.screen, "Not yet implemented!", resource.getString("statusError"), 0);
        }
        this.screen.getEvidenceTree().updateTree();
        this.screen.setCursor(new Cursor(0));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compileNetwork() {
        long ini = System.currentTimeMillis();
        this.screen.setCursor(new Cursor(3));
        this.singleEntityNetwork.resetNodesCopy();
        this.screen.getEvidenceTree().resetTree();
        if (this.getInferenceAlgorithm() == InferenceAlgorithmEnum.JUNCTION_TREE) {
            if (!this.singleEntityNetwork.isBN() && !this.singleEntityNetwork.isID()) {
                JOptionPane.showMessageDialog(null, resource.getString("junctionTreeNotApplicableError"), resource.getString("statusError"), 0);
                this.screen.setCursor(new Cursor(0));
                return false;
            }
            try {
                ((ProbabilisticNetwork)this.singleEntityNetwork).compile();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), resource.getString("statusError"), 0);
                this.screen.setCursor(new Cursor(0));
                return false;
            }
        }
        if (this.getInferenceAlgorithm() == InferenceAlgorithmEnum.LIKELIHOOD_WEIGHTING) {
            if (!this.singleEntityNetwork.isBN()) {
                JOptionPane.showMessageDialog(null, resource.getString("likelihoodWeightingNotApplicableError"), resource.getString("statusError"), 0);
                this.screen.setCursor(new Cursor(0));
                return false;
            }
            String sampleSizeText = JOptionPane.showInputDialog(this.screen, resource.getString("sampleSizeInputMessage"), resource.getString("sampleSizeInputTitle"), 3);
            if (sampleSizeText == null) {
                return false;
            }
            int sampleSize = 0;
            try {
                sampleSize = Integer.parseInt(sampleSizeText);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, resource.getString("sampleSizeInputError"), resource.getString("statusError"), 0);
                this.screen.setCursor(new Cursor(0));
                return false;
            }
            this.singleEntityNetwork.resetEvidences();
            this.lwInference = new LikelihoodWeightingInference((ProbabilisticNetwork)this.singleEntityNetwork, sampleSize);
            this.lwInference.run();
        } else if (this.getInferenceAlgorithm() == InferenceAlgorithmEnum.GAUSSIAN_MIXTURE) {
            if (!this.singleEntityNetwork.isHybridBN()) {
                JOptionPane.showMessageDialog(null, resource.getString("continuousInferenceNotApplicableError"), resource.getString("statusError"), 0);
                this.screen.setCursor(new Cursor(0));
                return false;
            }
            try {
                this.singleEntityNetwork.resetEvidences();
                this.gmInference = new GaussianMixture((ProbabilisticNetwork)this.singleEntityNetwork);
                this.gmInference.run();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), resource.getString("statusError"), 0);
                this.screen.setCursor(new Cursor(0));
                return false;
            }
        }
        this.screen.setCursor(new Cursor(0));
        this.screen.setStatus(String.valueOf(resource.getString("statusTotalTime")) + this.df.format((double)(System.currentTimeMillis() - ini) / 1000.0) + resource.getString("statusSeconds"));
        return true;
    }

    public void insertContinuousNode(double x, double y) {
        ContinuousNode node = new ContinuousNode();
        node.setPosition(x, y);
        node.setName(String.valueOf(resource.getString("probabilisticNodeName")) + this.singleEntityNetwork.getNodeCount());
        node.setDescription(node.getName());
        this.singleEntityNetwork.addNode(node);
    }

    public void insertProbabilisticNode(double x, double y) {
        ProbabilisticNode node = new ProbabilisticNode();
        node.setPosition(x, y);
        node.appendState(resource.getString("firstStateProbabilisticName"));
        node.setName(String.valueOf(resource.getString("probabilisticNodeName")) + this.singleEntityNetwork.getNodeCount());
        node.setDescription(node.getName());
        PotentialTable auxTabProb = node.getPotentialTable();
        auxTabProb.addVariable(node);
        auxTabProb.setValue(0, 1.0f);
        this.singleEntityNetwork.addNode(node);
    }

    public void insertDecisionNode(double x, double y) {
        DecisionNode node = new DecisionNode();
        node.setPosition(x, y);
        node.appendState(resource.getString("firstStateDecisionName"));
        node.setName(String.valueOf(resource.getString("decisionNodeName")) + this.singleEntityNetwork.getNodeCount());
        node.setDescription(node.getName());
        this.singleEntityNetwork.addNode(node);
    }

    public void insertUtilityNode(double x, double y) {
        UtilityNode node = new UtilityNode();
        node.setPosition(x, y);
        node.setName(String.valueOf(resource.getString("utilityNodeName")) + this.singleEntityNetwork.getNodeCount());
        node.setDescription(node.getName());
        PotentialTable auxTab = node.getPotentialTable();
        auxTab.addVariable(node);
        this.singleEntityNetwork.addNode(node);
    }

    public void insertEdge(Edge edge) {
        try {
            this.singleEntityNetwork.addEdge(edge);
        }
        catch (InvalidParentException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), resource.getString("statusError"), 0);
        }
    }

    public void deleteSelectedItem() {
        Object selected = this.screen.getGraphPane().getSelected();
        if (selected != null) {
            this.deleteSelected(selected);
        }
        this.screen.getGraphPane().update();
    }

    public void createContinuousDistribution(final ContinuousNode node) {
        ArrayList<Node> discreteNodeList = new ArrayList<Node>();
        ArrayList<String> discreteNodeNameList = new ArrayList<String>();
        ArrayList<String> continuousNodeNameList = new ArrayList<String>();
        for (Node n : node.getParents()) {
            if (n.getType() == 0) {
                discreteNodeList.add(n);
                discreteNodeNameList.add(n.getName());
                continue;
            }
            if (n.getType() != 5) continue;
            continuousNodeNameList.add(n.getName());
        }
        final ContinuousNormalDistributionPane distributionPane = new ContinuousNormalDistributionPane(discreteNodeNameList, continuousNodeNameList);
        this.screen.setDistributionPane(distributionPane);
        this.screen.setTableOwner(node);
        for (Node n : discreteNodeList) {
            ArrayList<String> stateList = new ArrayList<String>(n.getStatesSize());
            int i = 0;
            while (i < n.getStatesSize()) {
                stateList.add(n.getStateAt(i));
                ++i;
            }
            distributionPane.fillDiscreteParentStateSelection(n.getName(), stateList);
        }
        this.loadContinuousDistributionPaneValues(distributionPane, node.getCnNormalDistribution());
        ActionListener confirmAL = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SENController.this.setContinuousDistributionValues(distributionPane, node.getCnNormalDistribution());
            }
        };
        ActionListener restoreValuesFromDistributionAL = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SENController.this.loadContinuousDistributionPaneValues(distributionPane, node.getCnNormalDistribution());
            }
        };
        distributionPane.addConfirmButtonActionListener(confirmAL);
        distributionPane.addCancelButtonActionListener(restoreValuesFromDistributionAL);
        distributionPane.addParentStateChangeActionListener(restoreValuesFromDistributionAL);
        this.screen.setAddRemoveStateButtonVisible(false);
    }

    private void loadContinuousDistributionPaneValues(ContinuousNormalDistributionPane distributionPane, CNNormalDistribution distribution) {
        int[] mCoord = distributionPane.getDiscreteParentNodeStateSelectedList();
        if (mCoord.length == 0) {
            mCoord = new int[]{0};
        }
        String mean = String.valueOf(distribution.getMean(mCoord));
        String variance = String.valueOf(distribution.getVariance(mCoord));
        ArrayList<String> constantList = new ArrayList<String>(distribution.getConstantListSize());
        int i = 0;
        while (i < distribution.getConstantListSize()) {
            constantList.add(String.valueOf(distribution.getConstantAt(i, mCoord)));
            ++i;
        }
        distributionPane.setMeanText(mean);
        distributionPane.setVarianceText(variance);
        distributionPane.setConstantTextList(constantList);
    }

    private void setContinuousDistributionValues(ContinuousNormalDistributionPane distributionPane, CNNormalDistribution distribution) {
        try {
            double mean = Double.parseDouble(distributionPane.getMeanText());
            double variance = Double.parseDouble(distributionPane.getVarianceText());
            List<String> constantTextList = distributionPane.getConstantTextList();
            ArrayList<Double> constantList = new ArrayList<Double>(constantTextList.size());
            for (String constantText : constantTextList) {
                constantList.add(Double.parseDouble(constantText));
            }
            int[] multidimensionalCoord = distributionPane.getDiscreteParentNodeStateSelectedList();
            if (multidimensionalCoord.length == 0) {
                multidimensionalCoord = new int[]{0};
            }
            distribution.setMean(mean, multidimensionalCoord);
            distribution.setVariance(variance, multidimensionalCoord);
            int i = 0;
            while (i < constantList.size()) {
                distribution.setConstantAt(i, (double)((Double)constantList.get(i)), multidimensionalCoord);
                ++i;
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, resource.getString("continuousNormalDistributionParamError"), resource.getString("statusError"), 0);
        }
    }

    public void createDiscreteTable(Node node) {
        this.screen.setTable(this.makeTable(node));
        this.screen.setTableOwner(node);
        if (this.screen.isCompiled()) {
            int i = 0;
            while (i < this.screen.getEvidenceTree().getRowCount()) {
                if (this.screen.getEvidenceTree().getPathForRow(i).getLastPathComponent().toString().equals(node.toString())) {
                    if (this.screen.getEvidenceTree().isExpanded(this.screen.getEvidenceTree().getPathForRow(i))) {
                        this.screen.getEvidenceTree().collapsePath(this.screen.getEvidenceTree().getPathForRow(i));
                        break;
                    }
                    this.screen.getEvidenceTree().expandPath(this.screen.getEvidenceTree().getPathForRow(i));
                    break;
                }
                ++i;
            }
        }
        this.screen.setAddRemoveStateButtonVisible(true);
    }

    public JTable makeTable(final Node node) {
        JTable table;
        PotentialTable potTab;
        this.screen.getTxtDescription().setEnabled(true);
        this.screen.getTxtSigla().setEnabled(true);
        this.screen.getTxtDescription().setText(node.getDescription());
        this.screen.getTxtSigla().setText(node.getName());
        if (node.getStatesSize() == 0) {
            Node parent = node.getParents().get(0);
            int numClasses = parent.getStatesSize();
            double[] mean = node.getMean();
            double[] stdDev = node.getStandardDeviation();
            JTable table2 = new JTable(3, numClasses + 1);
            table2.setAutoResizeMode(0);
            table2.setTableHeader(null);
            table2.setValueAt(parent.getName(), 0, 0);
            table2.setValueAt(resource.getString("mean"), 1, 0);
            table2.setValueAt(resource.getString("stdDev"), 2, 0);
            int i = 0;
            while (i < numClasses) {
                table2.setValueAt(parent.getStateAt(i), 0, i + 1);
                table2.setValueAt(mean[i], 1, i + 1);
                table2.setValueAt(stdDev[i], 2, i + 1);
                ++i;
            }
            return table2;
        }
        if (node instanceof ITabledVariable) {
            potTab = ((ITabledVariable)((Object)node)).getPotentialTable();
            table = new GUIPotentialTable(potTab).makeTable();
        } else {
            potTab = null;
            table = new JTable(node.getStatesSize(), 1);
            int i = 0;
            while (i < node.getStatesSize()) {
                table.setValueAt(node.getStateAt(i), i, 0);
                ++i;
            }
            table.setAutoResizeMode(0);
            table.setTableHeader(null);
        }
        table.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (e.getColumn() == 0) {
                    if (!table.getValueAt(e.getLastRow(), e.getColumn()).toString().trim().equals("")) {
                        node.setStateAt(table.getValueAt(e.getLastRow(), e.getColumn()).toString(), e.getLastRow() - (table.getRowCount() - node.getStatesSize()));
                    } else {
                        table.revalidate();
                        table.setValueAt(node.getStateAt(e.getLastRow() - (table.getRowCount() - node.getStatesSize())), e.getLastRow(), e.getColumn());
                    }
                } else if (potTab != null) {
                    String valueText = table.getValueAt(e.getLastRow(), e.getColumn()).toString().replace(',', '.');
                    try {
                        float value = Float.parseFloat(valueText);
                        potTab.setValue((e.getColumn() - 1) * node.getStatesSize() + e.getLastRow(), value);
                    }
                    catch (NumberFormatException nfe) {
                        if (!valueText.trim().equals("")) {
                            JOptionPane.showMessageDialog(null, resource.getString("numberFormatError"), resource.getString("error"), 0);
                        }
                        table.revalidate();
                        table.setValueAt("" + potTab.getValue((e.getColumn() - 1) * node.getStatesSize() + e.getLastRow()), e.getLastRow(), e.getColumn());
                    }
                }
            }
        });
        ReplaceTextCellEditor cellEditor = new ReplaceTextCellEditor();
        int i = 0;
        while (i < table.getColumnModel().getColumnCount()) {
            table.getColumnModel().getColumn(i).setCellEditor(cellEditor);
            ++i;
        }
        table.setSurrendersFocusOnKeystroke(true);
        return table;
    }

    public JTable makeTableOld(final Node node) {
        JTable table;
        int variables;
        PotentialTable potTab;
        this.screen.getTxtDescription().setEnabled(true);
        this.screen.getTxtSigla().setEnabled(true);
        this.screen.getTxtDescription().setText(node.getDescription());
        this.screen.getTxtSigla().setText(node.getName());
        if (node.getStatesSize() == 0) {
            Node parent = node.getParents().get(0);
            int numClasses = parent.getStatesSize();
            double[] mean = node.getMean();
            double[] stdDev = node.getStandardDeviation();
            JTable table2 = new JTable(3, numClasses + 1);
            table2.setAutoResizeMode(0);
            table2.setTableHeader(null);
            table2.setValueAt(parent.getName(), 0, 0);
            table2.setValueAt(resource.getString("mean"), 1, 0);
            table2.setValueAt(resource.getString("stdDev"), 2, 0);
            int i = 0;
            while (i < numClasses) {
                table2.setValueAt(parent.getStateAt(i), 0, i + 1);
                table2.setValueAt(mean[i], 1, i + 1);
                table2.setValueAt(stdDev[i], 2, i + 1);
                ++i;
            }
            return table2;
        }
        if (node instanceof ITabledVariable) {
            potTab = ((ITabledVariable)((Object)node)).getPotentialTable();
            int states = 1;
            variables = potTab.variableCount();
            states = potTab.tableSize() / node.getStatesSize();
            int rows = node.getStatesSize() + variables - 1;
            int columns = states + 1;
            table = new JTable(rows, columns);
            int k = variables - 1;
            int l = 0;
            while (k < table.getRowCount()) {
                table.setValueAt(node.getStateAt(l), k, 0);
                ++k;
                ++l;
            }
            k = variables - 1;
            l = 0;
            while (k >= 1) {
                Node variable = potTab.getVariableAt(k);
                states /= variable.getStatesSize();
                table.setValueAt(variable.getName(), l, 0);
                int i = 0;
                while (i < table.getColumnCount() - 1) {
                    table.setValueAt(variable.getStateAt(i / states % variable.getStatesSize()), l, i + 1);
                    ++i;
                }
                --k;
                ++l;
            }
            states = node.getStatesSize();
            int i = 1;
            int k2 = 0;
            while (i < table.getColumnCount()) {
                int j = variables - 1;
                int l2 = 0;
                while (j < table.getRowCount()) {
                    table.setValueAt(this.df.format(potTab.getValue(k2 + l2)), j, i);
                    ++j;
                    ++l2;
                }
                ++i;
                k2 += states;
            }
        } else {
            potTab = null;
            variables = node.getParents().size();
            table = new JTable(node.getStatesSize(), 1);
            int i = 0;
            while (i < node.getStatesSize()) {
                table.setValueAt(node.getStateAt(i), i, 0);
                ++i;
            }
        }
        table.setTableHeader(null);
        table.setAutoResizeMode(0);
        table.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                if (e.getLastRow() < variables - 1) {
                    return;
                }
                if (e.getColumn() == 0) {
                    if (!table.getValueAt(e.getLastRow(), e.getColumn()).equals("")) {
                        node.setStateAt(table.getValueAt(e.getLastRow(), e.getColumn()).toString(), e.getLastRow() - (table.getRowCount() - node.getStatesSize()));
                    }
                } else {
                    String temp = table.getValueAt(e.getLastRow(), e.getColumn()).toString().replace(',', '.');
                    try {
                        float valor = Float.parseFloat(temp);
                        potTab.setValue((e.getColumn() - 1) * node.getStatesSize() + e.getLastRow(), valor);
                    }
                    catch (NumberFormatException nfe) {
                        JOptionPane.showMessageDialog(null, resource.getString("error"), resource.getString("realNumberError"), 0);
                        table.revalidate();
                        table.setValueAt("" + potTab.getValue((e.getColumn() - 1) * node.getStatesSize() + e.getLastRow()), e.getLastRow(), e.getColumn());
                    }
                }
            }
        });
        return table;
    }

    public void deleteSelected(Object selecionado) {
        if (selecionado instanceof Edge) {
            this.singleEntityNetwork.removeEdge((Edge)selecionado);
        } else if (selecionado instanceof Node) {
            this.singleEntityNetwork.removeNode((Node)selecionado);
        }
    }

    public void showExplanationProperties(ProbabilisticNode node) {
        this.screen.setCursor(new Cursor(3));
        ExplanationProperties explanation = new ExplanationProperties(this.screen, this.singleEntityNetwork);
        explanation.setProbabilisticNode(node);
        explanation.setVisible(true);
        this.screen.setCursor(new Cursor(0));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum InferenceAlgorithmEnum {
        JUNCTION_TREE,
        LIKELIHOOD_WEIGHTING,
        GAUSSIAN_MIXTURE;

    }
}

