/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.aprendizagem;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import unbbayes.aprendizagem.RelationInterationController;
import unbbayes.prs.Node;
import unbbayes.prs.bn.LearningNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationsWindow
extends JDialog {
    private static final long serialVersionUID = 0L;
    private JPanel rolBox;
    private JPanel relationBox;
    private JPanel relationPanel;
    private JPanel buttonPanel;
    private JPanel parentsPanel;
    private JPanel sunPanel;
    private JList parentsList;
    private JList sunList;
    private JList relationList;
    private DefaultListModel relationListModel;
    private DefaultListModel parentsListModel;
    private DefaultListModel sunListModel;
    private JButton addButton;
    private JButton removeButton;
    private JButton continueButton;
    private ArrayList<Node> variables;
    private RelationInterationController relationController;
    ActionListener continueEvent = new ActionListener(){

        public void actionPerformed(ActionEvent ae) {
            RelationsWindow.this.relationController.continueEvent();
        }
    };
    ActionListener removeEvent = new ActionListener(){

        public void actionPerformed(ActionEvent ae) {
            RelationsWindow.this.relationController.removeEvent(RelationsWindow.this.relationList.getSelectedValue());
        }
    };
    ActionListener addEvent = new ActionListener(){

        public void actionPerformed(ActionEvent ae) {
            RelationsWindow.this.relationController.addEvent(RelationsWindow.this.parentsList.getSelectedValue(), RelationsWindow.this.sunList.getSelectedValue());
        }
    };

    public RelationsWindow(ArrayList<Node> variables) {
        super(new Frame(), "UnBBayes - Learning Module", true);
        Container container = this.getContentPane();
        this.variables = variables;
        container.add(this.getRelationBox());
        this.listInsert();
        this.relationController = new RelationInterationController(this, variables);
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    public DefaultListModel getRelationModel() {
        return this.relationListModel;
    }

    public JList getRelationList() {
        return this.relationList;
    }

    private JPanel getRelationBox() {
        this.relationBox = new JPanel(new GridLayout(1, 5, 10, 10));
        this.relationBox.add(this.getParents());
        this.relationBox.add(this.getSun());
        this.relationBox.add(this.getButtons());
        this.relationBox.add(this.getRelations());
        return this.relationBox;
    }

    private JPanel getParents() {
        this.parentsPanel = new JPanel(new BorderLayout());
        this.parentsListModel = new DefaultListModel();
        this.parentsList = new JList(this.parentsListModel);
        JScrollPane parentsBoxJP = new JScrollPane(this.parentsList);
        this.parentsList.setSelectionMode(0);
        this.parentsList.setSelectedIndex(0);
        this.parentsPanel.add((Component)new JLabel("Parents"), "North");
        this.parentsPanel.add((Component)parentsBoxJP, "Center");
        return this.parentsPanel;
    }

    private JPanel getSun() {
        this.sunPanel = new JPanel(new BorderLayout());
        this.sunListModel = new DefaultListModel();
        this.sunList = new JList(this.sunListModel);
        JScrollPane sunBoxJP = new JScrollPane(this.sunList);
        this.sunList.setSelectionMode(0);
        this.sunList.setSelectedIndex(0);
        this.sunPanel.add((Component)new JLabel("Suns"), "North");
        this.sunPanel.add((Component)sunBoxJP, "Center");
        return this.sunPanel;
    }

    private JPanel getButtons() {
        this.buttonPanel = new JPanel(new GridLayout(8, 1, 10, 10));
        this.addButton = new JButton("Add");
        this.removeButton = new JButton("Remove");
        this.continueButton = new JButton("Continue");
        this.buttonPanel.add(new JLabel(""));
        this.buttonPanel.add(new JLabel(""));
        this.buttonPanel.add(this.addButton);
        this.buttonPanel.add(new JLabel(""));
        this.buttonPanel.add(new JLabel(""));
        this.buttonPanel.add(this.removeButton);
        this.buttonPanel.add(this.continueButton);
        this.continueButton.addActionListener(this.continueEvent);
        this.addButton.addActionListener(this.addEvent);
        this.removeButton.addActionListener(this.removeEvent);
        return this.buttonPanel;
    }

    private JPanel getRelations() {
        this.relationPanel = new JPanel(new BorderLayout());
        this.relationListModel = new DefaultListModel();
        this.relationList = new JList(this.relationListModel);
        this.relationList.setSelectionMode(0);
        JScrollPane relationBoxJP = new JScrollPane(this.relationList);
        this.relationPanel.add((Component)new JLabel("Relations"), "North");
        this.relationPanel.add((Component)relationBoxJP, "Center");
        return this.relationPanel;
    }

    private void listInsert() {
        int i = 0;
        while (i < this.variables.size()) {
            LearningNode aux = (LearningNode)this.variables.get(i);
            this.parentsListModel.addElement(aux.getName());
            this.sunListModel.addElement(aux.getName());
            ++i;
        }
    }
}

