/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.aprendizagem;

import java.util.ArrayList;
import unbbayes.aprendizagem.LearningToolkit;
import unbbayes.prs.Node;
import unbbayes.prs.bn.LearningNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PonctuationToolkit
extends LearningToolkit {
    private final int GH = 0;
    private final int MDL = 1;
    private final int GHS = 2;
    private int metric;

    protected double gMDL(LearningNode variable, ArrayList<Node> parents) {
        double riSum = 0.0;
        double qiSum = 0.0;
        int nij = 0;
        int nijk = 0;
        int ri = variable.getEstadoTamanho();
        int qi = 1;
        int[][] ArrayNijk = this.getFrequencies(variable, parents);
        if (parents != null && parents.size() > 0) {
            qi = this.getQ(parents);
        }
        int j = 0;
        while (j < qi) {
            int k = 0;
            while (k < ri) {
                nij += ArrayNijk[k][j];
                ++k;
            }
            k = 0;
            while (k < ri) {
                nijk = ArrayNijk[k][j];
                if (nij != 0 && nijk != 0) {
                    riSum += (double)nijk * (this.log(nijk) - this.log(nij));
                }
                ++k;
            }
            qiSum += riSum;
            nij = 0;
            riSum = 0.0;
            ++j;
        }
        return qiSum -= 0.5 * (double)qi * (double)(ri - 1) * this.log(this.caseNumber);
    }

    protected double gGH(LearningNode variable, ArrayList<Node> parents) {
        double qiSum = 0.0;
        int qi = 1;
        int ri = variable.getEstadoTamanho();
        int[][] ArrayNijk = this.getFrequencies(variable, parents);
        if (parents != null && parents.size() > 0) {
            qi = this.getQ(parents);
        }
        int j = 0;
        while (j < qi) {
            double rSum = this.fatorialLog(ri - 1);
            int nij = 0;
            int k = 0;
            while (k < ri) {
                nij += ArrayNijk[k][j];
                ++k;
            }
            double sSum = this.fatorialLog(nij + ri - 1);
            double tSum = 0.0;
            k = 0;
            while (k < ri) {
                int nijk = ArrayNijk[k][j];
                tSum += this.fatorialLog(nijk);
                ++k;
            }
            qiSum += rSum - sSum + tSum;
            ++j;
        }
        return qiSum;
    }

    protected double gGHS(LearningNode variable, ArrayList<Node> parents) {
        double qiSum = 0.0;
        int qi = 1;
        int ri = variable.getEstadoTamanho();
        int[][] ArrayNijk = this.getFrequencies(variable, parents);
        if (parents != null && parents.size() > 0) {
            qi = this.getQ(parents);
        }
        int j = 0;
        while (j < qi) {
            double rSum = this.fatLog(ri - 1);
            int nij = 0;
            int k = 0;
            while (k < ri) {
                nij += ArrayNijk[k][j];
                ++k;
            }
            double sSum = this.fatLog(nij + ri - 1);
            double tSum = 0.0;
            k = 0;
            while (k < ri) {
                int nijk = ArrayNijk[k][j];
                tSum += this.fatLog(nijk);
                ++k;
            }
            qiSum += rSum - sSum + tSum;
            ++j;
        }
        return qiSum;
    }

    protected double getG(LearningNode variable, ArrayList<Node> parents) {
        switch (this.metric) {
            case 0: {
                return this.gGH(variable, parents);
            }
            case 1: {
                return this.gMDL(variable, parents);
            }
            case 2: {
                return this.gGHS(variable, parents);
            }
        }
        return 0.0;
    }

    protected void setMetric(String metric) {
        if (metric.equalsIgnoreCase("GH")) {
            this.metric = 0;
            return;
        }
        if (metric.equalsIgnoreCase("MDL")) {
            this.metric = 1;
            return;
        }
        if (metric.equalsIgnoreCase("GHS")) {
            this.metric = 2;
            return;
        }
    }

    private double fatLog(int n) {
        if (n <= 100) {
            return this.fatorialLog(n);
        }
        return this.stirlingLog(n);
    }

    private double fatorialLog(int n) {
        double f = 0.0;
        int i = 1;
        while (i <= n) {
            f += this.log(i);
            ++i;
        }
        return f;
    }

    private double stirlingLog(int n) {
        return 0.5 * this.log(Math.PI * 2) + ((double)n + 0.5) * this.log(n) - (double)n * this.log(Math.E);
    }
}

