/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.aprendizagem;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import unbbayes.aprendizagem.OptionsInterationController;
import unbbayes.prs.bn.LearningNode;

public class OptionsWindow
extends JDialog {
    private static final long serialVersionUID = 0L;
    private LearningNode variable;
    private JTextField txtMaxParents;
    private JTextField txtName;
    private JLabel lMaxParents;
    private JLabel lName;
    private JLabel lStates;
    private JPanel centerPanel;
    private JPanel northPanel;
    private JPanel namePanel;
    private JPanel maxPanel;
    private JPanel repetitionPanel;
    private JPanel statesPanel;
    private JList statesList;
    private DefaultListModel statesListModel;
    private JButton applyButton;
    private JButton cancelButton;
    private OptionsInterationController optionsController;
    ActionListener applyEvent = new ActionListener(){

        public void actionPerformed(ActionEvent ae) {
            OptionsWindow.this.optionsController.applyEvent(OptionsWindow.this.txtMaxParents.getText());
        }
    };
    ActionListener cancelEvent = new ActionListener(){

        public void actionPerformed(ActionEvent ae) {
            OptionsWindow.this.optionsController.cancelEvent();
        }
    };

    public OptionsWindow(LearningNode variable) {
        super(new Frame(), "UnBBayes - Learning Module", true);
        this.variable = variable;
        Container container = this.getContentPane();
        container.add((Component)this.getNorthPanel(), "North");
        container.add((Component)this.getCenterPanel(), "Center");
        this.optionsController = new OptionsInterationController(this, variable);
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    private JPanel getNorthPanel() {
        this.northPanel = new JPanel(new GridLayout(1, 2, 10, 10));
        this.northPanel.add(this.getNamePanel());
        this.northPanel.add(this.getMaxPanel());
        return this.northPanel;
    }

    private JPanel getCenterPanel() {
        this.centerPanel = new JPanel(new GridLayout(1, 2, 10, 10));
        this.centerPanel.add(this.getStatesPanel());
        this.centerPanel.add(this.getRepetitionPanel());
        return this.centerPanel;
    }

    private JPanel getNamePanel() {
        this.namePanel = new JPanel(new GridLayout(1, 2, 10, 10));
        this.lName = new JLabel("          Name");
        this.txtName = new JTextField(this.variable.getName());
        this.txtName.setEnabled(false);
        this.namePanel.add(this.lName);
        this.namePanel.add(this.txtName);
        return this.namePanel;
    }

    private JPanel getMaxPanel() {
        this.maxPanel = new JPanel(new GridLayout(1, 2));
        this.lMaxParents = new JLabel("Max parents :");
        this.txtMaxParents = new JTextField("" + this.variable.getNumeroMaximoPais());
        this.maxPanel.add(this.lMaxParents);
        this.maxPanel.add(this.txtMaxParents);
        return this.maxPanel;
    }

    private JPanel getStatesPanel() {
        this.statesPanel = new JPanel(new BorderLayout());
        this.lStates = new JLabel("States");
        this.statesListModel = new DefaultListModel();
        this.statesList = new JList(this.statesListModel);
        JScrollPane statesSP = new JScrollPane(this.statesList);
        this.statesList.setSelectionMode(0);
        List<String> auxVector = this.variable.getEstados();
        int j = 0;
        while (j < auxVector.size()) {
            String auxState = auxVector.get(j);
            this.statesListModel.addElement(auxState);
            ++j;
        }
        this.statesPanel.add((Component)statesSP, "Center");
        this.statesPanel.add((Component)this.lStates, "North");
        return this.statesPanel;
    }

    private JPanel getRepetitionPanel() {
        this.repetitionPanel = new JPanel(new GridLayout(7, 1, 5, 5));
        this.applyButton = new JButton("Apply");
        this.cancelButton = new JButton("Cancel");
        this.repetitionPanel.add(new JLabel(""));
        this.repetitionPanel.add(new JLabel(""));
        this.repetitionPanel.add(new JLabel(""));
        this.repetitionPanel.add(this.applyButton);
        this.repetitionPanel.add(this.cancelButton);
        this.repetitionPanel.add(new JLabel(""));
        this.repetitionPanel.add(new JLabel(""));
        this.applyButton.addActionListener(this.applyEvent);
        this.cancelButton.addActionListener(this.cancelEvent);
        return this.repetitionPanel;
    }
}

