/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.aprendizagem.Gibbs.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import unbbayes.controller.FileController;
import unbbayes.gui.SimpleFileFilter;
import unbbayes.prs.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IOGibbs {
    private byte[][] data;
    private ArrayList<Node> variables;
    private PrintStream ps;
    private File file;

    public IOGibbs(byte[][] data, ArrayList<Node> variables) {
        this.data = data;
        this.variables = variables;
        try {
            this.file = this.getFile();
            this.ps = new PrintStream(new FileOutputStream(this.file));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void makeFile() {
        this.makeFirstLine();
        int i = 0;
        while (i < this.data.length) {
            int j = 0;
            while (j < this.variables.size()) {
                Node node = this.variables.get(j);
                this.ps.print(node.getStateAt(this.data[i][j]));
                if (j != this.variables.size() - 1) {
                    this.ps.print('\t');
                } else {
                    this.ps.println();
                }
                ++j;
            }
            ++i;
        }
    }

    private void makeFirstLine() {
        int i = 0;
        while (i < this.variables.size()) {
            Node node = this.variables.get(i);
            this.ps.print(node.getName());
            if (i != this.variables.size() - 1) {
                this.ps.print('\t');
            } else {
                this.ps.println();
            }
            ++i;
        }
    }

    private File getFile() {
        File file;
        String[] nets = new String[]{"net", "xml"};
        FileController fileController = FileController.getInstance();
        JFileChooser chooser = new JFileChooser(fileController.getCurrentDirectory());
        chooser.setMultiSelectionEnabled(false);
        chooser.setFileSelectionMode(2);
        chooser.addChoosableFileFilter(new SimpleFileFilter(nets, "txt"));
        int option = chooser.showSaveDialog(null);
        if (option == 0 && (file = chooser.getSelectedFile()) != null) {
            return file;
        }
        return null;
    }
}

