/*
 * Decompiled with CFR 0.152.
 */
package unbbayes.aprendizagem.Gibbs.controller;

import java.util.ArrayList;
import java.util.Collections;
import unbbayes.aprendizagem.LearningToolkit;
import unbbayes.prs.Node;
import unbbayes.prs.bn.LearningNode;
import unbbayes.prs.bn.ProbabilisticNetwork;
import unbbayes.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GibbsController
extends LearningToolkit {
    private byte[][] data;
    private ArrayList<Node> variables;
    private ProbabilisticNetwork pn = null;

    public GibbsController(ProbabilisticNetwork pn, byte[][] data, ArrayList<Node> variables) {
        this.data = data;
        this.variables = variables;
        this.pn = pn;
        double[] distribution = null;
        int i = 0;
        while (i < data[0].length) {
            int j = 0;
            while (j < data.length) {
                if (data[j][i] == -1) {
                    distribution = this.getDistribution((LearningNode)variables.get(i), j);
                    data[j][i] = (byte)this.getEstado(distribution);
                }
                ++j;
            }
            ++i;
        }
    }

    private double[] getDistribution(LearningNode node, int line) {
        byte[] parents = new byte[this.variables.size() - 1];
        if (this.pn == null) {
            int i = 0;
            while (i < parents.length + 1) {
                parents[i] = i != node.getPos() ? this.data[line][i] : -1;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.pn.getNodeCount()) {
                Node nodeAux = this.pn.getNodeAt(i);
                if (nodeAux.getName().equals(node.getName())) {
                    int j = 0;
                    while (j < parents.length) {
                        boolean find = false;
                        Node variable = this.variables.get(j);
                        int k = 0;
                        while (k < nodeAux.getParents().size()) {
                            Node pnNode = nodeAux.getParents().get(k);
                            if (variable.getName().equals(pnNode.getName())) {
                                parents[j] = this.data[line][j];
                                find = true;
                                break;
                            }
                            ++k;
                        }
                        if (!find) {
                            parents[j] = -1;
                        }
                        ++j;
                    }
                    break;
                }
                ++i;
            }
        }
        return this.distributionCalc(node, parents, node.getPos());
    }

    private double[] distributionCalc(LearningNode node, byte[] parents, int col) {
        int[] absoluteDistribution = new int[node.getEstadoTamanho()];
        int cont = 0;
        int i = 0;
        while (i < this.data.length) {
            boolean achou = true;
            int j = 0;
            while (j < this.data[0].length && achou) {
                if (j != col && parents[j] != -1 && this.data[i][j] != parents[j]) {
                    achou = false;
                }
                ++j;
            }
            if (achou && parents[col] != -1) {
                ++cont;
                byte by = this.data[i][col];
                absoluteDistribution[by] = absoluteDistribution[by] + 1;
            }
            ++i;
        }
        return this.makeRelativeDistribution(absoluteDistribution, cont, node);
    }

    private double[] makeRelativeDistribution(int[] absolute, int cont, LearningNode node) {
        double[] relative = new double[absolute.length];
        int ri = node.getEstadoTamanho();
        int i = 0;
        while (i < relative.length) {
            relative[i] = (double)(1 + absolute[i]) / (double)(ri + cont);
            ++i;
        }
        return relative;
    }

    private int getEstado(double[] coluna) {
        double numero = Math.random();
        Debug.println("Numero Randomico = " + numero);
        double[][] faixa = this.criarFaixasIntervalo(coluna);
        int i = 0;
        while (i < coluna.length) {
            if (i == 0 ? numero <= faixa[i][1] && numero >= faixa[i][0] : numero <= faixa[i][1] && numero > faixa[i][0]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private double[][] criarFaixasIntervalo(double[] coluna) {
        double[][] faixa = new double[coluna.length][2];
        double[] colunaOrdenada = this.ordenar(coluna);
        double atual = 0.0;
        int i = 0;
        while (i < coluna.length) {
            faixa[i][0] = atual;
            faixa[i][1] = coluna[i] + atual;
            atual = faixa[i][1];
            ++i;
        }
        return faixa;
    }

    private double[] ordenar(double[] coluna) {
        ArrayList<Double> lista = new ArrayList<Double>();
        double[] colunaOrdenada = new double[coluna.length];
        int i = 0;
        while (i < coluna.length) {
            lista.add(new Double(coluna[i]));
            ++i;
        }
        Collections.sort(lista);
        i = 0;
        while (i < lista.size()) {
            colunaOrdenada[i] = (Double)lista.get(i);
            ++i;
        }
        return colunaOrdenada;
    }
}

