/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella.utilities;

import edu.isi.stella.Cons;
import edu.isi.stella.IncompatibleQuantityException;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.Quantity;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.utilities.Utilities;
import java.io.PrintStream;

public class Ratio
extends Quantity {
    public int numerator;
    public int denominator;

    public static Ratio makeRatio(int n, int n2) {
        int n3 = Stella.gcd((int)n, (int)n2);
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        if (n < 0) {
            n4 = (int)((double)(0 - n) / (double)n3);
            bl = true;
        } else {
            n4 = (int)((double)n / (double)n3);
        }
        if (n2 < 0) {
            n5 = (int)((double)(0 - n2) / (double)n3);
            bl = !bl;
        } else {
            n5 = (int)((double)n2 / (double)n3);
        }
        if (bl) {
            n4 = 0 - n4;
        }
        return Ratio.newRatio(n4, n5);
    }

    public static Ratio newRatio(int n, int n2) {
        Ratio ratio = null;
        ratio = new Ratio();
        ratio.numerator = n;
        ratio.denominator = n2;
        return ratio;
    }

    public static String computeUnitsForPrimeId(Ratio ratio) {
        String string = Utilities.computeUnitsForInteger(ratio.numerator, false);
        String string2 = Utilities.computeUnitsForInteger(ratio.denominator, false);
        if (Stella.stringEqlP((String)string2, (String)"")) {
            return string;
        }
        return string + "/" + string2;
    }

    public static Cons computeMeasuresForPrimeId(Ratio ratio, Object[] objectArray) {
        Cons cons = Utilities.computeMeasuresForInteger(ratio.numerator);
        objectArray[0] = Utilities.computeMeasuresForInteger(ratio.denominator);
        return cons;
    }

    public Ratio exponentiate(int n) {
        Ratio ratio = this;
        if (n < 0) {
            return Ratio.newRatio(Utilities.ipower(ratio.denominator, 0 - n), Utilities.ipower(ratio.numerator, 0 - n));
        }
        return Ratio.newRatio(Utilities.ipower(ratio.numerator, n), Utilities.ipower(ratio.denominator, n));
    }

    public Ratio invert() {
        Ratio ratio = this;
        return Ratio.newRatio(ratio.denominator, ratio.numerator);
    }

    public Ratio negate() {
        Ratio ratio = this;
        return Ratio.newRatio(0 - ratio.numerator, ratio.denominator);
    }

    public Ratio divide(Ratio ratio) {
        Ratio ratio2 = this;
        return Ratio.makeRatio(ratio2.numerator * ratio.denominator, ratio2.denominator * ratio.numerator);
    }

    public Ratio multiply(Ratio ratio) {
        Ratio ratio2 = this;
        return Ratio.makeRatio(ratio2.numerator * ratio.numerator, ratio2.denominator * ratio.denominator);
    }

    public Ratio subtract(Ratio ratio) {
        Ratio ratio2 = this;
        return Ratio.makeRatio(ratio2.numerator * ratio.denominator - ratio.numerator * ratio2.denominator, ratio2.denominator * ratio.denominator);
    }

    public Ratio add(Ratio ratio) {
        Ratio ratio2 = this;
        return Ratio.makeRatio(ratio2.numerator * ratio.denominator + ratio.numerator * ratio2.denominator, ratio2.denominator * ratio.denominator);
    }

    public boolean greaterP(Stella_Object stella_Object) {
        Ratio ratio = this;
        Ratio ratio2 = (Ratio)ratio.coerceTo(stella_Object);
        return ratio.numerator * ratio2.denominator > ratio2.numerator * ratio.denominator;
    }

    public boolean greaterEqualP(Stella_Object stella_Object) {
        Ratio ratio = this;
        Ratio ratio2 = (Ratio)ratio.coerceTo(stella_Object);
        return ratio.numerator * ratio2.denominator >= ratio2.numerator * ratio.denominator;
    }

    public boolean lessEqualP(Stella_Object stella_Object) {
        Ratio ratio = this;
        Ratio ratio2 = (Ratio)ratio.coerceTo(stella_Object);
        return ratio.numerator * ratio2.denominator <= ratio2.numerator * ratio.denominator;
    }

    public boolean lessP(Stella_Object stella_Object) {
        Ratio ratio = this;
        Ratio ratio2 = (Ratio)ratio.coerceTo(stella_Object);
        return ratio.numerator * ratio2.denominator < ratio2.numerator * ratio.denominator;
    }

    public boolean objectEqlP(Stella_Object stella_Object) {
        Ratio ratio = this;
        return stella_Object != null && stella_Object.primaryType() == Utilities.SGT_UTILITIES_RATIO && ratio.numerator == ((Ratio)stella_Object).numerator && ratio.denominator == ((Ratio)stella_Object).denominator;
    }

    public Quantity coerceTo(Stella_Object stella_Object) {
        Ratio ratio = this;
        Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object);
        if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Utilities.SGT_UTILITIES_RATIO)) {
            Ratio ratio2 = (Ratio)stella_Object;
            return ratio2;
        }
        if (Surrogate.subtypeOfIntegerP((Surrogate)surrogate)) {
            IntegerWrapper integerWrapper = (IntegerWrapper)stella_Object;
            return Ratio.makeRatio(integerWrapper.wrapperValue, 1);
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("Can't convert `" + stella_Object + "' to a RATIO");
        throw (IncompatibleQuantityException)IncompatibleQuantityException.newIncompatibleQuantityException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    public int hashCode_() {
        Ratio ratio = this;
        return ratio.numerator | ratio.denominator << 10;
    }

    public void printObject(PrintStream printStream) {
        Ratio ratio = this;
        printStream.print(ratio.numerator + "/" + ratio.denominator);
    }

    public static Stella_Object accessRatioSlotValue(Ratio ratio, Symbol symbol, Stella_Object stella_Object, boolean bl) {
        if (symbol == Utilities.SYM_UTILITIES_NUMERATOR) {
            if (bl) {
                ratio.numerator = ((IntegerWrapper)stella_Object).wrapperValue;
            } else {
                stella_Object = IntegerWrapper.wrapInteger((int)ratio.numerator);
            }
        } else if (symbol == Utilities.SYM_UTILITIES_DENOMINATOR) {
            if (bl) {
                ratio.denominator = ((IntegerWrapper)stella_Object).wrapperValue;
            } else {
                stella_Object = IntegerWrapper.wrapInteger((int)ratio.denominator);
            }
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + symbol + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        return stella_Object;
    }

    public Surrogate primaryType() {
        Ratio ratio = this;
        return Utilities.SGT_UTILITIES_RATIO;
    }
}

