/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.stella.utilities;

import edu.isi.stella.BadArgumentException;
import edu.isi.stella.Cons;
import edu.isi.stella.FloatWrapper;
import edu.isi.stella.IncompatibleQuantityException;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.Quantity;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.StringWrapper;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.TimeDuration;
import edu.isi.stella.javalib.Native;
import edu.isi.stella.utilities.IncompatibleUnitsException;
import edu.isi.stella.utilities.Measure;
import edu.isi.stella.utilities.Ratio;
import edu.isi.stella.utilities.Utilities;
import java.io.PrintStream;

public class DimNumber
extends Quantity {
    public Ratio pid;
    public double magnitude;
    public String preferredUnits;

    public static DimNumber parseDimNumber(String string) {
        int n;
        char c = '\u0000';
        int n2 = 32;
        boolean bl = true;
        boolean bl2 = false;
        int n3 = string.length();
        double d = Double.NEGATIVE_INFINITY;
        for (n = 0; n < n3; ++n) {
            c = string.charAt(n);
            if (c == '+' || c == '-') {
                if (!bl) {
                    OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                    outputStringStream.nativeStream.print("Bad number format (sign in bad place): `" + string + "'");
                    throw (BadArgumentException)BadArgumentException.newBadArgumentException((String)outputStringStream.theStringReader()).fillInStackTrace();
                }
                bl = false;
            } else if (c == '.') {
                if (bl2) {
                    OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                    outputStringStream.nativeStream.print("Bad number format (too many decimals): `" + string + "'");
                    throw (BadArgumentException)BadArgumentException.newBadArgumentException((String)outputStringStream.theStringReader()).fillInStackTrace();
                }
                bl2 = true;
                bl = false;
            } else if (Stella.$CHARACTER_TYPE_TABLE$[c] == Utilities.KWD_DIGIT) {
                bl = false;
            } else if (c == 'e' || c == 'E') {
                if (Stella.$CHARACTER_TYPE_TABLE$[n2] != Utilities.KWD_DIGIT) break;
                bl = true;
            } else {
                if (n2 != 101 && n2 != 69) break;
                --n;
                break;
            }
            n2 = c;
        }
        try {
            d = Native.stringToFloat((String)Native.string_subsequence((String)string, (int)0, (int)n));
        }
        catch (Exception exception) {
            try {
                d = Native.stringToInteger((String)Native.string_subsequence((String)string, (int)0, (int)n));
            }
            catch (Exception exception2) {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("Bad number format: `" + string + "'");
                throw (BadArgumentException)BadArgumentException.newBadArgumentException((String)outputStringStream.theStringReader()).fillInStackTrace();
            }
        }
        return DimNumber.makeDimNumber(d, Native.string_subsequence((String)string, (int)n, (int)n3));
    }

    public static DimNumber makeDimNumber(double d, String string) {
        double d2 = Double.NEGATIVE_INFINITY;
        Ratio ratio = null;
        Object object = new Object[1];
        d2 = Utilities.unitToScaleFactorAndId(string, object);
        ratio = (Ratio)((Object)object[0]);
        object = DimNumber.newDimNumber(ratio, d * d2);
        object.preferredUnits = string;
        Object object2 = object;
        return object2;
    }

    public static DimNumber newDimNumber(Ratio ratio, double d) {
        DimNumber dimNumber = null;
        dimNumber = new DimNumber();
        dimNumber.pid = ratio;
        dimNumber.magnitude = d;
        dimNumber.preferredUnits = null;
        return dimNumber;
    }

    public static Cons hoursToHms(DimNumber dimNumber) {
        int n = Native.truncate((double)dimNumber.getMagnitude("hr"));
        DimNumber dimNumber2 = DimNumber.makeDimNumber(n, "hr");
        int n2 = Native.truncate((double)dimNumber.subtract(dimNumber2).getMagnitude("min"));
        DimNumber dimNumber3 = DimNumber.makeDimNumber(n2, "min");
        int n3 = Native.truncate((double)dimNumber.subtract(dimNumber2).subtract(dimNumber3).getMagnitude("s"));
        return Stella.consList((Cons)Stella_Object.cons((Stella_Object)dimNumber2, (Cons)Stella_Object.cons((Stella_Object)dimNumber3, (Cons)Stella_Object.cons((Stella_Object)DimNumber.makeDimNumber(n3, "s"), (Cons)Stella.NIL))));
    }

    public static Cons degreesToDms(DimNumber dimNumber) {
        int n = Native.truncate((double)dimNumber.getMagnitude("deg"));
        DimNumber dimNumber2 = DimNumber.makeDimNumber(n, "deg");
        int n2 = Native.truncate((double)dimNumber.subtract(dimNumber2).getMagnitude("arcmin"));
        DimNumber dimNumber3 = DimNumber.makeDimNumber(n2, "arcmin");
        int n3 = Native.truncate((double)dimNumber.subtract(dimNumber2).subtract(dimNumber3).getMagnitude("arcsec"));
        return Stella.consList((Cons)Stella_Object.cons((Stella_Object)dimNumber2, (Cons)Stella_Object.cons((Stella_Object)dimNumber3, (Cons)Stella_Object.cons((Stella_Object)DimNumber.makeDimNumber(n3, "arcsec"), (Cons)Stella.NIL))));
    }

    public static TimeDuration dimToTimeDuration(DimNumber dimNumber) {
        int n = Native.floor((double)dimNumber.getMagnitude("days"));
        return TimeDuration.makeTimeDuration((int)n, (int)Native.floor((double)dimNumber.subtract(DimNumber.makeDimNumber(n, "days")).getMagnitude("ms")));
    }

    public boolean greaterP(Stella_Object stella_Object) {
        DimNumber dimNumber = this;
        DimNumber dimNumber2 = (DimNumber)dimNumber.coerceTo(stella_Object);
        if (dimNumber.pid.objectEqlP((Stella_Object)dimNumber2.pid)) {
            return dimNumber.magnitude > dimNumber2.magnitude;
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("Can't compare `" + (Object)((Object)dimNumber) + "' and `" + (Object)((Object)dimNumber2) + "' because of incompatible units");
        throw (IncompatibleUnitsException)((Object)IncompatibleUnitsException.newIncompatibleUnitsException(outputStringStream.theStringReader()).fillInStackTrace());
    }

    public boolean greaterEqualP(Stella_Object stella_Object) {
        DimNumber dimNumber = this;
        DimNumber dimNumber2 = (DimNumber)dimNumber.coerceTo(stella_Object);
        if (dimNumber.pid.objectEqlP((Stella_Object)dimNumber2.pid)) {
            return dimNumber.magnitude >= dimNumber2.magnitude;
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("Can't compare `" + (Object)((Object)dimNumber) + "' and `" + (Object)((Object)dimNumber2) + "' because of incompatible units");
        throw (IncompatibleUnitsException)((Object)IncompatibleUnitsException.newIncompatibleUnitsException(outputStringStream.theStringReader()).fillInStackTrace());
    }

    public boolean lessEqualP(Stella_Object stella_Object) {
        DimNumber dimNumber = this;
        DimNumber dimNumber2 = (DimNumber)dimNumber.coerceTo(stella_Object);
        if (dimNumber.pid.objectEqlP((Stella_Object)dimNumber2.pid)) {
            return dimNumber.magnitude <= dimNumber2.magnitude;
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("Can't compare `" + (Object)((Object)dimNumber) + "' and `" + (Object)((Object)dimNumber2) + "' because of incompatible units");
        throw (IncompatibleUnitsException)((Object)IncompatibleUnitsException.newIncompatibleUnitsException(outputStringStream.theStringReader()).fillInStackTrace());
    }

    public boolean lessP(Stella_Object stella_Object) {
        DimNumber dimNumber = this;
        DimNumber dimNumber2 = (DimNumber)dimNumber.coerceTo(stella_Object);
        if (dimNumber.pid.objectEqlP((Stella_Object)dimNumber2.pid)) {
            return dimNumber.magnitude < dimNumber2.magnitude;
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("Can't compare `" + (Object)((Object)dimNumber) + "' and `" + (Object)((Object)dimNumber2) + "' because of incompatible units");
        throw (IncompatibleUnitsException)((Object)IncompatibleUnitsException.newIncompatibleUnitsException(outputStringStream.theStringReader()).fillInStackTrace());
    }

    public DimNumber exponentiate(int n) {
        DimNumber dimNumber = this;
        return DimNumber.newDimNumber(dimNumber.pid.exponentiate(n), Math.pow(dimNumber.magnitude, n));
    }

    public DimNumber squareRoot() {
        DimNumber dimNumber = this;
        double d = Math.sqrt(dimNumber.pid.numerator);
        int n = Native.floor((double)d);
        double d2 = Math.sqrt(dimNumber.pid.denominator);
        int n2 = Native.floor((double)d2);
        if (d == (double)n && d2 == (double)n2) {
            return DimNumber.newDimNumber(Ratio.makeRatio(n, n2), Math.sqrt(dimNumber.magnitude));
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("Attempt to take square root of `" + (Object)((Object)dimNumber) + "'  when the units are not a perfect square");
        throw (BadArgumentException)BadArgumentException.newBadArgumentException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    public DimNumber absoluteValue() {
        DimNumber dimNumber = this;
        if (dimNumber.magnitude < 0.0) {
            return dimNumber.negate();
        }
        return dimNumber;
    }

    public DimNumber invert() {
        DimNumber dimNumber = this;
        return DimNumber.newDimNumber(dimNumber.pid.invert(), 1.0 / dimNumber.magnitude);
    }

    public DimNumber negate() {
        DimNumber dimNumber = this;
        DimNumber dimNumber2 = DimNumber.newDimNumber(dimNumber.pid, 0.0 - dimNumber.magnitude);
        dimNumber2.preferredUnits = dimNumber.preferredUnits;
        DimNumber dimNumber3 = dimNumber2;
        return dimNumber3;
    }

    public DimNumber modulus(DimNumber dimNumber) {
        DimNumber dimNumber2 = this;
        if (dimNumber2.pid.objectEqlP((Stella_Object)dimNumber.pid)) {
            double d = dimNumber2.magnitude / dimNumber.magnitude;
            DimNumber dimNumber3 = DimNumber.newDimNumber(dimNumber2.pid, (d - (double)Native.floor((double)d)) * dimNumber.magnitude);
            dimNumber3.preferredUnits = dimNumber2.preferredUnits;
            DimNumber dimNumber4 = dimNumber3;
            return dimNumber4;
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("Can't perform modulus on `" + (Object)((Object)dimNumber2) + "' and `" + (Object)((Object)dimNumber) + "' because of incompatible units");
        throw (IncompatibleUnitsException)((Object)IncompatibleUnitsException.newIncompatibleUnitsException(outputStringStream.theStringReader()).fillInStackTrace());
    }

    public DimNumber divide(DimNumber dimNumber) {
        DimNumber dimNumber2 = this;
        return DimNumber.newDimNumber(dimNumber2.pid.divide(dimNumber.pid), dimNumber2.magnitude / dimNumber.magnitude);
    }

    public DimNumber multiply(DimNumber dimNumber) {
        DimNumber dimNumber2 = this;
        return DimNumber.newDimNumber(dimNumber2.pid.multiply(dimNumber.pid), dimNumber2.magnitude * dimNumber.magnitude);
    }

    public DimNumber subtract(DimNumber dimNumber) {
        DimNumber dimNumber2 = this;
        if (dimNumber2.pid.objectEqlP((Stella_Object)dimNumber.pid)) {
            return DimNumber.newDimNumber(dimNumber2.pid, dimNumber2.magnitude - dimNumber.magnitude);
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("Can't subtract `" + (Object)((Object)dimNumber) + "' from `" + (Object)((Object)dimNumber2) + "' because of incompatible units");
        throw (IncompatibleUnitsException)((Object)IncompatibleUnitsException.newIncompatibleUnitsException(outputStringStream.theStringReader()).fillInStackTrace());
    }

    public DimNumber add(DimNumber dimNumber) {
        DimNumber dimNumber2 = this;
        if (dimNumber2.pid.objectEqlP((Stella_Object)dimNumber.pid)) {
            return DimNumber.newDimNumber(dimNumber2.pid, dimNumber2.magnitude + dimNumber.magnitude);
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("Can't add `" + (Object)((Object)dimNumber2) + "' and `" + (Object)((Object)dimNumber) + "' because of incompatible units");
        throw (IncompatibleUnitsException)((Object)IncompatibleUnitsException.newIncompatibleUnitsException(outputStringStream.theStringReader()).fillInStackTrace());
    }

    public int signum() {
        DimNumber dimNumber = this;
        if (dimNumber.magnitude > 0.0) {
            return 1;
        }
        if (dimNumber.magnitude == 0.0) {
            return 0;
        }
        return -1;
    }

    public int hashCode_() {
        DimNumber dimNumber = this;
        return (int)(Double.doubleToLongBits(dimNumber.magnitude) ^ Double.doubleToLongBits(dimNumber.magnitude) >>> 32) ^ dimNumber.pid.hashCode_();
    }

    public boolean objectEqlP(Stella_Object stella_Object) {
        DimNumber dimNumber = this;
        return stella_Object != null && stella_Object.primaryType() == Utilities.SGT_UTILITIES_DIM_NUMBER && dimNumber.pid.objectEqlP((Stella_Object)((DimNumber)stella_Object).pid) && dimNumber.magnitude == ((DimNumber)stella_Object).magnitude;
    }

    public static boolean compatibleUnitsP(DimNumber dimNumber, DimNumber dimNumber2) {
        return dimNumber.pid.objectEqlP((Stella_Object)dimNumber2.pid);
    }

    public String formatDimNumber(String string, int n) {
        DimNumber dimNumber = this;
        if (string == null) {
            string = dimNumber.getUnit();
        }
        if (n != Integer.MIN_VALUE) {
            return Native.formatFloat((double)dimNumber.getMagnitude(string), (int)n) + string;
        }
        return Native.floatToString((double)dimNumber.getMagnitude(string)) + string;
    }

    public Cons getBaseMeasures(Object[] objectArray) {
        DimNumber dimNumber = this;
        return Ratio.computeMeasuresForPrimeId(dimNumber.pid, objectArray);
    }

    public Measure getMeasure() {
        DimNumber dimNumber = this;
        return (Measure)Utilities.$PRIME_TO_MEASURE_TABLE$.lookup((Stella_Object)dimNumber.pid);
    }

    public String getBaseUnit() {
        DimNumber dimNumber = this;
        Measure measure = (Measure)Utilities.$PRIME_TO_MEASURE_TABLE$.lookup((Stella_Object)dimNumber.pid);
        if (measure != null) {
            return measure.baseUnit;
        }
        return Ratio.computeUnitsForPrimeId(dimNumber.pid);
    }

    public String getUnit() {
        DimNumber dimNumber = this;
        String string = dimNumber.preferredUnits;
        if (string != null) {
            return string;
        }
        return dimNumber.getBaseUnit();
    }

    public double getMagnitude(String string) {
        DimNumber dimNumber = this;
        double d = Double.NEGATIVE_INFINITY;
        Ratio ratio = null;
        OutputStringStream outputStringStream = new Object[1];
        d = Utilities.unitToScaleFactorAndId(string, (Object[])outputStringStream);
        ratio = (Ratio)((Object)outputStringStream[0]);
        if (Stella_Object.eqlP((Stella_Object)ratio, (Stella_Object)dimNumber.pid)) {
            return dimNumber.magnitude / d;
        }
        outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("Unit `" + string + "' is not compatible with `" + dimNumber.getUnit() + "'");
        throw (IncompatibleUnitsException)((Object)IncompatibleUnitsException.newIncompatibleUnitsException(outputStringStream.theStringReader()).fillInStackTrace());
    }

    public Quantity coerceTo(Stella_Object stella_Object) {
        DimNumber dimNumber = this;
        Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object);
        if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Utilities.SGT_UTILITIES_DIM_NUMBER)) {
            DimNumber dimNumber2 = (DimNumber)stella_Object;
            return dimNumber2;
        }
        if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Utilities.SGT_STELLA_TIME_DURATION)) {
            TimeDuration timeDuration = (TimeDuration)stella_Object;
            return Utilities.timeDurationToDim(timeDuration);
        }
        if (Surrogate.subtypeOfIntegerP((Surrogate)surrogate)) {
            IntegerWrapper integerWrapper = (IntegerWrapper)stella_Object;
            return DimNumber.makeDimNumber(integerWrapper.wrapperValue, "");
        }
        if (Surrogate.subtypeOfFloatP((Surrogate)surrogate)) {
            FloatWrapper floatWrapper = (FloatWrapper)stella_Object;
            return DimNumber.makeDimNumber(floatWrapper.wrapperValue, "");
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("Can't convert `" + stella_Object + "' to a DIM-NUMBER");
        throw (IncompatibleQuantityException)IncompatibleQuantityException.newIncompatibleQuantityException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    public void printObject(PrintStream printStream) {
        DimNumber dimNumber = this;
        printStream.print("<" + dimNumber.getMagnitude(dimNumber.getUnit()) + dimNumber.getUnit() + ">");
    }

    public static Stella_Object accessDimNumberSlotValue(DimNumber dimNumber, Symbol symbol, Stella_Object object, boolean bl) {
        if (symbol == Utilities.SYM_UTILITIES_PID) {
            if (bl) {
                dimNumber.pid = (Ratio)((Object)object);
            } else {
                object = dimNumber.pid;
            }
        } else if (symbol == Utilities.SYM_UTILITIES_MAGNITUDE) {
            if (bl) {
                dimNumber.magnitude = ((FloatWrapper)object).wrapperValue;
            } else {
                object = FloatWrapper.wrapFloat((double)dimNumber.magnitude);
            }
        } else if (symbol == Utilities.SYM_UTILITIES_PREFERRED_UNITS) {
            if (bl) {
                dimNumber.preferredUnits = ((StringWrapper)object).wrapperValue;
            } else {
                object = StringWrapper.wrapString((String)dimNumber.preferredUnits);
            }
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + symbol + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        return object;
    }

    public Surrogate primaryType() {
        DimNumber dimNumber = this;
        return Utilities.SGT_UTILITIES_DIM_NUMBER;
    }
}

