/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.powerloom.pl_kernel_kb;

import edu.isi.powerloom.logic.Clash;
import edu.isi.powerloom.logic.Logic;
import edu.isi.powerloom.logic.LogicObject;
import edu.isi.powerloom.logic.Skolem;
import edu.isi.powerloom.pl_kernel_kb.PlKernelKb;
import edu.isi.stella.BooleanWrapper;
import edu.isi.stella.Context;
import edu.isi.stella.FloatWrapper;
import edu.isi.stella.IncompatibleQuantityException;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.KeyValueList;
import edu.isi.stella.Keyword;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.Thing;
import edu.isi.stella.javalib.Native;
import java.io.PrintStream;

public class IntervalCache
extends Thing {
    public Context homeContext;
    public LogicObject intervalMember;
    public Stella_Object lowerBound;
    public Stella_Object upperBound;
    public boolean strictLowerBoundP;
    public boolean strictUpperBoundP;

    public static IntervalCache newIntervalCache() {
        IntervalCache intervalCache = null;
        intervalCache = new IntervalCache();
        intervalCache.dynamicSlots = KeyValueList.newKeyValueList();
        intervalCache.surrogateValueInverse = null;
        intervalCache.strictUpperBoundP = false;
        intervalCache.strictLowerBoundP = false;
        intervalCache.upperBound = null;
        intervalCache.lowerBound = null;
        intervalCache.intervalMember = null;
        intervalCache.homeContext = null;
        return intervalCache;
    }

    public static Stella_Object accessIntervalCacheBounds(IntervalCache intervalCache, Keyword keyword, Object[] objectArray) {
        if (intervalCache == null) {
            Stella_Object stella_Object = null;
            objectArray[0] = BooleanWrapper.wrapBoolean((boolean)false);
            return stella_Object;
        }
        if (keyword == PlKernelKb.KWD_LOWER_BOUND) {
            Stella_Object stella_Object = intervalCache.lowerBound;
            objectArray[0] = BooleanWrapper.wrapBoolean((boolean)intervalCache.strictLowerBoundP);
            return stella_Object;
        }
        if (keyword == PlKernelKb.KWD_UPPER_BOUND) {
            Stella_Object stella_Object = intervalCache.upperBound;
            objectArray[0] = BooleanWrapper.wrapBoolean((boolean)intervalCache.strictUpperBoundP);
            return stella_Object;
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    public static void unifyIntervalCaches(IntervalCache intervalCache, IntervalCache intervalCache2, Surrogate surrogate) {
        if (surrogate == PlKernelKb.SGT_PL_KERNEL_KB_g || surrogate == Logic.SGT_PL_KERNEL_KB_ge) {
            intervalCache.propagateInequalityToIntervalCache(IntervalCache.accessIntervalCacheBounds(intervalCache2, PlKernelKb.KWD_LOWER_BOUND, new Object[1]), surrogate);
            intervalCache2.propagateInequalityToIntervalCache(IntervalCache.accessIntervalCacheBounds(intervalCache, PlKernelKb.KWD_UPPER_BOUND, new Object[1]), PlKernelKb.inverseInequalityOperator(surrogate));
        } else if (surrogate == PlKernelKb.SGT_PL_KERNEL_KB_l || surrogate == PlKernelKb.SGT_PL_KERNEL_KB_el) {
            intervalCache.propagateInequalityToIntervalCache(IntervalCache.accessIntervalCacheBounds(intervalCache2, PlKernelKb.KWD_UPPER_BOUND, new Object[1]), surrogate);
            intervalCache2.propagateInequalityToIntervalCache(IntervalCache.accessIntervalCacheBounds(intervalCache, PlKernelKb.KWD_LOWER_BOUND, new Object[1]), PlKernelKb.inverseInequalityOperator(surrogate));
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + surrogate + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
    }

    public void propagateInequalityToIntervalCache(Stella_Object stella_Object, Surrogate surrogate) {
        boolean bl;
        IntervalCache intervalCache;
        block13: {
            intervalCache = this;
            if (PlKernelKb.nullLiteralWrapperP(stella_Object)) {
                return;
            }
            if (!Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_STELLA_NUMBER_WRAPPER) && !Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_QUANTITY_LOGIC_WRAPPER)) {
                return;
            }
            bl = false;
            try {
                if (surrogate == PlKernelKb.SGT_PL_KERNEL_KB_g) {
                    if (intervalCache.lowerBound == null || PlKernelKb.compareIntervalBoundsP(PlKernelKb.SGT_PL_KERNEL_KB_g, stella_Object, intervalCache.lowerBound) || Stella_Object.eqlP((Stella_Object)stella_Object, (Stella_Object)intervalCache.lowerBound) && !intervalCache.strictLowerBoundP) {
                        intervalCache.lowerBound = stella_Object;
                        intervalCache.strictLowerBoundP = true;
                        bl = true;
                    }
                    break block13;
                }
                if (surrogate == Logic.SGT_PL_KERNEL_KB_ge) {
                    if (intervalCache.lowerBound == null || PlKernelKb.compareIntervalBoundsP(PlKernelKb.SGT_PL_KERNEL_KB_g, stella_Object, intervalCache.lowerBound)) {
                        intervalCache.lowerBound = stella_Object;
                        intervalCache.strictLowerBoundP = false;
                        bl = true;
                    }
                    break block13;
                }
                if (surrogate == PlKernelKb.SGT_PL_KERNEL_KB_l) {
                    if (intervalCache.upperBound == null || PlKernelKb.compareIntervalBoundsP(PlKernelKb.SGT_PL_KERNEL_KB_l, stella_Object, intervalCache.upperBound) || stella_Object == intervalCache.upperBound && !intervalCache.strictUpperBoundP) {
                        intervalCache.upperBound = stella_Object;
                        intervalCache.strictUpperBoundP = true;
                        bl = true;
                    }
                    break block13;
                }
                if (surrogate == PlKernelKb.SGT_PL_KERNEL_KB_el) {
                    if (intervalCache.upperBound == null || PlKernelKb.compareIntervalBoundsP(PlKernelKb.SGT_PL_KERNEL_KB_l, stella_Object, intervalCache.upperBound)) {
                        intervalCache.upperBound = stella_Object;
                        intervalCache.strictUpperBoundP = false;
                        bl = true;
                    }
                    break block13;
                }
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("`" + surrogate + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
            }
            catch (IncompatibleQuantityException incompatibleQuantityException) {
                IntervalCache.signalIntervalClash(intervalCache);
            }
        }
        if (bl) {
            intervalCache.evaluateTighterInterval();
        }
    }

    public void evaluateTighterInterval() {
        IntervalCache intervalCache = this;
        if (intervalCache.lowerBound != null && intervalCache.upperBound != null) {
            if (Stella_Object.eqlP((Stella_Object)intervalCache.lowerBound, (Stella_Object)intervalCache.upperBound)) {
                if (intervalCache.strictLowerBoundP || intervalCache.strictUpperBoundP) {
                    IntervalCache.signalIntervalClash(intervalCache);
                } else {
                    Logic.equateValues((Stella_Object)intervalCache.intervalMember, intervalCache.lowerBound);
                }
            } else {
                try {
                    if (PlKernelKb.compareIntervalBoundsP(PlKernelKb.SGT_PL_KERNEL_KB_g, intervalCache.lowerBound, intervalCache.upperBound)) {
                        IntervalCache.signalIntervalClash(intervalCache);
                    }
                    if (intervalCache.integerValuedMemberP()) {
                        intervalCache.evaluateTighterIntegerInterval();
                    }
                }
                catch (IncompatibleQuantityException incompatibleQuantityException) {
                    IntervalCache.signalIntervalClash(intervalCache);
                }
            }
        }
        PlKernelKb.evaluateAdjacentInequalities(intervalCache.intervalMember);
    }

    public void evaluateTighterIntegerInterval() {
        IntervalCache intervalCache = this;
        IntegerWrapper integerWrapper = intervalCache.integerLowerBound();
        IntegerWrapper integerWrapper2 = intervalCache.integerUpperBound();
        if (integerWrapper != null && integerWrapper2 != null && Stella_Object.eqlP((Stella_Object)integerWrapper, (Stella_Object)integerWrapper2)) {
            Logic.equateValues((Stella_Object)intervalCache.intervalMember, (Stella_Object)integerWrapper);
        }
    }

    public IntegerWrapper integerUpperBound() {
        IntervalCache intervalCache = this;
        Stella_Object stella_Object = intervalCache.upperBound;
        if (stella_Object != null) {
            Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object);
            if (Surrogate.subtypeOfIntegerP((Surrogate)surrogate)) {
                IntegerWrapper integerWrapper = (IntegerWrapper)stella_Object;
                if (intervalCache.strictUpperBoundP) {
                    return IntegerWrapper.wrapInteger((int)(IntegerWrapper.unwrapInteger((IntegerWrapper)integerWrapper) - 1));
                }
                return integerWrapper;
            }
            if (Surrogate.subtypeOfFloatP((Surrogate)surrogate)) {
                FloatWrapper floatWrapper = (FloatWrapper)stella_Object;
                if (intervalCache.strictUpperBoundP) {
                    if (Stella.integerValuedP((double)FloatWrapper.unwrapFloat((FloatWrapper)floatWrapper))) {
                        return IntegerWrapper.wrapInteger((int)(Native.floor((double)FloatWrapper.unwrapFloat((FloatWrapper)floatWrapper)) - 1));
                    }
                    return IntegerWrapper.wrapInteger((int)Native.floor((double)FloatWrapper.unwrapFloat((FloatWrapper)floatWrapper)));
                }
                return IntegerWrapper.wrapInteger((int)Native.floor((double)FloatWrapper.unwrapFloat((FloatWrapper)floatWrapper)));
            }
            return null;
        }
        return null;
    }

    public IntegerWrapper integerLowerBound() {
        IntervalCache intervalCache = this;
        Stella_Object stella_Object = intervalCache.lowerBound;
        if (stella_Object != null) {
            Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object);
            if (Surrogate.subtypeOfIntegerP((Surrogate)surrogate)) {
                IntegerWrapper integerWrapper = (IntegerWrapper)stella_Object;
                if (intervalCache.strictLowerBoundP) {
                    return IntegerWrapper.wrapInteger((int)(IntegerWrapper.unwrapInteger((IntegerWrapper)integerWrapper) + 1));
                }
                return integerWrapper;
            }
            if (Surrogate.subtypeOfFloatP((Surrogate)surrogate)) {
                FloatWrapper floatWrapper = (FloatWrapper)stella_Object;
                if (intervalCache.strictLowerBoundP) {
                    if (Stella.integerValuedP((double)FloatWrapper.unwrapFloat((FloatWrapper)floatWrapper))) {
                        return IntegerWrapper.wrapInteger((int)(Native.floor((double)FloatWrapper.unwrapFloat((FloatWrapper)floatWrapper)) + 1));
                    }
                    return IntegerWrapper.wrapInteger((int)Native.ceiling((double)FloatWrapper.unwrapFloat((FloatWrapper)floatWrapper)));
                }
                return IntegerWrapper.wrapInteger((int)Native.ceiling((double)FloatWrapper.unwrapFloat((FloatWrapper)floatWrapper)));
            }
            return null;
        }
        return null;
    }

    public boolean integerValuedMemberP() {
        IntervalCache intervalCache = this;
        LogicObject logicObject = intervalCache.intervalMember;
        return Stella_Object.isaP((Stella_Object)logicObject, (Surrogate)Logic.SGT_LOGIC_SKOLEM) && Surrogate.subtypeOfP((Surrogate)((Skolem)logicObject).skolemType, (Surrogate)Logic.SGT_STELLA_INTEGER);
    }

    public static void signalIntervalClash(IntervalCache intervalCache) {
        intervalCache.intervalMember.markAsIncoherent();
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.println("Clash in interval values `" + (Object)((Object)intervalCache) + "'");
        throw (Clash)((Object)Clash.newClash(outputStringStream.theStringReader()).fillInStackTrace());
    }

    public void printObject(PrintStream printStream) {
        IntervalCache intervalCache = this;
        printStream.print("|cache-of: " + (Object)((Object)intervalCache.intervalMember) + " ");
        PlKernelKb.printInterval(printStream, intervalCache.lowerBound, intervalCache.strictLowerBoundP, intervalCache.upperBound, intervalCache.strictUpperBoundP);
        printStream.print("|");
    }

    public static Stella_Object accessIntervalCacheSlotValue(IntervalCache intervalCache, Symbol symbol, Stella_Object object, boolean bl) {
        if (symbol == Logic.SYM_STELLA_HOME_CONTEXT) {
            if (bl) {
                intervalCache.homeContext = (Context)object;
            } else {
                object = intervalCache.homeContext;
            }
        } else if (symbol == PlKernelKb.SYM_PL_KERNEL_KB_INTERVAL_MEMBER) {
            if (bl) {
                intervalCache.intervalMember = (LogicObject)((Object)object);
            } else {
                object = intervalCache.intervalMember;
            }
        } else if (symbol == PlKernelKb.SYM_STELLA_LOWER_BOUND) {
            if (bl) {
                intervalCache.lowerBound = object;
            } else {
                object = intervalCache.lowerBound;
            }
        } else if (symbol == PlKernelKb.SYM_STELLA_UPPER_BOUND) {
            if (bl) {
                intervalCache.upperBound = object;
            } else {
                object = intervalCache.upperBound;
            }
        } else if (symbol == PlKernelKb.SYM_PL_KERNEL_KB_STRICT_LOWER_BOUNDp) {
            if (bl) {
                intervalCache.strictLowerBoundP = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)((BooleanWrapper)object));
            } else {
                object = intervalCache.strictLowerBoundP ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else if (symbol == PlKernelKb.SYM_PL_KERNEL_KB_STRICT_UPPER_BOUNDp) {
            if (bl) {
                intervalCache.strictUpperBoundP = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)((BooleanWrapper)object));
            } else {
                object = intervalCache.strictUpperBoundP ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else if (bl) {
            KeyValueList.setDynamicSlotValue((KeyValueList)intervalCache.dynamicSlots, (Symbol)symbol, (Stella_Object)object, null);
        } else {
            object = intervalCache.dynamicSlots.lookup((Stella_Object)symbol);
        }
        return object;
    }

    public Surrogate primaryType() {
        IntervalCache intervalCache = this;
        return Logic.SGT_PL_KERNEL_KB_INTERVAL_CACHE;
    }
}

