/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.powerloom.logic;

import edu.isi.powerloom.logic.Logic;
import edu.isi.stella.Cons;
import edu.isi.stella.FloatWrapper;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.List;
import edu.isi.stella.Module;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.StandardObject;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.Vector;

public class TrainingExample
extends StandardObject {
    public Cons query;
    public Symbol concept;
    public Symbol name;
    public double score;
    public Module module;
    public List inputFeatures;
    public Vector input;
    public Cons facts;
    public Vector nnHidden;
    public Stella_Object output;
    public double temp;
    public Stella_Object cachedSolution;
    public int timestamp;

    public static TrainingExample newTrainingExample() {
        TrainingExample trainingExample = null;
        trainingExample = new TrainingExample();
        trainingExample.timestamp = Integer.MIN_VALUE;
        trainingExample.cachedSolution = null;
        trainingExample.temp = Double.NEGATIVE_INFINITY;
        trainingExample.output = null;
        trainingExample.nnHidden = null;
        trainingExample.facts = null;
        trainingExample.input = null;
        trainingExample.inputFeatures = null;
        trainingExample.module = null;
        trainingExample.score = Double.NEGATIVE_INFINITY;
        trainingExample.name = null;
        trainingExample.concept = null;
        trainingExample.query = null;
        return trainingExample;
    }

    public static List getNearestNeighbors(TrainingExample trainingExample, List list, int n) {
        List list2 = List.newList();
        Module module = (Module)Stella.$MODULE$.get();
        Vector vector = Vector.newVector((int)n);
        int n2 = 0;
        double d = 0.0;
        Vector vector2 = Vector.newVector((int)n);
        int n3 = Integer.MIN_VALUE;
        int n4 = 0;
        int n5 = n - 1;
        while (n4 <= n5) {
            n3 = n4++;
            vector2.theArray[n3] = FloatWrapper.wrapFloat((double)999999.0);
        }
        if (trainingExample.input == null) {
            trainingExample.input = Logic.createInputSignature(trainingExample.query);
        }
        TrainingExample trainingExample2 = null;
        Cons cons = list.theConsList;
        while (cons != Stella.NIL) {
            trainingExample2 = (TrainingExample)cons.value;
            if (trainingExample2.input == null) {
                if (trainingExample2.module != null) {
                    trainingExample2.module.changeModule();
                }
                trainingExample2.input = Logic.createInputSignature(trainingExample2.query);
                module.changeModule();
            }
            if (trainingExample.input.length() == 1) {
                trainingExample.input = Logic.createInputSignature(trainingExample.query);
            }
            d = (double)Logic.hammingDistance(trainingExample.input, trainingExample2.input) + 0.0;
            if (Logic.$PRINT_CASE_DISTANCES$) {
                System.out.println("  Distance from " + trainingExample2.query.last() + ": " + d);
            }
            trainingExample2.temp = d;
            if (d < ((FloatWrapper)vector2.theArray[n2]).wrapperValue) {
                vector2.theArray[n2] = FloatWrapper.wrapFloat((double)d);
                vector.theArray[n2] = trainingExample2;
                n2 = 0;
                n5 = Integer.MIN_VALUE;
                int n6 = n - 1;
                for (int i = 1; i <= n6; ++i) {
                    n5 = i;
                    if (!(((FloatWrapper)vector2.theArray[n5]).wrapperValue > ((FloatWrapper)vector2.theArray[n2]).wrapperValue)) continue;
                    n2 = n5;
                }
            }
            cons = cons.rest;
        }
        int n7 = Integer.MIN_VALUE;
        n5 = n - 1;
        Cons cons2 = null;
        for (int i = 0; i <= n5; ++i) {
            n7 = i;
            if (cons2 == null) {
                cons2 = Stella_Object.cons((Stella_Object)((TrainingExample)vector.theArray[n7]), (Cons)Stella.NIL);
                if (list2.theConsList == Stella.NIL) {
                    list2.theConsList = cons2;
                    continue;
                }
                Cons.addConsToEndOfConsList((Cons)list2.theConsList, (Cons)cons2);
                continue;
            }
            cons2 = cons2.rest = Stella_Object.cons((Stella_Object)((TrainingExample)vector.theArray[n7]), (Cons)Stella.NIL);
        }
        return list2;
    }

    public static List getNnNearestNeighbors(TrainingExample trainingExample, List list, int n) {
        List list2 = List.newList();
        Module module = (Module)Stella.$MODULE$.get();
        Vector vector = Vector.newVector((int)n);
        int n2 = 0;
        double d = 0.0;
        Vector vector2 = Vector.newVector((int)n);
        Logic.shuffleList(list);
        int n3 = Integer.MIN_VALUE;
        int n4 = 0;
        int n5 = n - 1;
        while (n4 <= n5) {
            n3 = n4++;
            vector2.theArray[n3] = FloatWrapper.wrapFloat((double)999999.0);
        }
        trainingExample.nnHidden = Logic.createHiddenSignature(trainingExample.query);
        TrainingExample trainingExample2 = null;
        Cons cons = list.theConsList;
        while (cons != Stella.NIL) {
            trainingExample2 = (TrainingExample)cons.value;
            if (trainingExample2.nnHidden == null) {
                if (trainingExample2.module != null) {
                    trainingExample2.module.changeModule();
                }
                if (trainingExample2.nnHidden == null) {
                    trainingExample2.nnHidden = Logic.createHiddenSignature(trainingExample2.query);
                }
                module.changeModule();
            }
            d = Logic.euclideanDistance(trainingExample.nnHidden, trainingExample2.nnHidden) + 0.0;
            if (Logic.$PRINT_CASE_DISTANCES$) {
                System.out.println("  Distance from " + trainingExample2.query.last() + ": " + d);
            }
            trainingExample2.temp = d;
            if (d < ((FloatWrapper)vector2.theArray[n2]).wrapperValue) {
                vector2.theArray[n2] = FloatWrapper.wrapFloat((double)d);
                vector.theArray[n2] = trainingExample2;
                n2 = 0;
                n5 = Integer.MIN_VALUE;
                int n6 = n - 1;
                for (int i = 1; i <= n6; ++i) {
                    n5 = i;
                    if (!(((FloatWrapper)vector2.theArray[n5]).wrapperValue > ((FloatWrapper)vector2.theArray[n2]).wrapperValue)) continue;
                    n2 = n5;
                }
            }
            cons = cons.rest;
        }
        int n7 = Integer.MIN_VALUE;
        n5 = n - 1;
        Cons cons2 = null;
        for (int i = 0; i <= n5; ++i) {
            n7 = i;
            if ((TrainingExample)vector.theArray[n7] == null) continue;
            if (cons2 == null) {
                cons2 = Stella_Object.cons((Stella_Object)((TrainingExample)vector.theArray[n7]), (Cons)Stella.NIL);
                if (list2.theConsList == Stella.NIL) {
                    list2.theConsList = cons2;
                    continue;
                }
                Cons.addConsToEndOfConsList((Cons)list2.theConsList, (Cons)cons2);
                continue;
            }
            cons2 = cons2.rest = Stella_Object.cons((Stella_Object)((TrainingExample)vector.theArray[n7]), (Cons)Stella.NIL);
        }
        return list2;
    }

    public static void printTrainingExample(TrainingExample trainingExample) {
        System.out.println(trainingExample.query + " in " + trainingExample.module);
    }

    public static Stella_Object accessTrainingExampleSlotValue(TrainingExample trainingExample, Symbol symbol, Stella_Object stella_Object, boolean bl) {
        if (symbol == Logic.SYM_LOGIC_QUERY) {
            if (bl) {
                trainingExample.query = (Cons)stella_Object;
            } else {
                stella_Object = trainingExample.query;
            }
        } else if (symbol == Logic.SYM_LOGIC_CONCEPT) {
            if (bl) {
                trainingExample.concept = (Symbol)stella_Object;
            } else {
                stella_Object = trainingExample.concept;
            }
        } else if (symbol == Logic.SYM_STELLA_NAME) {
            if (bl) {
                trainingExample.name = (Symbol)stella_Object;
            } else {
                stella_Object = trainingExample.name;
            }
        } else if (symbol == Logic.SYM_LOGIC_SCORE) {
            if (bl) {
                trainingExample.score = ((FloatWrapper)stella_Object).wrapperValue;
            } else {
                stella_Object = FloatWrapper.wrapFloat((double)trainingExample.score);
            }
        } else if (symbol == Logic.SYM_STELLA_MODULE) {
            if (bl) {
                trainingExample.module = (Module)stella_Object;
            } else {
                stella_Object = trainingExample.module;
            }
        } else if (symbol == Logic.SYM_LOGIC_INPUT_FEATURES) {
            if (bl) {
                trainingExample.inputFeatures = (List)stella_Object;
            } else {
                stella_Object = trainingExample.inputFeatures;
            }
        } else if (symbol == Logic.SYM_LOGIC_INPUT) {
            if (bl) {
                trainingExample.input = (Vector)stella_Object;
            } else {
                stella_Object = trainingExample.input;
            }
        } else if (symbol == Logic.SYM_LOGIC_FACTS) {
            if (bl) {
                trainingExample.facts = (Cons)stella_Object;
            } else {
                stella_Object = trainingExample.facts;
            }
        } else if (symbol == Logic.SYM_LOGIC_NN_HIDDEN) {
            if (bl) {
                trainingExample.nnHidden = (Vector)stella_Object;
            } else {
                stella_Object = trainingExample.nnHidden;
            }
        } else if (symbol == Logic.SYM_LOGIC_OUTPUT) {
            if (bl) {
                trainingExample.output = stella_Object;
            } else {
                stella_Object = trainingExample.output;
            }
        } else if (symbol == Logic.SYM_LOGIC_TEMP) {
            if (bl) {
                trainingExample.temp = ((FloatWrapper)stella_Object).wrapperValue;
            } else {
                stella_Object = FloatWrapper.wrapFloat((double)trainingExample.temp);
            }
        } else if (symbol == Logic.SYM_LOGIC_CACHED_SOLUTION) {
            if (bl) {
                trainingExample.cachedSolution = stella_Object;
            } else {
                stella_Object = trainingExample.cachedSolution;
            }
        } else if (symbol == Logic.SYM_LOGIC_TIMESTAMP) {
            if (bl) {
                trainingExample.timestamp = ((IntegerWrapper)stella_Object).wrapperValue;
            } else {
                stella_Object = IntegerWrapper.wrapInteger((int)trainingExample.timestamp);
            }
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + symbol + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        return stella_Object;
    }

    public Surrogate primaryType() {
        TrainingExample trainingExample = this;
        return Logic.SGT_LOGIC_TRAINING_EXAMPLE;
    }
}

