/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.powerloom.logic;

import edu.isi.powerloom.logic.Clash;
import edu.isi.powerloom.logic.Description;
import edu.isi.powerloom.logic.Logic;
import edu.isi.powerloom.logic.LogicObject;
import edu.isi.powerloom.logic.NamedDescription;
import edu.isi.powerloom.logic.PatternVariable;
import edu.isi.powerloom.logic.Proposition;
import edu.isi.powerloom.logic.PropositionError;
import edu.isi.powerloom.logic.QueryIterator;
import edu.isi.powerloom.pl_kernel_kb.PlKernelKb;
import edu.isi.stella.Cons;
import edu.isi.stella.Context;
import edu.isi.stella.GeneralizedSymbol;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.Iterator;
import edu.isi.stella.KeyValueList;
import edu.isi.stella.Keyword;
import edu.isi.stella.List;
import edu.isi.stella.Module;
import edu.isi.stella.NumberWrapper;
import edu.isi.stella.OutputStream;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.Relation;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.StorageSlot;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.Thing;
import edu.isi.stella.World;
import edu.isi.stella.javalib.Native;

public class Skolem
extends LogicObject {
    public Surrogate skolemType;
    public Symbol skolemName;
    public Stella_Object variableValue;
    public Proposition definingProposition;

    public static Skolem newSkolem() {
        Skolem skolem = null;
        skolem = new Skolem();
        skolem.dependentPropositionsIndex = null;
        skolem.dynamicSlots = KeyValueList.newKeyValueList();
        skolem.surrogateValueInverse = null;
        skolem.variableValueInverse = null;
        skolem.homeContext = (Module)Stella.$MODULE$.get();
        skolem.definingProposition = null;
        skolem.variableValue = null;
        skolem.skolemName = null;
        skolem.skolemType = null;
        LogicObject.logLogicObject(skolem);
        return skolem;
    }

    public static Proposition inheritEquivalentProposition(Skolem skolem, Stella_Object stella_Object) {
        Proposition proposition = null;
        Proposition proposition2 = null;
        Iterator iterator = Logic.unfilteredDependentPropositions((Stella_Object)skolem, Logic.SGT_PL_KERNEL_KB_EQUIVALENT).allocateIterator();
        while (iterator.nextP()) {
            proposition2 = (Proposition)iterator.value;
            if ((Surrogate)proposition2.operator != Logic.SGT_PL_KERNEL_KB_EQUIVALENT || !Stella_Object.eqlP((Stella_Object)proposition2.arguments.theArray[0], (Stella_Object)stella_Object) && !Stella_Object.eqlP((Stella_Object)proposition2.arguments.theArray[1], (Stella_Object)stella_Object)) continue;
            proposition = proposition2;
            break;
        }
        if ((proposition2 = proposition) == null) {
            proposition2 = Logic.createProposition(Logic.SYM_LOGIC_EQUIVALENT, 2);
            proposition2.arguments.theArray[0] = skolem;
            proposition2.arguments.theArray[1] = stella_Object;
        }
        return proposition2;
    }

    public static boolean valueClashesWithSkolemP(Skolem skolem, Stella_Object stella_Object) {
        Surrogate surrogate = skolem.skolemType;
        if (surrogate == null) {
            return false;
        }
        if (!((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null || Logic.checkStrictTypeP(stella_Object, surrogate, true))) {
            return true;
        }
        if (Logic.literalTypeP(surrogate) && Logic.logicalSubtypeOfP(surrogate, Logic.SGT_STELLA_NUMBER)) {
            return !PlKernelKb.satisfiesIntervalBoundsP((Stella_Object)skolem, (Stella_Object)((NumberWrapper)stella_Object));
        }
        return false;
    }

    public static Stella_Object generateSkolem(Skolem skolem) {
        if (Logic.nativeValueOf((Stella_Object)skolem) != null) {
            return Logic.generateTerm(Logic.nativeValueOf((Stella_Object)skolem));
        }
        if (skolem.definingProposition != null && Stella_Object.accessInContext((Stella_Object)skolem.variableValue, (Context)skolem.homeContext, (boolean)false) == null) {
            return Proposition.generateFunctionAsTerm(skolem.definingProposition);
        }
        if (Logic.innermostOf((Stella_Object)skolem) != null && skolem != Logic.innermostOf((Stella_Object)skolem)) {
            return Logic.generateTerm(Logic.innermostOf((Stella_Object)skolem));
        }
        if (LogicObject.conceptPrototypeP(skolem)) {
            return Stella.list$((Cons)Stella_Object.cons((Stella_Object)Logic.SYM_PL_KERNEL_KB_CONCEPT_PROTOTYPE, (Cons)Stella_Object.cons((Stella_Object)Logic.generateTerm((Stella_Object)LogicObject.conceptPrototypeOf(skolem)), (Cons)Stella_Object.cons((Stella_Object)Stella.NIL, (Cons)Stella.NIL))));
        }
        Stella.STANDARD_WARNING.nativeStream.println("Warning: Don't know how to generate skolem: `" + (Object)((Object)skolem) + "'");
        Stella.STANDARD_WARNING.nativeStream.println();
        return Logic.SYM_LOGIC_UNIDENTIFIED_SKOLEM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printSkolem(Skolem skolem, OutputStream outputStream, boolean bl) {
        String string = "|SK|";
        if ((Keyword)Logic.$PRINTMODE$.get() == Logic.KWD_ORIGINAL || (Keyword)Logic.$PRINTMODE$.get() == Logic.KWD_REALISTIC) {
            string = "";
            if (Logic.nativeValueOf((Stella_Object)skolem) != null) {
                Logic.printVariableValue(Logic.nativeValueOf((Stella_Object)skolem), outputStream);
                return;
            }
        }
        if (skolem.definingProposition != null && Stella_Object.accessInContext((Stella_Object)skolem.variableValue, (Context)skolem.homeContext, (boolean)false) == null) {
            outputStream.nativeStream.print(string);
            Object object = Logic.$PRINTLOGICALFORMSTREAM$.get();
            Object object2 = Logic.$INDENTCOUNTER$.get();
            try {
                Native.setSpecial((ThreadLocal)Logic.$PRINTLOGICALFORMSTREAM$, (Object)outputStream);
                Native.setIntSpecial((ThreadLocal)Logic.$INDENTCOUNTER$, (int)20);
                Proposition.printKifFunctionExpression(skolem.definingProposition);
            }
            finally {
                Logic.$INDENTCOUNTER$.set(object2);
                Logic.$PRINTLOGICALFORMSTREAM$.set(object);
            }
            return;
        }
        Skolem.printValueOfChain(skolem, outputStream, Logic.innermostOf((Stella_Object)skolem));
    }

    public static void printSkolemName(Skolem skolem, OutputStream outputStream) {
        outputStream.nativeStream.print(Native.stringDowncase((String)Skolem.getSkolemPrintName(skolem)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printValueOfChain(Skolem skolem, OutputStream outputStream, Stella_Object object) {
        if (object == null) {
            object = skolem;
        }
        if ((Keyword)Logic.$PRINTMODE$.get() == Logic.KWD_REALISTIC || (Keyword)Logic.$PRINTMODE$.get() == Logic.KWD_ORIGINAL) {
            if (Surrogate.subtypeOfP((Surrogate)Stella_Object.safePrimaryType((Stella_Object)skolem), (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                PatternVariable patternVariable = (PatternVariable)skolem;
                Object object2 = Logic.$PRINTMODE$.get();
                try {
                    Native.setSpecial((ThreadLocal)Logic.$PRINTMODE$, (Object)Logic.KWD_FLAT);
                    Skolem.printValueOfChain(patternVariable, outputStream, object);
                }
                finally {
                    Logic.$PRINTMODE$.set(object2);
                }
            } else {
                Logic.printVariableValue(object, outputStream);
            }
        } else if ((Keyword)Logic.$PRINTMODE$.get() == Logic.KWD_FLAT || (Keyword)Logic.$PRINTMODE$.get() == Logic.KWD_DEBUG_LOW) {
            Skolem.printSkolemName(skolem, outputStream);
            if (skolem == object) {
                return;
            }
            outputStream.nativeStream.print("//");
            Logic.printVariableValue(object, outputStream);
        } else if ((Keyword)Logic.$PRINTMODE$.get() == Logic.KWD_DEBUG_HIGH) {
            Skolem.printSkolemName(skolem, outputStream);
            if (skolem == object) {
                return;
            }
            Skolem skolem2 = skolem;
            LogicObject logicObject = null;
            while (true) {
                LogicObject logicObject2;
                Surrogate surrogate;
                if (Surrogate.subtypeOfP((Surrogate)(surrogate = Stella_Object.safePrimaryType((Stella_Object)skolem2)), (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
                    logicObject2 = skolem2;
                    logicObject = Stella_Object.accessInContext((Stella_Object)logicObject2.variableValue, (Context)logicObject2.homeContext, (boolean)false);
                } else if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_LOGIC_OBJECT)) {
                    logicObject = logicObject2 = (LogicObject)skolem2;
                } else if (Surrogate.subtypeOfSurrogateP((Surrogate)surrogate)) {
                    logicObject2 = (Surrogate)skolem2;
                    logicObject = ((Surrogate)logicObject2).surrogateValue;
                } else if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_STELLA_RELATION)) {
                    logicObject2 = (Relation)skolem2;
                    logicObject = (NamedDescription)KeyValueList.dynamicSlotValue((KeyValueList)((Relation)logicObject2).dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTION, null);
                } else {
                    logicObject2 = OutputStringStream.newOutputStringStream();
                    ((OutputStringStream)logicObject2).nativeStream.print("`" + surrogate + "' is not a valid case option");
                    throw (StellaException)StellaException.newStellaException((String)logicObject2.theStringReader()).fillInStackTrace();
                }
                outputStream.nativeStream.print("//");
                Logic.printVariableValue((Stella_Object)logicObject, outputStream);
                if (!Stella_Object.eqlP((Stella_Object)logicObject, (Stella_Object)object)) {
                    skolem2 = logicObject;
                    continue;
                }
                break;
            }
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + (Keyword)Logic.$PRINTMODE$.get() + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
    }

    public static String getSkolemPrintName(Skolem skolem) {
        if ((KeyValueList)Logic.$SKOLEMNAMEMAPPINGTABLE$.get() != null) {
            Skolem skolem2 = (Skolem)((KeyValueList)Logic.$SKOLEMNAMEMAPPINGTABLE$.get()).lookup((Stella_Object)skolem);
            return skolem2 != null ? skolem2.skolemName.symbolName : skolem.skolemName.symbolName;
        }
        return skolem.skolemName.symbolName;
    }

    public static void printKifSkolem(Skolem skolem, boolean bl) {
        OutputStream outputStream = (OutputStream)Logic.$PRINTLOGICALFORMSTREAM$.get();
        if (bl) {
            Skolem.printSkolem(skolem, outputStream, false);
        } else if (skolem.definingProposition != null) {
            Proposition.printKifFunctionExpression(skolem.definingProposition);
        } else {
            Skolem.printSkolem(skolem, outputStream, false);
        }
    }

    public static Surrogate computeRelationTermSurrogate(Skolem skolem, Proposition proposition) {
        Proposition proposition2 = skolem.definingProposition;
        String string = Native.stringify((Stella_Object)Proposition.generateFunctionAsTerm(proposition2));
        Surrogate surrogate = null;
        int n = 0;
        List list = null;
        List list2 = null;
        NamedDescription namedDescription = null;
        surrogate = GeneralizedSymbol.internDerivedSurrogate((GeneralizedSymbol)((Surrogate)proposition2.operator), (String)string);
        if (surrogate.surrogateValue != null) {
            return surrogate;
        }
        n = Logic.testPropertyP((Stella_Object)skolem, Logic.SGT_PL_KERNEL_KB_VARIABLE_ARITY) ? -1 : (Logic.accessBinaryValue((Stella_Object)skolem, Logic.SGT_PL_KERNEL_KB_ARITY) != null ? ((IntegerWrapper)Logic.accessBinaryValue((Stella_Object)skolem, (Surrogate)Logic.SGT_PL_KERNEL_KB_ARITY)).wrapperValue : proposition.arguments.length() - 1);
        if (n == -1) {
            list = Stella.list((Cons)Stella_Object.cons((Stella_Object)Logic.yieldSystemDefinedParameterName(1, (Stella_Object)skolem), (Cons)Stella.NIL));
            list2 = Stella.list((Cons)Stella_Object.cons((Stella_Object)Logic.SGT_STELLA_THING, (Cons)Stella.NIL));
        } else {
            list = List.newList();
            list2 = List.newList();
            int n2 = Integer.MIN_VALUE;
            int n3 = 0;
            int n4 = n - 1;
            while (n3 <= n4) {
                n2 = n3++;
                list.insert((Stella_Object)Logic.yieldSystemDefinedParameterName(n2, (Stella_Object)skolem));
                list2.insert((Stella_Object)Logic.SGT_STELLA_THING);
            }
            list.reverse();
            list2.reverse();
        }
        namedDescription = Logic.createPrimitiveDescription(list, list2, n < 0, Logic.logicalType((Stella_Object)skolem) == Logic.SGT_PL_KERNEL_KB_CLASS || Logic.classP((Stella_Object)skolem), Logic.logicalType((Stella_Object)skolem) == Logic.SGT_PL_KERNEL_KB_FUNCTION || proposition.operator == Logic.SGT_PL_KERNEL_KB_VALUE || Logic.functionP((Stella_Object)skolem), (Module)surrogate.homeContext);
        surrogate.surrogateValue = namedDescription;
        namedDescription.surrogateValueInverse = surrogate;
        Description.ensureDescriptionBody(namedDescription);
        return surrogate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pushLogicVariableBinding(Skolem skolem) {
        if (Skolem.anonymousVariableP(skolem)) {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            Object object = Stella.$PRINTREADABLYp$.get();
            try {
                Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                outputStringStream.nativeStream.println("ERROR: Illegal nameless variable '?' found in list of\nquantified variables.");
                outputStringStream.nativeStream.println("   Quantified variables must have names..");
                Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
            }
            finally {
                Stella.$PRINTREADABLYp$.set(object);
            }
            throw (PropositionError)((Object)PropositionError.newPropositionError(outputStringStream.theStringReader()).fillInStackTrace());
        }
        Native.setSpecial((ThreadLocal)Logic.$LOGICVARIABLETABLE$, (Object)Stella_Object.cons((Stella_Object)skolem, (Cons)((Cons)Logic.$LOGICVARIABLETABLE$.get())));
    }

    public static void inheritVariableValueUpdate(Skolem skolem, World world) {
    }

    public void markAsIncoherent() {
        Stella_Object stella_Object;
        Skolem skolem = this;
        if (skolem.definingProposition != null && Surrogate.subtypeOfP((Surrogate)Stella_Object.safePrimaryType((Stella_Object)(stella_Object = skolem.definingProposition.arguments.theArray[0])), (Surrogate)Logic.SGT_LOGIC_LOGIC_OBJECT)) {
            LogicObject logicObject = (LogicObject)stella_Object;
            logicObject.markAsIncoherent();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reactToInferenceUpdate() {
        Skolem skolem = this;
        Stella_Object stella_Object = Logic.valueOf((Stella_Object)skolem);
        Stella_Object stella_Object2 = null;
        Object object = Stella.$MODULE$.get();
        Object object2 = Stella.$CONTEXT$.get();
        try {
            Native.setSpecial((ThreadLocal)Stella.$MODULE$, (Object)((Context)Stella.$CONTEXT$.get()).baseModule);
            Native.setSpecial((ThreadLocal)Stella.$CONTEXT$, (Object)((Module)Stella.$MODULE$.get()));
            stella_Object2 = Logic.valueOf((Stella_Object)skolem);
        }
        finally {
            Stella.$CONTEXT$.set(object2);
            Stella.$MODULE$.set(object);
        }
        if (stella_Object2 != null && !Stella_Object.eqlP((Stella_Object)stella_Object2, (Stella_Object)stella_Object)) {
            Logic.equateValues(Logic.valueOf(stella_Object2), stella_Object);
        }
        object = null;
        object2 = Logic.unfilteredDependentPropositions((Stella_Object)skolem, null).allocateIterator();
        while (object2.nextP()) {
            object = (Proposition)((Iterator)object2).value;
            Proposition.postForEvaluation((Proposition)((Object)object));
        }
        if (((Boolean)Logic.$FILLINGCONSTRAINTPROPAGATIONQUEUESp$.get()).booleanValue() && (object = skolem.definingProposition) != null) {
            Proposition.postToForwardChainingQueue((Proposition)((Object)object), (World)((Context)Stella.$CONTEXT$.get()));
        }
    }

    public static void updateSkolemType(Skolem skolem, Surrogate surrogate) {
        Surrogate surrogate2 = skolem.skolemType;
        if (surrogate2 == null || Logic.logicalSubtypeOfP(surrogate, surrogate2)) {
            skolem.skolemType = surrogate;
        }
    }

    public static boolean anonymousVariableP(Skolem skolem) {
        return skolem.skolemName == Logic.ANONYMOUS_VARIABLE_NAME && Logic.variableP((Stella_Object)skolem);
    }

    public Cons conflictingDefaultValues() {
        Skolem skolem = this;
        Cons cons = (Cons)KeyValueList.dynamicSlotValue((KeyValueList)skolem.dynamicSlots, (Symbol)Logic.SYM_LOGIC_CONFLICTING_DEFAULT_VALUES, null);
        if (cons == null) {
            return Stella.NIL;
        }
        return cons;
    }

    public static void unbindSkolemValue(Skolem skolem, boolean bl) {
        Stella_Object stella_Object = Logic.valueOf((Stella_Object)skolem);
        Proposition proposition = skolem.definingProposition;
        Proposition proposition2 = null;
        LogicObject.unlinkEquivalentValue(skolem);
        proposition2 = Logic.findEquatingProposition(stella_Object, skolem);
        if (proposition2 != null) {
            Proposition.updatePropositionTruthValue(proposition2, Logic.KWD_RETRACT_TRUE);
            Logic.handleOutOfDateInferenceCache(Logic.KWD_RETRACT, proposition2);
        } else {
            Logic.handleOutOfDateInferenceCache(Logic.KWD_RETRACT, proposition);
        }
        if (proposition != null) {
            Skolem.reactToSkolemValueUpdate(skolem, stella_Object, null, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void bindSkolemToValue(Skolem skolem, Stella_Object stella_Object, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        block28: {
            boolean bl2 = false;
            object4 = skolem.skolemType;
            object3 = null;
            if (Logic.skolemP(stella_Object) && (object3 = Logic.findEquatingProposition(stella_Object, skolem)) != null && Proposition.defaultTrueP(object3)) {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                Object object5 = Stella.$PRINTREADABLYp$.get();
                try {
                    Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                    outputStringStream.nativeStream.println("ERROR: Equating two skolems `" + (Object)((Object)skolem) + "' and `" + stella_Object + "' by default is not yet supported.");
                    outputStringStream.nativeStream.println(".");
                    Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
                }
                finally {
                    Stella.$PRINTREADABLYp$.set(object5);
                }
                throw (PropositionError)((Object)PropositionError.newPropositionError(outputStringStream.theStringReader()).fillInStackTrace());
            }
            object2 = new Object[1];
            bl2 = Logic.checkCoercedTypeP(stella_Object, object4, true, (Object[])object2);
            stella_Object = (Stella_Object)object2[0];
            if (!bl2) {
                object3 = Logic.findEquatingProposition(stella_Object, skolem);
                if (object3 == null) {
                    object2 = Logic.$TERMUNDERCONSTRUCTION$.get();
                    try {
                        Native.setSpecial((ThreadLocal)Logic.$TERMUNDERCONSTRUCTION$, (Object)((Stella_Object)Logic.$TERMUNDERCONSTRUCTION$.get()));
                        if ((Stella_Object)Logic.$TERMUNDERCONSTRUCTION$.get() == null) {
                            Native.setSpecial((ThreadLocal)Logic.$TERMUNDERCONSTRUCTION$, (Object)((Object)skolem.definingProposition));
                        }
                        object = Stella.$PRINTREADABLYp$.get();
                        try {
                            Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                            Stella.STANDARD_WARNING.nativeStream.println("WARNING: Type check violation: Assigned value `" + stella_Object + "'");
                            Stella.STANDARD_WARNING.nativeStream.println("   to skolem with type `" + object4 + "'.");
                            Logic.helpSignalPropositionError(Stella.STANDARD_WARNING, Logic.KWD_WARNING);
                            break block28;
                        }
                        finally {
                            Stella.$PRINTREADABLYp$.set(object);
                        }
                    }
                    finally {
                        Logic.$TERMUNDERCONSTRUCTION$.set(object2);
                    }
                }
                Proposition.verifyArgumentTypesAndCount(object3);
            }
        }
        Skolem skolem2 = skolem;
        object4 = stella_Object;
        object3 = skolem2.variableValue;
        object2 = Stella_Object.updateInContext((Stella_Object)object3, (Stella_Object)object4, (Context)skolem2.homeContext, (boolean)false);
        if (object3 == null || object3.primaryType() != Logic.SGT_STELLA_CS_VALUE) {
            skolem2.variableValue = object2;
        }
        if (Surrogate.subtypeOfP((Surrogate)(skolem2 = Stella_Object.safePrimaryType((Stella_Object)stella_Object)), (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
            object4 = (Skolem)stella_Object;
            object3 = Stella_Object.accessInContext((Stella_Object)object4.variableValue, (Context)object4.homeContext, (boolean)false);
            while (object3 != null && Surrogate.subtypeOfP((Surrogate)Stella_Object.safePrimaryType((Stella_Object)object3), (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
                object2 = (Skolem)((Object)object3);
                if (object2 == object4) {
                    object = skolem;
                    Stella_Object stella_Object2 = null;
                    Stella_Object stella_Object3 = ((Skolem)((Object)object)).variableValue;
                    Stella_Object stella_Object4 = Stella_Object.updateInContext((Stella_Object)stella_Object3, stella_Object2, (Context)((Skolem)((Object)object)).homeContext, (boolean)false);
                    if (stella_Object3 == null || stella_Object3.primaryType() != Logic.SGT_STELLA_CS_VALUE) {
                        ((Skolem)((Object)object)).variableValue = stella_Object4;
                    }
                    return;
                }
                object2 = (Skolem)Stella_Object.accessInContext((Stella_Object)object2.variableValue, (Context)object2.homeContext, (boolean)false);
            }
            object3 = object4;
            object2 = Stella_Object.cons((Stella_Object)skolem, (Cons)object4.variableValueInverse());
            object = ((Skolem)((Object)object3)).variableValueInverse;
            Stella_Object stella_Object5 = Stella_Object.updateInContext((Stella_Object)object, (Stella_Object)object2, (Context)((Skolem)((Object)object3)).homeContext, (boolean)false);
            if (object == null || object.primaryType() != Logic.SGT_STELLA_CS_VALUE) {
                ((Skolem)((Object)object3)).variableValueInverse = stella_Object5;
            }
            if (object4.skolemType == null) {
                object4.skolemType = skolem.skolemType;
            }
        } else if (Surrogate.subtypeOfP((Surrogate)skolem2, (Surrogate)Logic.SGT_LOGIC_LOGIC_OBJECT)) {
            object4 = (LogicObject)stella_Object;
            object3 = object4;
            object2 = Stella_Object.cons((Stella_Object)skolem, (Cons)object4.variableValueInverse());
            object = ((LogicObject)((Object)object3)).variableValueInverse;
            Stella_Object stella_Object6 = Stella_Object.updateInContext((Stella_Object)object, (Stella_Object)object2, (Context)((LogicObject)((Object)object3)).homeContext, (boolean)false);
            if (object == null || object.primaryType() != Logic.SGT_STELLA_CS_VALUE) {
                ((LogicObject)((Object)object3)).variableValueInverse = stella_Object6;
            }
        } else {
            object4 = skolem.definingProposition;
            if (object4 != null && Logic.rewrapIthArgumentP(stella_Object, (Proposition)((Object)object4), object4.arguments.length())) {
                object3 = skolem;
                object2 = Logic.rewrapArgument(stella_Object);
                object = ((Skolem)((Object)object3)).variableValue;
                Stella_Object stella_Object7 = Stella_Object.updateInContext((Stella_Object)object, (Stella_Object)object2, (Context)((Skolem)((Object)object3)).homeContext, (boolean)false);
                if (object == null || object.primaryType() != Logic.SGT_STELLA_CS_VALUE) {
                    ((Skolem)((Object)object3)).variableValue = stella_Object7;
                }
            }
        }
        Logic.handleOutOfDateInferenceCache(Logic.KWD_ASSERT, skolem.definingProposition);
        Logic.reactToKbUpdate((Context)Stella.$CONTEXT$.get(), (Stella_Object)skolem);
        if (!Logic.skolemP(stella_Object) && skolem.definingProposition != null) {
            Skolem.reactToSkolemValueUpdate(skolem, null, stella_Object, bl);
        }
    }

    public static void unifySkolemAndValue(Skolem skolem, Stella_Object stella_Object) {
        Proposition proposition = null;
        Iterator iterator = Logic.unfilteredDependentPropositions((Stella_Object)skolem, null).allocateIterator();
        while (iterator.nextP()) {
            proposition = (Proposition)iterator.value;
            Proposition.evaluateProposition(proposition);
        }
    }

    public static void unifyTypes(Skolem skolem, Stella_Object stella_Object) {
        Surrogate surrogate;
        Surrogate surrogate2 = Logic.logicalType((Stella_Object)skolem);
        if (surrogate2 != (surrogate = Logic.logicalType(stella_Object)) && !Logic.logicalSubtypeOfP(surrogate2, surrogate) && !Logic.logicalSubtypeOfP(surrogate, surrogate2)) {
            if (surrogate2 == Logic.SGT_STELLA_THING) {
                if (Stella_Object.isaP((Stella_Object)skolem, (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
                    // empty if block
                }
                skolem.skolemType = surrogate;
            } else if (surrogate == Logic.SGT_STELLA_THING) {
                if (Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_SKOLEM)) {
                    ((Skolem)stella_Object).skolemType = surrogate2;
                }
            } else {
                if (Logic.bottomP(stella_Object)) {
                    return;
                }
                Logic.signalUnificationClash((Stella_Object)skolem, stella_Object);
            }
        }
    }

    public static void signalVariableValueClash(Skolem skolem, Stella_Object stella_Object, Stella_Object stella_Object2) {
        if (stella_Object != null && stella_Object2 != null) {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.println("Skolem `" + (Object)((Object)skolem) + "' is equated with multiple values:");
            outputStringStream.nativeStream.print("   `" + stella_Object + "' and `" + stella_Object2 + "'.");
            throw (Clash)((Object)Clash.newClash(outputStringStream.theStringReader()).fillInStackTrace());
        }
        throw (Clash)((Object)Clash.newClash("Variable value clash.").fillInStackTrace());
    }

    public boolean objectEqualP(Stella_Object stella_Object) {
        Skolem skolem = this;
        if (skolem == stella_Object) {
            return true;
        }
        if (Logic.skolemP(stella_Object)) {
            Proposition proposition = skolem.definingProposition;
            Proposition proposition2 = ((Skolem)stella_Object).definingProposition;
            return proposition != null && proposition2 != null && Proposition.equivalentFunctionPropositionsP(proposition, proposition2, null);
        }
        return false;
    }

    public static Skolem helpCreateSkolem(Skolem skolem, Surrogate surrogate, Symbol symbol, boolean bl) {
        surrogate = Logic.unwrapWrappedType(surrogate);
        if (symbol == null) {
            symbol = Logic.yieldAnonymousSkolemName(Logic.variableP((Stella_Object)skolem));
        }
        skolem.skolemName = symbol;
        if (bl && surrogate != null) {
            Logic.assertIsaProposition((Stella_Object)skolem, surrogate);
        }
        return skolem;
    }

    public static boolean unboundP(Skolem skolem) {
        return Stella_Object.accessInContext((Stella_Object)skolem.variableValue, (Context)skolem.homeContext, (boolean)false) == null;
    }

    public static void reactToSkolemValueUpdate(Skolem skolem, Stella_Object stella_Object, Stella_Object stella_Object2, boolean bl) {
        Proposition proposition = skolem.definingProposition;
        if (bl && Proposition.nativeSlotPropositionP(proposition)) {
            Relation relation = Logic.getDescription((Stella_Object)((Surrogate)proposition.operator)).nativeRelation();
            Stella_Object stella_Object3 = Logic.valueOf(proposition.arguments.theArray[0]);
            if (stella_Object2 != null) {
                Logic.assignNativeSlotValue((Thing)stella_Object3, (StorageSlot)relation, stella_Object2);
            } else {
                Logic.dropNativeSlotValue((Thing)stella_Object3, (StorageSlot)relation, stella_Object);
            }
        }
        if (!Stella_Object.eqlP((Stella_Object)stella_Object, (Stella_Object)stella_Object2)) {
            Keyword.bumpMemoizationTimestamp((Keyword)Logic.KWD_KB_UPDATE);
            if (stella_Object2 != null && Stella_Object.isaP((Stella_Object)stella_Object2, (Surrogate)Logic.SGT_LOGIC_DESCRIPTION) || Proposition.metaPropositionP(proposition)) {
                Keyword.bumpMemoizationTimestamp((Keyword)Logic.KWD_META_KB_UPDATE);
            }
            if (stella_Object != null) {
                Proposition.updateLinksAndTimestamps(proposition, Logic.KWD_RETRACT_TRUE);
            }
            if (stella_Object2 != null) {
                Proposition.updateLinksAndTimestamps(proposition, Logic.KWD_ASSERT_TRUE);
            }
        }
    }

    public static Stella_Object accessSkolemSlotValue(Skolem skolem, Symbol symbol, Stella_Object object, boolean bl) {
        if (symbol == Logic.SYM_LOGIC_SKOLEM_TYPE) {
            if (bl) {
                skolem.skolemType = (Surrogate)object;
            } else {
                object = skolem.skolemType;
            }
        } else if (symbol == Logic.SYM_LOGIC_SKOLEM_NAME) {
            if (bl) {
                skolem.skolemName = (Symbol)object;
            } else {
                object = skolem.skolemName;
            }
        } else if (symbol == Logic.SYM_LOGIC_VARIABLE_VALUE) {
            if (bl) {
                Skolem skolem2 = skolem;
                Stella_Object stella_Object = object;
                Stella_Object stella_Object2 = skolem2.variableValue;
                Stella_Object stella_Object3 = Stella_Object.updateInContext((Stella_Object)stella_Object2, (Stella_Object)stella_Object, (Context)skolem2.homeContext, (boolean)false);
                if (stella_Object2 == null || stella_Object2.primaryType() != Logic.SGT_STELLA_CS_VALUE) {
                    skolem2.variableValue = stella_Object3;
                }
            } else {
                object = Stella_Object.accessInContext((Stella_Object)skolem.variableValue, (Context)skolem.homeContext, (boolean)false);
            }
        } else if (symbol == Logic.SYM_LOGIC_DEFINING_PROPOSITION) {
            if (bl) {
                skolem.definingProposition = (Proposition)((Object)object);
            } else {
                object = skolem.definingProposition;
            }
        } else if (bl) {
            KeyValueList.setDynamicSlotValue((KeyValueList)skolem.dynamicSlots, (Symbol)symbol, (Stella_Object)object, null);
        } else {
            object = skolem.dynamicSlots.lookup((Stella_Object)symbol);
        }
        return object;
    }

    public Surrogate primaryType() {
        Skolem skolem = this;
        return Logic.SGT_LOGIC_SKOLEM;
    }
}

