/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.powerloom.logic;

import edu.isi.powerloom.logic.ControlFrame;
import edu.isi.powerloom.logic.ControlFramePriorityQueue;
import edu.isi.powerloom.logic.Description;
import edu.isi.powerloom.logic.ExplainException;
import edu.isi.powerloom.logic.ExplainNoQueryException;
import edu.isi.powerloom.logic.ExplainNoSuchLabelException;
import edu.isi.powerloom.logic.ExplainQueryTrueException;
import edu.isi.powerloom.logic.FailException;
import edu.isi.powerloom.logic.IncrementalPartialMatch;
import edu.isi.powerloom.logic.InferenceLevel;
import edu.isi.powerloom.logic.Justification;
import edu.isi.powerloom.logic.Logic;
import edu.isi.powerloom.logic.LogicObject;
import edu.isi.powerloom.logic.NamedDescription;
import edu.isi.powerloom.logic.NnPartialMatch;
import edu.isi.powerloom.logic.ParallelThread;
import edu.isi.powerloom.logic.ParsingError;
import edu.isi.powerloom.logic.PartialMatchFrame;
import edu.isi.powerloom.logic.PatternRecord;
import edu.isi.powerloom.logic.PatternVariable;
import edu.isi.powerloom.logic.Proposition;
import edu.isi.powerloom.logic.PropositionError;
import edu.isi.powerloom.logic.QuerySolution;
import edu.isi.powerloom.logic.QuerySolutionTable;
import edu.isi.powerloom.logic.TruthValue;
import edu.isi.stella.BooleanVector;
import edu.isi.stella.BooleanWrapper;
import edu.isi.stella.Cons;
import edu.isi.stella.Context;
import edu.isi.stella.ContextSensitiveObject;
import edu.isi.stella.DictionaryIterator;
import edu.isi.stella.FloatWrapper;
import edu.isi.stella.GeneralizedSymbol;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.Iterator;
import edu.isi.stella.KeyValueList;
import edu.isi.stella.Keyword;
import edu.isi.stella.List;
import edu.isi.stella.Module;
import edu.isi.stella.OutputStream;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.PropertyList;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Class;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.StringWrapper;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.Vector;
import edu.isi.stella.Wrapper;
import edu.isi.stella.javalib.Native;
import java.io.PrintStream;

public class QueryIterator
extends Iterator {
    public Vector externalVariables;
    public boolean exhaustedP;
    public PropertyList options;
    public QuerySolutionTable solutions;
    public Context queryContext;
    public ControlFrame baseControlFrame;
    public ControlFrame currentControlFrame;
    public PatternRecord currentPatternRecord;
    public ParallelThread currentParallelThread;
    public ControlFramePriorityQueue controlFramePriorityQueue;
    public boolean augmentedGoalCacheP;
    public List activeGoalCaches;
    public boolean triggeredDepthCutoffP;
    public boolean failedToFindDuplicateSubgoalP;
    public boolean foundAtLeastOneSolutionP;
    public int timestamp;
    public PartialMatchFrame partialMatchStrategy;
    public InferenceLevel inferenceLevel;
    public int currentDepthCutoff;
    public int maximumDepth;
    public double allottedTime;
    public int allottedClockTicks;
    public int currentClockTicks;
    public boolean timeoutP;
    public KeyValueList dynamicSlots;

    public static QueryIterator newQueryIterator() {
        QueryIterator queryIterator = null;
        queryIterator = new QueryIterator();
        queryIterator.dynamicSlots = KeyValueList.newKeyValueList();
        queryIterator.firstIterationP = true;
        queryIterator.value = null;
        queryIterator.timeoutP = false;
        queryIterator.currentClockTicks = 0;
        queryIterator.allottedClockTicks = Integer.MIN_VALUE;
        queryIterator.allottedTime = Double.NEGATIVE_INFINITY;
        queryIterator.maximumDepth = Integer.MIN_VALUE;
        queryIterator.currentDepthCutoff = Integer.MIN_VALUE;
        queryIterator.inferenceLevel = null;
        queryIterator.partialMatchStrategy = null;
        queryIterator.timestamp = Integer.MIN_VALUE;
        queryIterator.foundAtLeastOneSolutionP = false;
        queryIterator.failedToFindDuplicateSubgoalP = false;
        queryIterator.triggeredDepthCutoffP = false;
        queryIterator.activeGoalCaches = List.newList();
        queryIterator.augmentedGoalCacheP = false;
        queryIterator.controlFramePriorityQueue = null;
        queryIterator.currentParallelThread = null;
        queryIterator.currentPatternRecord = null;
        queryIterator.currentControlFrame = null;
        queryIterator.baseControlFrame = null;
        queryIterator.queryContext = null;
        queryIterator.solutions = QuerySolutionTable.newQuerySolutionTable();
        queryIterator.options = PropertyList.newPropertyList();
        queryIterator.exhaustedP = false;
        queryIterator.externalVariables = null;
        return queryIterator;
    }

    public static List getWhynotJustifications(QueryIterator queryIterator, String string, KeyValueList keyValueList) {
        List list = null;
        if (queryIterator == null) {
            queryIterator = Logic.$MOST_RECENT_QUERY$;
        }
        if (keyValueList == null) {
            keyValueList = (KeyValueList)Logic.$MOST_RECENT_EXPLANATION_MAPPING$.get();
        }
        if (queryIterator == null) {
            throw (ExplainNoQueryException)((Object)ExplainNoQueryException.newExplainNoQueryException("There is nothing to explain.").fillInStackTrace());
        }
        if (queryIterator.partialMatchStrategy == null && !queryIterator.exhaustedP) {
            throw (ExplainQueryTrueException)((Object)ExplainQueryTrueException.newExplainQueryTrueException("The query did not fail.").fillInStackTrace());
        }
        queryIterator = QueryIterator.deriveJustifiedPartialQuery(queryIterator);
        list = queryIterator.baseControlFrame.allJustifications();
        if (string != null) {
            if (keyValueList != null) {
                list = Stella.list((Cons)Stella_Object.cons((Stella_Object)Logic.lookupJustification(keyValueList, string), (Cons)Stella.NIL));
            }
            if (list.first() == null) {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("Label `" + string + "' does not exists in the current explanation");
                throw (ExplainNoSuchLabelException)((Object)ExplainNoSuchLabelException.newExplainNoSuchLabelException(outputStringStream.theStringReader()).fillInStackTrace());
            }
        }
        return list;
    }

    public static QueryIterator deriveJustifiedPartialQuery(QueryIterator queryIterator) {
        if (queryIterator.partialMatchStrategy != null && (Justification)KeyValueList.dynamicSlotValue((KeyValueList)queryIterator.baseControlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null) != null) {
            return queryIterator;
        }
        QueryIterator queryIterator2 = Description.createQueryIterator(queryIterator.baseControlFrame.patternRecord.description, ((QuerySolution)queryIterator.value).bindings);
        boolean bl = (Boolean)Logic.$RECORD_JUSTIFICATIONSp$.get();
        queryIterator2.options.insertAt((Stella_Object)Logic.KWD_MATCH_MODE, (Stella_Object)Logic.KWD_WHYNOT);
        Logic.setPowerloomFeature(Logic.KWD_JUSTIFICATIONS);
        Logic.callAskPartial((Stella_Object)queryIterator2);
        if (!bl) {
            Logic.unsetPowerloomFeature(Logic.KWD_JUSTIFICATIONS);
        }
        return queryIterator2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cutoffSimilarWhynotProofs(QueryIterator queryIterator) {
        ControlFrame controlFrame = queryIterator.baseControlFrame;
        while (controlFrame.down != null) {
            controlFrame = controlFrame.down;
        }
        if ((Iterator)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, null) != null) {
            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, (Stella_Object)Stella.NIL.allocateIterator(), null);
            if (Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_GOAL_TREE)) {
                Object object = Logic.$PRINTINFRAME$.get();
                Object object2 = Logic.$PRINTMODE$.get();
                Object object3 = Logic.$PRINTLOGICALFORMSTREAM$.get();
                Object object4 = Logic.$QUERYITERATOR$.get();
                try {
                    Native.setSpecial((ThreadLocal)Logic.$PRINTINFRAME$, (Object)((Object)controlFrame));
                    Native.setSpecial((ThreadLocal)Logic.$PRINTMODE$, (Object)Logic.KWD_REALISTIC);
                    Native.setSpecial((ThreadLocal)Logic.$PRINTLOGICALFORMSTREAM$, (Object)Stella.STANDARD_OUTPUT);
                    Native.setSpecial((ThreadLocal)Logic.$QUERYITERATOR$, (Object)((Object)queryIterator));
                    System.out.print("*** cutting off similar WhyNot proofs at goal=");
                    Logic.printUnformattedLogicalForm((Stella_Object)controlFrame.proposition, Stella.STANDARD_OUTPUT);
                    System.out.println();
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    Logic.$QUERYITERATOR$.set(object4);
                    Logic.$PRINTLOGICALFORMSTREAM$.set(object3);
                    Logic.$PRINTMODE$.set(object2);
                    Logic.$PRINTINFRAME$.set(object);
                    throw throwable;
                }
                Logic.$QUERYITERATOR$.set(object4);
                Logic.$PRINTLOGICALFORMSTREAM$.set(object3);
                Logic.$PRINTMODE$.set(object2);
                Logic.$PRINTINFRAME$.set(object);
                {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List deriveQueryJustifications(QueryIterator queryIterator, Stella_Object stella_Object, int n, int n2) {
        Object object;
        Object object2 = Logic.$QUERYITERATOR$.get();
        Object object3 = Stella.$CONTEXT$.get();
        Object object4 = Logic.$INFERENCELEVEL$.get();
        Object object5 = Logic.$REVERSEPOLARITYp$.get();
        Object object6 = Logic.$GENERATE_ALL_PROOFSp$.get();
        Object object7 = Logic.$RECORD_JUSTIFICATIONSp$.get();
        try {
            Native.setSpecial((ThreadLocal)Logic.$QUERYITERATOR$, (Object)((Object)queryIterator));
            Native.setSpecial((ThreadLocal)Stella.$CONTEXT$, (Object)queryIterator.queryContext);
            Native.setSpecial((ThreadLocal)Logic.$INFERENCELEVEL$, (Object)((Object)Logic.currentInferenceLevel()));
            Native.setBooleanSpecial((ThreadLocal)Logic.$REVERSEPOLARITYp$, (boolean)false);
            Native.setBooleanSpecial((ThreadLocal)Logic.$GENERATE_ALL_PROOFSp$, (boolean)false);
            Native.setBooleanSpecial((ThreadLocal)Logic.$RECORD_JUSTIFICATIONSp$, (boolean)true);
            QueryIterator queryIterator2 = Logic.allocateQueryIterator();
            PropertyList propertyList = queryIterator.options;
            if (stella_Object == null) {
                propertyList = propertyList.copy();
                propertyList.removeAt((Stella_Object)Logic.KWD_HOW_MANY);
                stella_Object = propertyList;
            }
            QueryIterator.processQueryOptions(queryIterator2, stella_Object);
            object = Logic.$TYPE_CHECK_STRATEGY$.get();
            try {
                Native.setSpecial((ThreadLocal)Logic.$TYPE_CHECK_STRATEGY$, (Object)Logic.KWD_NONE);
                QueryIterator.initializeQueryIterator(queryIterator2, queryIterator.queryDescription(), queryIterator.solutions.nth((int)n).bindings);
            }
            finally {
                Logic.$TYPE_CHECK_STRATEGY$.set(object);
            }
            if (queryIterator.queryIsPartialP()) {
                Logic.callAskPartial((Stella_Object)queryIterator2);
            } else {
                Logic.callAsk((Stella_Object)queryIterator2);
            }
            object = QueryIterator.getQueryJustifications(queryIterator2, Integer.MIN_VALUE, n2, false);
            Object var15_14 = null;
        }
        catch (Throwable throwable) {
            Object var15_15 = null;
            Logic.$RECORD_JUSTIFICATIONSp$.set(object7);
            Logic.$GENERATE_ALL_PROOFSp$.set(object6);
            Logic.$REVERSEPOLARITYp$.set(object5);
            Logic.$INFERENCELEVEL$.set(object4);
            Stella.$CONTEXT$.set(object3);
            Logic.$QUERYITERATOR$.set(object2);
            throw throwable;
        }
        Logic.$RECORD_JUSTIFICATIONSp$.set(object7);
        Logic.$GENERATE_ALL_PROOFSp$.set(object6);
        Logic.$REVERSEPOLARITYp$.set(object5);
        Logic.$INFERENCELEVEL$.set(object4);
        Stella.$CONTEXT$.set(object3);
        Logic.$QUERYITERATOR$.set(object2);
        return object;
    }

    public static List getQueryJustifications(QueryIterator queryIterator, int n, int n2, boolean bl) {
        boolean bl2 = queryIterator.queryIsTrueFalseP();
        QuerySolutionTable querySolutionTable = queryIterator.solutions;
        QuerySolution querySolution = null;
        int n3 = querySolutionTable.length();
        List list = null;
        if (querySolutionTable.emptyP()) {
            return Stella.NIL_LIST;
        }
        if (bl2 || n == Integer.MIN_VALUE || n < 0) {
            n = n3 - 1;
        }
        if (n >= n3) {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("There were only `" + n3 + "' solutions");
            throw (ExplainException)((Object)ExplainException.newExplainException(outputStringStream.theStringReader()).fillInStackTrace());
        }
        querySolution = querySolutionTable.nth(n);
        if (querySolution.justification == null) {
            if (bl) {
                list = QueryIterator.deriveQueryJustifications(queryIterator, null, n, n2);
                querySolution.justification = (Justification)list.first();
                querySolution.allJustifications = list;
                return list;
            }
            return Stella.NIL_LIST;
        }
        if (querySolution.allJustifications != null && querySolution.allJustifications.nonEmptyP()) {
            list = Stella.list((Cons)Stella.NIL);
            Justification justification = null;
            Cons cons = querySolution.allJustifications.theConsList;
            int n4 = Integer.MIN_VALUE;
            int n5 = n2;
            boolean bl3 = n5 == Integer.MIN_VALUE;
            Cons cons2 = null;
            for (int i = 1; cons != Stella.NIL && (bl3 || i <= n5); ++i) {
                justification = (Justification)cons.value;
                n4 = i;
                if (cons2 == null) {
                    cons2 = Stella_Object.cons((Stella_Object)justification, (Cons)Stella.NIL);
                    if (list.theConsList == Stella.NIL) {
                        list.theConsList = cons2;
                    } else {
                        Cons.addConsToEndOfConsList((Cons)list.theConsList, (Cons)cons2);
                    }
                } else {
                    cons2 = cons2.rest = Stella_Object.cons((Stella_Object)justification, (Cons)Stella.NIL);
                }
                cons = cons.rest;
            }
        }
        if (list != null) {
            return list;
        }
        return Stella.list((Cons)Stella_Object.cons((Stella_Object)querySolution.justification, (Cons)Stella.NIL));
    }

    public static double returnPartialTruth(QueryIterator queryIterator, boolean bl) {
        if (!bl) {
            queryIterator.options.insertAt((Stella_Object)Logic.KWD_MAXIMIZE_SCOREp, (Stella_Object)(bl ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER));
        }
        return Logic.callAskPartial((Stella_Object)queryIterator);
    }

    public static void sortSolutionsByScore(QueryIterator queryIterator) {
        queryIterator.solutions.sort(Native.find_java_method((String)"edu.isi.powerloom.logic.QuerySolution", (String)"solutionScoreGreaterThanP", (Class[])new Class[]{Native.find_java_class((String)"edu.isi.powerloom.logic.QuerySolution"), Native.find_java_class((String)"edu.isi.powerloom.logic.QuerySolution")}));
    }

    public static void initializePartialQuery(QueryIterator queryIterator) {
        PartialMatchFrame partialMatchFrame = queryIterator.partialMatchStrategy;
        if (partialMatchFrame == null) {
            queryIterator.partialMatchStrategy = partialMatchFrame = QueryIterator.makePartialMatchFrame(queryIterator);
        }
        partialMatchFrame.initializePartialMatchStrategy(queryIterator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PartialMatchFrame makePartialMatchFrame(QueryIterator queryIterator) {
        GeneralizedSymbol generalizedSymbol = (GeneralizedSymbol)queryIterator.options.lookup((Stella_Object)Logic.KWD_MATCH_MODE);
        ControlFrame controlFrame = queryIterator.baseControlFrame;
        Keyword keyword = controlFrame.state;
        if (generalizedSymbol == null) {
            generalizedSymbol = Logic.$PARTIAL_MATCH_MODE$;
        }
        if (generalizedSymbol == Logic.KWD_BASIC || generalizedSymbol == Logic.KWD_INCREMENTAL) {
            return IncrementalPartialMatch.newIncrementalPartialMatch(keyword, controlFrame);
        }
        if (generalizedSymbol == Logic.KWD_NN || generalizedSymbol == Logic.KWD_NEURAL_NETWORK) {
            return NnPartialMatch.newNnPartialMatch(keyword, controlFrame);
        }
        Stella_Class stella_Class = null;
        String string = generalizedSymbol.symbolName + "-PARTIAL-MATCH";
        Module module = generalizedSymbol.homeModule();
        Module module2 = module != null ? module : (Module)Stella.$MODULE$.get();
        Object object = Stella.$MODULE$.get();
        Object object2 = Stella.$CONTEXT$.get();
        try {
            Native.setSpecial((ThreadLocal)Stella.$MODULE$, (Object)module2);
            Native.setSpecial((ThreadLocal)Stella.$CONTEXT$, (Object)((Module)Stella.$MODULE$.get()));
            stella_Class = Stella.string_lookupClass((String)string);
            if (stella_Class == null) {
                stella_Class = Stella.string_getObject((String)string, null);
            }
        }
        finally {
            Stella.$CONTEXT$.set(object2);
            Stella.$MODULE$.set(object);
        }
        if (stella_Class != null && Stella_Object.isaP((Stella_Object)stella_Class, (Surrogate)Logic.SGT_STELLA_CLASS)) {
            return (PartialMatchFrame)Surrogate.createObject((Surrogate)stella_Class.classType, (Cons)Stella_Object.cons((Stella_Object)Logic.KWD_CONTROL_FRAME, (Cons)Stella_Object.cons((Stella_Object)controlFrame, (Cons)Stella_Object.cons((Stella_Object)Logic.KWD_KIND, (Cons)Stella_Object.cons((Stella_Object)keyword, (Cons)Stella.NIL)))));
        }
        object = OutputStringStream.newOutputStringStream();
        object2 = Stella.$PRINTREADABLYp$.get();
        try {
            Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
            ((OutputStringStream)object).nativeStream.println("PARSING ERROR: Unknown partial match mode: `" + generalizedSymbol + "'.");
            Logic.helpSignalPropositionError((OutputStream)object, Logic.KWD_ERROR);
        }
        finally {
            Stella.$PRINTREADABLYp$.set(object2);
        }
        throw (ParsingError)((Object)ParsingError.newParsingError(object.theStringReader()).fillInStackTrace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cons updatePropositionsFromQuery(QueryIterator queryIterator, Description description, Module module, Keyword keyword) {
        if (queryIterator.queryIsTrueFalseP()) {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            Object object = Stella.$PRINTREADABLYp$.get();
            try {
                Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                outputStringStream.nativeStream.println("ERROR: Can't yet assert/retract the result of a true/false query.");
                Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
            }
            finally {
                Stella.$PRINTREADABLYp$.set(object);
            }
            throw (PropositionError)((Object)PropositionError.newPropositionError(outputStringStream.theStringReader()).fillInStackTrace());
        }
        Description description2 = queryIterator.queryDescription();
        boolean bl = queryIterator.queryIsPartialP();
        QuerySolutionTable querySolutionTable = queryIterator.solutions;
        KeyValueList keyValueList = KeyValueList.newKeyValueList();
        boolean bl2 = false;
        Proposition proposition = null;
        Cons cons = Stella.NIL;
        int n = 0;
        boolean bl3 = false;
        if (description != null) {
            if (!(description.arity() == description2.arity() || Description.variableArityP(description) && description2.arity() >= description.ioVariables.length())) {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                Object object = Stella.$PRINTREADABLYp$.get();
                try {
                    Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                    outputStringStream.nativeStream.println("ERROR: Arity mismatch between query proposition and `" + (Object)((Object)description) + "'.");
                    Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
                }
                finally {
                    Stella.$PRINTREADABLYp$.set(object);
                }
                throw (PropositionError)((Object)PropositionError.newPropositionError(outputStringStream.theStringReader()).fillInStackTrace());
            }
        } else {
            description = description2;
        }
        if (module == null) {
            module = (Module)Stella.$MODULE$.get();
        }
        proposition = description.proposition;
        if (Description.variableArityP(description) && description2.arity() > description.ioVariables.length()) {
            if (proposition.kind != Logic.KWD_FUNCTION && proposition.kind != Logic.KWD_PREDICATE) {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                Object object = Stella.$PRINTREADABLYp$.get();
                try {
                    Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                    outputStringStream.nativeStream.println("ERROR: Illegal variable arity description..");
                    Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
                }
                finally {
                    Stella.$PRINTREADABLYp$.set(object);
                }
                throw (PropositionError)((Object)PropositionError.newPropositionError(outputStringStream.theStringReader()).fillInStackTrace());
            }
            proposition = Proposition.shallowCopyProposition(proposition);
            proposition.arguments = description2.ioVariables.copy();
            description = description2;
        }
        Object object = Stella.$MODULE$.get();
        Object object2 = Stella.$CONTEXT$.get();
        try {
            Native.setSpecial((ThreadLocal)Stella.$MODULE$, (Object)module);
            Native.setSpecial((ThreadLocal)Stella.$CONTEXT$, (Object)((Module)Stella.$MODULE$.get()));
            bl2 = Description.namedDescriptionP(description) && NamedDescription.getDescriptionExtension((NamedDescription)description, false).emptyP();
            QuerySolution querySolution = null;
            DictionaryIterator dictionaryIterator = (DictionaryIterator)querySolutionTable.allocateIterator();
            int n2 = Integer.MIN_VALUE;
            int n3 = 0;
            while (dictionaryIterator.nextP()) {
                querySolution = (QuerySolution)dictionaryIterator.value;
                n2 = n3;
                keyValueList.clear();
                if (Stella.mod((int)n2, (int)10000) == 9999) {
                    if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_UPDATE_FROM_QUERY)) {
                        System.out.print(++n);
                        OutputStream.flushOutput((OutputStream)Stella.STANDARD_OUTPUT);
                    }
                    OutputStream.flushOutput((OutputStream)Stella.STANDARD_OUTPUT);
                } else if (Stella.mod((int)n2, (int)1000) == 999) {
                    if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_UPDATE_FROM_QUERY)) {
                        System.out.print(".");
                        OutputStream.flushOutput((OutputStream)Stella.STANDARD_OUTPUT);
                    }
                    OutputStream.flushOutput((OutputStream)Stella.STANDARD_OUTPUT);
                    bl3 = true;
                }
                ContextSensitiveObject contextSensitiveObject = null;
                Vector vector = description.ioVariables;
                int n4 = 0;
                int n5 = vector.length();
                Stella_Object stella_Object = null;
                Vector vector2 = querySolution.bindings;
                int n6 = vector2.length();
                for (int i = 0; n4 < n5 && i < n6; ++n4, ++i) {
                    contextSensitiveObject = (PatternVariable)vector.theArray[n4];
                    stella_Object = vector2.theArray[i];
                    keyValueList.insertAt((Stella_Object)contextSensitiveObject, stella_Object);
                }
                contextSensitiveObject = null;
                vector = Proposition.inheritAsTopLevelProposition(proposition, keyValueList);
                while (vector != Stella.NIL) {
                    boolean bl4;
                    contextSensitiveObject = (Proposition)vector.value;
                    KeyValueList.setDynamicSlotValue((KeyValueList)contextSensitiveObject.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTIVEp, (Stella_Object)Stella.FALSE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
                    contextSensitiveObject = Proposition.recursivelyFastenDownPropositions((Proposition)contextSensitiveObject, bl2);
                    Keyword keyword2 = keyword;
                    TruthValue truthValue = querySolution.truthValue;
                    boolean bl5 = bl4 = contextSensitiveObject.kind == Logic.KWD_EQUIVALENT;
                    if (truthValue == Logic.FALSE_TRUTH_VALUE || truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
                        keyword2 = Logic.invertUpdateMode(keyword2);
                    }
                    if (truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE || truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
                        keyword2 = Logic.defaultifyUpdateMode(keyword2);
                    }
                    if (bl4) {
                        Proposition.updateEquivalenceProposition((Proposition)contextSensitiveObject, keyword2);
                    } else {
                        Proposition.updatePropositionTruthValue((Proposition)contextSensitiveObject, keyword2);
                    }
                    if (bl) {
                        KeyValueList.setDynamicSlotValue((KeyValueList)contextSensitiveObject.dynamicSlots, (Symbol)Logic.SYM_LOGIC_WEIGHT, (Stella_Object)FloatWrapper.wrapFloat((double)querySolution.matchScore), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
                    }
                    cons = Stella_Object.cons((Stella_Object)contextSensitiveObject, (Cons)cons);
                    vector = vector.rest;
                }
                ++n3;
            }
        }
        finally {
            Stella.$CONTEXT$.set(object2);
            Stella.$MODULE$.set(object);
        }
        if (bl3 && Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_UPDATE_FROM_QUERY)) {
            System.out.println();
        }
        return cons.reverse();
    }

    public List listify() {
        QueryIterator queryIterator = this;
        List list = List.newList();
        list.theConsList = queryIterator.consify();
        List list2 = list;
        return list2;
    }

    public static Cons consifyQuery(QueryIterator queryIterator) {
        return queryIterator.consify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cons consify() {
        QueryIterator queryIterator = this;
        if (queryIterator == null) {
            return Stella.NIL;
        }
        Object object = Logic.$QUERYITERATOR$.get();
        Object object2 = Logic.$REVERSEPOLARITYp$.get();
        try {
            Native.setSpecial((ThreadLocal)Logic.$QUERYITERATOR$, (Object)((Object)queryIterator));
            Native.setBooleanSpecial((ThreadLocal)Logic.$REVERSEPOLARITYp$, (boolean)false);
            while (queryIterator.nextP()) {
            }
        }
        finally {
            Logic.$REVERSEPOLARITYp$.set(object2);
            Logic.$QUERYITERATOR$.set(object);
        }
        return queryIterator.consifyCurrentSolutions();
    }

    public Cons consifyCurrentSolutions() {
        QueryIterator queryIterator = this;
        if (queryIterator == null) {
            return Stella.NIL;
        }
        QuerySolutionTable querySolutionTable = queryIterator.solutions;
        Cons cons = Stella.NIL;
        int n = queryIterator.queryDescription().arity();
        boolean bl = ((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ATOMIC_SINGLETONSp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue;
        QuerySolution querySolution = null;
        DictionaryIterator dictionaryIterator = (DictionaryIterator)querySolutionTable.allocateIterator();
        Cons cons2 = null;
        while (dictionaryIterator.nextP()) {
            querySolution = (QuerySolution)dictionaryIterator.value;
            if (cons2 == null) {
                cons2 = Stella_Object.cons((Stella_Object)(bl && n == 1 ? querySolution.bindings.theArray[0] : querySolution.bindings.consify()), (Cons)Stella.NIL);
                if (cons == Stella.NIL) {
                    cons = cons2;
                    continue;
                }
                Cons.addConsToEndOfConsList((Cons)cons, (Cons)cons2);
                continue;
            }
            cons2 = cons2.rest = Stella_Object.cons((Stella_Object)(bl && n == 1 ? querySolution.bindings.theArray[0] : querySolution.bindings.consify()), (Cons)Stella.NIL);
        }
        return cons;
    }

    public static BooleanWrapper runYesOrNoQueryP(QueryIterator queryIterator) {
        TruthValue truthValue = Logic.callAsk((Stella_Object)queryIterator);
        if (truthValue == Logic.TRUE_TRUTH_VALUE || truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE) {
            return Stella.TRUE_WRAPPER;
        }
        if (truthValue == Logic.FALSE_TRUTH_VALUE || truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
            return Stella.FALSE_WRAPPER;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processQueryOptions(QueryIterator queryIterator, Stella_Object stella_Object) {
        PropertyList propertyList = Stella_Object.vetOptions((Stella_Object)stella_Object, null);
        PropertyList propertyList2 = null;
        queryIterator.options = propertyList;
        Stella_Object stella_Object2 = null;
        Stella_Object stella_Object3 = null;
        Cons cons = propertyList.thePlist;
        while (true) {
            block76: {
                block90: {
                    Surrogate surrogate;
                    GeneralizedSymbol generalizedSymbol;
                    block89: {
                        block88: {
                            block86: {
                                block87: {
                                    block85: {
                                        block84: {
                                            block83: {
                                                block82: {
                                                    block81: {
                                                        block80: {
                                                            block79: {
                                                                block78: {
                                                                    block77: {
                                                                        if (cons == Stella.NIL) {
                                                                            if (propertyList2 == null) return;
                                                                            propertyList.insertAt((Stella_Object)Logic.KWD_DEFERRED_OPTIONS, propertyList2);
                                                                            return;
                                                                        }
                                                                        stella_Object2 = cons.value;
                                                                        stella_Object3 = cons.rest.value;
                                                                        generalizedSymbol = (GeneralizedSymbol)stella_Object2;
                                                                        if (generalizedSymbol != Logic.KWD_TIMEOUT) break block77;
                                                                        surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object3);
                                                                        if (Surrogate.subtypeOfIntegerP((Surrogate)surrogate)) {
                                                                            IntegerWrapper integerWrapper = (IntegerWrapper)stella_Object3;
                                                                            queryIterator.allottedTime = integerWrapper.numberWrapperToFloat();
                                                                            propertyList.insertAt(stella_Object2, (Stella_Object)FloatWrapper.wrapFloat((double)queryIterator.allottedTime));
                                                                        } else if (Surrogate.subtypeOfFloatP((Surrogate)surrogate)) {
                                                                            FloatWrapper floatWrapper = (FloatWrapper)stella_Object3;
                                                                            queryIterator.allottedTime = floatWrapper.wrapperValue;
                                                                            propertyList.insertAt(stella_Object2, (Stella_Object)FloatWrapper.wrapFloat((double)queryIterator.allottedTime));
                                                                        } else {
                                                                            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                                                                            Object object = Stella.$PRINTREADABLYp$.get();
                                                                            try {
                                                                                Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                                                                                outputStringStream.nativeStream.println("PARSING ERROR: Illegal :TIMEOUT value: `" + stella_Object3 + "'.");
                                                                                Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
                                                                                throw (ParsingError)((Object)ParsingError.newParsingError(outputStringStream.theStringReader()).fillInStackTrace());
                                                                            }
                                                                            finally {
                                                                                Stella.$PRINTREADABLYp$.set(object);
                                                                            }
                                                                        }
                                                                        queryIterator.timeoutP = false;
                                                                        break block76;
                                                                    }
                                                                    if (generalizedSymbol != Logic.KWD_MOVEOUT) break block78;
                                                                    surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object3);
                                                                    if (Surrogate.subtypeOfIntegerP((Surrogate)surrogate)) {
                                                                        IntegerWrapper integerWrapper = (IntegerWrapper)stella_Object3;
                                                                        queryIterator.allottedClockTicks = Native.floor((int)integerWrapper.wrapperValue);
                                                                        propertyList.insertAt(stella_Object2, (Stella_Object)IntegerWrapper.wrapInteger((int)Native.floor((int)integerWrapper.wrapperValue)));
                                                                        break block76;
                                                                    } else if (Surrogate.subtypeOfFloatP((Surrogate)surrogate)) {
                                                                        FloatWrapper floatWrapper = (FloatWrapper)stella_Object3;
                                                                        queryIterator.allottedClockTicks = Native.floor((double)floatWrapper.wrapperValue);
                                                                        propertyList.insertAt(stella_Object2, (Stella_Object)IntegerWrapper.wrapInteger((int)Native.floor((double)floatWrapper.wrapperValue)));
                                                                        break block76;
                                                                    } else {
                                                                        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                                                                        Object object = Stella.$PRINTREADABLYp$.get();
                                                                        try {
                                                                            Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                                                                            outputStringStream.nativeStream.println("PARSING ERROR: Illegal :MOVEOUT value: `" + stella_Object3 + "'.");
                                                                            Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
                                                                            throw (ParsingError)((Object)ParsingError.newParsingError(outputStringStream.theStringReader()).fillInStackTrace());
                                                                        }
                                                                        finally {
                                                                            Stella.$PRINTREADABLYp$.set(object);
                                                                        }
                                                                    }
                                                                }
                                                                if (generalizedSymbol != Logic.KWD_MAXIMUM_DEPTH) break block79;
                                                                surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object3);
                                                                if (Surrogate.subtypeOfIntegerP((Surrogate)surrogate)) {
                                                                    IntegerWrapper integerWrapper = (IntegerWrapper)stella_Object3;
                                                                    propertyList.insertAt(stella_Object2, (Stella_Object)IntegerWrapper.wrapInteger((int)Native.floor((int)integerWrapper.wrapperValue)));
                                                                    queryIterator.maximumDepth = ((IntegerWrapper)Logic.lookupQueryOption((Stella_Object)queryIterator, (Keyword)Logic.KWD_MAXIMUM_DEPTH)).wrapperValue;
                                                                    break block76;
                                                                } else if (Surrogate.subtypeOfFloatP((Surrogate)surrogate)) {
                                                                    FloatWrapper floatWrapper = (FloatWrapper)stella_Object3;
                                                                    propertyList.insertAt(stella_Object2, (Stella_Object)IntegerWrapper.wrapInteger((int)Native.floor((double)floatWrapper.wrapperValue)));
                                                                    queryIterator.maximumDepth = ((IntegerWrapper)Logic.lookupQueryOption((Stella_Object)queryIterator, (Keyword)Logic.KWD_MAXIMUM_DEPTH)).wrapperValue;
                                                                    break block76;
                                                                } else {
                                                                    OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                                                                    Object object = Stella.$PRINTREADABLYp$.get();
                                                                    try {
                                                                        Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                                                                        outputStringStream.nativeStream.println("PARSING ERROR: Illegal :MAXIMUM-DEPTH value: `" + stella_Object3 + "'.");
                                                                        Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
                                                                        throw (ParsingError)((Object)ParsingError.newParsingError(outputStringStream.theStringReader()).fillInStackTrace());
                                                                    }
                                                                    finally {
                                                                        Stella.$PRINTREADABLYp$.set(object);
                                                                    }
                                                                }
                                                            }
                                                            if (generalizedSymbol != Logic.KWD_INFERENCE_LEVEL) break block80;
                                                            surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object3);
                                                            if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_STELLA_GENERALIZED_SYMBOL)) {
                                                                GeneralizedSymbol generalizedSymbol2 = (GeneralizedSymbol)stella_Object3;
                                                                propertyList.insertAt(stella_Object2, (Stella_Object)Stella.string_keywordify((String)Logic.coerceToString((Stella_Object)generalizedSymbol2)));
                                                                queryIterator.inferenceLevel = Logic.getInferenceLevel((Keyword)Logic.lookupQueryOption((Stella_Object)queryIterator, Logic.KWD_INFERENCE_LEVEL));
                                                                break block76;
                                                            } else if (Surrogate.subtypeOfStringP((Surrogate)surrogate)) {
                                                                StringWrapper stringWrapper = (StringWrapper)stella_Object3;
                                                                propertyList.insertAt(stella_Object2, (Stella_Object)Stella.string_keywordify((String)Logic.coerceToString((Stella_Object)stringWrapper)));
                                                                queryIterator.inferenceLevel = Logic.getInferenceLevel((Keyword)Logic.lookupQueryOption((Stella_Object)queryIterator, Logic.KWD_INFERENCE_LEVEL));
                                                                break block76;
                                                            } else {
                                                                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                                                                Object object = Stella.$PRINTREADABLYp$.get();
                                                                try {
                                                                    Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                                                                    outputStringStream.nativeStream.println("PARSING ERROR: Illegal :INFERENCE-LEVEL value: `" + stella_Object3 + "'.");
                                                                    Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
                                                                    throw (ParsingError)((Object)ParsingError.newParsingError(outputStringStream.theStringReader()).fillInStackTrace());
                                                                }
                                                                finally {
                                                                    Stella.$PRINTREADABLYp$.set(object);
                                                                }
                                                            }
                                                        }
                                                        if (generalizedSymbol != Logic.KWD_THREE_VALUEDp) break block81;
                                                        stella_Object3 = Stella_Object.coerceToBoolean((Stella_Object)stella_Object3);
                                                        propertyList.insertAt(stella_Object2, stella_Object3);
                                                        break block76;
                                                    }
                                                    if (generalizedSymbol != Logic.KWD_ITERATIVE_DEEPENINGp) break block82;
                                                    stella_Object3 = Stella_Object.coerceToBoolean((Stella_Object)stella_Object3);
                                                    propertyList.insertAt(stella_Object2, stella_Object3);
                                                    if (Stella_Object.eqlP((Stella_Object)stella_Object3, (Stella_Object)Stella.TRUE_WRAPPER)) {
                                                        KeyValueList.setDynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ITERATIVE_DEEPENINGp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
                                                    }
                                                    break block76;
                                                }
                                                if (generalizedSymbol != Logic.KWD_SINGLETONSp) break block83;
                                                propertyList.insertAt(stella_Object2, (Stella_Object)Stella_Object.coerceToBoolean((Stella_Object)stella_Object3));
                                                KeyValueList.setDynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ATOMIC_SINGLETONSp, (Stella_Object)(Stella_Object.eqlP((Stella_Object)stella_Object3, (Stella_Object)Stella.TRUE_WRAPPER) ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER), (Wrapper)Stella.FALSE_WRAPPER);
                                                break block76;
                                            }
                                            if (generalizedSymbol != Logic.KWD_DONT_OPTIMIZEp) break block84;
                                            stella_Object3 = Stella_Object.coerceToBoolean((Stella_Object)stella_Object3);
                                            propertyList.insertAt(stella_Object2, stella_Object3);
                                            break block76;
                                        }
                                        if (generalizedSymbol != Logic.KWD_HOW_MANY) break block85;
                                        surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object3);
                                        if (Surrogate.subtypeOfIntegerP((Surrogate)surrogate)) {
                                            IntegerWrapper integerWrapper = (IntegerWrapper)stella_Object3;
                                            break block76;
                                        } else {
                                            if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_STELLA_GENERALIZED_SYMBOL)) {
                                                GeneralizedSymbol generalizedSymbol3 = (GeneralizedSymbol)stella_Object3;
                                                if (Stella.stringEqlP((String)generalizedSymbol3.symbolName, (String)"ALL")) {
                                                    propertyList.insertAt(stella_Object2, (Stella_Object)IntegerWrapper.wrapInteger((int)Integer.MIN_VALUE));
                                                    break block76;
                                                } else {
                                                    OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                                                    Object object = Stella.$PRINTREADABLYp$.get();
                                                    try {
                                                        Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                                                        outputStringStream.nativeStream.println("PARSING ERROR: Illegal :HOW-MANY value: `" + generalizedSymbol3 + "'.");
                                                        Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
                                                        throw (ParsingError)((Object)ParsingError.newParsingError(outputStringStream.theStringReader()).fillInStackTrace());
                                                    }
                                                    finally {
                                                        Stella.$PRINTREADABLYp$.set(object);
                                                    }
                                                }
                                            }
                                            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                                            Object object = Stella.$PRINTREADABLYp$.get();
                                            try {
                                                Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                                                outputStringStream.nativeStream.println("PARSING ERROR: Illegal :HOW-MANY value: `" + stella_Object3 + "'.");
                                                Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
                                                throw (ParsingError)((Object)ParsingError.newParsingError(outputStringStream.theStringReader()).fillInStackTrace());
                                            }
                                            finally {
                                                Stella.$PRINTREADABLYp$.set(object);
                                            }
                                        }
                                    }
                                    if (generalizedSymbol == Logic.KWD_SORT_BY) {
                                        if (Surrogate.subtypeOfP((Surrogate)Stella_Object.safePrimaryType((Stella_Object)stella_Object3), (Surrogate)Logic.SGT_STELLA_GENERALIZED_SYMBOL)) {
                                            surrogate = (GeneralizedSymbol)stella_Object3;
                                            if (Stella.stringEqlP((String)surrogate.symbolName, (String)"SCORE")) {
                                                propertyList.insertAt(stella_Object2, (Stella_Object)Logic.KWD_SCORE);
                                                break block76;
                                            } else {
                                                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                                                Object object = Stella.$PRINTREADABLYp$.get();
                                                try {
                                                    Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                                                    outputStringStream.nativeStream.println("PARSING ERROR: Illegal :SORT-BY value: `" + surrogate + "'.");
                                                    Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
                                                    throw (ParsingError)((Object)ParsingError.newParsingError(outputStringStream.theStringReader()).fillInStackTrace());
                                                }
                                                finally {
                                                    Stella.$PRINTREADABLYp$.set(object);
                                                }
                                            }
                                        }
                                        surrogate = OutputStringStream.newOutputStringStream();
                                        Object object = Stella.$PRINTREADABLYp$.get();
                                        try {
                                            Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                                            surrogate.nativeStream.println("PARSING ERROR: Illegal :SORT-BY value: `" + stella_Object3 + "'.");
                                            Logic.helpSignalPropositionError((OutputStream)surrogate, Logic.KWD_ERROR);
                                            throw (ParsingError)((Object)ParsingError.newParsingError(surrogate.theStringReader()).fillInStackTrace());
                                        }
                                        finally {
                                            Stella.$PRINTREADABLYp$.set(object);
                                        }
                                    }
                                    if (generalizedSymbol != Logic.KWD_MATCH_MODE) break block86;
                                    surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object3);
                                    if (!Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_STELLA_GENERALIZED_SYMBOL)) break block87;
                                    GeneralizedSymbol generalizedSymbol4 = (GeneralizedSymbol)stella_Object3;
                                    if (Stella_Object.stringP((Stella_Object)generalizedSymbol4)) {
                                        propertyList.insertAt(stella_Object2, (Stella_Object)generalizedSymbol4.keywordify());
                                        break block76;
                                    } else {
                                        propertyList.insertAt(stella_Object2, (Stella_Object)generalizedSymbol4);
                                    }
                                    break block76;
                                }
                                if (Surrogate.subtypeOfStringP((Surrogate)surrogate)) {
                                    StringWrapper stringWrapper = (StringWrapper)stella_Object3;
                                    if (Stella_Object.stringP((Stella_Object)stringWrapper)) {
                                        propertyList.insertAt(stella_Object2, (Stella_Object)stringWrapper.keywordify());
                                        break block76;
                                    } else {
                                        propertyList.insertAt(stella_Object2, (Stella_Object)stringWrapper);
                                    }
                                    break block76;
                                } else {
                                    OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                                    Object object = Stella.$PRINTREADABLYp$.get();
                                    try {
                                        Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                                        outputStringStream.nativeStream.println("PARSING ERROR: Illegal :MATCH-MODE value: `" + stella_Object3 + "'.");
                                        Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
                                        throw (ParsingError)((Object)ParsingError.newParsingError(outputStringStream.theStringReader()).fillInStackTrace());
                                    }
                                    finally {
                                        Stella.$PRINTREADABLYp$.set(object);
                                    }
                                }
                            }
                            if (generalizedSymbol != Logic.KWD_MINIMUM_SCORE) break block88;
                            surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object3);
                            if (Surrogate.subtypeOfIntegerP((Surrogate)surrogate)) {
                                IntegerWrapper integerWrapper = (IntegerWrapper)stella_Object3;
                                propertyList.insertAt(stella_Object2, (Stella_Object)FloatWrapper.wrapFloat((double)integerWrapper.wrapperValue));
                                break block76;
                            } else if (Surrogate.subtypeOfFloatP((Surrogate)surrogate)) {
                                FloatWrapper floatWrapper = (FloatWrapper)stella_Object3;
                                break block76;
                            } else {
                                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                                Object object = Stella.$PRINTREADABLYp$.get();
                                try {
                                    Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                                    outputStringStream.nativeStream.println("PARSING ERROR: Illegal :MINIMUM-SCORE value: `" + stella_Object3 + "'.");
                                    Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
                                    throw (ParsingError)((Object)ParsingError.newParsingError(outputStringStream.theStringReader()).fillInStackTrace());
                                }
                                finally {
                                    Stella.$PRINTREADABLYp$.set(object);
                                }
                            }
                        }
                        if (generalizedSymbol != Logic.KWD_MAXIMIZE_SCOREp) break block89;
                        propertyList.insertAt(stella_Object2, (Stella_Object)Stella_Object.coerceToBoolean((Stella_Object)stella_Object3));
                        break block76;
                    }
                    if (generalizedSymbol != Logic.KWD_MAXIMUM_UNKNOWNS) break block90;
                    surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object3);
                    if (Surrogate.subtypeOfIntegerP((Surrogate)surrogate)) {
                        IntegerWrapper integerWrapper = (IntegerWrapper)stella_Object3;
                        break block76;
                    } else if (Surrogate.subtypeOfFloatP((Surrogate)surrogate)) {
                        FloatWrapper floatWrapper = (FloatWrapper)stella_Object3;
                        propertyList.insertAt(stella_Object2, (Stella_Object)IntegerWrapper.wrapInteger((int)((int)floatWrapper.wrapperValue)));
                        break block76;
                    } else {
                        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                        Object object = Stella.$PRINTREADABLYp$.get();
                        try {
                            Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                            outputStringStream.nativeStream.println("PARSING ERROR: Illegal :MAXIMUM-UNKNOWNS value: `" + stella_Object3 + "'.");
                            Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
                            throw (ParsingError)((Object)ParsingError.newParsingError(outputStringStream.theStringReader()).fillInStackTrace());
                        }
                        finally {
                            Stella.$PRINTREADABLYp$.set(object);
                        }
                    }
                }
                if (propertyList2 == null) {
                    propertyList2 = PropertyList.newPropertyList();
                }
                propertyList2.insertAt(stella_Object2, stella_Object3);
            }
            cons = cons.rest.rest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        PatternRecord patternRecord;
        QueryIterator queryIterator = this;
        if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_GOAL_CACHES)) {
            System.out.println("------------- RESET -------------");
        }
        ControlFrame controlFrame = queryIterator.baseControlFrame;
        if (controlFrame.down != null) {
            ControlFrame.popFramesUpTo(controlFrame.down);
        }
        queryIterator.currentPatternRecord = patternRecord = controlFrame.patternRecord;
        Object object = Stella.$CONTEXT$.get();
        Object object2 = Logic.$QUERYITERATOR$.get();
        try {
            Native.setSpecial((ThreadLocal)Stella.$CONTEXT$, (Object)Logic.getQueryContext());
            Native.setSpecial((ThreadLocal)Logic.$QUERYITERATOR$, (Object)((Object)queryIterator));
            PatternRecord.unbindVariablesBeginningAt(patternRecord, 0);
            if ((Vector)KeyValueList.dynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_LOGIC_INITIAL_BINDINGS, null) != null) {
                PatternVariable patternVariable = null;
                Vector vector = queryIterator.externalVariables;
                int n = 0;
                int n2 = vector.length();
                Stella_Object stella_Object = null;
                Vector vector2 = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_LOGIC_INITIAL_BINDINGS, null);
                int n3 = vector2.length();
                for (int i = 0; n < n2 && i < n3; ++n, ++i) {
                    patternVariable = (PatternVariable)vector.theArray[n];
                    stella_Object = vector2.theArray[i];
                    if (stella_Object == null || Logic.bindArgumentToValueP((Stella_Object)patternVariable, stella_Object, false)) continue;
                    OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                    outputStringStream.nativeStream.print("reset: binding of `" + (Object)((Object)patternVariable) + "' to `" + stella_Object + "' failed.");
                    throw (FailException)((Object)FailException.newFailException(outputStringStream.theStringReader()).fillInStackTrace());
                }
            }
            ControlFrame.overlayWithPatternFrameP(controlFrame, patternRecord.description, patternRecord.externalArguments);
        }
        finally {
            Logic.$QUERYITERATOR$.set(object2);
            Stella.$CONTEXT$.set(object);
        }
        queryIterator.exhaustedP = false;
        queryIterator.timeoutP = false;
        queryIterator.solutions.clear();
        controlFrame.truthValue = null;
        queryIterator.augmentedGoalCacheP = false;
        queryIterator.triggeredDepthCutoffP = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean tryToDefeatLastAnswerP(QueryIterator queryIterator) {
        QueryIterator queryIterator2 = queryIterator.queryIsTrueFalseP() ? queryIterator : (QueryIterator)KeyValueList.dynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_LOGIC_AUXILIARY_QUERY, null);
        Context context = queryIterator.queryContext;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (queryIterator2 == null) {
            queryIterator2 = Description.createQueryIterator(queryIterator.queryDescription(), ((QuerySolution)queryIterator.value).bindings);
            queryIterator2.queryContext = context;
        } else {
            if (queryIterator == (QueryIterator)KeyValueList.dynamicSlotValue((KeyValueList)queryIterator2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_AUXILIARY_QUERY, null)) {
                return false;
            }
            KeyValueList.setDynamicSlotValue((KeyValueList)queryIterator2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_INITIAL_BINDINGS, (Stella_Object)((QuerySolution)queryIterator.value).bindings, null);
        }
        KeyValueList.setDynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_LOGIC_AUXILIARY_QUERY, (Stella_Object)queryIterator2, null);
        KeyValueList.setDynamicSlotValue((KeyValueList)queryIterator2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_AUXILIARY_QUERY, (Stella_Object)queryIterator, null);
        queryIterator2.baseControlFrame.reversePolarityP = true;
        queryIterator2.reset();
        if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_GOAL_TREE)) {
            System.out.println("Looking for conflicting default conclusion:");
        }
        if (queryIterator2.nextP()) {
            queryIterator2.reset();
            Object object = Logic.$DONTUSEDEFAULTKNOWLEDGEp$.get();
            try {
                Native.setBooleanSpecial((ThreadLocal)Logic.$DONTUSEDEFAULTKNOWLEDGEp$, (boolean)true);
                if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_GOAL_TREE)) {
                    System.out.println("Looking for conflicting strict conclusion:");
                }
                bl2 = queryIterator2.nextP();
            }
            finally {
                Logic.$DONTUSEDEFAULTKNOWLEDGEp$.set(object);
            }
            queryIterator2.baseControlFrame.reversePolarityP = false;
            queryIterator2.reset();
            object = Logic.$DONTUSEDEFAULTKNOWLEDGEp$.get();
            try {
                Native.setBooleanSpecial((ThreadLocal)Logic.$DONTUSEDEFAULTKNOWLEDGEp$, (boolean)true);
                if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_GOAL_TREE)) {
                    System.out.println("Looking for strict conclusion:");
                }
                bl = queryIterator2.nextP();
            }
            finally {
                Logic.$DONTUSEDEFAULTKNOWLEDGEp$.set(object);
            }
            if (bl) {
                if (bl2) {
                    object = Logic.$QUERYITERATOR$.get();
                    try {
                        Native.setSpecial((ThreadLocal)Logic.$QUERYITERATOR$, (Object)((Object)queryIterator2));
                        System.out.println();
                        System.out.println("CONTRADICTION: Discovered strict arguments for");
                        System.out.println("    `" + (Object)((Object)queryIterator2.baseControlFrame.proposition) + "'");
                        System.out.println("and its negation.");
                        System.out.println();
                    }
                    finally {
                        Logic.$QUERYITERATOR$.set(object);
                    }
                    bl3 = true;
                } else {
                    bl3 = false;
                }
            } else {
                bl3 = true;
            }
        }
        KeyValueList.setDynamicSlotValue((KeyValueList)queryIterator2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_AUXILIARY_QUERY, null, null);
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean nextP() {
        Object object;
        QueryIterator queryIterator = this;
        if (queryIterator.exhaustedP) {
            return false;
        }
        ControlFrame controlFrame = queryIterator.baseControlFrame;
        QuerySolution querySolution = QuerySolution.newQuerySolution();
        querySolution.bindings = Vector.newVector((int)queryIterator.externalVariables.length());
        querySolution.truthValue = Logic.UNKNOWN_TRUTH_VALUE;
        QuerySolution querySolution2 = querySolution;
        QuerySolution querySolution3 = null;
        queryIterator.value = querySolution2;
        if (queryIterator.firstIterationP) {
            queryIterator.firstIterationP = false;
            object = (PropertyList)Logic.lookupQueryOption((Stella_Object)queryIterator, Logic.KWD_DEFERRED_OPTIONS);
            if (object != null && object.nonEmptyP()) {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                Object object2 = Stella.$PRINTREADABLYp$.get();
                try {
                    Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
                    outputStringStream.nativeStream.println("PARSING ERROR: Illegal query option(s): `" + object + "'.");
                    Logic.helpSignalPropositionError((OutputStream)outputStringStream, Logic.KWD_ERROR);
                }
                finally {
                    Stella.$PRINTREADABLYp$.set(object2);
                }
                throw (ParsingError)((Object)ParsingError.newParsingError(outputStringStream.theStringReader()).fillInStackTrace());
            }
        }
        while (true) {
            block17: {
                object = Stella.$CONTEXT$.get();
                Object object3 = Stella.$MODULE$.get();
                try {
                    Native.setSpecial((ThreadLocal)Stella.$CONTEXT$, (Object)Logic.getQueryContext());
                    Native.setSpecial((ThreadLocal)Stella.$MODULE$, (Object)((Context)Stella.$CONTEXT$.get()).baseModule);
                    do {
                        querySolution2.bindings.clear();
                        querySolution2.truthValue = Logic.UNKNOWN_TRUTH_VALUE;
                        querySolution2.justification = null;
                        querySolution2.matchScore = Double.NEGATIVE_INFINITY;
                        if (!QueryIterator.executeBackwardChainingProofP(queryIterator)) {
                            break block17;
                        }
                        LogicObject logicObject = null;
                        Vector vector = queryIterator.externalVariables;
                        int n = vector.length();
                        int n2 = Integer.MIN_VALUE;
                        int n3 = 0;
                        for (int i = 0; i < n; ++i) {
                            logicObject = (PatternVariable)vector.theArray[i];
                            n2 = n3++;
                            querySolution2.bindings.theArray[n2] = ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord.variableBindings.theArray[logicObject.boundToOffset];
                        }
                        queryIterator.foundAtLeastOneSolutionP = true;
                        logicObject = controlFrame.truthValue;
                        querySolution2.truthValue = logicObject != null ? logicObject : Logic.UNKNOWN_TRUTH_VALUE;
                        querySolution2.justification = (Justification)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null);
                        if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) == null || ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy == null) continue;
                        double d = querySolution2.matchScore = controlFrame.partialMatchFrame != null && (controlFrame.partialMatchFrame.positiveScore != Double.NEGATIVE_INFINITY || controlFrame.partialMatchFrame.negativeScore != Double.NEGATIVE_INFINITY) ? controlFrame.partialMatchFrame.positiveScore : ((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_LOGIC_LATEST_POSITIVE_SCORE, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue;
                    } while ((querySolution3 = (QuerySolution)queryIterator.solutions.lookup(querySolution2.bindings)) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) == null || ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy == null || querySolution2.matchScore <= querySolution3.matchScore) || (controlFrame.truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE || controlFrame.truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE) && QueryIterator.tryToDefeatLastAnswerP(queryIterator));
                    controlFrame.truthValue = querySolution2.truthValue;
                    KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, (Stella_Object)querySolution2.justification, null);
                    queryIterator.solutions.insertAt(querySolution2.bindings, querySolution2);
                    boolean bl = true;
                    return bl;
                }
                finally {
                    Stella.$MODULE$.set(object3);
                    Stella.$CONTEXT$.set(object);
                }
            }
            if (queryIterator.timeoutP) {
                return false;
            }
            if (queryIterator.augmentedGoalCacheP) {
                queryIterator.reset();
                continue;
            }
            if (!((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ITERATIVE_DEEPENINGp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue || !queryIterator.triggeredDepthCutoffP || queryIterator.currentDepthCutoff >= queryIterator.maximumDepth) break;
            ++queryIterator.currentDepthCutoff;
            queryIterator.reset();
        }
        if (queryIterator.failedToFindDuplicateSubgoalP && !queryIterator.foundAtLeastOneSolutionP) {
            System.out.println("Failed to find a duplicate subgoal on one or more occurrences when");
            System.out.println("   the depth cutoff " + queryIterator.currentDepthCutoff + " was exceeded.  Consider increasing the cutoff");
            System.out.println("   (by setting the variable *maximum-backtracking-depth*)");
            System.out.println("   and trying again.");
        }
        queryIterator.exhaustedP = true;
        return false;
    }

    public boolean querySucceededP() {
        QueryIterator queryIterator = this;
        return queryIterator.solutions.nonEmptyP();
    }

    public boolean queryIsPartialP() {
        QueryIterator queryIterator = this;
        if (queryIterator.partialMatchStrategy != null) {
            return true;
        }
        Stella_Object stella_Object = Logic.lookupQueryOption((Stella_Object)queryIterator, Logic.KWD_MATCH_MODE);
        return stella_Object != null && stella_Object != Logic.KWD_STRICT;
    }

    public boolean queryIsTrueFalseP() {
        QueryIterator queryIterator = this;
        if (queryIterator.externalVariables.arraySize == 0) {
            return true;
        }
        PatternRecord patternRecord = queryIterator.baseControlFrame.patternRecord;
        boolean bl = true;
        Stella_Object stella_Object = null;
        Vector vector = patternRecord.externalArguments;
        int n = 0;
        int n2 = vector.length();
        BooleanWrapper booleanWrapper = null;
        BooleanVector booleanVector = patternRecord.booleanVector;
        int n3 = booleanVector.length();
        for (int i = 0; n < n2 && i < n3; ++n, ++i) {
            stella_Object = vector.theArray[n];
            booleanWrapper = (BooleanWrapper)booleanVector.theArray[i];
            if (BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)booleanWrapper)) continue;
            bl = false;
            break;
        }
        boolean bl2 = bl;
        return bl2;
    }

    public Description queryDescription() {
        QueryIterator queryIterator = this;
        return queryIterator.baseControlFrame.patternRecord.description;
    }

    public Proposition queryProposition() {
        QueryIterator queryIterator = this;
        return queryIterator.baseControlFrame.proposition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueryIterator initializeQueryIterator(QueryIterator queryIterator, Description description, Vector vector) {
        ControlFrame controlFrame = ControlFrame.newControlFrame();
        Vector vector2 = null;
        Object object = Logic.$QUERYITERATOR$.get();
        Object object2 = Logic.$EVALUATIONMODE$.get();
        try {
            Native.setSpecial((ThreadLocal)Logic.$QUERYITERATOR$, (Object)((Object)queryIterator));
            Native.setSpecial((ThreadLocal)Logic.$EVALUATIONMODE$, (Object)Logic.KWD_DESCRIPTION);
            if (Logic.testQueryOptionP((Stella_Object)queryIterator, Logic.KWD_DONT_OPTIMIZEp)) {
                KeyValueList.setDynamicSlotValue((KeyValueList)description.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DONT_OPTIMIZEp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
                KeyValueList.setDynamicSlotValue((KeyValueList)description.proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DONT_OPTIMIZEp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
            }
            queryIterator.queryContext = (Context)Stella.$CONTEXT$.get();
            queryIterator.baseControlFrame = controlFrame;
            queryIterator.currentControlFrame = controlFrame;
            Logic.$CONTROL_FRAME_ID_COUNTER$ = 0;
            controlFrame.proposition = description.proposition;
            controlFrame.up = null;
            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_GOAL_CACHE, null, null);
            controlFrame.goalBindings = null;
            vector2 = ControlFrame.allocateCollectionVariables(controlFrame, description);
            Object object3 = Stella.$CONTEXT$.get();
            Object object4 = Stella.$MODULE$.get();
            try {
                Native.setSpecial((ThreadLocal)Stella.$CONTEXT$, (Object)Logic.getQueryContext());
                Native.setSpecial((ThreadLocal)Stella.$MODULE$, (Object)((Context)Stella.$CONTEXT$.get()).baseModule);
                if (vector != null) {
                    KeyValueList.setDynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_LOGIC_INITIAL_BINDINGS, (Stella_Object)vector, null);
                    if (vector.length() > vector2.length()) {
                        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                        outputStringStream.nativeStream.print("Arity mismatch between bindings `" + vector + "' and external variables `" + vector2 + "'.");
                        throw (FailException)((Object)FailException.newFailException(outputStringStream.theStringReader()).fillInStackTrace());
                    }
                    PatternVariable patternVariable = null;
                    Vector vector3 = vector2;
                    int n = 0;
                    int n2 = vector3.length();
                    Stella_Object stella_Object = null;
                    Vector vector4 = vector;
                    int n3 = vector4.length();
                    for (int i = 0; n < n2 && i < n3; ++n, ++i) {
                        patternVariable = (PatternVariable)vector3.theArray[n];
                        stella_Object = vector4.theArray[i];
                        if (stella_Object == null || Logic.bindArgumentToValueP((Stella_Object)patternVariable, stella_Object, false)) continue;
                        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                        outputStringStream.nativeStream.print("Binding of `" + (Object)((Object)patternVariable) + "' to `" + stella_Object + "' failed.");
                        throw (FailException)((Object)FailException.newFailException(outputStringStream.theStringReader()).fillInStackTrace());
                    }
                }
                ControlFrame.overlayWithPatternFrameP(controlFrame, description, vector2);
            }
            finally {
                Stella.$MODULE$.set(object4);
                Stella.$CONTEXT$.set(object3);
            }
            queryIterator.controlFramePriorityQueue = ControlFramePriorityQueue.newControlFramePriorityQueue();
            if (queryIterator.maximumDepth == Integer.MIN_VALUE) {
                queryIterator.maximumDepth = Logic.$MAXIMUM_BACKTRACKING_DEPTH$;
            }
            queryIterator.augmentedGoalCacheP = false;
            queryIterator.activeGoalCaches.clear();
            if (Logic.$ITERATIVE_DEEPENING_MODEp$ && !Logic.testQueryOptionP((Stella_Object)queryIterator, Logic.KWD_ITERATIVE_DEEPENINGp)) {
                KeyValueList.setDynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ITERATIVE_DEEPENINGp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
            }
            queryIterator.currentDepthCutoff = ((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ITERATIVE_DEEPENINGp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue ? Stella.min((int)Logic.$INITIAL_BACKTRACKING_DEPTH$, (int)queryIterator.maximumDepth) : queryIterator.maximumDepth;
            queryIterator.triggeredDepthCutoffP = false;
            queryIterator.failedToFindDuplicateSubgoalP = false;
            queryIterator.foundAtLeastOneSolutionP = false;
            queryIterator.externalVariables = vector2;
            object3 = queryIterator;
            return object3;
        }
        finally {
            Logic.$EVALUATIONMODE$.set(object2);
            Logic.$QUERYITERATOR$.set(object);
        }
    }

    public static void freeQueryIterator(QueryIterator queryIterator) {
        if (queryIterator.baseControlFrame == null) {
            return;
        }
        ((QuerySolution)queryIterator.value).free();
        queryIterator.baseControlFrame = null;
    }

    public void free() {
        QueryIterator queryIterator = this;
        QueryIterator.freeQueryIterator(queryIterator);
    }

    public static void printQueryIteratorReadably(QueryIterator queryIterator, PrintStream printStream) {
        boolean bl;
        QuerySolutionTable querySolutionTable = queryIterator.solutions;
        boolean bl2 = true;
        boolean bl3 = ((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ATOMIC_SINGLETONSp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue && queryIterator.partialMatchStrategy == null;
        printStream.print("(");
        QuerySolution querySolution = null;
        DictionaryIterator dictionaryIterator = (DictionaryIterator)querySolutionTable.allocateIterator();
        int n = Integer.MIN_VALUE;
        int n2 = (Integer)Stella.$PRINTLENGTH$.get();
        boolean bl4 = bl = n2 == Integer.MIN_VALUE;
        for (int i = 1; dictionaryIterator.nextP() && (bl || i <= n2); ++i) {
            querySolution = (QuerySolution)dictionaryIterator.value;
            n = i;
            if (!bl2) {
                if (bl3) {
                    printStream.print(" ");
                } else {
                    printStream.println();
                    printStream.print(" ");
                }
            }
            bl2 = false;
            if (!bl3) {
                printStream.print("(");
            }
            Stella_Object stella_Object = null;
            Vector vector = querySolution.bindings;
            int n3 = 0;
            int n4 = vector.length();
            int n5 = Integer.MIN_VALUE;
            int n6 = 0;
            while (n3 < n4) {
                stella_Object = vector.theArray[n3];
                n5 = n6;
                printStream.print((n5 == 0 ? "" : " ") + stella_Object);
                if (queryIterator.partialMatchStrategy != null) {
                    printStream.print(" " + querySolution.matchScore);
                }
                ++n3;
                ++n6;
            }
            if (!bl3) {
                printStream.print(")");
            }
            if (n != (Integer)Stella.$PRINTLENGTH$.get() || n >= querySolutionTable.length()) continue;
            printStream.print(" ...");
        }
        printStream.println(")");
    }

    public static void traceSolution(QueryIterator queryIterator, QuerySolution querySolution, int n) {
        if (Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_TRACE_SOLUTIONS)) {
            System.out.print("SOLUTION ");
            QueryIterator.printQueryIteratorSolutionOrnately((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()), querySolution, n, Stella.STANDARD_OUTPUT.nativeStream);
            System.out.println();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printQueryIteratorSolutionOrnately(QueryIterator queryIterator, QuerySolution querySolution, int n, PrintStream printStream) {
        DictionaryIterator dictionaryIterator;
        Object object;
        if (n == Integer.MIN_VALUE) {
            n = 0;
            object = null;
            dictionaryIterator = (DictionaryIterator)queryIterator.solutions.allocateIterator();
            while (dictionaryIterator.nextP()) {
                object = (QuerySolution)dictionaryIterator.value;
                if (Stella_Object.equalP((Stella_Object)((QuerySolution)((Object)object)).bindings, (Stella_Object)object)) continue;
                ++n;
            }
        }
        object = Stella.$PRINTREADABLYp$.get();
        try {
            Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
            printStream.print("  #" + n + ": ");
            dictionaryIterator = null;
            Vector vector = querySolution.bindings;
            int n2 = 0;
            int n3 = vector.length();
            PatternVariable patternVariable = null;
            Vector vector2 = queryIterator.externalVariables;
            int n4 = 0;
            int n5 = vector2.length();
            int n6 = Integer.MIN_VALUE;
            int n7 = 0;
            while (n2 < n3 && n4 < n5) {
                dictionaryIterator = vector.theArray[n2];
                patternVariable = (PatternVariable)vector2.theArray[n4];
                n6 = n7;
                printStream.print((n6 == 0 ? "" : ", ") + patternVariable.skolemName + "=" + dictionaryIterator);
                ++n2;
                ++n4;
                ++n7;
            }
            if (queryIterator.partialMatchStrategy != null && querySolution.matchScore != Double.NEGATIVE_INFINITY) {
                printStream.print(" " + querySolution.matchScore);
            }
        }
        finally {
            Stella.$PRINTREADABLYp$.set(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printQueryIteratorOrnately(QueryIterator queryIterator, PrintStream printStream) {
        QuerySolutionTable querySolutionTable = queryIterator.solutions;
        int n = querySolutionTable.length();
        boolean bl = queryIterator.exhaustedP;
        switch (n) {
            case 0: {
                printStream.print("No solutions");
                break;
            }
            case 1: {
                printStream.print("There is 1 solution");
                break;
            }
            default: {
                printStream.print("There are " + n + " solutions");
            }
        }
        if (!bl) {
            printStream.print(" so far");
        }
        if (queryIterator.timeoutP) {
            printStream.print(" (timeout)");
        }
        if (n == 0) {
            printStream.println(".");
            return;
        }
        printStream.println(":");
        Object object = Stella.$PRINTREADABLYp$.get();
        try {
            boolean bl2;
            Native.setBooleanSpecial((ThreadLocal)Stella.$PRINTREADABLYp$, (boolean)true);
            QuerySolution querySolution = null;
            DictionaryIterator dictionaryIterator = (DictionaryIterator)querySolutionTable.allocateIterator();
            int n2 = Integer.MIN_VALUE;
            int n3 = (Integer)Stella.$PRINTLENGTH$.get();
            boolean bl3 = bl2 = n3 == Integer.MIN_VALUE;
            for (int i = 1; dictionaryIterator.nextP() && (bl2 || i <= n3); ++i) {
                querySolution = (QuerySolution)dictionaryIterator.value;
                n2 = i;
                QueryIterator.printQueryIteratorSolutionOrnately(queryIterator, querySolution, n2, printStream);
                if (n2 < n) {
                    printStream.println();
                }
                if (n2 != (Integer)Stella.$PRINTLENGTH$.get() || n2 >= n) continue;
                printStream.println("  ......");
            }
        }
        finally {
            Stella.$PRINTREADABLYp$.set(object);
        }
    }

    public static void printQueryIterator(QueryIterator queryIterator, PrintStream printStream) {
        if (((Boolean)Stella.$PRINTREADABLYp$.get()).booleanValue()) {
            QueryIterator.printQueryIteratorReadably(queryIterator, printStream);
        } else {
            QueryIterator.printQueryIteratorOrnately(queryIterator, printStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean executeBackwardChainingProofP(QueryIterator queryIterator) {
        if (queryIterator.baseControlFrame.down == null) {
            return false;
        }
        Object object = Logic.$QUERYITERATOR$.get();
        try {
            boolean bl;
            boolean bl2;
            boolean bl3;
            int n;
            double d;
            int n2;
            int n3;
            block55: {
                Native.setSpecial((ThreadLocal)Logic.$QUERYITERATOR$, (Object)((Object)queryIterator));
                ControlFrame controlFrame = queryIterator.baseControlFrame;
                int n4 = 0;
                Keyword keyword = Logic.KWD_DOWN;
                Keyword keyword2 = null;
                n3 = queryIterator.currentClockTicks;
                long l = Native.getTicktock();
                n2 = n3;
                d = queryIterator.allottedTime;
                n = queryIterator.allottedClockTicks;
                boolean bl4 = d != Double.NEGATIVE_INFINITY;
                bl3 = n != Integer.MIN_VALUE;
                boolean bl5 = Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_GOAL_TREE);
                bl2 = false;
                bl = false;
                queryIterator.timeoutP = false;
                controlFrame.startingClockTicks = n3;
                if (bl3) {
                    controlFrame.allottedClockTicks = n;
                }
                controlFrame.truthValue = null;
                KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null, null);
                if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null) {
                    controlFrame.partialMatchFrame = queryIterator.partialMatchStrategy;
                    controlFrame.partialMatchFrame.clearFramePartialTruth();
                }
                keyword = Logic.KWD_DOWN;
                while (true) {
                    ControlFrame controlFrame2;
                    queryIterator.currentControlFrame = controlFrame;
                    if (bl5) {
                        if (keyword == Logic.KWD_UP_TRUE || keyword == Logic.KWD_UP_FAIL) {
                            ControlFrame.traceGoalTree(controlFrame.result, n4, keyword);
                        } else {
                            ControlFrame.traceGoalTree(controlFrame, n4, keyword);
                        }
                    }
                    if (bl4 && (n3 & 0xF) == 0) {
                        long l2 = Native.getTicktock();
                        double d2 = Native.ticktockDifference((long)l, (long)l2);
                        if (d2 >= 0.02) {
                            d -= d2;
                            l = l2;
                        }
                        if (d <= 0.0) {
                            bl2 = true;
                        }
                    }
                    keyword2 = ControlFrame.evaluateNextMove(controlFrame, keyword, n3);
                    controlFrame = queryIterator.currentControlFrame;
                    if (keyword2 == Logic.KWD_MOVE_DOWN) {
                        controlFrame2 = controlFrame;
                        ControlFrame controlFrame3 = controlFrame.down;
                        ++n4;
                        queryIterator.currentClockTicks = ++n3;
                        if (controlFrame3 != null) {
                            controlFrame = controlFrame3;
                            controlFrame.startingClockTicks = n3;
                            if (bl3 && controlFrame.allottedClockTicks == Integer.MIN_VALUE) {
                                controlFrame.allottedClockTicks = controlFrame2.allottedClockTicks - 1;
                            }
                            controlFrame.truthValue = null;
                            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null, null);
                            if (controlFrame.partialMatchFrame != null) {
                                controlFrame.partialMatchFrame.clearFramePartialTruth();
                            }
                            keyword = Logic.KWD_DOWN;
                        } else {
                            Stella_Object stella_Object = controlFrame2.proposition.arguments.theArray[controlFrame2.argumentCursor];
                            controlFrame = controlFrame3 = ControlFrame.createDownFrame(controlFrame2, (Proposition)stella_Object);
                            controlFrame.startingClockTicks = n3;
                            if (bl3) {
                                controlFrame.allottedClockTicks = controlFrame2.allottedClockTicks - 1;
                            }
                            keyword = Logic.KWD_DOWN;
                        }
                        if (n4 > queryIterator.currentDepthCutoff && controlFrame2.state == Logic.KWD_PATTERN) {
                            ControlFrame.popFramesUpTo(controlFrame);
                            Object[] objectArray = new Object[1];
                            controlFrame = ControlFrame.handleDepthViolation(controlFrame, n4, objectArray);
                            n4 = ((IntegerWrapper)objectArray[0]).wrapperValue;
                            keyword = Logic.KWD_UP_FAIL;
                        }
                        if (bl3) {
                            if (controlFrame.allottedClockTicks <= 0 && keyword != Logic.KWD_UP_FAIL) {
                                ControlFrame.popFramesUpTo(controlFrame);
                                Object[] objectArray = new Object[1];
                                controlFrame = ControlFrame.handleTimeout(controlFrame, n4, objectArray);
                                n4 = ((IntegerWrapper)objectArray[0]).wrapperValue;
                                keyword = Logic.KWD_UP_FAIL;
                            }
                            if (keyword == Logic.KWD_UP_FAIL) {
                                controlFrame.allottedClockTicks -= n3 - controlFrame3.startingClockTicks + 1;
                            }
                        }
                        if (!bl2 || keyword != Logic.KWD_DOWN) continue;
                        bl = false;
                        break block55;
                    }
                    if (keyword2 == Logic.KWD_FINAL_SUCCESS) {
                        controlFrame2 = controlFrame.up;
                        if (controlFrame2 != null) {
                            controlFrame2.result = controlFrame;
                            if ((Logic.$CACHE_SUCCEEDED_GOALSp$ || Logic.$CACHE_FAILED_GOALSp$) && Logic.$DUPLICATE_SUBGOAL_STRATEGY$ == Logic.KWD_DUPLICATE_GOALS && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) == null || ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy == null)) {
                                ControlFrame.cacheGoal(controlFrame, true, false, n3);
                            } else {
                                ControlFrame.updateGoalCache(controlFrame, true);
                            }
                        }
                        --n4;
                        if (bl3) {
                            controlFrame.allottedClockTicks = Integer.MIN_VALUE;
                            if (controlFrame2 != null) {
                                controlFrame2.allottedClockTicks = controlFrame2.allottedClockTicks - (n3 - controlFrame.startingClockTicks) - 1;
                            }
                        }
                        if ((controlFrame = controlFrame2) == null) {
                            bl = true;
                            break block55;
                        }
                        ControlFrame.popDownFrame(controlFrame);
                        keyword = Logic.KWD_UP_TRUE;
                        continue;
                    }
                    if (keyword2 == Logic.KWD_CONTINUING_SUCCESS) {
                        controlFrame2 = controlFrame.up;
                        if (controlFrame2 != null) {
                            controlFrame2.result = controlFrame;
                            if ((Logic.$CACHE_SUCCEEDED_GOALSp$ || Logic.$CACHE_FAILED_GOALSp$) && Logic.$DUPLICATE_SUBGOAL_STRATEGY$ == Logic.KWD_DUPLICATE_GOALS && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) == null || ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy == null)) {
                                ControlFrame.cacheGoal(controlFrame, true, true, n3);
                            } else {
                                ControlFrame.updateGoalCache(controlFrame, true);
                            }
                        }
                        --n4;
                        if (bl3) {
                            controlFrame.allottedClockTicks = Integer.MIN_VALUE;
                            if (controlFrame2 != null) {
                                controlFrame2.allottedClockTicks = controlFrame2.allottedClockTicks - (n3 - controlFrame.startingClockTicks) - 1;
                            }
                        }
                        if ((controlFrame = controlFrame2) == null) {
                            bl = true;
                            break block55;
                        }
                        keyword = Logic.KWD_UP_TRUE;
                        continue;
                    }
                    if (keyword2 == Logic.KWD_FAILURE) {
                        controlFrame2 = controlFrame.up;
                        if (controlFrame2 != null) {
                            controlFrame2.result = controlFrame;
                            if ((Logic.$CACHE_SUCCEEDED_GOALSp$ || Logic.$CACHE_FAILED_GOALSp$) && Logic.$DUPLICATE_SUBGOAL_STRATEGY$ == Logic.KWD_DUPLICATE_GOALS && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) == null || ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy == null)) {
                                ControlFrame.cacheGoal(controlFrame, false, false, n3);
                            } else {
                                ControlFrame.updateGoalCache(controlFrame, false);
                            }
                        }
                        --n4;
                        if (bl3) {
                            controlFrame.allottedClockTicks = Integer.MIN_VALUE;
                            if (controlFrame2 != null) {
                                controlFrame2.allottedClockTicks = controlFrame2.allottedClockTicks - (n3 - controlFrame.startingClockTicks) - 1;
                            }
                        }
                        if ((controlFrame = controlFrame2) == null) {
                            bl = false;
                            break block55;
                        }
                        ControlFrame.popDownFrame(controlFrame);
                        keyword = Logic.KWD_UP_FAIL;
                        continue;
                    }
                    if (keyword2 == Logic.KWD_MOVE_IN_PLACE) {
                        controlFrame.truthValue = null;
                        KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null, null);
                        if (controlFrame.partialMatchFrame != null) {
                            controlFrame.partialMatchFrame.clearFramePartialTruth();
                        }
                        keyword = Logic.KWD_DOWN;
                        if (bl3) {
                            ControlFrame controlFrame4 = controlFrame.up;
                            int n5 = controlFrame.startingClockTicks;
                            int n6 = controlFrame4.allottedClockTicks - (n3 - n5) - 1;
                            controlFrame4.allottedClockTicks = n6--;
                            controlFrame.allottedClockTicks = n6;
                            queryIterator.currentClockTicks = ++n3;
                            controlFrame.startingClockTicks = n3;
                            if (n6 > 0) continue;
                            ControlFrame.popFramesUpTo(controlFrame);
                            Object[] objectArray = new Object[1];
                            controlFrame = ControlFrame.handleTimeout(controlFrame, n4, objectArray);
                            n4 = ((IntegerWrapper)objectArray[0]).wrapperValue;
                            keyword = Logic.KWD_UP_FAIL;
                            controlFrame.allottedClockTicks -= n3 - n5 + 1;
                            continue;
                        }
                        queryIterator.currentClockTicks = ++n3;
                        controlFrame.startingClockTicks = n3;
                        continue;
                    }
                    if (keyword2 != Logic.KWD_TIMEOUT) break;
                    controlFrame2 = controlFrame.up;
                    if (controlFrame2 != null) {
                        controlFrame2.result = controlFrame;
                        if ((Logic.$CACHE_SUCCEEDED_GOALSp$ || Logic.$CACHE_FAILED_GOALSp$) && Logic.$DUPLICATE_SUBGOAL_STRATEGY$ == Logic.KWD_DUPLICATE_GOALS && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) == null || ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy == null)) {
                            ControlFrame.cacheGoal(controlFrame, false, true, n3);
                        } else {
                            ControlFrame.updateGoalCache(controlFrame, false);
                        }
                    }
                    --n4;
                    if (bl3) {
                        controlFrame.allottedClockTicks = Integer.MIN_VALUE;
                        if (controlFrame2 != null) {
                            controlFrame2.allottedClockTicks = controlFrame2.allottedClockTicks - (n3 - controlFrame.startingClockTicks) - 1;
                        }
                    }
                    if ((controlFrame = controlFrame2) == null) {
                        bl = false;
                        break block55;
                    }
                    keyword = Logic.KWD_UP_FAIL;
                }
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("`" + keyword2 + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
            }
            queryIterator.allottedTime = d;
            queryIterator.timeoutP = bl2;
            if (bl3) {
                queryIterator.allottedClockTicks = Stella.max((int)(n - (n3 - n2)), (int)0);
                if (!bl2) {
                    queryIterator.timeoutP = queryIterator.allottedClockTicks == 0;
                }
            }
            boolean bl6 = bl;
            return bl6;
        }
        finally {
            Logic.$QUERYITERATOR$.set(object);
        }
    }

    public void printObject(PrintStream printStream) {
        QueryIterator queryIterator = this;
        QueryIterator.printQueryIterator(queryIterator, printStream);
    }

    public boolean deletedPSetter(boolean bl) {
        QueryIterator queryIterator = this;
        KeyValueList.setDynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_STELLA_DELETED_OBJECTp, (Stella_Object)(bl ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER), null);
        return bl;
    }

    public boolean deletedP() {
        QueryIterator queryIterator = this;
        BooleanWrapper booleanWrapper = (BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_STELLA_DELETED_OBJECTp, null);
        if (booleanWrapper != null) {
            return BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)booleanWrapper);
        }
        return false;
    }

    public static Stella_Object accessQueryIteratorSlotValue(QueryIterator queryIterator, Symbol symbol, Stella_Object object, boolean bl) {
        if (symbol == Logic.SYM_LOGIC_EXTERNAL_VARIABLES) {
            if (bl) {
                queryIterator.externalVariables = (Vector)object;
            } else {
                object = queryIterator.externalVariables;
            }
        } else if (symbol == Logic.SYM_LOGIC_EXHAUSTEDp) {
            if (bl) {
                queryIterator.exhaustedP = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)((BooleanWrapper)object));
            } else {
                object = queryIterator.exhaustedP ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else if (symbol == Logic.SYM_STELLA_OPTIONS) {
            if (bl) {
                queryIterator.options = (PropertyList)object;
            } else {
                object = queryIterator.options;
            }
        } else if (symbol == Logic.SYM_LOGIC_SOLUTIONS) {
            if (bl) {
                queryIterator.solutions = (QuerySolutionTable)((Object)object);
            } else {
                object = queryIterator.solutions;
            }
        } else if (symbol == Logic.SYM_LOGIC_QUERY_CONTEXT) {
            if (bl) {
                queryIterator.queryContext = (Context)object;
            } else {
                object = queryIterator.queryContext;
            }
        } else if (symbol == Logic.SYM_LOGIC_BASE_CONTROL_FRAME) {
            if (bl) {
                queryIterator.baseControlFrame = (ControlFrame)((Object)object);
            } else {
                object = queryIterator.baseControlFrame;
            }
        } else if (symbol == Logic.SYM_LOGIC_CURRENT_CONTROL_FRAME) {
            if (bl) {
                queryIterator.currentControlFrame = (ControlFrame)((Object)object);
            } else {
                object = queryIterator.currentControlFrame;
            }
        } else if (symbol == Logic.SYM_LOGIC_CURRENT_PATTERN_RECORD) {
            if (bl) {
                queryIterator.currentPatternRecord = (PatternRecord)((Object)object);
            } else {
                object = queryIterator.currentPatternRecord;
            }
        } else if (symbol == Logic.SYM_LOGIC_CURRENT_PARALLEL_THREAD) {
            if (bl) {
                queryIterator.currentParallelThread = (ParallelThread)((Object)object);
            } else {
                object = queryIterator.currentParallelThread;
            }
        } else if (symbol == Logic.SYM_LOGIC_CONTROL_FRAME_PRIORITY_QUEUE) {
            if (bl) {
                queryIterator.controlFramePriorityQueue = (ControlFramePriorityQueue)((Object)object);
            } else {
                object = queryIterator.controlFramePriorityQueue;
            }
        } else if (symbol == Logic.SYM_LOGIC_AUGMENTED_GOAL_CACHEp) {
            if (bl) {
                queryIterator.augmentedGoalCacheP = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)((BooleanWrapper)object));
            } else {
                object = queryIterator.augmentedGoalCacheP ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else if (symbol == Logic.SYM_LOGIC_ACTIVE_GOAL_CACHES) {
            if (bl) {
                queryIterator.activeGoalCaches = (List)object;
            } else {
                object = queryIterator.activeGoalCaches;
            }
        } else if (symbol == Logic.SYM_LOGIC_TRIGGERED_DEPTH_CUTOFFp) {
            if (bl) {
                queryIterator.triggeredDepthCutoffP = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)((BooleanWrapper)object));
            } else {
                object = queryIterator.triggeredDepthCutoffP ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else if (symbol == Logic.SYM_LOGIC_FAILED_TO_FIND_DUPLICATE_SUBGOALp) {
            if (bl) {
                queryIterator.failedToFindDuplicateSubgoalP = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)((BooleanWrapper)object));
            } else {
                object = queryIterator.failedToFindDuplicateSubgoalP ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else if (symbol == Logic.SYM_LOGIC_FOUND_AT_LEAST_ONE_SOLUTIONp) {
            if (bl) {
                queryIterator.foundAtLeastOneSolutionP = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)((BooleanWrapper)object));
            } else {
                object = queryIterator.foundAtLeastOneSolutionP ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else if (symbol == Logic.SYM_LOGIC_TIMESTAMP) {
            if (bl) {
                queryIterator.timestamp = ((IntegerWrapper)object).wrapperValue;
            } else {
                object = IntegerWrapper.wrapInteger((int)queryIterator.timestamp);
            }
        } else if (symbol == Logic.SYM_LOGIC_PARTIAL_MATCH_STRATEGY) {
            if (bl) {
                queryIterator.partialMatchStrategy = (PartialMatchFrame)((Object)object);
            } else {
                object = queryIterator.partialMatchStrategy;
            }
        } else if (symbol == Logic.SYM_LOGIC_RESIDUE_GOALS) {
            if (bl) {
                KeyValueList.setDynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_LOGIC_RESIDUE_GOALS, (Stella_Object)((List)object), null);
            } else {
                object = queryIterator.residueGoals();
            }
        } else if (symbol == Logic.SYM_LOGIC_BEST_GOAL_SEQUENCE) {
            if (bl) {
                KeyValueList.setDynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_LOGIC_BEST_GOAL_SEQUENCE, (Stella_Object)((List)object), null);
            } else {
                object = queryIterator.bestGoalSequence();
            }
        } else if (symbol == Logic.SYM_LOGIC_INFERENCE_LEVEL) {
            if (bl) {
                queryIterator.inferenceLevel = (InferenceLevel)((Object)object);
            } else {
                object = queryIterator.inferenceLevel;
            }
        } else if (symbol == Logic.SYM_LOGIC_CURRENT_DEPTH_CUTOFF) {
            if (bl) {
                queryIterator.currentDepthCutoff = ((IntegerWrapper)object).wrapperValue;
            } else {
                object = IntegerWrapper.wrapInteger((int)queryIterator.currentDepthCutoff);
            }
        } else if (symbol == Logic.SYM_LOGIC_MAXIMUM_DEPTH) {
            if (bl) {
                queryIterator.maximumDepth = ((IntegerWrapper)object).wrapperValue;
            } else {
                object = IntegerWrapper.wrapInteger((int)queryIterator.maximumDepth);
            }
        } else if (symbol == Logic.SYM_LOGIC_ALLOTTED_TIME) {
            if (bl) {
                queryIterator.allottedTime = ((FloatWrapper)object).wrapperValue;
            } else {
                object = FloatWrapper.wrapFloat((double)queryIterator.allottedTime);
            }
        } else if (symbol == Logic.SYM_LOGIC_ALLOTTED_CLOCK_TICKS) {
            if (bl) {
                queryIterator.allottedClockTicks = ((IntegerWrapper)object).wrapperValue;
            } else {
                object = IntegerWrapper.wrapInteger((int)queryIterator.allottedClockTicks);
            }
        } else if (symbol == Logic.SYM_LOGIC_CURRENT_CLOCK_TICKS) {
            if (bl) {
                queryIterator.currentClockTicks = ((IntegerWrapper)object).wrapperValue;
            } else {
                object = IntegerWrapper.wrapInteger((int)queryIterator.currentClockTicks);
            }
        } else if (symbol == Logic.SYM_LOGIC_TIMEOUTp) {
            if (bl) {
                queryIterator.timeoutP = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)((BooleanWrapper)object));
            } else {
                object = queryIterator.timeoutP ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else {
            if (symbol == Logic.SYM_LOGIC_NEGATED_QUERY) {
                symbol = Logic.SYM_LOGIC_AUXILIARY_QUERY;
            } else if (symbol == Logic.SYM_LOGIC_LATEST_PARTIAL_SCORE) {
                symbol = Logic.SYM_LOGIC_LATEST_POSITIVE_SCORE;
            }
            if (bl) {
                KeyValueList.setDynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)symbol, (Stella_Object)object, null);
            } else {
                object = queryIterator.dynamicSlots.lookup((Stella_Object)symbol);
            }
        }
        return object;
    }

    public BooleanWrapper badP() {
        QueryIterator queryIterator = this;
        BooleanWrapper booleanWrapper = (BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_STELLA_BADp, null);
        if (booleanWrapper == null) {
            return Stella.FALSE_WRAPPER;
        }
        return booleanWrapper;
    }

    public List bestGoalSequence() {
        QueryIterator queryIterator = this;
        List list = (List)KeyValueList.dynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_LOGIC_BEST_GOAL_SEQUENCE, null);
        if (list == null) {
            return Stella.NIL_LIST;
        }
        return list;
    }

    public List residueGoals() {
        QueryIterator queryIterator = this;
        List list = (List)KeyValueList.dynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_LOGIC_RESIDUE_GOALS, null);
        if (list == null) {
            return Stella.NIL_LIST;
        }
        return list;
    }

    public Surrogate primaryType() {
        QueryIterator queryIterator = this;
        return Logic.SGT_LOGIC_QUERY_ITERATOR;
    }
}

