/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.powerloom.logic;

import edu.isi.powerloom.logic.Logic;
import edu.isi.powerloom.logic.Proposition;
import edu.isi.powerloom.logic.twoDArray;
import edu.isi.stella.FloatWrapper;
import edu.isi.stella.KeyValueList;
import edu.isi.stella.OutputFileStream;
import edu.isi.stella.OutputStream;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.StandardObject;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.Vector;
import edu.isi.stella.Wrapper;

public class PropositionNeuralNetwork
extends StandardObject {
    public Proposition proposition;
    public Vector input;
    public Vector hidden;
    public double output;
    public Vector inputError;
    public Vector hiddenError;
    public twoDArray ih;
    public twoDArray ihDelta;
    public Vector ho;
    public Vector hoDelta;
    public twoDArray ihSlope;
    public twoDArray ihPrevSlope;
    public Vector hoSlope;
    public Vector hoPrevSlope;

    public static PropositionNeuralNetwork newPropositionNeuralNetwork() {
        PropositionNeuralNetwork propositionNeuralNetwork = null;
        propositionNeuralNetwork = new PropositionNeuralNetwork();
        propositionNeuralNetwork.hoPrevSlope = null;
        propositionNeuralNetwork.hoSlope = null;
        propositionNeuralNetwork.ihPrevSlope = null;
        propositionNeuralNetwork.ihSlope = null;
        propositionNeuralNetwork.hoDelta = null;
        propositionNeuralNetwork.ho = null;
        propositionNeuralNetwork.ihDelta = null;
        propositionNeuralNetwork.ih = null;
        propositionNeuralNetwork.hiddenError = null;
        propositionNeuralNetwork.inputError = null;
        propositionNeuralNetwork.output = Double.NEGATIVE_INFINITY;
        propositionNeuralNetwork.hidden = null;
        propositionNeuralNetwork.input = null;
        propositionNeuralNetwork.proposition = null;
        return propositionNeuralNetwork;
    }

    public static void printNeuralNetwork(PropositionNeuralNetwork propositionNeuralNetwork, OutputStream outputStream) {
        int n;
        outputStream.nativeStream.println("defnetwork ");
        Proposition.printProposition(propositionNeuralNetwork.proposition, outputStream, false);
        outputStream.nativeStream.println();
        outputStream.nativeStream.println(propositionNeuralNetwork.input.length() + " " + propositionNeuralNetwork.hidden.length());
        int n2 = Integer.MIN_VALUE;
        int n3 = propositionNeuralNetwork.input.length() - 1;
        for (int i = 0; i <= n3; ++i) {
            n2 = i;
            n = Integer.MIN_VALUE;
            int n4 = 0;
            int n5 = propositionNeuralNetwork.hidden.length() - 1;
            while (n4 <= n5) {
                n = n4++;
                double d = ((FloatWrapper)propositionNeuralNetwork.ih.theArray[n2 * propositionNeuralNetwork.ih.nofColumns + n]).wrapperValue;
                outputStream.nativeStream.print(" " + d);
            }
        }
        outputStream.nativeStream.println();
        FloatWrapper floatWrapper = null;
        Vector vector = propositionNeuralNetwork.ho;
        n = vector.length();
        for (n3 = 0; n3 < n; ++n3) {
            floatWrapper = (FloatWrapper)vector.theArray[n3];
            double d = floatWrapper.wrapperValue;
            outputStream.nativeStream.print(" " + d);
        }
        outputStream.nativeStream.println();
    }

    public static void saveNeuralNetwork(PropositionNeuralNetwork propositionNeuralNetwork, String string) {
        OutputFileStream outputFileStream = OutputFileStream.newOutputFileStream((String)string);
        PropositionNeuralNetwork.printNeuralNetwork(propositionNeuralNetwork, (OutputStream)outputFileStream);
        outputFileStream.free();
    }

    public static double activatePropositionalNeuralNetwork(PropositionNeuralNetwork propositionNeuralNetwork) {
        int n;
        int n2;
        int n3 = propositionNeuralNetwork.input.length();
        int n4 = propositionNeuralNetwork.hidden.length();
        Vector vector = propositionNeuralNetwork.proposition.arguments;
        int n5 = n3 - 1;
        Vector vector2 = propositionNeuralNetwork.input;
        Vector vector3 = propositionNeuralNetwork.hidden;
        twoDArray twoDArray2 = propositionNeuralNetwork.ih;
        Vector vector4 = propositionNeuralNetwork.ho;
        double d = 0.0;
        double d2 = 0.0;
        Logic.$ACTIVATED_NETWORKS$.push((Stella_Object)propositionNeuralNetwork);
        propositionNeuralNetwork.input.theArray[0] = FloatWrapper.wrapFloat((double)1.0);
        int n6 = Integer.MIN_VALUE;
        int n7 = n5;
        int n8 = n2 = n7 == Integer.MIN_VALUE ? 1 : 0;
        for (n = 1; n2 != 0 || n <= n7; ++n) {
            n6 = n;
            vector2.theArray[n6] = ((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)((Proposition)vector.theArray[n6 - 1]).dynamicSlots, (Symbol)Logic.SYM_LOGIC_MATCH_SCORE, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue != Double.NEGATIVE_INFINITY ? FloatWrapper.wrapFloat((double)((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)((Proposition)vector.theArray[n6 - 1]).dynamicSlots, (Symbol)Logic.SYM_LOGIC_MATCH_SCORE, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue) : FloatWrapper.wrapFloat((double)0.0);
        }
        n6 = Integer.MIN_VALUE;
        n7 = n4 - 1;
        for (n = 0; n <= n7; ++n) {
            boolean bl;
            n6 = n;
            n2 = Integer.MIN_VALUE;
            int n9 = 0;
            int n10 = n5;
            boolean bl2 = bl = n10 == Integer.MIN_VALUE;
            while (bl || n9 <= n10) {
                n2 = n9++;
                d2 += ((FloatWrapper)vector2.theArray[n2]).wrapperValue * ((FloatWrapper)twoDArray2.theArray[n2 * twoDArray2.nofColumns + n6]).wrapperValue;
            }
            vector3.theArray[n6] = FloatWrapper.wrapFloat((double)(1.0 / (1.0 + Math.exp(0.0 - d2))));
            d += ((FloatWrapper)vector3.theArray[n6]).wrapperValue * ((FloatWrapper)vector4.theArray[n6]).wrapperValue;
        }
        if (1.0 + Math.exp(0.0 - d) == 0.0) {
            System.out.println("Sum is " + d);
        }
        propositionNeuralNetwork.output = 1.0 / (1.0 + Math.exp(0.0 - d));
        KeyValueList.setDynamicSlotValue((KeyValueList)propositionNeuralNetwork.proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MATCH_SCORE, (Stella_Object)FloatWrapper.wrapFloat((double)propositionNeuralNetwork.output), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
        return propositionNeuralNetwork.output;
    }

    public static void randomizeNeuralNetwork(PropositionNeuralNetwork propositionNeuralNetwork) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = propositionNeuralNetwork.input.length();
        int n6 = propositionNeuralNetwork.hidden.length();
        int n7 = Integer.MIN_VALUE;
        int n8 = n6 - 1;
        for (n4 = 0; n4 <= n8; ++n4) {
            n7 = n4;
            propositionNeuralNetwork.hoDelta.theArray[n7] = FloatWrapper.wrapFloat((double)0.0);
            n3 = Integer.MIN_VALUE;
            n2 = 0;
            n = n5 - 1;
            while (n2 <= n) {
                n3 = n2++;
                propositionNeuralNetwork.ihDelta.theArray[n3 * propositionNeuralNetwork.ihDelta.nofColumns + n7] = FloatWrapper.wrapFloat((double)0.0);
            }
        }
        n7 = Integer.MIN_VALUE;
        n8 = n6 - 1;
        for (n4 = 0; n4 <= n8; ++n4) {
            n7 = n4;
            n3 = Integer.MIN_VALUE;
            n2 = 0;
            n = n5 - 1;
            while (n2 <= n) {
                n3 = n2++;
                propositionNeuralNetwork.ih.theArray[n3 * propositionNeuralNetwork.ih.nofColumns + n7] = FloatWrapper.wrapFloat((double)Logic.randomWeight(Logic.$WEIGHT_RANGE$));
            }
            propositionNeuralNetwork.ho.theArray[n7] = FloatWrapper.wrapFloat((double)Logic.randomWeight(Logic.$WEIGHT_RANGE$));
        }
    }

    public static void clearSlopes(PropositionNeuralNetwork propositionNeuralNetwork) {
        int n = Integer.MIN_VALUE;
        int n2 = propositionNeuralNetwork.hidden.length() - 1;
        for (int i = 0; i <= n2; ++i) {
            n = i;
            int n3 = Integer.MIN_VALUE;
            int n4 = 0;
            int n5 = propositionNeuralNetwork.input.length() - 1;
            while (n4 <= n5) {
                n3 = n4++;
                propositionNeuralNetwork.ihPrevSlope.theArray[n3 * propositionNeuralNetwork.ihPrevSlope.nofColumns + n] = (FloatWrapper)propositionNeuralNetwork.ihSlope.theArray[n3 * propositionNeuralNetwork.ihSlope.nofColumns + n];
                propositionNeuralNetwork.ihSlope.theArray[n3 * propositionNeuralNetwork.ihSlope.nofColumns + n] = FloatWrapper.wrapFloat((double)(((FloatWrapper)propositionNeuralNetwork.ih.theArray[n3 * propositionNeuralNetwork.ih.nofColumns + n]).wrapperValue * Logic.$WEIGHT_DECAY$));
            }
            propositionNeuralNetwork.hoPrevSlope.theArray[n] = (FloatWrapper)propositionNeuralNetwork.hoSlope.theArray[n];
            propositionNeuralNetwork.hoSlope.theArray[n] = FloatWrapper.wrapFloat((double)(((FloatWrapper)propositionNeuralNetwork.ho.theArray[n]).wrapperValue * Logic.$WEIGHT_DECAY$));
        }
    }

    public static Stella_Object accessPropositionNeuralNetworkSlotValue(PropositionNeuralNetwork propositionNeuralNetwork, Symbol symbol, Stella_Object object, boolean bl) {
        if (symbol == Logic.SYM_LOGIC_PROPOSITION) {
            if (bl) {
                propositionNeuralNetwork.proposition = (Proposition)((Object)object);
            } else {
                object = propositionNeuralNetwork.proposition;
            }
        } else if (symbol == Logic.SYM_LOGIC_INPUT) {
            if (bl) {
                propositionNeuralNetwork.input = (Vector)object;
            } else {
                object = propositionNeuralNetwork.input;
            }
        } else if (symbol == Logic.SYM_LOGIC_HIDDEN) {
            if (bl) {
                propositionNeuralNetwork.hidden = (Vector)object;
            } else {
                object = propositionNeuralNetwork.hidden;
            }
        } else if (symbol == Logic.SYM_LOGIC_OUTPUT) {
            if (bl) {
                propositionNeuralNetwork.output = ((FloatWrapper)object).wrapperValue;
            } else {
                object = FloatWrapper.wrapFloat((double)propositionNeuralNetwork.output);
            }
        } else if (symbol == Logic.SYM_LOGIC_INPUT_ERROR) {
            if (bl) {
                propositionNeuralNetwork.inputError = (Vector)object;
            } else {
                object = propositionNeuralNetwork.inputError;
            }
        } else if (symbol == Logic.SYM_LOGIC_HIDDEN_ERROR) {
            if (bl) {
                propositionNeuralNetwork.hiddenError = (Vector)object;
            } else {
                object = propositionNeuralNetwork.hiddenError;
            }
        } else if (symbol == Logic.SYM_LOGIC_IH) {
            if (bl) {
                propositionNeuralNetwork.ih = (twoDArray)((Object)object);
            } else {
                object = propositionNeuralNetwork.ih;
            }
        } else if (symbol == Logic.SYM_LOGIC_IH_DELTA) {
            if (bl) {
                propositionNeuralNetwork.ihDelta = (twoDArray)((Object)object);
            } else {
                object = propositionNeuralNetwork.ihDelta;
            }
        } else if (symbol == Logic.SYM_LOGIC_HO) {
            if (bl) {
                propositionNeuralNetwork.ho = (Vector)object;
            } else {
                object = propositionNeuralNetwork.ho;
            }
        } else if (symbol == Logic.SYM_LOGIC_HO_DELTA) {
            if (bl) {
                propositionNeuralNetwork.hoDelta = (Vector)object;
            } else {
                object = propositionNeuralNetwork.hoDelta;
            }
        } else if (symbol == Logic.SYM_LOGIC_IH_SLOPE) {
            if (bl) {
                propositionNeuralNetwork.ihSlope = (twoDArray)((Object)object);
            } else {
                object = propositionNeuralNetwork.ihSlope;
            }
        } else if (symbol == Logic.SYM_LOGIC_IH_PREV_SLOPE) {
            if (bl) {
                propositionNeuralNetwork.ihPrevSlope = (twoDArray)((Object)object);
            } else {
                object = propositionNeuralNetwork.ihPrevSlope;
            }
        } else if (symbol == Logic.SYM_LOGIC_HO_SLOPE) {
            if (bl) {
                propositionNeuralNetwork.hoSlope = (Vector)object;
            } else {
                object = propositionNeuralNetwork.hoSlope;
            }
        } else if (symbol == Logic.SYM_LOGIC_HO_PREV_SLOPE) {
            if (bl) {
                propositionNeuralNetwork.hoPrevSlope = (Vector)object;
            } else {
                object = propositionNeuralNetwork.hoPrevSlope;
            }
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + symbol + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        return object;
    }

    public Surrogate primaryType() {
        PropositionNeuralNetwork propositionNeuralNetwork = this;
        return Logic.SGT_LOGIC_PROPOSITION_NEURAL_NETWORK;
    }
}

