/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.powerloom.logic;

import edu.isi.powerloom.logic.AtomicGoalCache;
import edu.isi.powerloom.logic.ControlFrame;
import edu.isi.powerloom.logic.Justification;
import edu.isi.powerloom.logic.Logic;
import edu.isi.powerloom.logic.Proposition;
import edu.isi.powerloom.logic.QueryIterator;
import edu.isi.powerloom.logic.TruthValue;
import edu.isi.stella.BooleanWrapper;
import edu.isi.stella.Cons;
import edu.isi.stella.FloatWrapper;
import edu.isi.stella.KeyValueList;
import edu.isi.stella.Keyword;
import edu.isi.stella.OutputStream;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.StandardObject;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.Wrapper;

public abstract class PartialMatchFrame
extends StandardObject {
    public Keyword kind;
    public ControlFrame controlFrame;
    public PartialMatchFrame parent;
    public PartialMatchFrame child;
    public double positiveScore;
    public double negativeScore;
    public double dynamicCutoff;
    public Cons argumentScores;
    public Cons argumentWeights;
    public Cons unboundVars;
    public boolean successP;

    public double computePartialTruth(QueryIterator queryIterator) {
        PartialMatchFrame partialMatchFrame = this;
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("Don't know how to compute partial truth for `" + (Object)((Object)partialMatchFrame) + "'");
        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    public QueryIterator retrievePartialSolutions(QueryIterator queryIterator) {
        PartialMatchFrame partialMatchFrame = this;
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("Don't know how to retrieve partial solutions for `" + (Object)((Object)partialMatchFrame) + "'");
        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    public void initializePartialMatchStrategy(QueryIterator queryIterator) {
        PartialMatchFrame partialMatchFrame = this;
        FloatWrapper floatWrapper = (FloatWrapper)queryIterator.options.lookup((Stella_Object)Logic.KWD_MINIMUM_SCORE);
        double d = 0.001;
        queryIterator.partialMatchStrategy = partialMatchFrame;
        partialMatchFrame.dynamicCutoff = floatWrapper != null ? floatWrapper.wrapperValue : d;
        KeyValueList.setDynamicSlotValue((KeyValueList)queryIterator.dynamicSlots, (Symbol)Logic.SYM_LOGIC_LATEST_POSITIVE_SCORE, (Stella_Object)FloatWrapper.wrapFloat((double)0.0), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
    }

    public boolean earlyPartialMatchOrSuccessP() {
        PartialMatchFrame partialMatchFrame = this;
        return false;
    }

    public boolean earlyPartialMatchAndFailureP() {
        PartialMatchFrame partialMatchFrame = this;
        return false;
    }

    public void popPartialMatchScore() {
        PartialMatchFrame partialMatchFrame = this;
    }

    public void recordPartialMatchScore(double d, double d2) {
        PartialMatchFrame partialMatchFrame = this;
    }

    public void setBasePartialMatchTruth(Proposition proposition, Keyword keyword) {
        PartialMatchFrame partialMatchFrame = this;
        if (keyword == Logic.KWD_TRUE) {
            KeyValueList.setDynamicSlotValue((KeyValueList)((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).dynamicSlots, (Symbol)Logic.SYM_LOGIC_LATEST_POSITIVE_SCORE, (Stella_Object)FloatWrapper.wrapFloat((double)1.0), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
        } else if (keyword == Logic.KWD_FAIL) {
            KeyValueList.setDynamicSlotValue((KeyValueList)((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).dynamicSlots, (Symbol)Logic.SYM_LOGIC_LATEST_POSITIVE_SCORE, (Stella_Object)FloatWrapper.wrapFloat((double)0.0), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
    }

    public Keyword continuePartialAntecedentsProof(Keyword keyword) {
        PartialMatchFrame partialMatchFrame = this;
        return ControlFrame.continueAntecedentsProof(partialMatchFrame.controlFrame, keyword);
    }

    public Keyword continuePartialStrategiesProofs(Keyword keyword) {
        PartialMatchFrame partialMatchFrame = this;
        return ControlFrame.oldInterpretGoalScores(partialMatchFrame.controlFrame, keyword);
    }

    public double computeGoalScore() {
        PartialMatchFrame partialMatchFrame = this;
        return Double.NEGATIVE_INFINITY;
    }

    public Keyword continuePartialFailProof(Keyword keyword) {
        PartialMatchFrame partialMatchFrame = this;
        keyword = ControlFrame.oldInterpretFailScore(partialMatchFrame.controlFrame, keyword);
        return ControlFrame.continueFailProof(partialMatchFrame.controlFrame, keyword);
    }

    public Keyword continuePartialNotProof(Keyword keyword) {
        PartialMatchFrame partialMatchFrame = this;
        return ControlFrame.continueNotProof(partialMatchFrame.controlFrame, keyword);
    }

    public double computeNotScore() {
        PartialMatchFrame partialMatchFrame = this;
        return Double.NEGATIVE_INFINITY;
    }

    public Keyword continuePartialOrProof(Keyword keyword) {
        PartialMatchFrame partialMatchFrame = this;
        keyword = ControlFrame.oldInterpretOrScores(partialMatchFrame.controlFrame, keyword);
        return ControlFrame.continueOrProof(partialMatchFrame.controlFrame, keyword);
    }

    public double computeOrScore() {
        PartialMatchFrame partialMatchFrame = this;
        return Double.NEGATIVE_INFINITY;
    }

    public Keyword continuePartialAndProof(ControlFrame controlFrame, Keyword keyword) {
        PartialMatchFrame partialMatchFrame = this;
        keyword = ControlFrame.oldInterpretAndScores(controlFrame, keyword);
        return ControlFrame.continueAndProof(controlFrame, keyword);
    }

    public double computeAndScore() {
        PartialMatchFrame partialMatchFrame = this;
        return Double.NEGATIVE_INFINITY;
    }

    public boolean allowUnboundVariablesP() {
        PartialMatchFrame partialMatchFrame = this;
        return false;
    }

    public void setJustificationPartialTruth(Justification justification) {
        PartialMatchFrame partialMatchFrame = this;
        justification.positiveScore = partialMatchFrame.positiveScore;
        justification.negativeScore = partialMatchFrame.negativeScore;
    }

    public void setCachePartialTruth(AtomicGoalCache atomicGoalCache) {
        PartialMatchFrame partialMatchFrame = this;
        atomicGoalCache.positiveScore = partialMatchFrame.positiveScore;
        atomicGoalCache.negativeScore = partialMatchFrame.negativeScore;
    }

    public void traceFramePartialTruth(Keyword keyword, OutputStream outputStream) {
        PartialMatchFrame partialMatchFrame = this;
        double d = partialMatchFrame.propositionWeight(partialMatchFrame.controlFrame.proposition);
        if (keyword == Logic.KWD_DOWN) {
            double d2 = partialMatchFrame.computeDynamicCutoff();
            if (d2 != Double.NEGATIVE_INFINITY) {
                outputStream.nativeStream.print("cutoff=" + d2);
            }
        } else if (keyword == Logic.KWD_UP_TRUE || keyword == Logic.KWD_UP_FAIL) {
            double d3 = partialMatchFrame.positiveScore;
            outputStream.nativeStream.print("score=" + d3);
            if (d != Double.NEGATIVE_INFINITY && d != 1.0) {
                outputStream.nativeStream.print(" weight=" + d);
            }
        }
    }

    public void propagateFramePartialTruth(ControlFrame controlFrame) {
        boolean bl;
        PartialMatchFrame partialMatchFrame = this;
        PartialMatchFrame partialMatchFrame2 = controlFrame.partialMatchFrame;
        boolean bl2 = bl = partialMatchFrame.controlFrame.reversePolarityP != controlFrame.reversePolarityP;
        if (partialMatchFrame2 == null) {
            if (bl) {
                partialMatchFrame2 = (PartialMatchFrame)Surrogate.createObject((Surrogate)partialMatchFrame.primaryType(), (Cons)Stella_Object.cons((Stella_Object)Logic.KWD_CONTROL_FRAME, (Cons)Stella_Object.cons((Stella_Object)controlFrame, (Cons)Stella_Object.cons((Stella_Object)Logic.KWD_KIND, (Cons)Stella_Object.cons((Stella_Object)controlFrame.state, (Cons)Stella.NIL)))));
                partialMatchFrame2.parent = partialMatchFrame.parent;
                partialMatchFrame2.child = partialMatchFrame;
            } else {
                partialMatchFrame2 = partialMatchFrame;
            }
            controlFrame.partialMatchFrame = partialMatchFrame2;
        }
        if (bl) {
            partialMatchFrame2.positiveScore = 0.0 - partialMatchFrame.positiveScore;
            partialMatchFrame2.negativeScore = partialMatchFrame.positiveScore;
        } else {
            partialMatchFrame2.positiveScore = partialMatchFrame.positiveScore;
            partialMatchFrame2.negativeScore = partialMatchFrame.negativeScore;
        }
        KeyValueList.setDynamicSlotValue((KeyValueList)((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).dynamicSlots, (Symbol)Logic.SYM_LOGIC_LATEST_POSITIVE_SCORE, (Stella_Object)FloatWrapper.wrapFloat((double)partialMatchFrame2.positiveScore), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
    }

    public void setFramePartialTruth(TruthValue truthValue, double d, double d2, boolean bl) {
        boolean bl2;
        PartialMatchFrame partialMatchFrame = this;
        boolean bl3 = bl2 = partialMatchFrame.controlFrame.reversePolarityP && !bl;
        if (d == Double.NEGATIVE_INFINITY && truthValue != null) {
            d = truthValue.positiveScore;
        }
        if (d2 == Double.NEGATIVE_INFINITY && truthValue != null) {
            d2 = TruthValue.invertTruthValue((TruthValue)truthValue).positiveScore;
        }
        if (bl2) {
            double d3 = d;
            d = 0.0 - d;
            d2 = d3;
        }
        partialMatchFrame.positiveScore = d;
        partialMatchFrame.negativeScore = d2;
        KeyValueList.setDynamicSlotValue((KeyValueList)((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).dynamicSlots, (Symbol)Logic.SYM_LOGIC_LATEST_POSITIVE_SCORE, (Stella_Object)FloatWrapper.wrapFloat((double)d), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
    }

    public boolean definedFramePartialTruthP() {
        PartialMatchFrame partialMatchFrame = this;
        return partialMatchFrame.positiveScore != Double.NEGATIVE_INFINITY || partialMatchFrame.negativeScore != Double.NEGATIVE_INFINITY;
    }

    public void clearFramePartialTruth() {
        PartialMatchFrame partialMatchFrame = this;
        partialMatchFrame.positiveScore = Double.NEGATIVE_INFINITY;
        partialMatchFrame.negativeScore = Double.NEGATIVE_INFINITY;
    }

    public double propositionWeight(Proposition proposition) {
        PartialMatchFrame partialMatchFrame = this;
        if (proposition != null) {
            double d = ((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_WEIGHT, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue;
            if (d == Double.NEGATIVE_INFINITY) {
                return 1.0;
            }
            return d;
        }
        return 1.0;
    }

    public boolean cutoffPartialMatchP(boolean bl) {
        PartialMatchFrame partialMatchFrame = this;
        double d = partialMatchFrame.positiveScore;
        double d2 = partialMatchFrame.dynamicCutoff;
        boolean bl2 = false;
        if (d == Double.NEGATIVE_INFINITY || d2 == Double.NEGATIVE_INFINITY || d2 == 0.0) {
            bl2 = false;
        } else if (d2 < 0.0) {
            bl2 = d > d2;
        } else {
            boolean bl3 = bl2 = d < d2;
        }
        if (bl2 && bl) {
            System.out.println("*** Cutting off search, cutoff=" + d2);
        }
        return bl2;
    }

    public void setDynamicCutoff() {
        PartialMatchFrame partialMatchFrame = this;
        double d = partialMatchFrame.computeDynamicCutoff();
        if (d != Double.NEGATIVE_INFINITY) {
            if (d < -100.0 || d > 100.0) {
                Stella.STANDARD_WARNING.nativeStream.println("Warning: *** fishy dynamic cutoff=`" + d + "' computed, resetting to 0.0");
                d = 0.0;
            }
            partialMatchFrame.dynamicCutoff = d;
        }
    }

    public double computeDynamicCutoff() {
        PartialMatchFrame partialMatchFrame = this;
        return Double.NEGATIVE_INFINITY;
    }

    public PartialMatchFrame createPartialMatchFrame(ControlFrame controlFrame, Keyword keyword) {
        PartialMatchFrame partialMatchFrame = this;
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.println("Missing concrete method named 'create-partial-match-frame' on the");
        outputStringStream.nativeStream.print("   class `" + partialMatchFrame.primaryType() + "'");
        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    public static void linkToParentPartialMatchFrame(PartialMatchFrame partialMatchFrame) {
        ControlFrame controlFrame = partialMatchFrame.controlFrame.up;
        while (controlFrame != null && controlFrame.partialMatchFrame == null) {
            controlFrame = controlFrame.up;
        }
        if (controlFrame != null) {
            partialMatchFrame.parent = controlFrame.partialMatchFrame;
            controlFrame.partialMatchFrame.child = partialMatchFrame;
        }
    }

    public static Stella_Object accessPartialMatchFrameSlotValue(PartialMatchFrame partialMatchFrame, Symbol symbol, Stella_Object object, boolean bl) {
        if (symbol == Logic.SYM_LOGIC_KIND) {
            if (bl) {
                partialMatchFrame.kind = (Keyword)object;
            } else {
                object = partialMatchFrame.kind;
            }
        } else if (symbol == Logic.SYM_LOGIC_CONTROL_FRAME) {
            if (bl) {
                partialMatchFrame.controlFrame = (ControlFrame)((Object)object);
            } else {
                object = partialMatchFrame.controlFrame;
            }
        } else if (symbol == Logic.SYM_LOGIC_PARENT) {
            if (bl) {
                partialMatchFrame.parent = (PartialMatchFrame)((Object)object);
            } else {
                object = partialMatchFrame.parent;
            }
        } else if (symbol == Logic.SYM_LOGIC_CHILD) {
            if (bl) {
                partialMatchFrame.child = (PartialMatchFrame)((Object)object);
            } else {
                object = partialMatchFrame.child;
            }
        } else if (symbol == Logic.SYM_LOGIC_POSITIVE_SCORE) {
            if (bl) {
                partialMatchFrame.positiveScore = ((FloatWrapper)object).wrapperValue;
            } else {
                object = FloatWrapper.wrapFloat((double)partialMatchFrame.positiveScore);
            }
        } else if (symbol == Logic.SYM_LOGIC_NEGATIVE_SCORE) {
            if (bl) {
                partialMatchFrame.negativeScore = ((FloatWrapper)object).wrapperValue;
            } else {
                object = FloatWrapper.wrapFloat((double)partialMatchFrame.negativeScore);
            }
        } else if (symbol == Logic.SYM_LOGIC_DYNAMIC_CUTOFF) {
            if (bl) {
                partialMatchFrame.dynamicCutoff = ((FloatWrapper)object).wrapperValue;
            } else {
                object = FloatWrapper.wrapFloat((double)partialMatchFrame.dynamicCutoff);
            }
        } else if (symbol == Logic.SYM_LOGIC_ARGUMENT_SCORES) {
            if (bl) {
                partialMatchFrame.argumentScores = (Cons)object;
            } else {
                object = partialMatchFrame.argumentScores;
            }
        } else if (symbol == Logic.SYM_LOGIC_ARGUMENT_WEIGHTS) {
            if (bl) {
                partialMatchFrame.argumentWeights = (Cons)object;
            } else {
                object = partialMatchFrame.argumentWeights;
            }
        } else if (symbol == Logic.SYM_LOGIC_UNBOUND_VARS) {
            if (bl) {
                partialMatchFrame.unboundVars = (Cons)object;
            } else {
                object = partialMatchFrame.unboundVars;
            }
        } else if (symbol == Logic.SYM_LOGIC_SUCCESSp) {
            if (bl) {
                partialMatchFrame.successP = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)((BooleanWrapper)object));
            } else {
                object = partialMatchFrame.successP ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + symbol + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        return object;
    }
}

