/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.powerloom.logic;

import edu.isi.powerloom.logic.Description;
import edu.isi.powerloom.logic.ExplanationInfo;
import edu.isi.powerloom.logic.Logic;
import edu.isi.powerloom.logic.NamedDescription;
import edu.isi.powerloom.logic.PatternVariable;
import edu.isi.powerloom.logic.PrimitiveStrategy;
import edu.isi.powerloom.logic.Proposition;
import edu.isi.powerloom.logic.QueryIterator;
import edu.isi.powerloom.logic.TruthValue;
import edu.isi.stella.BooleanWrapper;
import edu.isi.stella.Cons;
import edu.isi.stella.ContextSensitiveObject;
import edu.isi.stella.FloatWrapper;
import edu.isi.stella.KeyValueList;
import edu.isi.stella.Keyword;
import edu.isi.stella.KvCons;
import edu.isi.stella.List;
import edu.isi.stella.OutputStream;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.PropertyList;
import edu.isi.stella.StandardObject;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.Vector;
import edu.isi.stella.javalib.Native;
import java.io.PrintStream;

public class Justification
extends StandardObject {
    public Keyword inferenceRule;
    public Proposition proposition;
    public Cons antecedents;
    public Justification patternJustification;
    public KeyValueList substitution;
    public boolean reversePolarityP;
    public TruthValue truthValue;
    public double positiveScore;
    public double negativeScore;

    public static Justification newJustification() {
        Justification justification = null;
        justification = new Justification();
        justification.negativeScore = Double.NEGATIVE_INFINITY;
        justification.positiveScore = Double.NEGATIVE_INFINITY;
        justification.truthValue = null;
        justification.reversePolarityP = false;
        justification.substitution = null;
        justification.patternJustification = null;
        justification.antecedents = Stella.NIL;
        justification.proposition = null;
        justification.inferenceRule = null;
        return justification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printWhynotJustification(Justification justification, OutputStream outputStream, int n, Keyword keyword, boolean bl) {
        Object object = Logic.$EXPLANATION_STYLE$.get();
        try {
            Native.setSpecial((ThreadLocal)Logic.$EXPLANATION_STYLE$, (Object)(keyword != null ? keyword : Logic.KWD_BRIEF));
            if (justification == null) {
                if (Logic.$MOST_RECENT_QUERY$ != null) {
                    Logic.prettyPrintLogicalForm((Stella_Object)Logic.$MOST_RECENT_QUERY$.currentPatternRecord.description.proposition, outputStream);
                    outputStream.nativeStream.println();
                    outputStream.nativeStream.println("  " + Logic.lookupExplanationPhrase(Logic.KWD_NOT_ASSERTED, Stella.NIL, null) + " and ");
                    outputStream.nativeStream.println("  " + Logic.lookupExplanationPhrase(Logic.KWD_NO_RULES, Stella.NIL, null) + ".");
                }
            } else if (bl) {
                List list = List.newList();
                Justification.collectFailedGoals(justification, list);
                outputStream.nativeStream.println("The query failed, because");
                Justification justification2 = null;
                Cons cons = list.theConsList;
                int n2 = Integer.MIN_VALUE;
                int n3 = 1;
                while (cons != Stella.NIL) {
                    justification2 = (Justification)cons.value;
                    n2 = n3;
                    if (n2 == 1) {
                        outputStream.nativeStream.print("    ");
                    } else {
                        outputStream.nativeStream.print("and ");
                    }
                    Justification.printJustificationProposition(justification2, outputStream, 4);
                    outputStream.nativeStream.println();
                    cons = cons.rest;
                    ++n3;
                }
                outputStream.nativeStream.println("failed.");
                outputStream.nativeStream.println();
            } else {
                Justification.printExplanation(justification, outputStream, (KeyValueList)Logic.$MOST_RECENT_EXPLANATION_MAPPING$.get(), n, (Keyword)Logic.$EXPLANATION_AUDIENCE$.get());
            }
        }
        finally {
            Logic.$EXPLANATION_STYLE$.set(object);
        }
    }

    public static void collectFailedGoals(Justification justification, List list) {
        Object object;
        Object object2;
        if (justification.inferenceRule == Logic.KWD_AND_INTRODUCTION) {
            object2 = List.newList();
            object = null;
            Cons cons = justification.antecedents;
            while (cons != Stella.NIL) {
                object = (Justification)cons.value;
                if (Justification.failedGoalJustificationP((Justification)((Object)object))) {
                    Stella_Object stella_Object = null;
                    Vector vector = object.proposition.arguments;
                    int n = vector.length();
                    for (int i = 0; i < n; ++i) {
                        stella_Object = vector.theArray[i];
                        if (!Logic.alternativeBindingsSetP(Logic.justificationArgumentBoundTo(stella_Object, (Justification)((Object)object)))) continue;
                        object2.insertNew((Stella_Object)((PatternVariable)stella_Object));
                    }
                }
                cons = cons.rest;
            }
            if (object2.nonEmptyP()) {
                object = null;
                cons = justification.antecedents;
                while (cons != Stella.NIL) {
                    object = (Justification)cons.value;
                    boolean bl = false;
                    if (Justification.failedGoalJustificationP((Justification)((Object)object))) {
                        bl = true;
                    } else {
                        boolean bl2 = false;
                        Stella_Object stella_Object = null;
                        Vector vector = object.proposition.arguments;
                        int n = vector.length();
                        for (int i = 0; i < n; ++i) {
                            stella_Object = vector.theArray[i];
                            if (!object2.memberP(stella_Object)) continue;
                            bl2 = true;
                            break;
                        }
                        bl = bl2;
                    }
                    if (bl) {
                        list.insert((Stella_Object)object);
                    } else {
                        Justification.collectFailedGoals((Justification)((Object)object), list);
                    }
                    cons = cons.rest;
                }
                return;
            }
        }
        if (Justification.failedGoalJustificationP(justification)) {
            list.insertNew((Stella_Object)justification);
        } else {
            object2 = null;
            object = justification.antecedents;
            while (object != Stella.NIL) {
                object2 = (Justification)object.value;
                Justification.collectFailedGoals((Justification)((Object)object2), list);
                object = object.rest;
            }
        }
    }

    public static Cons retrievalProofSolution(Justification justification, QueryIterator queryIterator) {
        Cons cons = Stella.NIL;
        KeyValueList keyValueList = justification.substitution;
        PatternVariable patternVariable = null;
        Vector vector = queryIterator.externalVariables;
        int n = vector.length();
        block0: for (int i = 0; i < n; ++i) {
            patternVariable = (PatternVariable)vector.theArray[i];
            PatternVariable patternVariable2 = null;
            Stella_Object stella_Object = null;
            KvCons kvCons = keyValueList.theKvList;
            while (kvCons != null) {
                patternVariable2 = (PatternVariable)kvCons.key;
                stella_Object = kvCons.value;
                if (patternVariable2.skolemName == patternVariable.skolemName) {
                    cons = Stella_Object.cons((Stella_Object)stella_Object, (Cons)cons);
                    continue block0;
                }
                kvCons = kvCons.rest;
            }
        }
        return cons.reverse();
    }

    public static int computeProofDeviation(Justification justification, Justification justification2, int n, KeyValueList keyValueList) {
        if (keyValueList == null) {
            keyValueList = KeyValueList.newKeyValueList();
        }
        int n2 = 0;
        int n3 = 0;
        if (justification.inferenceRule == justification2.inferenceRule && justification.inferenceStrategy() == justification2.inferenceStrategy() && justification.truthValue == justification2.truthValue && justification.reversePolarityP == justification2.reversePolarityP && justification.positiveScore == justification2.positiveScore && justification.negativeScore == justification2.negativeScore && Proposition.equivalentPropositionsP(justification.proposition, justification2.proposition, null)) {
            Object object;
            Object object2;
            Cons cons;
            Object object3;
            if (justification.inferenceRule == Logic.KWD_PATTERN) {
                object3 = null;
                cons = null;
                object2 = justification.substitution.theKvList;
                object = null;
                Stella_Object stella_Object = null;
                KvCons kvCons = justification2.substitution.theKvList;
                while (object2 != null && kvCons != null) {
                    object3 = (PatternVariable)object2.key;
                    cons = object2.value;
                    object = (PatternVariable)kvCons.key;
                    stella_Object = kvCons.value;
                    if (object3 != object) {
                        keyValueList.clear();
                        return Integer.MIN_VALUE;
                    }
                    if (!Stella_Object.eqlP((Stella_Object)cons, (Stella_Object)stella_Object)) {
                        ++n2;
                    }
                    if (n2 > n) {
                        keyValueList.clear();
                        return Integer.MIN_VALUE;
                    }
                    object2 = object2.rest;
                    kvCons = kvCons.rest;
                }
                if (n2 > 0) {
                    keyValueList.insertAt((Stella_Object)justification, (Stella_Object)justification2);
                }
            }
            object3 = null;
            cons = justification.antecedents;
            object2 = null;
            object = justification2.antecedents;
            while (cons != Stella.NIL && object != Stella.NIL) {
                object3 = (Justification)cons.value;
                object2 = (Justification)object.value;
                n3 = Justification.computeProofDeviation(object3, (Justification)((Object)object2), n - n2, keyValueList);
                if (n3 == Integer.MIN_VALUE) {
                    keyValueList.clear();
                    return Integer.MIN_VALUE;
                }
                n2 += n3;
                cons = cons.rest;
                object = object.rest;
            }
            return n2;
        }
        return Integer.MIN_VALUE;
    }

    public static boolean betterWhynotProofP(Justification justification, Justification justification2) {
        return justification.positiveScore > justification2.positiveScore;
    }

    public static int computeNumberOfFailedSubgoals(Justification justification) {
        List list = null;
        if (justification != null) {
            list = List.newList();
            Justification.collectFailedGoals(justification, list);
            return list.length();
        }
        return 0;
    }

    public static void collectVisibleAntecedents(Justification justification, List list) {
        Cons cons = justification.antecedents;
        Justification justification2 = null;
        Cons cons2 = cons;
        while (cons2 != Stella.NIL) {
            justification2 = (Justification)cons2.value;
            justification2 = Justification.visibleJustification(justification2);
            Keyword keyword = justification2.inferenceRule;
            if (keyword == Logic.KWD_AND_INTRODUCTION) {
                if ((Keyword)Logic.$EXPLANATION_STYLE$.get() == Logic.KWD_BRIEF) {
                    Justification justification3 = null;
                    Cons cons3 = Justification.visibleAntecedents((Justification)justification2).theConsList;
                    while (cons3 != Stella.NIL) {
                        justification3 = (Justification)cons3.value;
                        list.push((Stella_Object)justification3);
                        cons3 = cons3.rest;
                    }
                } else {
                    list.push((Stella_Object)justification2);
                }
            } else if (keyword == Logic.KWD_PRIMITIVE_STRATEGY) {
                if (((PrimitiveStrategy)justification2).strategy == Logic.KWD_EQUIVALENCE) {
                    if (!Proposition.auxiliaryEquivalencePropositionP(justification2.proposition)) {
                        list.push((Stella_Object)justification2);
                    }
                } else {
                    list.push((Stella_Object)justification2);
                }
            } else {
                list.push((Stella_Object)justification2);
            }
            cons2 = cons2.rest;
        }
    }

    public static List visibleAntecedents(Justification justification) {
        List list = List.newList();
        Justification.collectVisibleAntecedents(justification, list);
        return list.reverse();
    }

    public static Justification visibleJustification(Justification justification) {
        if (justification.inferenceRule == Logic.KWD_DISPROOF && !justification.reversePolarityP || justification.inferenceRule == Logic.KWD_PRIMITIVE_STRATEGY && justification.inferenceStrategy() == Logic.KWD_GOAL_COMPLEMENT) {
            return Justification.visibleJustification((Justification)justification.antecedents.value);
        }
        if (justification.inferenceRule == Logic.KWD_PATTERN) {
            return Justification.visibleJustification((Justification)justification.antecedents.value);
        }
        return justification;
    }

    public static void printExplanationAntecedents(Justification justification, OutputStream outputStream, KeyValueList keyValueList, int n, List list) {
        ExplanationInfo explanationInfo = Justification.explanationInfo(justification, keyValueList);
        String string = explanationInfo.label;
        int n2 = explanationInfo.depth;
        List list2 = Justification.visibleAntecedents(justification);
        Cons cons = Stella.NIL;
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = Logic.$EXPLANATION_TAB_STRING$.length() + 6;
        int n6 = 0;
        int n7 = 0;
        Justification justification2 = null;
        Cons cons2 = list2.theConsList;
        while (cons2 != Stella.NIL) {
            justification2 = (Justification)cons2.value;
            explanationInfo = Justification.explanationInfo(justification2, keyValueList);
            if (explanationInfo == null) {
                explanationInfo = Justification.registerJustification(justification2, keyValueList);
                explanationInfo.label = string + "." + Native.integerToString((int)(++n3));
                explanationInfo.depth = n2 + 1;
            }
            n4 = Stella.max((int)n4, (int)explanationInfo.label.length());
            if (!bl) {
                bl = Justification.markAsExplicitAssertionP(justification2) || Justification.markAsFailedGoalP(justification2);
            }
            cons2 = cons2.rest;
        }
        n6 = n4 > Logic.$MAX_INLINE_LABEL_LENGTH$ ? n5 : n5 + n4 + 1;
        if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_HTML) {
            outputStream.nativeStream.println("<TABLE>");
        }
        justification2 = null;
        cons2 = list2.theConsList;
        int n8 = Integer.MIN_VALUE;
        int n9 = 1;
        while (cons2 != Stella.NIL) {
            justification2 = (Justification)cons2.value;
            n8 = n9;
            explanationInfo = Justification.explanationInfo(justification2, keyValueList);
            string = explanationInfo.label;
            if (!(explanationInfo.explainedP || Justification.markAsExplicitAssertionP(justification2) || Justification.markAsFailedGoalP(justification2) || n != Integer.MIN_VALUE && explanationInfo.depth > n)) {
                cons = Stella_Object.cons((Stella_Object)justification2, (Cons)cons);
            }
            if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_ASCII) {
                boolean bl2;
                outputStream.nativeStream.print(Logic.$EXPLANATION_TAB_STRING$ + (n8 == 1 ? "since " : "and   "));
                Logic.printExplanationLabel(outputStream, string, false);
                outputStream.nativeStream.print(" ");
                if (n4 > Logic.$MAX_INLINE_LABEL_LENGTH$) {
                    outputStream.nativeStream.println();
                    n7 = n6;
                } else {
                    n7 = n6 - (n5 + string.length()) - 1;
                }
                int n10 = Integer.MIN_VALUE;
                int n11 = n7;
                boolean bl3 = bl2 = n11 == Integer.MIN_VALUE;
                for (int i = 1; bl2 || i <= n11; ++i) {
                    n10 = i;
                    outputStream.nativeStream.print(" ");
                }
                if (bl) {
                    outputStream.nativeStream.print(Justification.explanationTruthMarker(justification2) + " ");
                }
            } else if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_HTML) {
                outputStream.nativeStream.println("<TR>");
                outputStream.nativeStream.print("<TD align=right valign=top>");
                outputStream.nativeStream.print(n8 == 1 ? "since&nbsp;" : "and&nbsp;");
                Logic.printExplanationLabel(outputStream, string, false);
                outputStream.nativeStream.print("<TD align=left valign=top>");
                if (bl) {
                    outputStream.nativeStream.print(Justification.explanationTruthMarker(justification2));
                }
                outputStream.nativeStream.print("</TD>");
                outputStream.nativeStream.println("</TD>");
            } else if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_XML) {
                Logic.printExplanationLabel(outputStream, string, false);
            } else {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("`" + (Keyword)Logic.$EXPLANATION_FORMAT$.get() + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
            }
            if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_HTML) {
                outputStream.nativeStream.println("<TD>");
            }
            Justification.printJustificationPropositionForFormat(justification2, outputStream, bl ? n6 + Justification.explanationTruthMarker(justification2).length() + 1 : n6);
            outputStream.nativeStream.println();
            if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_HTML) {
                outputStream.nativeStream.println("</TD></TR>");
            }
            cons2 = cons2.rest;
            ++n9;
        }
        if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_HTML) {
            outputStream.nativeStream.println("</TABLE>");
        }
        justification2 = null;
        cons2 = cons;
        while (cons2 != Stella.NIL) {
            justification2 = cons2.value;
            list.push((Stella_Object)justification2);
            cons2 = cons2.rest;
        }
    }

    public static void printExplanationSubstitution(Justification justification, OutputStream outputStream, KeyValueList keyValueList) {
        if (justification.inferenceRule == Logic.KWD_MODUS_PONENS || justification.inferenceRule == Logic.KWD_MODUS_TOLLENS) {
            KeyValueList keyValueList2 = Justification.getExplanationSubstitution(justification);
            int n = Integer.MIN_VALUE;
            if (keyValueList2 != null) {
                boolean bl;
                n = keyValueList2.length();
                if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_ASCII) {
                    outputStream.nativeStream.print(Logic.$EXPLANATION_TAB_STRING$ + "with substitution {");
                } else if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_HTML) {
                    outputStream.nativeStream.println("<BR><TABLE><TR>");
                    outputStream.nativeStream.print("<TD align=left valign=top>");
                    outputStream.nativeStream.println("with&nbsp;substitution");
                    outputStream.nativeStream.println("</TD>");
                    outputStream.nativeStream.print("<TD>{");
                } else if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_XML) {
                    outputStream.nativeStream.print("<variables>");
                } else {
                    OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                    outputStringStream.nativeStream.print("`" + (Keyword)Logic.$EXPLANATION_FORMAT$.get() + "' is not a valid case option");
                    throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
                }
                Stella_Object stella_Object = null;
                Stella_Object stella_Object2 = null;
                KvCons kvCons = keyValueList2.theKvList;
                int n2 = Integer.MIN_VALUE;
                int n3 = n;
                boolean bl2 = bl = n3 == Integer.MIN_VALUE;
                for (int i = 1; kvCons != null && (bl || i <= n3); ++i) {
                    stella_Object = kvCons.key;
                    stella_Object2 = kvCons.value;
                    n2 = i;
                    Logic.printOneVariableSubstitution(outputStream, stella_Object, stella_Object2);
                    if (n2 < n && ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_ASCII || (Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_HTML)) {
                        outputStream.nativeStream.print(", ");
                        if (Logic.$CYC_KLUDGES_ENABLEDp$ && ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_ASCII || (Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_HTML)) {
                            outputStream.nativeStream.println();
                            outputStream.nativeStream.print(Logic.$EXPLANATION_TAB_STRING$ + "                   ");
                        }
                    }
                    kvCons = kvCons.rest;
                }
                if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_ASCII) {
                    outputStream.nativeStream.println("}");
                } else if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_HTML) {
                    outputStream.nativeStream.println("}</TD></TR></TABLE>");
                } else if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_XML) {
                    outputStream.nativeStream.println("</variables>");
                } else {
                    stella_Object = OutputStringStream.newOutputStringStream();
                    stella_Object.nativeStream.print("`" + (Keyword)Logic.$EXPLANATION_FORMAT$.get() + "' is not a valid case option");
                    throw (StellaException)StellaException.newStellaException((String)stella_Object.theStringReader()).fillInStackTrace();
                }
            }
        }
    }

    public static KeyValueList getExplanationSubstitution(Justification justification) {
        Justification justification2 = (Justification)justification.antecedents.value;
        Proposition proposition = justification2.proposition;
        Justification justification3 = (Justification)justification.antecedents.rest.value;
        KeyValueList keyValueList = justification3.substitution;
        return keyValueList;
    }

    public static String makeRuleOriginExplanationPhrase(Justification justification) {
        Proposition proposition = justification.proposition;
        Proposition proposition2 = (Proposition)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MASTER_PROPOSITION, null);
        Description description = (Description)proposition.arguments.theArray[1];
        Description description2 = (Description)proposition.arguments.theArray[0];
        NamedDescription namedDescription = null;
        Description description3 = null;
        int n = Integer.MIN_VALUE;
        int n2 = 4;
        for (int i = 1; i <= n2; ++i) {
            n = i;
            switch (n) {
                case 1: {
                    description3 = description;
                    break;
                }
                case 2: {
                    description3 = (Description)KeyValueList.dynamicSlotValue((KeyValueList)description.dynamicSlots, (Symbol)Logic.SYM_LOGIC_COMPLEMENT_DESCRIPTION, null);
                    break;
                }
                case 3: {
                    description3 = description2;
                    break;
                }
                case 4: {
                    description3 = (Description)KeyValueList.dynamicSlotValue((KeyValueList)description2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_COMPLEMENT_DESCRIPTION, null);
                    break;
                }
                default: {
                    OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                    outputStringStream.nativeStream.print("`" + n + "' is not a valid case option");
                    throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
                }
            }
            if (description3 == null || !Stella_Object.isaP((Stella_Object)description3, (Surrogate)Logic.SGT_LOGIC_NAMED_DESCRIPTION) || !Logic.originatedPropositions((Stella_Object)description3).memberP((Stella_Object)proposition2)) continue;
            namedDescription = (NamedDescription)description3;
            break;
        }
        if (namedDescription != null) {
            return Logic.lookupExplanationPhrase(Logic.KWD_DEFINITION, Stella.NIL, null) + " " + Logic.nameObjectMetaclass(namedDescription) + " " + namedDescription.descriptionName().symbolName;
        }
        return Logic.lookupExplanationPhrase(Logic.KWD_LOOKUP_ASSERTIONS, Stella.NIL, null);
    }

    public static boolean partiallyFollowsP(Justification justification) {
        return justification.truthValue == Logic.UNKNOWN_TRUTH_VALUE || justification.truthValue == null;
    }

    public static boolean markAsCutoffGoalP(Justification justification) {
        return Justification.cutoffGoalJustificationP(justification);
    }

    public static boolean markAsFailedGoalP(Justification justification) {
        return (Keyword)Logic.$EXPLANATION_STYLE$.get() == Logic.KWD_BRIEF && justification.inferenceRule == Logic.KWD_PRIMITIVE_STRATEGY && Justification.failedGoalJustificationP(justification);
    }

    public static boolean markAsExplicitAssertionP(Justification justification) {
        Keyword keyword;
        return (Keyword)Logic.$EXPLANATION_STYLE$.get() == Logic.KWD_BRIEF && justification.inferenceRule == Logic.KWD_PRIMITIVE_STRATEGY && ((keyword = ((PrimitiveStrategy)justification).strategy) == Logic.KWD_SCAN_COLLECTION || keyword == Logic.KWD_SCAN_PROPOSITIONS || keyword == Logic.KWD_LOOKUP_ASSERTIONS || keyword == Logic.KWD_EQUIVALENCE);
    }

    public static void printExplanationText(Justification justification, OutputStream outputStream, KeyValueList keyValueList) {
        String string = "";
        String string2 = "";
        String string3 = "";
        Cons cons = Stella.NIL;
        Cons cons2 = Stella_Object.cons((Stella_Object)Logic.KWD_AMPLIFICATION, (Cons)Stella.NIL);
        if (justification.reversePolarityP) {
            cons = Stella_Object.cons((Stella_Object)Logic.KWD_REVERSE, (Cons)cons);
            cons2 = Stella_Object.cons((Stella_Object)Logic.KWD_REVERSE, (Cons)cons2);
        }
        if (Justification.partiallyFollowsP(justification)) {
            cons = Stella_Object.cons((Stella_Object)Logic.KWD_PARTIAL, (Cons)cons);
            cons2 = Stella_Object.cons((Stella_Object)Logic.KWD_PARTIAL, (Cons)cons2);
        }
        string = Justification.failedGoalJustificationP(justification) ? Logic.lookupExplanationPhrase(Logic.KWD_FAILED, cons, null) : Logic.lookupExplanationPhrase(Logic.KWD_FOLLOWS, cons, null);
        if (justification.inferenceRule == Logic.KWD_PRIMITIVE_STRATEGY) {
            if (justification.inferenceStrategy() == Logic.KWD_SCAN_PROPOSITIONS && (Proposition)KeyValueList.dynamicSlotValue((KeyValueList)justification.proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MASTER_PROPOSITION, null) != null) {
                string = Logic.lookupExplanationPhrase(Logic.KWD_HOLDS, Stella.NIL, null);
                string2 = Justification.makeRuleOriginExplanationPhrase(justification);
            }
            if (string2 == null) {
                string2 = Logic.lookupExplanationPhrase(justification.inferenceStrategy(), cons, null);
            }
        } else {
            string2 = Logic.lookupExplanationPhrase(justification.inferenceRule, cons, null);
            string3 = Logic.lookupExplanationPhrase(justification.inferenceRule, cons2, null);
        }
        if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_ASCII) {
            outputStream.nativeStream.print(Logic.$EXPLANATION_TAB_STRING$);
            outputStream.nativeStream.print(string + " " + string2);
            if (string3.length() > 0 && !Stella.stringEqlP((String)string3, (String)string2)) {
                outputStream.nativeStream.print(" " + string3);
            }
            outputStream.nativeStream.println();
        } else if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_HTML) {
            outputStream.nativeStream.println("<BR>");
            outputStream.nativeStream.print(string + " " + string2);
            if (string3.length() > 0 && !Stella.stringEqlP((String)string3, (String)string2)) {
                outputStream.nativeStream.print(" " + string3);
            }
            outputStream.nativeStream.println();
        } else if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_XML) {
            outputStream.nativeStream.println("<method>" + string2 + "</method>");
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + (Keyword)Logic.$EXPLANATION_FORMAT$.get() + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
    }

    public static void printExplanationHeader(Justification justification, OutputStream outputStream, KeyValueList keyValueList) {
        ExplanationInfo explanationInfo = Justification.explanationInfo(justification, keyValueList);
        String string = explanationInfo.label;
        int n = string.length() + 1;
        if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_XML || (Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_ASCII) {
            Logic.printExplanationLabel(outputStream, string, true);
        } else if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_HTML) {
            outputStream.nativeStream.print("<TD align=left valign=top>");
            Logic.printExplanationLabel(outputStream, string, true);
            outputStream.nativeStream.println("</TD>");
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + (Keyword)Logic.$EXPLANATION_FORMAT$.get() + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        if (string.length() > Logic.$MAX_INLINE_LABEL_LENGTH$) {
            outputStream.nativeStream.println();
            outputStream.nativeStream.print(Logic.$EXPLANATION_TAB_STRING$);
            n = Logic.$EXPLANATION_TAB_STRING$.length();
        } else {
            outputStream.nativeStream.print(" ");
        }
        if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() != Logic.KWD_XML && (Keyword)Logic.$EXPLANATION_FORMAT$.get() != Logic.KWD_ASCII) {
            if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_HTML) {
                outputStream.nativeStream.print("<TD align=left valign=top>");
            } else {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("`" + (Keyword)Logic.$EXPLANATION_FORMAT$.get() + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
            }
        }
        Justification.printJustificationPropositionForFormat(justification, outputStream, n);
        outputStream.nativeStream.println();
        explanationInfo.explainedP = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printJustificationProposition(Justification justification, OutputStream outputStream, int n) {
        Object object = Logic.$INDENTCOUNTER$.get();
        Object object2 = Logic.$PRINTMODE$.get();
        try {
            Native.setIntSpecial((ThreadLocal)Logic.$INDENTCOUNTER$, (int)n);
            Native.setSpecial((ThreadLocal)Logic.$PRINTMODE$, (Object)Logic.KWD_REALISTIC);
            Proposition proposition = justification.proposition;
            if (justification.reversePolarityP) {
                proposition = Logic.createProposition(Logic.SYM_STELLA_NOT, 1);
                proposition.arguments.theArray[0] = justification.proposition;
            }
            Object object3 = Logic.$CURRENTJUSTIFICATION$.get();
            try {
                Native.setSpecial((ThreadLocal)Logic.$CURRENTJUSTIFICATION$, (Object)((Object)justification));
                Logic.prettyPrintLogicalForm((Stella_Object)proposition, outputStream);
            }
            finally {
                Logic.$CURRENTJUSTIFICATION$.set(object3);
            }
        }
        finally {
            Logic.$PRINTMODE$.set(object2);
            Logic.$INDENTCOUNTER$.set(object);
        }
    }

    public static void printJustificationPropositionForFormat(Justification justification, OutputStream outputStream, int n) {
        if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_ASCII) {
            Justification.printJustificationProposition(justification, outputStream, n);
        } else if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_HTML) {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            boolean bl = true;
            Justification.printJustificationProposition(justification, (OutputStream)outputStringStream, n);
            if (Logic.$CYC_KLUDGES_ENABLEDp$ && (Keyword)Logic.$LOGIC_DIALECT$.get() == Logic.KWD_CYC_NL) {
                bl = false;
            }
            if ((Keyword)Logic.$LOGIC_DIALECT$.get() == Logic.KWD_KIF_ONTOSAURUS || (Keyword)Logic.$LOGIC_DIALECT$.get() == Logic.KWD_JAVA_GUI_HTML) {
                bl = false;
            }
            if (bl) {
                Stella.writeHtmlQuotingSpecialCharacters((PrintStream)outputStream.nativeStream, (String)outputStringStream.theStringReader());
            } else {
                outputStream.nativeStream.print(outputStringStream.theStringReader());
            }
        } else if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_XML) {
            Proposition proposition = justification.proposition;
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            Justification.printJustificationProposition(justification, (OutputStream)outputStringStream, 0);
            outputStream.nativeStream.print("<proposition type=\"");
            if (proposition.kind == Logic.KWD_IMPLIES) {
                outputStream.nativeStream.print("RULE");
            } else {
                outputStream.nativeStream.print("FACT");
            }
            outputStream.nativeStream.print("\" truthvalue=\"" + (Object)((Object)(justification.truthValue == null ? Logic.UNKNOWN_TRUTH_VALUE : justification.truthValue)));
            outputStream.nativeStream.println("\">");
            Stella.writeHtmlQuotingSpecialCharacters((PrintStream)outputStream.nativeStream, (String)outputStringStream.theStringReader());
            outputStream.nativeStream.println();
            outputStream.nativeStream.print("</proposition>");
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + (Keyword)Logic.$EXPLANATION_FORMAT$.get() + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
    }

    public static void printOneExplanation(Justification justification, OutputStream outputStream, KeyValueList keyValueList, int n, List list) {
        if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_ASCII) {
            Justification.printExplanationHeader(justification, outputStream, keyValueList);
            Justification.printExplanationSupport(justification, outputStream, keyValueList, n, list);
            outputStream.nativeStream.println();
        } else if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_XML) {
            outputStream.nativeStream.print("<inference>");
            outputStream.nativeStream.println();
            Justification.printExplanationHeader(justification, outputStream, keyValueList);
            outputStream.nativeStream.print("<support>");
            outputStream.nativeStream.println();
            Justification.printExplanationSupport(justification, outputStream, keyValueList, n, list);
            outputStream.nativeStream.println("</support>");
            outputStream.nativeStream.println("</inference>");
        } else if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_HTML) {
            outputStream.nativeStream.print("<TABLE>");
            outputStream.nativeStream.print("<TR>");
            outputStream.nativeStream.println();
            Justification.printExplanationHeader(justification, outputStream, keyValueList);
            Justification.printExplanationSupport(justification, outputStream, keyValueList, n, list);
            outputStream.nativeStream.print("</TD>");
            outputStream.nativeStream.println("</TR>");
            outputStream.nativeStream.println("</TABLE>");
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + (Keyword)Logic.$EXPLANATION_FORMAT$.get() + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
    }

    public static void printExplanationSupport(Justification justification, OutputStream outputStream, KeyValueList keyValueList, int n, List list) {
        Justification.printExplanationText(justification, outputStream, keyValueList);
        Justification.printExplanationSubstitution(justification, outputStream, keyValueList);
        Justification.printExplanationAntecedents(justification, outputStream, keyValueList, n, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyValueList printExplanation(Justification justification, OutputStream outputStream, KeyValueList keyValueList, int n, Keyword keyword) {
        List list = List.newList();
        ExplanationInfo explanationInfo = null;
        justification = Justification.visibleJustification(justification);
        if (keyValueList == null) {
            keyValueList = KeyValueList.newKeyValueList();
            explanationInfo = Justification.registerJustification(justification, keyValueList);
            explanationInfo.label = "1";
            explanationInfo.depth = 1;
        } else {
            explanationInfo = Justification.explanationInfo(justification, keyValueList);
            if (explanationInfo == null) {
                throw (StellaException)StellaException.newStellaException((String)"Justification not found in supplied explanation mapping.").fillInStackTrace();
            }
            Logic.resetMappingForSubexplanation(keyValueList);
            n = explanationInfo.depth + n - 1;
        }
        list.push((Stella_Object)justification);
        Object object = Logic.$EXPLANATION_AUDIENCE$.get();
        try {
            Native.setSpecial((ThreadLocal)Logic.$EXPLANATION_AUDIENCE$, (Object)keyword);
            while (list.nonEmptyP()) {
                justification = (Justification)list.pop();
                Justification.printOneExplanation(justification, outputStream, keyValueList, n, list);
            }
        }
        finally {
            Logic.$EXPLANATION_AUDIENCE$.set(object);
        }
        Native.setSpecial((ThreadLocal)Logic.$MOST_RECENT_EXPLANATION_MAPPING$, (Object)keyValueList);
        return keyValueList;
    }

    public static ExplanationInfo explanationInfo(Justification justification, KeyValueList keyValueList) {
        return Justification.getExplanationInfo(justification, keyValueList, false);
    }

    public static ExplanationInfo getExplanationInfo(Justification justification, KeyValueList keyValueList, boolean bl) {
        ExplanationInfo explanationInfo = (ExplanationInfo)keyValueList.lookup((Stella_Object)justification);
        if (explanationInfo == null) {
            Justification justification2 = null;
            ExplanationInfo explanationInfo2 = null;
            KvCons kvCons = keyValueList.theKvList;
            while (kvCons != null) {
                justification2 = (Justification)kvCons.key;
                explanationInfo2 = (ExplanationInfo)kvCons.value;
                if (Justification.justificationEqlP(justification2, justification)) {
                    keyValueList.insertAt((Stella_Object)justification, (Stella_Object)explanationInfo2);
                    return explanationInfo2;
                }
                kvCons = kvCons.rest;
            }
            if (bl) {
                explanationInfo = ExplanationInfo.newExplanationInfo();
                keyValueList.insertAt((Stella_Object)justification, (Stella_Object)explanationInfo);
            }
        }
        return explanationInfo;
    }

    public static ExplanationInfo registerJustification(Justification justification, KeyValueList keyValueList) {
        return Justification.getExplanationInfo(justification, keyValueList, true);
    }

    public static String explanationTruthMarker(Justification justification) {
        Keyword keyword = null;
        keyword = Justification.markAsExplicitAssertionP(justification) ? Logic.KWD_ASSERTION : (Justification.markAsFailedGoalP(justification) ? Logic.KWD_FAILURE : (Justification.markAsCutoffGoalP(justification) ? Logic.KWD_CUTOFF : Logic.KWD_INFERENCE));
        if ((Keyword)Logic.$EXPLANATION_FORMAT$.get() == Logic.KWD_HTML) {
            String string = "Fact:";
            String string2 = "#00ff00";
            String string3 = "#ffd70";
            String string4 = "#ff0000";
            String string5 = null;
            if (keyword == Logic.KWD_ASSERTION) {
                if (justification.proposition.kind == Logic.KWD_IMPLIES) {
                    string = "Rule:";
                }
                string5 = string2;
            } else if (keyword == Logic.KWD_FAILURE) {
                string5 = string4;
                string = "Unknown:";
            } else if (keyword == Logic.KWD_CUTOFF) {
                string5 = string4;
                string = "Cutoff:";
            } else if (keyword == Logic.KWD_INFERENCE) {
                string = "Inferred:";
                string5 = Justification.partiallyFollowsP(justification) ? string3 : string2;
            } else {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
            }
            if (string5 != null) {
                string = "<font color=\"" + string5 + "\">" + "<strong>" + string + "</strong>" + "</font>";
            }
            return string;
        }
        if (keyword == Logic.KWD_ASSERTION) {
            return Logic.$EXPLANATION_ASSERTION_MARKER$;
        }
        if (keyword == Logic.KWD_FAILURE) {
            return Logic.$EXPLANATION_FAILURE_MARKER$;
        }
        if (keyword == Logic.KWD_CUTOFF) {
            return Logic.$EXPLANATION_CUTOFF_MARKER$;
        }
        if (keyword == Logic.KWD_INFERENCE) {
            return Logic.$EXPLANATION_INFERENCE_MARKER$;
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cons consifyJustification(Justification justification, Keyword keyword) {
        Object object = Logic.$EXPLANATION_STYLE$.get();
        try {
            Cons cons;
            Object object2;
            Object object3;
            Native.setSpecial((ThreadLocal)Logic.$EXPLANATION_STYLE$, (Object)keyword);
            if (keyword != Logic.KWD_RAW) {
                justification = Justification.visibleJustification(justification);
            }
            Cons cons2 = keyword == Logic.KWD_RAW ? justification.antecedents : Justification.visibleAntecedents((Justification)justification).theConsList;
            Stella_Object stella_Object = null;
            PropertyList propertyList = PropertyList.newPropertyList();
            Cons cons3 = Stella.NIL;
            Cons cons4 = Stella.NIL;
            if (justification.inferenceRule != null) {
                propertyList.insertAt((Stella_Object)Logic.KWD_INFERENCE_RULE, (Stella_Object)justification.inferenceRule);
                if (Stella_Object.isaP((Stella_Object)justification, (Surrogate)Logic.SGT_LOGIC_PRIMITIVE_STRATEGY)) {
                    propertyList.insertAt((Stella_Object)Logic.KWD_STRATEGY, (Stella_Object)((PrimitiveStrategy)justification).strategy);
                }
            }
            if (justification.truthValue != null) {
                propertyList.insertAt((Stella_Object)Logic.KWD_TRUTH_VALUE, (Stella_Object)justification.truthValue);
            } else {
                propertyList.insertAt((Stella_Object)Logic.KWD_TRUTH_VALUE, (Stella_Object)Logic.UNKNOWN_TRUTH_VALUE);
            }
            if (justification.positiveScore != Double.NEGATIVE_INFINITY) {
                propertyList.insertAt((Stella_Object)Logic.KWD_POSITIVE_SCORE, (Stella_Object)FloatWrapper.wrapFloat((double)justification.positiveScore));
            }
            if ((object3 = justification.substitution) == null) {
                object2 = null;
                cons = justification.antecedents;
                while (cons != Stella.NIL) {
                    object2 = (Justification)cons.value;
                    if (object2.inferenceRule == Logic.KWD_PATTERN) {
                        object3 = object2.substitution;
                        break;
                    }
                    cons = cons.rest;
                }
            }
            if (object3 != null) {
                object2 = null;
                cons = null;
                KvCons kvCons = object3.theKvList;
                while (kvCons != null) {
                    object2 = (PatternVariable)kvCons.key;
                    cons = kvCons.value;
                    cons3 = Stella_Object.cons((Stella_Object)Logic.generateTerm((Stella_Object)object2), (Cons)cons3);
                    cons3 = Stella_Object.cons((Stella_Object)Logic.generateTerm((Stella_Object)cons), (Cons)cons3);
                    kvCons = kvCons.rest;
                }
                propertyList.insertAt((Stella_Object)Logic.KWD_SUBSTITUTION, (Stella_Object)cons3.reverse());
            }
            object3 = Logic.$CURRENTJUSTIFICATION$.get();
            try {
                Native.setSpecial((ThreadLocal)Logic.$CURRENTJUSTIFICATION$, (Object)((Object)justification));
                stella_Object = Proposition.generateProposition(justification.proposition);
                if (justification.reversePolarityP) {
                    stella_Object = Stella.list$((Cons)Stella_Object.cons((Stella_Object)Logic.SYM_STELLA_NOT, (Cons)Stella_Object.cons((Stella_Object)stella_Object, (Cons)Stella_Object.cons((Stella_Object)Stella.NIL, (Cons)Stella.NIL))));
                }
            }
            finally {
                Logic.$CURRENTJUSTIFICATION$.set(object3);
            }
            cons4 = Stella.consList((Cons)Stella_Object.cons((Stella_Object)stella_Object, (Cons)Stella_Object.cons((Stella_Object)propertyList.thePlist, (Cons)Stella.NIL)));
            object3 = null;
            object2 = cons2;
            cons = null;
            while (object2 != Stella.NIL) {
                object3 = (Justification)((Cons)object2).value;
                if (cons == null) {
                    cons = Stella_Object.cons((Stella_Object)Justification.consifyJustification((Justification)((Object)object3), keyword), (Cons)Stella.NIL);
                    if (cons4 == Stella.NIL) {
                        cons4 = cons;
                    } else {
                        Cons.addConsToEndOfConsList((Cons)cons4, (Cons)cons);
                    }
                } else {
                    cons = cons.rest = Stella_Object.cons((Stella_Object)Justification.consifyJustification((Justification)((Object)object3), keyword), (Cons)Stella.NIL);
                }
                object2 = ((Cons)object2).rest;
            }
            object3 = cons4;
            return object3;
        }
        finally {
            Logic.$EXPLANATION_STYLE$.set(object);
        }
    }

    public Cons consify() {
        Justification justification = this;
        return Justification.consifyJustification(justification, Logic.KWD_RAW);
    }

    public static boolean cutoffGoalJustificationP(Justification justification) {
        Keyword keyword = justification.inferenceRule;
        return keyword == Logic.KWD_TIMEOUT || keyword == Logic.KWD_DEPTH_CUTOFF;
    }

    public static boolean failedGoalJustificationP(Justification justification) {
        Keyword keyword = justification.inferenceRule;
        return (keyword == Logic.KWD_PRIMITIVE_STRATEGY || keyword == Logic.KWD_TIMEOUT || keyword == Logic.KWD_DEPTH_CUTOFF) && ((PrimitiveStrategy)justification).strategy == Logic.KWD_FAILURE;
    }

    public static void backlinkToPatternJustification(Justification justification, Justification justification2) {
        if (justification.patternJustification == null) {
            justification.patternJustification = justification2;
            Justification justification3 = null;
            Cons cons = justification.antecedents;
            while (cons != Stella.NIL) {
                justification3 = (Justification)cons.value;
                Justification.backlinkToPatternJustification(justification3, justification2);
                cons = cons.rest;
            }
        }
    }

    public Justification copy() {
        PrimitiveStrategy primitiveStrategy;
        Justification justification;
        Justification justification2 = this;
        Justification justification3 = null;
        Cons cons = Stella.NIL;
        if (Surrogate.subtypeOfP((Surrogate)Stella_Object.safePrimaryType((Stella_Object)justification2), (Surrogate)Logic.SGT_LOGIC_PRIMITIVE_STRATEGY)) {
            justification = (PrimitiveStrategy)justification2;
            primitiveStrategy = PrimitiveStrategy.newPrimitiveStrategy();
            primitiveStrategy.strategy = ((PrimitiveStrategy)justification).strategy;
            justification3 = primitiveStrategy;
        } else {
            justification3 = Justification.newJustification();
        }
        justification3.inferenceRule = justification2.inferenceRule;
        justification3.proposition = justification2.proposition;
        justification3.substitution = justification2.substitution;
        justification3.reversePolarityP = justification2.reversePolarityP;
        justification3.truthValue = justification2.truthValue;
        justification3.positiveScore = justification2.positiveScore;
        justification3.negativeScore = justification2.negativeScore;
        justification = null;
        primitiveStrategy = justification2.antecedents;
        Cons cons2 = null;
        while (primitiveStrategy != Stella.NIL) {
            justification = (Justification)((Cons)primitiveStrategy).value;
            if (cons2 == null) {
                cons2 = Stella_Object.cons((Stella_Object)justification.copy(), (Cons)Stella.NIL);
                if (cons == Stella.NIL) {
                    cons = cons2;
                } else {
                    Cons.addConsToEndOfConsList((Cons)cons, (Cons)cons2);
                }
            } else {
                cons2 = cons2.rest = Stella_Object.cons((Stella_Object)justification.copy(), (Cons)Stella.NIL);
            }
            primitiveStrategy = ((Cons)primitiveStrategy).rest;
        }
        justification3.antecedents = cons;
        if (justification2.inferenceRule == Logic.KWD_PATTERN) {
            justification = null;
            primitiveStrategy = justification3.antecedents;
            while (primitiveStrategy != Stella.NIL) {
                justification = (Justification)((Cons)primitiveStrategy).value;
                Justification.backlinkToPatternJustification(justification, justification3);
                primitiveStrategy = ((Cons)primitiveStrategy).rest;
            }
        }
        return justification3;
    }

    public static boolean justificationEqlP(Justification justification, Justification justification2) {
        return justification == justification2 || justification.inferenceRule == justification2.inferenceRule && justification.reversePolarityP == justification2.reversePolarityP && (justification.inferenceRule != Logic.KWD_PRIMITIVE_STRATEGY && justification2.inferenceRule != Logic.KWD_PRIMITIVE_STRATEGY || ((PrimitiveStrategy)justification).strategy == ((PrimitiveStrategy)justification2).strategy) && Proposition.justificationPropositionsEqlP(justification.proposition, justification, justification2.proposition, justification2);
    }

    public static KeyValueList yieldJustificationSubstitution(Justification justification, KeyValueList keyValueList, Proposition proposition) {
        Proposition proposition2 = justification.proposition;
        Proposition proposition3 = proposition == null ? proposition2 : proposition;
        Stella_Object stella_Object = null;
        Vector vector = proposition3.arguments;
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            ContextSensitiveObject contextSensitiveObject;
            stella_Object = vector.theArray[i];
            Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object);
            if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                contextSensitiveObject = (PatternVariable)stella_Object;
                if (!PatternVariable.freeVariableP((PatternVariable)contextSensitiveObject, proposition2)) continue;
                if (keyValueList == null) {
                    keyValueList = KeyValueList.newKeyValueList();
                }
                keyValueList.insertAt((Stella_Object)contextSensitiveObject, Logic.justificationArgumentBoundTo((Stella_Object)contextSensitiveObject, justification));
                continue;
            }
            if (!Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PROPOSITION)) continue;
            contextSensitiveObject = (Proposition)stella_Object;
            keyValueList = Justification.yieldJustificationSubstitution(justification, keyValueList, (Proposition)contextSensitiveObject);
        }
        return keyValueList;
    }

    public static Stella_Object accessJustificationSlotValue(Justification justification, Symbol symbol, Stella_Object object, boolean bl) {
        if (symbol == Logic.SYM_LOGIC_INFERENCE_RULE) {
            if (bl) {
                justification.inferenceRule = (Keyword)object;
            } else {
                object = justification.inferenceRule;
            }
        } else if (symbol == Logic.SYM_LOGIC_PROPOSITION) {
            if (bl) {
                justification.proposition = (Proposition)((Object)object);
            } else {
                object = justification.proposition;
            }
        } else if (symbol == Logic.SYM_LOGIC_ANTECEDENTS) {
            if (bl) {
                justification.antecedents = (Cons)object;
            } else {
                object = justification.antecedents;
            }
        } else if (symbol == Logic.SYM_LOGIC_PATTERN_JUSTIFICATION) {
            if (bl) {
                justification.patternJustification = (Justification)((Object)object);
            } else {
                object = justification.patternJustification;
            }
        } else if (symbol == Logic.SYM_LOGIC_SUBSTITUTION) {
            if (bl) {
                justification.substitution = (KeyValueList)object;
            } else {
                object = justification.substitution;
            }
        } else if (symbol == Logic.SYM_LOGIC_REVERSE_POLARITYp) {
            if (bl) {
                justification.reversePolarityP = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)((BooleanWrapper)object));
            } else {
                object = justification.reversePolarityP ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else if (symbol == Logic.SYM_LOGIC_TRUTH_VALUE) {
            if (bl) {
                justification.truthValue = (TruthValue)((Object)object);
            } else {
                object = justification.truthValue;
            }
        } else if (symbol == Logic.SYM_LOGIC_POSITIVE_SCORE) {
            if (bl) {
                justification.positiveScore = ((FloatWrapper)object).wrapperValue;
            } else {
                object = FloatWrapper.wrapFloat((double)justification.positiveScore);
            }
        } else if (symbol == Logic.SYM_LOGIC_NEGATIVE_SCORE) {
            if (bl) {
                justification.negativeScore = ((FloatWrapper)object).wrapperValue;
            } else {
                object = FloatWrapper.wrapFloat((double)justification.negativeScore);
            }
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + symbol + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        return object;
    }

    public Keyword inferenceStrategy() {
        Justification justification = this;
        return null;
    }

    public Surrogate primaryType() {
        Justification justification = this;
        return Logic.SGT_LOGIC_JUSTIFICATION;
    }
}

