/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.powerloom.logic;

import edu.isi.powerloom.logic.ControlFrame;
import edu.isi.powerloom.logic.Justification;
import edu.isi.powerloom.logic.Logic;
import edu.isi.powerloom.logic.PartialMatchFrame;
import edu.isi.powerloom.logic.PrimitiveStrategy;
import edu.isi.powerloom.logic.Proposition;
import edu.isi.powerloom.logic.QueryIterator;
import edu.isi.powerloom.logic.QuerySolution;
import edu.isi.powerloom.logic.TruthValue;
import edu.isi.stella.BooleanWrapper;
import edu.isi.stella.Cons;
import edu.isi.stella.Context;
import edu.isi.stella.FloatWrapper;
import edu.isi.stella.KeyValueList;
import edu.isi.stella.Keyword;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.Vector;
import edu.isi.stella.Wrapper;
import edu.isi.stella.javalib.Native;

public class IncrementalPartialMatch
extends PartialMatchFrame {
    public double accumulatedScore;
    public double accumulatedWeight;
    public double totalWeight;
    public double maximumScore;

    public static IncrementalPartialMatch newIncrementalPartialMatch(Keyword keyword, ControlFrame controlFrame) {
        IncrementalPartialMatch incrementalPartialMatch = null;
        incrementalPartialMatch = new IncrementalPartialMatch();
        incrementalPartialMatch.kind = keyword;
        incrementalPartialMatch.controlFrame = controlFrame;
        incrementalPartialMatch.successP = false;
        incrementalPartialMatch.unboundVars = Stella.NIL;
        incrementalPartialMatch.argumentWeights = Stella.NIL;
        incrementalPartialMatch.argumentScores = Stella.NIL;
        incrementalPartialMatch.dynamicCutoff = Double.NEGATIVE_INFINITY;
        incrementalPartialMatch.negativeScore = Double.NEGATIVE_INFINITY;
        incrementalPartialMatch.positiveScore = Double.NEGATIVE_INFINITY;
        incrementalPartialMatch.maximumScore = 0.0;
        incrementalPartialMatch.totalWeight = Double.NEGATIVE_INFINITY;
        incrementalPartialMatch.accumulatedWeight = 0.0;
        incrementalPartialMatch.accumulatedScore = 0.0;
        incrementalPartialMatch.child = null;
        incrementalPartialMatch.parent = null;
        IncrementalPartialMatch.initializeIncrementalPartialMatch(incrementalPartialMatch);
        return incrementalPartialMatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double computePartialTruth(QueryIterator queryIterator) {
        IncrementalPartialMatch incrementalPartialMatch = this;
        ControlFrame controlFrame = queryIterator.baseControlFrame;
        PartialMatchFrame partialMatchFrame = queryIterator.partialMatchStrategy;
        FloatWrapper floatWrapper = (FloatWrapper)queryIterator.options.lookup((Stella_Object)Logic.KWD_MINIMUM_SCORE);
        boolean bl = !Stella_Object.eqlP((Stella_Object)queryIterator.options.lookup((Stella_Object)Logic.KWD_MAXIMIZE_SCOREp), (Stella_Object)Stella.FALSE_WRAPPER);
        double d = 0.001;
        double d2 = 0.0;
        double d3 = 0.0;
        Justification justification = null;
        if (partialMatchFrame == null) {
            partialMatchFrame = incrementalPartialMatch;
            queryIterator.partialMatchStrategy = incrementalPartialMatch;
        }
        partialMatchFrame.dynamicCutoff = floatWrapper != null ? floatWrapper.wrapperValue : d;
        Object object = Logic.$QUERYITERATOR$.get();
        Object object2 = Logic.$GENERATE_ALL_PROOFSp$.get();
        Object object3 = Logic.$INFERENCELEVEL$.get();
        Object object4 = Logic.$REVERSEPOLARITYp$.get();
        try {
            Native.setSpecial((ThreadLocal)Logic.$QUERYITERATOR$, (Object)((Object)queryIterator));
            Native.setBooleanSpecial((ThreadLocal)Logic.$GENERATE_ALL_PROOFSp$, (boolean)true);
            Native.setSpecial((ThreadLocal)Logic.$INFERENCELEVEL$, (Object)((Object)Logic.currentInferenceLevel()));
            Native.setBooleanSpecial((ThreadLocal)Logic.$REVERSEPOLARITYp$, (boolean)false);
            while (queryIterator.nextP() && !((d2 = partialMatchFrame.positiveScore) <= d3)) {
                justification = (Justification)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null);
                d3 = d2;
                partialMatchFrame.dynamicCutoff = d3 + d;
                if (!bl) break;
                if (controlFrame.truthValue == Logic.UNKNOWN_TRUTH_VALUE || controlFrame.truthValue == null) continue;
                break;
            }
            Object var19_15 = null;
        }
        catch (Throwable throwable) {
            Object var19_16 = null;
            Logic.$REVERSEPOLARITYp$.set(object4);
            Logic.$INFERENCELEVEL$.set(object3);
            Logic.$GENERATE_ALL_PROOFSp$.set(object2);
            Logic.$QUERYITERATOR$.set(object);
            throw throwable;
        }
        Logic.$REVERSEPOLARITYp$.set(object4);
        Logic.$INFERENCELEVEL$.set(object3);
        Logic.$GENERATE_ALL_PROOFSp$.set(object2);
        Logic.$QUERYITERATOR$.set(object);
        KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, (Stella_Object)justification, null);
        return d3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryIterator retrievePartialSolutions(QueryIterator queryIterator) {
        QueryIterator queryIterator2;
        IncrementalPartialMatch incrementalPartialMatch = this;
        BooleanWrapper booleanWrapper = (BooleanWrapper)Logic.lookupQueryOption((Stella_Object)queryIterator, Logic.KWD_MAXIMIZE_SCOREp);
        if (booleanWrapper == Stella.TRUE_WRAPPER) {
            Stella.STANDARD_WARNING.nativeStream.println("Warning: :MAXIMIZE-SCORE? option not yet implemented for partial retrieval in incremental partial match mode - ignoring it.");
        }
        Object object = Logic.$QUERYITERATOR$.get();
        Object object2 = Logic.$REVERSEPOLARITYp$.get();
        Object object3 = Logic.$GENERATE_ALL_PROOFSp$.get();
        Object object4 = Logic.$INFERENCELEVEL$.get();
        try {
            Native.setSpecial((ThreadLocal)Logic.$QUERYITERATOR$, (Object)((Object)queryIterator));
            Native.setBooleanSpecial((ThreadLocal)Logic.$REVERSEPOLARITYp$, (boolean)false);
            Native.setBooleanSpecial((ThreadLocal)Logic.$GENERATE_ALL_PROOFSp$, (boolean)false);
            Native.setSpecial((ThreadLocal)Logic.$INFERENCELEVEL$, (Object)((Object)Logic.currentInferenceLevel()));
            int n = Integer.MIN_VALUE;
            int n2 = Logic.lookupHowManySolutions((Stella_Object)queryIterator);
            boolean bl = n2 == Integer.MIN_VALUE;
            QuerySolution querySolution = null;
            QueryIterator queryIterator3 = queryIterator;
            for (int i = 1; (bl || i <= n2) && queryIterator3.nextP(); ++i) {
                n = i;
                querySolution = (QuerySolution)queryIterator3.value;
            }
            queryIterator2 = queryIterator;
            Object var15_15 = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            Logic.$INFERENCELEVEL$.set(object4);
            Logic.$GENERATE_ALL_PROOFSp$.set(object3);
            Logic.$REVERSEPOLARITYp$.set(object2);
            Logic.$QUERYITERATOR$.set(object);
            throw throwable;
        }
        Logic.$INFERENCELEVEL$.set(object4);
        Logic.$GENERATE_ALL_PROOFSp$.set(object3);
        Logic.$REVERSEPOLARITYp$.set(object2);
        Logic.$QUERYITERATOR$.set(object);
        return queryIterator2;
    }

    public Keyword continuePartialFailProof(Keyword keyword) {
        IncrementalPartialMatch incrementalPartialMatch = this;
        ControlFrame controlFrame = incrementalPartialMatch.controlFrame;
        if (keyword == Logic.KWD_DOWN) {
            incrementalPartialMatch.setDynamicCutoff();
        } else if (keyword == Logic.KWD_UP_TRUE) {
            ControlFrame controlFrame2 = controlFrame.result;
            PartialMatchFrame partialMatchFrame = controlFrame2.partialMatchFrame;
            partialMatchFrame.positiveScore = partialMatchFrame.positiveScore * partialMatchFrame.propositionWeight(controlFrame2.proposition) * -1.0;
            partialMatchFrame.propagateFramePartialTruth(controlFrame);
        } else if (keyword == Logic.KWD_UP_FAIL) {
            ControlFrame controlFrame3 = controlFrame.result;
            PartialMatchFrame partialMatchFrame = controlFrame3.partialMatchFrame;
            partialMatchFrame.positiveScore = (Keyword)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_INFERENCE_CUTOFF_REASON, null) != null ? 0.0 : partialMatchFrame.positiveScore * partialMatchFrame.propositionWeight(controlFrame3.proposition) * -1.0;
            partialMatchFrame.propagateFramePartialTruth(controlFrame);
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        return ControlFrame.continueFailProof(incrementalPartialMatch.controlFrame, keyword);
    }

    public Keyword continuePartialAntecedentsProof(Keyword keyword) {
        IncrementalPartialMatch incrementalPartialMatch = this;
        ControlFrame controlFrame = incrementalPartialMatch.controlFrame;
        Proposition proposition = ControlFrame.extractSubgoalOfFrame(controlFrame);
        double d = Double.NEGATIVE_INFINITY;
        Keyword keyword2 = null;
        if (keyword == Logic.KWD_DOWN) {
            incrementalPartialMatch.setDynamicCutoff();
        } else if (keyword == Logic.KWD_UP_TRUE || keyword == Logic.KWD_UP_FAIL) {
            d = controlFrame.result.partialMatchFrame.positiveScore;
            incrementalPartialMatch.pushOrPartialMatchScore(d, incrementalPartialMatch.propositionWeight((Proposition)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANTECEDENTS_RULE, null)));
            d = incrementalPartialMatch.computeGoalScore();
            incrementalPartialMatch.setFramePartialTruth(null, d, Double.NEGATIVE_INFINITY, false);
            if (!Proposition.allArgumentsBoundP(proposition) && !incrementalPartialMatch.allowUnboundVariablesP() || incrementalPartialMatch.cutoffPartialMatchP(Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_GOAL_TREE))) {
                incrementalPartialMatch.setFramePartialTruth(Logic.UNKNOWN_TRUTH_VALUE, 0.0, Double.NEGATIVE_INFINITY, true);
                keyword = Logic.KWD_UP_FAIL;
            }
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        if (keyword == Logic.KWD_UP_FAIL && controlFrame.down != null) {
            controlFrame.down = null;
        }
        keyword2 = ControlFrame.continueAntecedentsProof(controlFrame, keyword);
        if (keyword == Logic.KWD_UP_TRUE && controlFrame.truthValue == null) {
            controlFrame.truthValue = Logic.UNKNOWN_TRUTH_VALUE;
        }
        return keyword2;
    }

    public Keyword continuePartialStrategiesProofs(Keyword keyword) {
        IncrementalPartialMatch incrementalPartialMatch = this;
        ControlFrame controlFrame = incrementalPartialMatch.controlFrame;
        Keyword keyword2 = null;
        if (keyword == Logic.KWD_DOWN) {
            incrementalPartialMatch.setDynamicCutoff();
        } else if (keyword == Logic.KWD_UP_FAIL && controlFrame.down != null) {
            controlFrame.down = null;
        }
        while ((keyword2 = ControlFrame.continueStrategiesProofs(controlFrame, keyword)) == Logic.KWD_CONTINUING_SUCCESS && incrementalPartialMatch.cutoffPartialMatchP(Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_GOAL_TREE))) {
            keyword = Logic.KWD_DOWN;
        }
        return keyword2;
    }

    public double computeGoalScore() {
        IncrementalPartialMatch incrementalPartialMatch = this;
        double d = 0.0;
        if (Logic.$RULE_COMBINATION$ == Logic.KWD_MAX) {
            d = incrementalPartialMatch.maximumScore;
        } else if (Logic.$RULE_COMBINATION$ == Logic.KWD_NOISY_OR) {
            d = Logic.probabilisticSumN(incrementalPartialMatch.argumentScores);
        }
        return d;
    }

    public Keyword continuePartialNotProof(Keyword keyword) {
        IncrementalPartialMatch incrementalPartialMatch = this;
        ControlFrame controlFrame = incrementalPartialMatch.controlFrame;
        if (keyword == Logic.KWD_DOWN) {
            incrementalPartialMatch.setDynamicCutoff();
        } else if (keyword == Logic.KWD_UP_TRUE || keyword == Logic.KWD_UP_FAIL) {
            ControlFrame controlFrame2 = controlFrame.result;
            PartialMatchFrame partialMatchFrame = controlFrame2.partialMatchFrame;
            partialMatchFrame.positiveScore *= partialMatchFrame.propositionWeight(controlFrame2.proposition);
            partialMatchFrame.propagateFramePartialTruth(controlFrame);
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        return ControlFrame.continueNotProof(incrementalPartialMatch.controlFrame, keyword);
    }

    public double computeNotScore() {
        IncrementalPartialMatch incrementalPartialMatch = this;
        return 0.0 - incrementalPartialMatch.accumulatedScore / incrementalPartialMatch.totalWeight;
    }

    public Keyword continuePartialOrProof(Keyword keyword) {
        int n;
        IncrementalPartialMatch incrementalPartialMatch = this;
        ControlFrame controlFrame = incrementalPartialMatch.controlFrame;
        Proposition proposition = controlFrame.proposition;
        Keyword keyword2 = null;
        if (keyword == Logic.KWD_DOWN) {
            incrementalPartialMatch.setDynamicCutoff();
        } else if (keyword == Logic.KWD_UP_TRUE || keyword == Logic.KWD_UP_FAIL) {
            n = keyword == Logic.KWD_UP_TRUE ? 1 : 0;
            ControlFrame controlFrame2 = controlFrame.result;
            Vector vector = proposition.arguments;
            Proposition proposition2 = (Proposition)vector.theArray[controlFrame.argumentCursor];
            double d = Double.NEGATIVE_INFINITY;
            d = controlFrame2.partialMatchFrame.positiveScore;
            incrementalPartialMatch.pushOrPartialMatchScore(d, incrementalPartialMatch.propositionWeight(proposition2));
            d = incrementalPartialMatch.computeOrScore();
            incrementalPartialMatch.setFramePartialTruth(null, d, Double.NEGATIVE_INFINITY, false);
            if (!Proposition.allArgumentsBoundP(proposition2) && !incrementalPartialMatch.allowUnboundVariablesP() || incrementalPartialMatch.cutoffPartialMatchP(Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_GOAL_TREE)) || n == 0 && controlFrame.argumentCursor == vector.length() - 1) {
                incrementalPartialMatch.setFramePartialTruth(Logic.UNKNOWN_TRUTH_VALUE, 0.0, Double.NEGATIVE_INFINITY, true);
                keyword = Logic.KWD_UP_FAIL;
            } else {
                keyword = Logic.KWD_UP_TRUE;
            }
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        keyword2 = ControlFrame.continueOrProof(controlFrame, keyword);
        if (keyword2 == Logic.KWD_MOVE_DOWN) {
            n = Integer.MIN_VALUE;
            int n2 = incrementalPartialMatch.argumentScores.length() - 1;
            for (int i = controlFrame.argumentCursor; i <= n2; ++i) {
                n = i;
                incrementalPartialMatch.popOrPartialMatchScore();
            }
        } else if (keyword2 == Logic.KWD_FAILURE) {
            incrementalPartialMatch.setFramePartialTruth(null, incrementalPartialMatch.computeOrScore(), Double.NEGATIVE_INFINITY, false);
        }
        return keyword2;
    }

    public double computeOrScore() {
        IncrementalPartialMatch incrementalPartialMatch = this;
        return incrementalPartialMatch.maximumScore;
    }

    public void popOrPartialMatchScore() {
        IncrementalPartialMatch incrementalPartialMatch = this;
        double d = ((FloatWrapper)incrementalPartialMatch.argumentScores.value).wrapperValue * ((FloatWrapper)incrementalPartialMatch.argumentWeights.value).wrapperValue;
        double d2 = incrementalPartialMatch.maximumScore;
        incrementalPartialMatch.popAndPartialMatchScore();
        if (d == d2) {
            d2 = 0.0;
            FloatWrapper floatWrapper = null;
            Cons cons = incrementalPartialMatch.argumentScores;
            FloatWrapper floatWrapper2 = null;
            Cons cons2 = incrementalPartialMatch.argumentWeights;
            while (cons != Stella.NIL && cons2 != Stella.NIL) {
                floatWrapper = (FloatWrapper)cons.value;
                floatWrapper2 = (FloatWrapper)cons2.value;
                if (floatWrapper.wrapperValue * floatWrapper2.wrapperValue > d2) {
                    d2 = floatWrapper.wrapperValue * floatWrapper2.wrapperValue;
                }
                cons = cons.rest;
                cons2 = cons2.rest;
            }
            incrementalPartialMatch.maximumScore = d2;
        }
    }

    public void pushOrPartialMatchScore(double d, double d2) {
        IncrementalPartialMatch incrementalPartialMatch = this;
        if (d2 == Double.NEGATIVE_INFINITY) {
            d2 = 1.0;
        }
        incrementalPartialMatch.pushAndPartialMatchScore(d, d2);
        d *= d2;
        if (d > incrementalPartialMatch.maximumScore) {
            incrementalPartialMatch.maximumScore = d;
        }
    }

    public Keyword continuePartialAndProof(ControlFrame controlFrame, Keyword keyword) {
        Keyword keyword2;
        IncrementalPartialMatch incrementalPartialMatch = this;
        Cons cons = Stella.NIL;
        if (keyword == Logic.KWD_DOWN) {
            incrementalPartialMatch.setDynamicCutoff();
        } else if (keyword == Logic.KWD_UP_TRUE || keyword == Logic.KWD_UP_FAIL) {
            boolean bl = keyword == Logic.KWD_UP_TRUE;
            Proposition proposition = controlFrame.proposition;
            ControlFrame controlFrame2 = controlFrame.result;
            Proposition proposition2 = controlFrame2.proposition;
            double d = controlFrame2.partialMatchFrame.positiveScore;
            double d2 = incrementalPartialMatch.propositionWeight(proposition2);
            keyword = Logic.KWD_UP_TRUE;
            incrementalPartialMatch.pushAndPartialMatchScore(d, d2);
            if (controlFrame2.partialMatchFrame.cutoffPartialMatchP(Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_GOAL_TREE))) {
                keyword = Logic.KWD_UP_FAIL;
            } else if (!(controlFrame2.truthValue != Logic.FALSE_TRUTH_VALUE && controlFrame2.truthValue != Logic.DEFAULT_FALSE_TRUTH_VALUE || controlFrame2.truthValue != Logic.TRUE_TRUTH_VALUE && controlFrame2.truthValue != Logic.FALSE_TRUTH_VALUE)) {
                keyword = Logic.KWD_UP_FAIL;
            } else if (BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)proposition2.variableTypeP()) && !bl) {
                keyword = Logic.KWD_UP_FAIL;
            } else if (controlFrame.argumentCursor == proposition.arguments.length() - 1) {
                d = incrementalPartialMatch.computeAndScore();
                if (d <= Logic.$MINIMUM_SCORE_CUTOFF$ || !Proposition.allArgumentsBoundP(proposition) && !incrementalPartialMatch.allowUnboundVariablesP()) {
                    keyword = Logic.KWD_UP_FAIL;
                } else {
                    incrementalPartialMatch.setFramePartialTruth(null, d, Double.NEGATIVE_INFINITY, false);
                }
            }
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        if (keyword == Logic.KWD_UP_FAIL) {
            controlFrame.down = null;
        }
        if ((keyword2 = ControlFrame.continueAndProof(controlFrame, keyword)) == Logic.KWD_MOVE_DOWN) {
            int n = Integer.MIN_VALUE;
            int n2 = incrementalPartialMatch.argumentScores.length() - 1;
            for (int i = controlFrame.argumentCursor; i <= n2; ++i) {
                n = i;
                incrementalPartialMatch.popAndPartialMatchScore();
            }
            if (incrementalPartialMatch.skipAndClauseP(controlFrame, cons)) {
                keyword2 = incrementalPartialMatch.continuePartialAndProof(controlFrame, Logic.KWD_UP_FAIL);
            }
        } else if (keyword2 == Logic.KWD_FAILURE) {
            incrementalPartialMatch.setFramePartialTruth(controlFrame.truthValue, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, false);
        }
        return keyword2;
    }

    public boolean skipAndClauseP(ControlFrame controlFrame, Cons cons) {
        Object object;
        IncrementalPartialMatch incrementalPartialMatch = this;
        boolean bl = cons != Stella.NIL;
        boolean bl2 = Logic.$FAIL_UNBOUND_CLAUSESp$;
        Stella_Object stella_Object = controlFrame.proposition.arguments.theArray[controlFrame.argumentCursor];
        boolean bl3 = false;
        bl3 = bl;
        if (bl3) {
            boolean bl4 = false;
            object = null;
            Cons cons2 = Proposition.getUnboundVariables((Proposition)stella_Object);
            while (cons2 != Stella.NIL) {
                object = cons2.value;
                if (cons.memberP(object)) {
                    bl4 = true;
                    break;
                }
                cons2 = cons2.rest;
            }
            bl3 = bl4;
        }
        if (!bl3) {
            boolean bl5 = bl3 = bl2 && Proposition.allVariablesUnboundP((Proposition)stella_Object);
        }
        if (bl3) {
            ControlFrame controlFrame2 = ControlFrame.createDownFrame(controlFrame, (Proposition)stella_Object);
            ControlFrame.setFrameTruthValue(controlFrame2, Logic.UNKNOWN_TRUTH_VALUE);
            if (controlFrame2.partialMatchFrame == null) {
                ControlFrame.createAndLinkPartialMatchFrame(controlFrame2, null);
            }
            controlFrame2.partialMatchFrame.setFramePartialTruth(Logic.UNKNOWN_TRUTH_VALUE, 0.0, Double.NEGATIVE_INFINITY, true);
            object = PrimitiveStrategy.newPrimitiveStrategy();
            object.inferenceRule = Logic.KWD_SKIPPED_CONJUNCT;
            object.strategy = Logic.KWD_FAILURE;
            ControlFrame.recordGoalJustification(controlFrame2, (Justification)((Object)object));
            controlFrame2.state = Logic.KWD_POPPED;
            ((Vector)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ARGUMENTS, null)).theArray[controlFrame.argumentCursor] = controlFrame2;
            controlFrame.result = controlFrame2;
            if (Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_GOAL_TREE)) {
                System.out.println("*** Skipping clause " + stella_Object);
            }
            return true;
        }
        return false;
    }

    public double computeAndScore() {
        IncrementalPartialMatch incrementalPartialMatch = this;
        return incrementalPartialMatch.accumulatedScore / incrementalPartialMatch.totalWeight;
    }

    public void popAndPartialMatchScore() {
        IncrementalPartialMatch incrementalPartialMatch = this;
        incrementalPartialMatch.accumulatedScore -= ((FloatWrapper)incrementalPartialMatch.argumentScores.value).wrapperValue * ((FloatWrapper)incrementalPartialMatch.argumentWeights.value).wrapperValue;
        incrementalPartialMatch.accumulatedWeight -= ((FloatWrapper)incrementalPartialMatch.argumentWeights.value).wrapperValue;
        incrementalPartialMatch.argumentScores = incrementalPartialMatch.argumentScores.rest;
        incrementalPartialMatch.argumentWeights = incrementalPartialMatch.argumentWeights.rest;
    }

    public void pushAndPartialMatchScore(double d, double d2) {
        IncrementalPartialMatch incrementalPartialMatch = this;
        if (d2 == Double.NEGATIVE_INFINITY) {
            d2 = 1.0;
        }
        incrementalPartialMatch.argumentScores = Stella_Object.cons((Stella_Object)FloatWrapper.wrapFloat((double)d), (Cons)incrementalPartialMatch.argumentScores);
        incrementalPartialMatch.argumentWeights = Stella_Object.cons((Stella_Object)FloatWrapper.wrapFloat((double)d2), (Cons)incrementalPartialMatch.argumentWeights);
        incrementalPartialMatch.accumulatedScore += d * d2;
        incrementalPartialMatch.accumulatedWeight += d2;
    }

    public double propositionWeight(Proposition proposition) {
        IncrementalPartialMatch incrementalPartialMatch = this;
        if (proposition == null) {
            return 1.0;
        }
        if (BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)proposition.variableTypeP())) {
            return 0.0;
        }
        if (Proposition.auxiliaryEquivalencePropositionP(proposition)) {
            return 0.0;
        }
        if (((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_WEIGHT, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue != Double.NEGATIVE_INFINITY) {
            return ((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_WEIGHT, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue;
        }
        if ((TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false) != null) {
            return ((TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false)).positiveScore;
        }
        return 1.0;
    }

    public void clearFramePartialTruth() {
        IncrementalPartialMatch incrementalPartialMatch = this;
        incrementalPartialMatch.positiveScore = Double.NEGATIVE_INFINITY;
        incrementalPartialMatch.negativeScore = Double.NEGATIVE_INFINITY;
        incrementalPartialMatch.maximumScore = 0.0;
    }

    public double computeDynamicCutoff() {
        IncrementalPartialMatch incrementalPartialMatch = this;
        IncrementalPartialMatch incrementalPartialMatch2 = (IncrementalPartialMatch)incrementalPartialMatch.parent;
        double d = 0.0;
        if (incrementalPartialMatch2 != null) {
            if (incrementalPartialMatch2.kind == Logic.KWD_AND) {
                double d2 = incrementalPartialMatch2.dynamicCutoff;
                double d3 = incrementalPartialMatch2.totalWeight;
                double d4 = incrementalPartialMatch.propositionWeight(incrementalPartialMatch.controlFrame.proposition);
                double d5 = d4 == Double.NEGATIVE_INFINITY ? 1.0 : (d4 < 0.1 ? 0.1 : d4);
                double d6 = d3 - incrementalPartialMatch2.accumulatedWeight - d5;
                double d7 = d2 * d3 - incrementalPartialMatch2.accumulatedScore - d6;
                d = d7 / d5;
            } else {
                d = incrementalPartialMatch2.dynamicCutoff;
            }
            if (d < 0.0 && !incrementalPartialMatch.controlFrame.reversePolarityP) {
                d = 0.0;
            } else if (d > 0.0 && incrementalPartialMatch.controlFrame.reversePolarityP) {
                d = 0.0;
            } else if (incrementalPartialMatch.controlFrame.reversePolarityP != incrementalPartialMatch2.controlFrame.reversePolarityP) {
                d = 0.0 - d;
            }
        }
        return d;
    }

    public PartialMatchFrame createPartialMatchFrame(ControlFrame controlFrame, Keyword keyword) {
        IncrementalPartialMatch incrementalPartialMatch = this;
        return IncrementalPartialMatch.newIncrementalPartialMatch(keyword, controlFrame);
    }

    public static void initializeIncrementalPartialMatch(IncrementalPartialMatch incrementalPartialMatch) {
        ControlFrame controlFrame = incrementalPartialMatch.controlFrame;
        Keyword keyword = incrementalPartialMatch.kind;
        if (keyword == Logic.KWD_AND) {
            double d = Double.NEGATIVE_INFINITY;
            double d2 = 0.0;
            int n = 0;
            Proposition proposition = null;
            Vector vector = controlFrame.proposition.arguments;
            int n2 = vector.length();
            for (int i = 0; i < n2; ++i) {
                proposition = (Proposition)vector.theArray[i];
                if (proposition.kind == Logic.KWD_AND && ((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_WEIGHT, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue == Double.NEGATIVE_INFINITY) {
                    n = 0;
                    Proposition proposition2 = null;
                    Vector vector2 = proposition.arguments;
                    int n3 = vector2.length();
                    for (int j = 0; j < n3; ++j) {
                        proposition2 = (Proposition)vector2.theArray[j];
                        if (incrementalPartialMatch.propositionWeight(proposition2) != Double.NEGATIVE_INFINITY && !(incrementalPartialMatch.propositionWeight(proposition2) > 0.0)) continue;
                        ++n;
                    }
                    d = 1.0 * (double)n;
                    KeyValueList.setDynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_WEIGHT, (Stella_Object)FloatWrapper.wrapFloat((double)d), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
                } else {
                    d = incrementalPartialMatch.propositionWeight(proposition);
                }
                d2 += d;
            }
            incrementalPartialMatch.totalWeight = d2 > 0.0 ? d2 : (double)controlFrame.proposition.arguments.length();
        }
        PartialMatchFrame.linkToParentPartialMatchFrame(incrementalPartialMatch);
    }

    public static Stella_Object accessIncrementalPartialMatchSlotValue(IncrementalPartialMatch incrementalPartialMatch, Symbol symbol, Stella_Object object, boolean bl) {
        if (symbol == Logic.SYM_LOGIC_PARENT) {
            if (bl) {
                incrementalPartialMatch.parent = (IncrementalPartialMatch)((Object)object);
            } else {
                object = (IncrementalPartialMatch)incrementalPartialMatch.parent;
            }
        } else if (symbol == Logic.SYM_LOGIC_CHILD) {
            if (bl) {
                incrementalPartialMatch.child = (IncrementalPartialMatch)((Object)object);
            } else {
                object = (IncrementalPartialMatch)incrementalPartialMatch.child;
            }
        } else if (symbol == Logic.SYM_LOGIC_ACCUMULATED_SCORE) {
            if (bl) {
                incrementalPartialMatch.accumulatedScore = ((FloatWrapper)object).wrapperValue;
            } else {
                object = FloatWrapper.wrapFloat((double)incrementalPartialMatch.accumulatedScore);
            }
        } else if (symbol == Logic.SYM_LOGIC_ACCUMULATED_WEIGHT) {
            if (bl) {
                incrementalPartialMatch.accumulatedWeight = ((FloatWrapper)object).wrapperValue;
            } else {
                object = FloatWrapper.wrapFloat((double)incrementalPartialMatch.accumulatedWeight);
            }
        } else if (symbol == Logic.SYM_LOGIC_TOTAL_WEIGHT) {
            if (bl) {
                incrementalPartialMatch.totalWeight = ((FloatWrapper)object).wrapperValue;
            } else {
                object = FloatWrapper.wrapFloat((double)incrementalPartialMatch.totalWeight);
            }
        } else if (symbol == Logic.SYM_LOGIC_MAXIMUM_SCORE) {
            if (bl) {
                incrementalPartialMatch.maximumScore = ((FloatWrapper)object).wrapperValue;
            } else {
                object = FloatWrapper.wrapFloat((double)incrementalPartialMatch.maximumScore);
            }
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + symbol + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        return object;
    }

    public Surrogate primaryType() {
        IncrementalPartialMatch incrementalPartialMatch = this;
        return Logic.SGT_LOGIC_INCREMENTAL_PARTIAL_MATCH;
    }
}

