/*
 * Decompiled with CFR 0.152.
 */
package edu.isi.powerloom.logic;

import edu.isi.powerloom.logic.AtomicGoalCache;
import edu.isi.powerloom.logic.AtomicGoalCacheIterator;
import edu.isi.powerloom.logic.Clash;
import edu.isi.powerloom.logic.ClusteredConjunctionProofAdjunct;
import edu.isi.powerloom.logic.ConditionalAntecedentProofAdjunct;
import edu.isi.powerloom.logic.Description;
import edu.isi.powerloom.logic.FailException;
import edu.isi.powerloom.logic.ForwardGoalRecord;
import edu.isi.powerloom.logic.GoalCache;
import edu.isi.powerloom.logic.Justification;
import edu.isi.powerloom.logic.Logic;
import edu.isi.powerloom.logic.LogicObject;
import edu.isi.powerloom.logic.NamedDescription;
import edu.isi.powerloom.logic.NnPartialMatch;
import edu.isi.powerloom.logic.ParallelControlFrame;
import edu.isi.powerloom.logic.ParallelThread;
import edu.isi.powerloom.logic.PartialMatchFrame;
import edu.isi.powerloom.logic.PartialSupport;
import edu.isi.powerloom.logic.PatternRecord;
import edu.isi.powerloom.logic.PatternVariable;
import edu.isi.powerloom.logic.PrimitiveStrategy;
import edu.isi.powerloom.logic.ProofAdjunct;
import edu.isi.powerloom.logic.Proposition;
import edu.isi.powerloom.logic.QueryIterator;
import edu.isi.powerloom.logic.TruthValue;
import edu.isi.stella.BooleanVector;
import edu.isi.stella.BooleanWrapper;
import edu.isi.stella.Cons;
import edu.isi.stella.ConsIterator;
import edu.isi.stella.Context;
import edu.isi.stella.ContextSensitiveObject;
import edu.isi.stella.FloatWrapper;
import edu.isi.stella.GeneralizedSymbol;
import edu.isi.stella.IntegerVector;
import edu.isi.stella.IntegerWrapper;
import edu.isi.stella.Iterator;
import edu.isi.stella.KeyValueList;
import edu.isi.stella.Keyword;
import edu.isi.stella.List;
import edu.isi.stella.ListIterator;
import edu.isi.stella.OutputStream;
import edu.isi.stella.OutputStringStream;
import edu.isi.stella.PropertyList;
import edu.isi.stella.Slot;
import edu.isi.stella.StandardObject;
import edu.isi.stella.Stella;
import edu.isi.stella.StellaException;
import edu.isi.stella.Stella_Object;
import edu.isi.stella.StorageSlot;
import edu.isi.stella.Surrogate;
import edu.isi.stella.Symbol;
import edu.isi.stella.Vector;
import edu.isi.stella.Wrapper;
import edu.isi.stella.javalib.Native;
import java.io.PrintStream;
import java.lang.reflect.Method;

public class ControlFrame
extends StandardObject {
    public Keyword state;
    public Proposition proposition;
    public TruthValue truthValue;
    public boolean reversePolarityP;
    public int startingClockTicks;
    public int allottedClockTicks;
    public ControlFrame up;
    public ControlFrame down;
    public ControlFrame result;
    public int argumentCursor;
    public PatternRecord patternRecord;
    public PatternRecord inheritedPatternRecord;
    public int choicePointUnbindingOffset;
    public Keyword currentStrategy;
    public Cons nextStrategies;
    public PartialMatchFrame partialMatchFrame;
    public List justifications;
    public Cons goalBindings;
    public boolean cachedGoalResultP;
    public boolean dontCacheGoalFailureP;
    public KeyValueList dynamicSlots;

    public static ControlFrame newControlFrame() {
        ControlFrame controlFrame = null;
        controlFrame = new ControlFrame();
        controlFrame.dynamicSlots = KeyValueList.newKeyValueList();
        controlFrame.dontCacheGoalFailureP = false;
        controlFrame.cachedGoalResultP = false;
        controlFrame.goalBindings = null;
        controlFrame.justifications = List.newList();
        controlFrame.partialMatchFrame = null;
        controlFrame.nextStrategies = Stella.NIL;
        controlFrame.currentStrategy = null;
        controlFrame.choicePointUnbindingOffset = Integer.MIN_VALUE;
        controlFrame.inheritedPatternRecord = null;
        controlFrame.patternRecord = null;
        controlFrame.argumentCursor = 0;
        controlFrame.result = null;
        controlFrame.down = null;
        controlFrame.up = null;
        controlFrame.allottedClockTicks = Integer.MIN_VALUE;
        controlFrame.startingClockTicks = Integer.MIN_VALUE;
        controlFrame.reversePolarityP = false;
        controlFrame.truthValue = null;
        controlFrame.proposition = null;
        controlFrame.state = null;
        return controlFrame;
    }

    public static Keyword computeVarianceOrStandardDeviation(ControlFrame controlFrame, Keyword keyword, boolean bl) {
        Proposition proposition = controlFrame.proposition;
        Stella_Object stella_Object = proposition.arguments.theArray[0];
        Stella_Object stella_Object2 = Logic.argumentBoundTo(stella_Object);
        Stella_Object stella_Object3 = proposition.arguments.theArray[1];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        if (stella_Object2 != null && !Logic.logicalCollectionP(stella_Object2)) {
            System.out.println();
            System.out.println("Non list appears in second argument to 'VARIANCE or STANDARD-DEVIATION'");
            System.out.println();
            return Logic.KWD_TERMINAL_FAILURE;
        }
        List list = Logic.assertedCollectionMembers(stella_Object2, true);
        if (list.emptyP()) {
            return Logic.KWD_TERMINAL_FAILURE;
        }
        Stella_Object stella_Object4 = null;
        Cons cons = list.theConsList;
        while (cons != Stella.NIL) {
            IntegerWrapper integerWrapper;
            stella_Object4 = cons.value;
            Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object4);
            if (Surrogate.subtypeOfIntegerP((Surrogate)surrogate)) {
                integerWrapper = (IntegerWrapper)stella_Object4;
                d3 = integerWrapper.wrapperValue;
            } else if (Surrogate.subtypeOfFloatP((Surrogate)surrogate)) {
                integerWrapper = (FloatWrapper)stella_Object4;
                d3 = integerWrapper.wrapperValue;
            } else {
                ControlFrame.setFrameTruthValue(controlFrame, Logic.UNKNOWN_TRUTH_VALUE);
                return Logic.KWD_FAILURE;
            }
            d += d3;
            d2 += d3 * d3;
            ++n;
            cons = cons.rest;
        }
        switch (n) {
            case 0: {
                return Logic.KWD_TERMINAL_FAILURE;
            }
            case 1: {
                return Logic.selectTestResult(Logic.bindArgumentToValueP(stella_Object3, (Stella_Object)FloatWrapper.wrapFloat((double)0.0), true), true, controlFrame);
            }
        }
        d3 = (d2 - d * d / (double)n) / (double)(n - 1);
        if (bl) {
            d3 = Math.sqrt(d3);
        }
        return Logic.selectTestResult(Logic.bindArgumentToValueP(stella_Object3, (Stella_Object)FloatWrapper.wrapFloat((double)d3), true), true, controlFrame);
    }

    public static void createCollectDescriptionExtensionFrame(ControlFrame controlFrame, Description description) {
        ControlFrame controlFrame2 = ControlFrame.createDownFrame(controlFrame, null);
        ControlFrame.overlayWithPatternFrameP(controlFrame2, description, null);
        controlFrame2.patternRecord.collectionList = List.newList();
    }

    public static QueryIterator createQuerySpecialistIterator(ControlFrame controlFrame, Object[] objectArray) {
        Proposition proposition = null;
        PropertyList propertyList = null;
        Object object = new Object[1];
        proposition = ControlFrame.computeSubqueryOptions(controlFrame, object);
        propertyList = (PropertyList)object[0];
        object = Logic.allocateQueryIterator();
        Object object2 = null;
        Stella_Object stella_Object = null;
        boolean bl = false;
        boolean bl2 = false;
        List list = List.newList();
        Vector vector = null;
        if (proposition == null) {
            QueryIterator queryIterator = null;
            objectArray[0] = BooleanWrapper.wrapBoolean((boolean)false);
            objectArray[1] = BooleanWrapper.wrapBoolean((boolean)false);
            return queryIterator;
        }
        QueryIterator.processQueryOptions((QueryIterator)((Object)object), (Stella_Object)propertyList);
        stella_Object = Logic.lookupQueryOption((Stella_Object)object, Logic.KWD_MATCH_MODE);
        if (stella_Object != null && !Stella.stringEqualP((String)Logic.coerceToString(stella_Object), (String)"STRICT")) {
            bl2 = true;
        }
        Logic.collectFreeVariables((Stella_Object)proposition, list, Stella.list((Cons)Stella.NIL), Stella.list((Cons)Stella.NIL));
        KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_QUERY_SPECIALIST_IO_VARIABLES, (Stella_Object)list, null);
        Object object3 = Description.newDescription();
        object3.ioVariables = Logic.copyListToArgumentsVector(list);
        object3.proposition = proposition;
        object2 = object3;
        Description.computeInternalVariables((Description)((Object)object2));
        vector = Vector.newVector((int)list.length());
        bl = true;
        object3 = null;
        Cons cons = list.theConsList;
        int n = Integer.MIN_VALUE;
        int n2 = 0;
        while (cons != Stella.NIL) {
            object3 = cons.value;
            n = n2;
            vector.theArray[n] = Logic.argumentBoundTo((Stella_Object)object3);
            if (vector.theArray[n] == null) {
                bl = false;
            }
            cons = cons.rest;
            ++n2;
        }
        QueryIterator.initializeQueryIterator((QueryIterator)((Object)object), (Description)((Object)object2), vector);
        object3 = object;
        objectArray[0] = BooleanWrapper.wrapBoolean((boolean)bl);
        objectArray[1] = BooleanWrapper.wrapBoolean((boolean)bl2);
        return object3;
    }

    public List querySpecialistIoVariables() {
        ControlFrame controlFrame = this;
        List list = (List)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_QUERY_SPECIALIST_IO_VARIABLES, null);
        if (list == null) {
            return Stella.NIL_LIST;
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Proposition computeSubqueryOptions(ControlFrame controlFrame, Object[] objectArray) {
        Vector vector = controlFrame.proposition.arguments;
        Stella_Object stella_Object = null;
        Proposition proposition = null;
        int n = vector.length() - 1;
        int n2 = 1;
        Keyword keyword = null;
        Stella_Object stella_Object2 = null;
        PropertyList propertyList = PropertyList.newPropertyList();
        PropertyList propertyList2 = ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).options;
        if (n < 0) {
            Proposition proposition2 = null;
            objectArray[0] = null;
            return proposition2;
        }
        stella_Object = Logic.argumentBoundTo(vector.theArray[0]);
        if (stella_Object != null && Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_PROPOSITION)) {
            proposition = (Proposition)stella_Object;
        } else {
            if (n < 1) {
                Proposition proposition3 = null;
                objectArray[0] = null;
                return proposition3;
            }
            n2 = 0;
            keyword = Logic.KWD_HOW_MANY;
            stella_Object2 = stella_Object;
            stella_Object = Logic.argumentBoundTo(vector.theArray[1]);
            if (stella_Object != null && Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_PROPOSITION)) {
                proposition = (Proposition)stella_Object;
            } else {
                Proposition proposition4 = null;
                objectArray[0] = null;
                return proposition4;
            }
        }
        if ((n - n2) % 2 == 0) {
            --n;
        }
        block0: while (true) {
            Proposition proposition5;
            if (n2 >= n) {
                proposition5 = proposition;
                objectArray[0] = propertyList;
                return proposition5;
            }
            if (n2 != 0) {
                keyword = Logic.generateTerm(Logic.argumentBoundTo(vector.theArray[n2]));
                stella_Object2 = Logic.generateTerm(Logic.argumentBoundTo(vector.theArray[n2 + 1]));
            }
            n2 += 2;
            if (keyword == null || stella_Object2 == null) {
                proposition5 = null;
                objectArray[0] = null;
                return proposition5;
            }
            if (keyword == Logic.KWD_INHERIT) {
                if (stella_Object2 != Logic.KWD_ALL && stella_Object2 != Logic.KWD_CURRENT) continue;
                proposition5 = null;
                Stella_Object stella_Object3 = null;
                Cons cons = propertyList2.thePlist;
                while (true) {
                    if (cons == Stella.NIL) continue block0;
                    proposition5 = cons.value;
                    stella_Object3 = cons.rest.value;
                    propertyList.insertAt((Stella_Object)proposition5, stella_Object3);
                    cons = cons.rest.rest;
                }
            }
            if (stella_Object2 == Logic.KWD_INHERIT || stella_Object2 == Logic.KWD_CURRENT) {
                if (Logic.lookupQueryOption((Stella_Object)propertyList2, keyword) == null) continue;
                propertyList.insertAt((Stella_Object)keyword, Logic.lookupQueryOption((Stella_Object)propertyList2, keyword));
                continue;
            }
            propertyList.insertAt((Stella_Object)keyword, stella_Object2);
        }
    }

    public static Keyword nativeSlotReaderSpecialist(ControlFrame controlFrame, Keyword keyword) {
        Proposition proposition = controlFrame.proposition;
        NamedDescription namedDescription = Logic.getDescription((Stella_Object)((Surrogate)proposition.operator));
        Stella_Object stella_Object = Logic.argumentBoundTo(proposition.arguments.theArray[0]);
        Slot slot = !NamedDescription.classDescriptionP(namedDescription) ? (Slot)namedDescription.nativeRelation() : null;
        boolean bl = false;
        if (stella_Object != null && slot != null && Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_STELLA_THING) && !slot.abstractP) {
            Stella_Object stella_Object2 = StandardObject.readSlotValue((StandardObject)((StandardObject)stella_Object), (StorageSlot)((StorageSlot)slot));
            if (stella_Object2 == null) {
                return Logic.KWD_FAILURE;
            }
            if (!Logic.nullWrapperP(stella_Object2)) {
                bl = NamedDescription.functionDescriptionP(namedDescription) ? PatternVariable.bindVariableToValueP((PatternVariable)proposition.arguments.theArray[proposition.arguments.length() - 1], stella_Object2, true) : Stella_Object.eqlP((Stella_Object)stella_Object2, (Stella_Object)Stella.TRUE_WRAPPER);
                return Logic.selectTestResult(bl, true, controlFrame);
            }
        }
        return Logic.KWD_FAILURE;
    }

    public List allJustifications() {
        ControlFrame controlFrame = this;
        List list = (List)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ALL_JUSTIFICATIONS, null);
        if (list == null) {
            return Stella.NIL_LIST;
        }
        return list;
    }

    public static void recordExistentialIntroductionJustification(ControlFrame controlFrame, Keyword keyword) {
        ControlFrame controlFrame2 = controlFrame.result;
        if (keyword == Logic.KWD_UP_TRUE) {
            Justification justification = Justification.newJustification();
            justification.inferenceRule = Logic.KWD_EXISTENTIAL_INTRODUCTION;
            justification.antecedents = (Justification)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null) != null ? Stella_Object.cons((Stella_Object)((Justification)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null)), (Cons)Stella.NIL) : Stella.NIL;
            ControlFrame.recordGoalJustification(controlFrame, justification);
        }
    }

    public static void recordClosedNotJustification(ControlFrame controlFrame, Keyword keyword) {
        if (keyword == Logic.KWD_UP_FAIL) {
            Justification justification = Justification.newJustification();
            justification.inferenceRule = Logic.KWD_CLOSED_NOT_INTRODUCTION;
            justification.proposition = controlFrame.proposition.kind == Logic.KWD_FAIL ? controlFrame.up.proposition : controlFrame.proposition;
            ControlFrame.recordGoalJustification(controlFrame, justification);
        }
    }

    public static void recordFailJustification(ControlFrame controlFrame, Keyword keyword) {
        if (keyword == Logic.KWD_UP_FAIL) {
            Justification justification = Justification.newJustification();
            justification.inferenceRule = Logic.KWD_FAIL_INTRODUCTION;
            ControlFrame.recordGoalJustification(controlFrame, justification);
        }
    }

    public static void recordDisproofJustification(ControlFrame controlFrame, Keyword keyword) {
        ControlFrame controlFrame2 = controlFrame.result;
        if (keyword == Logic.KWD_UP_TRUE || keyword == Logic.KWD_UP_FAIL) {
            Justification justification = Justification.newJustification();
            justification.inferenceRule = Logic.KWD_DISPROOF;
            justification.antecedents = Stella_Object.cons((Stella_Object)((Justification)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null)), (Cons)Stella.NIL);
            ControlFrame.recordGoalJustification(controlFrame, justification);
        }
    }

    public static void recordOrIntroductionJustification(ControlFrame controlFrame, Keyword keyword) {
        ControlFrame controlFrame2 = controlFrame.result;
        if (keyword == Logic.KWD_UP_TRUE) {
            Justification justification = Justification.newJustification();
            justification.inferenceRule = Logic.KWD_OR_INTRODUCTION;
            justification.antecedents = Stella_Object.cons((Stella_Object)((Justification)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null)), (Cons)Stella.NIL);
            ControlFrame.recordGoalJustification(controlFrame, justification);
        }
    }

    public static void recordAndIntroductionJustification(ControlFrame controlFrame, Keyword keyword) {
        Vector vector = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ARGUMENTS, null);
        Cons cons = Stella.NIL;
        if (keyword == Logic.KWD_UP_TRUE) {
            StandardObject standardObject = null;
            Vector vector2 = vector;
            int n = vector2.length();
            Cons cons2 = null;
            for (int i = 0; i < n; ++i) {
                standardObject = (ControlFrame)vector2.theArray[i];
                if (cons2 == null) {
                    cons2 = Stella_Object.cons((Stella_Object)(standardObject.state == Logic.KWD_POPPED ? ((Justification)KeyValueList.dynamicSlotValue((KeyValueList)standardObject.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null)).copy() : (Justification)KeyValueList.dynamicSlotValue((KeyValueList)standardObject.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null)), (Cons)Stella.NIL);
                    if (cons == Stella.NIL) {
                        cons = cons2;
                        continue;
                    }
                    Cons.addConsToEndOfConsList((Cons)cons, (Cons)cons2);
                    continue;
                }
                cons2 = cons2.rest = Stella_Object.cons((Stella_Object)(standardObject.state == Logic.KWD_POPPED ? ((Justification)KeyValueList.dynamicSlotValue((KeyValueList)standardObject.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null)).copy() : (Justification)KeyValueList.dynamicSlotValue((KeyValueList)standardObject.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null)), (Cons)Stella.NIL);
            }
            standardObject = Justification.newJustification();
            standardObject.inferenceRule = Logic.KWD_AND_INTRODUCTION;
            standardObject.antecedents = cons;
            ControlFrame.recordGoalJustification(controlFrame, (Justification)standardObject);
        }
    }

    public static void recordModusPonensJustification(ControlFrame controlFrame, Keyword keyword) {
        ControlFrame controlFrame2 = controlFrame.result;
        if (keyword == Logic.KWD_UP_TRUE) {
            Proposition proposition = ControlFrame.extractSubgoalOfFrame(controlFrame);
            boolean bl = controlFrame.reversePolarityP;
            Keyword keyword2 = bl ? Logic.KWD_MODUS_TOLLENS : Logic.KWD_MODUS_PONENS;
            Proposition proposition2 = (Proposition)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANTECEDENTS_RULE, null);
            Proposition proposition3 = ((Description)(keyword2 == Logic.KWD_MODUS_PONENS ? proposition2.arguments.theArray[1] : proposition2.arguments.theArray[0])).proposition;
            boolean bl2 = proposition3.kind == Logic.KWD_NOT;
            Justification justification = Justification.newJustification();
            justification.inferenceRule = keyword2;
            justification.proposition = proposition;
            Justification justification2 = PrimitiveStrategy.newPrimitiveStrategy();
            justification2.strategy = Logic.KWD_SCAN_PROPOSITIONS;
            justification2.proposition = proposition2;
            justification2.truthValue = (TruthValue)Stella_Object.accessInContext((Stella_Object)proposition2.truthValue, (Context)proposition2.homeContext, (boolean)false);
            justification2.positiveScore = ((TruthValue)Stella_Object.accessInContext((Stella_Object)proposition2.truthValue, (Context)proposition2.homeContext, (boolean)false)).positiveScore;
            justification.antecedents = Stella_Object.cons((Stella_Object)justification2, (Cons)Stella_Object.cons((Stella_Object)((Justification)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null)), (Cons)Stella.NIL));
            justification2 = justification;
            ControlFrame.recordGoalJustification(controlFrame, justification2);
            justification2.reversePolarityP = bl ? !bl2 : bl2;
        }
    }

    public static void recordPatternJustification(ControlFrame controlFrame, Keyword keyword) {
        ControlFrame controlFrame2 = controlFrame.result;
        if (keyword == Logic.KWD_UP_TRUE || keyword == Logic.KWD_UP_FAIL) {
            if ((Justification)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null) == null) {
                return;
            }
            Justification justification = Justification.newJustification();
            justification.inferenceRule = Logic.KWD_PATTERN;
            justification.antecedents = Stella_Object.cons((Stella_Object)((Justification)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null)), (Cons)Stella.NIL);
            ControlFrame.recordGoalJustification(controlFrame, justification);
            Justification.backlinkToPatternJustification((Justification)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null), (Justification)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null));
            justification = KeyValueList.newKeyValueList();
            PatternRecord patternRecord = controlFrame.patternRecord;
            Description description = null;
            if (patternRecord != null && Surrogate.subtypeOfP((Surrogate)Stella_Object.safePrimaryType((Stella_Object)patternRecord), (Surrogate)Logic.SGT_LOGIC_PATTERN_RECORD)) {
                PatternRecord patternRecord2 = patternRecord;
                description = patternRecord2.optimalPattern;
                if (description != null) {
                    int n;
                    PatternVariable patternVariable = null;
                    Vector vector = description.ioVariables;
                    int n2 = vector.length();
                    for (n = 0; n < n2; ++n) {
                        patternVariable = (PatternVariable)vector.theArray[n];
                        justification.insertAt((Stella_Object)patternVariable, ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord.variableBindings.theArray[patternVariable.boundToOffset]);
                    }
                    patternVariable = null;
                    vector = description.internalVariables;
                    n2 = vector.length();
                    for (n = 0; n < n2; ++n) {
                        patternVariable = (PatternVariable)vector.theArray[n];
                        justification.insertAt((Stella_Object)patternVariable, ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord.variableBindings.theArray[patternVariable.boundToOffset]);
                    }
                }
            }
            if (Stella_Object.isaP((Stella_Object)justification, (Surrogate)Logic.SGT_STELLA_KEY_VALUE_LIST)) {
                justification = justification.reverse();
            }
            ((Justification)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null)).substitution = justification;
        }
    }

    public static void recordPrimitiveJustification(ControlFrame controlFrame, Keyword keyword) {
        if (keyword == Logic.KWD_UP_TRUE || keyword == Logic.KWD_UP_FAIL) {
            Cons cons = controlFrame.result != null && (Justification)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.result.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null) != null ? Stella_Object.cons((Stella_Object)((Justification)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.result.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null)), (Cons)Stella.NIL) : Stella.NIL;
            PrimitiveStrategy primitiveStrategy = PrimitiveStrategy.newPrimitiveStrategy();
            primitiveStrategy.strategy = keyword == Logic.KWD_UP_FAIL ? Logic.KWD_FAILURE : controlFrame.currentStrategy;
            primitiveStrategy.antecedents = cons;
            ControlFrame.recordGoalJustification(controlFrame, primitiveStrategy);
        }
    }

    public static void recordGoalJustification(ControlFrame controlFrame, Justification justification) {
        if (justification.proposition == null) {
            justification.proposition = controlFrame.proposition;
        }
        justification.reversePolarityP = controlFrame.reversePolarityP;
        justification.truthValue = controlFrame.truthValue;
        if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null) {
            controlFrame.setJustificationPartialTruth(justification);
        }
        KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, (Stella_Object)justification, null);
    }

    public Keyword continuePartialFailProof(Keyword keyword) {
        ControlFrame controlFrame = this;
        PartialMatchFrame partialMatchFrame = controlFrame.partialMatchFrame;
        if (partialMatchFrame == null) {
            ControlFrame.createAndLinkPartialMatchFrame(controlFrame, Logic.KWD_FAIL);
        }
        return controlFrame.partialMatchFrame.continuePartialFailProof(keyword);
    }

    public static Keyword continueFailProof(ControlFrame controlFrame, Keyword keyword) {
        if (controlFrame.reversePolarityP) {
            throw (StellaException)StellaException.newStellaException((String)":FAIL not implemented for negative polarity.").fillInStackTrace();
        }
        if (keyword == Logic.KWD_DOWN) {
            ControlFrame.createChoicePoint(controlFrame);
            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_INFERENCE_CUTOFF_REASON, null, null);
            return Logic.KWD_MOVE_DOWN;
        }
        if (keyword == Logic.KWD_UP_TRUE) {
            ControlFrame.setFrameTruthValue(controlFrame, Logic.FALSE_TRUTH_VALUE);
            PatternRecord.unbindVariablesBeginningAt(((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord, controlFrame.choicePointUnbindingOffset);
            if (controlFrame.down != null) {
                ControlFrame.popFramesUpTo(controlFrame.down);
            }
            return Logic.KWD_FAILURE;
        }
        if (keyword == Logic.KWD_UP_FAIL) {
            Keyword keyword2 = Logic.KWD_FINAL_SUCCESS;
            if ((Keyword)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_INFERENCE_CUTOFF_REASON, null) != null) {
                ControlFrame.setFrameTruthValue(controlFrame, Logic.UNKNOWN_TRUTH_VALUE);
                keyword2 = Logic.KWD_FAILURE;
            } else {
                ControlFrame.setFrameTruthValue(controlFrame, Logic.TRUE_TRUTH_VALUE);
                if (((Boolean)Logic.$RECORD_JUSTIFICATIONSp$.get()).booleanValue()) {
                    if (controlFrame.up.proposition.kind == Logic.KWD_NOT) {
                        ControlFrame.recordClosedNotJustification(controlFrame, keyword);
                    } else {
                        ControlFrame.recordFailJustification(controlFrame, keyword);
                    }
                }
            }
            PatternRecord.unbindVariablesBeginningAt(((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord, controlFrame.choicePointUnbindingOffset);
            return keyword2;
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    public static void registerInferenceCutoff(ControlFrame controlFrame, Keyword keyword) {
        while (controlFrame != null) {
            if (controlFrame.state == Logic.KWD_FAIL) {
                KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_INFERENCE_CUTOFF_REASON, (Stella_Object)keyword, null);
            }
            controlFrame = controlFrame.up;
        }
    }

    public static Keyword continueConstantProof(ControlFrame controlFrame, Keyword keyword) {
        Proposition proposition = controlFrame.proposition;
        controlFrame.truthValue = (TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false);
        if (((Boolean)Logic.$RECORD_JUSTIFICATIONSp$.get()).booleanValue() && (Justification)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null) == null) {
            PrimitiveStrategy primitiveStrategy = PrimitiveStrategy.newPrimitiveStrategy();
            primitiveStrategy.strategy = Logic.KWD_CONSTANT_PROPOSITION;
            ControlFrame.recordGoalJustification(controlFrame, primitiveStrategy);
        }
        if (controlFrame.reversePolarityP) {
            if (Proposition.falseP(proposition)) {
                return Logic.KWD_FINAL_SUCCESS;
            }
            return Logic.KWD_FAILURE;
        }
        if (Proposition.trueP(proposition)) {
            return Logic.KWD_FINAL_SUCCESS;
        }
        return Logic.KWD_FAILURE;
    }

    public static Keyword continueExistsProof(ControlFrame controlFrame, Keyword keyword) {
        if (keyword == Logic.KWD_DOWN) {
            return Logic.KWD_MOVE_DOWN;
        }
        if (keyword == Logic.KWD_UP_TRUE) {
            ControlFrame controlFrame2 = controlFrame.result;
            if (controlFrame2.partialMatchFrame != null) {
                controlFrame2.partialMatchFrame.propagateFramePartialTruth(controlFrame);
            }
            ControlFrame.propagateFrameTruthValue(controlFrame2, controlFrame);
            if (((Boolean)Logic.$RECORD_JUSTIFICATIONSp$.get()).booleanValue()) {
                ControlFrame.recordExistentialIntroductionJustification(controlFrame, keyword);
            }
            if (controlFrame.down == null) {
                return Logic.KWD_FINAL_SUCCESS;
            }
            return Logic.KWD_CONTINUING_SUCCESS;
        }
        if (keyword == Logic.KWD_UP_FAIL) {
            ControlFrame controlFrame3 = controlFrame.result;
            if (controlFrame3.partialMatchFrame != null) {
                controlFrame3.partialMatchFrame.propagateFramePartialTruth(controlFrame);
            }
            ControlFrame.propagateFrameTruthValue(controlFrame3, controlFrame);
            if (controlFrame.down == null) {
                return Logic.KWD_FAILURE;
            }
            throw (StellaException)StellaException.newStellaException((String)"Failed subgoal of 'exists' didn't remove itself from stack.").fillInStackTrace();
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    public static Keyword continueForallProof(ControlFrame controlFrame, Keyword keyword) {
        boolean bl = false;
        if (controlFrame.reversePolarityP) {
            bl = true;
        } else {
            boolean bl2 = true;
            PatternVariable patternVariable = null;
            Vector vector = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
            int n = vector.length();
            for (int i = 0; i < n; ++i) {
                patternVariable = (PatternVariable)vector.theArray[i];
                if (Logic.closedTermP((Stella_Object)Logic.getDescription((Stella_Object)Logic.logicalType((Stella_Object)patternVariable)))) continue;
                bl2 = false;
                break;
            }
            bl = bl2;
        }
        if (bl) {
            controlFrame.state = Logic.KWD_ITERATIVE_FORALL;
            return Logic.KWD_MOVE_IN_PLACE;
        }
        Keyword keyword2 = Logic.currentInferenceLevel().keyword;
        if (keyword2 == Logic.KWD_NORMAL || keyword2 == Logic.KWD_REFUTATION) {
            ControlFrame.overlayWithStrategyFrame(controlFrame, Logic.KWD_UNIVERSAL_INTRODUCTION);
            return Logic.KWD_MOVE_IN_PLACE;
        }
        return Logic.KWD_FAILURE;
    }

    public static Keyword tryRefutationProof(ControlFrame controlFrame) {
        ParallelThread parallelThread = ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentParallelThread;
        ParallelControlFrame parallelControlFrame = (ParallelControlFrame)parallelThread.topControlFrame.up;
        if (parallelControlFrame.unboundVariablesP) {
            return Logic.KWD_FAILURE;
        }
        ParallelControlFrame.enterHypotheticalWorld(parallelControlFrame);
        try {
            boolean bl = controlFrame.reversePolarityP;
            Proposition proposition = null;
            Cons cons = Proposition.inheritAsTopLevelProposition(controlFrame.proposition, null);
            while (cons != Stella.NIL) {
                proposition = (Proposition)cons.value;
                if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_GOAL_TREE)) {
                    System.out.println();
                    System.out.println("  Assume that " + (Object)((Object)proposition) + " is " + (bl ? "true" : "false") + ".");
                }
                Proposition.recursivelyFastenDownPropositions(proposition, false);
                Proposition.assignTruthValue(proposition, (Stella_Object)(bl ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER));
                cons = cons.rest;
            }
        }
        catch (Clash clash) {
            return Logic.KWD_FINAL_SUCCESS;
        }
        return Logic.KWD_FAILURE;
    }

    public static Keyword tryUniversalIntroductionProof(ControlFrame controlFrame) {
        ParallelThread parallelThread = ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentParallelThread;
        ParallelControlFrame parallelControlFrame = (ParallelControlFrame)parallelThread.topControlFrame.up;
        ParallelControlFrame.enterHypotheticalWorld(parallelControlFrame);
        Proposition proposition = controlFrame.proposition;
        Stella_Object stella_Object = proposition.arguments.theArray[0];
        Stella_Object stella_Object2 = proposition.arguments.theArray[1];
        ContextSensitiveObject contextSensitiveObject = null;
        Vector vector = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_IO_VARIABLES, null);
        int n = vector.length();
        for (int i = 0; i < n; ++i) {
            contextSensitiveObject = (PatternVariable)vector.theArray[i];
            LogicObject logicObject = Logic.createHypothesizedInstance("anonymous");
            if (contextSensitiveObject.skolemType != null) {
                Logic.assertMemberOfProposition((Stella_Object)logicObject, (Stella_Object)Logic.getDescription((Stella_Object)contextSensitiveObject.skolemType));
            }
            PatternVariable.bindVariableToValueP((PatternVariable)contextSensitiveObject, (Stella_Object)logicObject, false);
        }
        try {
            contextSensitiveObject = null;
            vector = Proposition.inheritAsTopLevelProposition((Proposition)stella_Object, null);
            while (vector != Stella.NIL) {
                contextSensitiveObject = (Proposition)vector.value;
                Proposition.recursivelyFastenDownPropositions((Proposition)contextSensitiveObject, false);
                Proposition.assignTruthValue((Proposition)contextSensitiveObject, (Stella_Object)Stella.TRUE_WRAPPER);
                vector = vector.rest;
            }
        }
        catch (Clash clash) {
            return Logic.KWD_FINAL_SUCCESS;
        }
        ControlFrame.createDownFrame(controlFrame, (Proposition)stella_Object2);
        return Logic.KWD_MOVE_DOWN;
    }

    public static Keyword tryDisjunctiveImplicationProof(ControlFrame controlFrame) {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        Proposition proposition;
        ParallelThread parallelThread = ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentParallelThread;
        ParallelControlFrame parallelControlFrame = (ParallelControlFrame)parallelThread.topControlFrame.up;
        Proposition proposition2 = controlFrame.proposition;
        Vector vector = proposition2.arguments;
        Proposition proposition3 = (Proposition)vector.theArray[0];
        if (parallelControlFrame.unboundVariablesP) {
            proposition3 = null;
            proposition = null;
            object = vector;
            n4 = object.length();
            for (n3 = 0; n3 < n4; ++n3) {
                proposition = (Proposition)object.theArray[n3];
                if (Proposition.allArgumentsBoundP(proposition)) continue;
                if (proposition3 != null) {
                    return Logic.KWD_FAILURE;
                }
                proposition3 = proposition;
            }
        } else {
            proposition = null;
            object = vector;
            n4 = object.length();
            for (n3 = 0; n3 < n4; ++n3) {
                proposition = (Proposition)object.theArray[n3];
                if (proposition.kind == Logic.KWD_NOT) continue;
                proposition3 = proposition;
                break;
            }
        }
        ParallelControlFrame.enterHypotheticalWorld(parallelControlFrame);
        try {
            boolean bl = controlFrame.reversePolarityP;
            object = null;
            Proposition proposition4 = null;
            Vector vector2 = vector;
            n2 = vector2.length();
            for (n = 0; n < n2; ++n) {
                proposition4 = (Proposition)vector2.theArray[n];
                if (proposition4 == proposition3) continue;
                object = Proposition.recursivelyFastenDownPropositions(!bl ? Proposition.inheritProposition(proposition4, KeyValueList.newKeyValueList()) : Logic.conjoinPropositions(Proposition.inheritAsTopLevelProposition(proposition4, KeyValueList.newKeyValueList())), false);
                if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_GOAL_TREE)) {
                    System.out.println();
                    System.out.println("  Assume that " + object + " is " + (bl ? "true" : "false") + ".");
                    System.out.println();
                }
                Proposition.assignTruthValue((Proposition)((Object)object), (Stella_Object)(bl ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER));
            }
        }
        catch (Clash clash) {
            return Logic.KWD_FINAL_SUCCESS;
        }
        Proposition proposition5 = null;
        object = vector;
        int n5 = object.length();
        n = Integer.MIN_VALUE;
        n2 = 0;
        for (int i = 0; i < n5; ++i) {
            proposition5 = (Proposition)object.theArray[i];
            n = n2++;
            if (proposition5 != proposition3) continue;
            controlFrame.argumentCursor = n;
            break;
        }
        return Logic.KWD_MOVE_DOWN;
    }

    public static Keyword continueClusteredConjunctionProof(ControlFrame controlFrame, Keyword keyword) {
        Keyword keyword2 = controlFrame.state;
        ClusteredConjunctionProofAdjunct clusteredConjunctionProofAdjunct = (ClusteredConjunctionProofAdjunct)((ProofAdjunct)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_PROOF_ADJUNCT, null));
        Proposition proposition = controlFrame.proposition;
        Vector vector = proposition.arguments;
        int n = vector.length();
        ControlFrame controlFrame2 = null;
        if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null) {
            controlFrame.state = Logic.KWD_AND;
            keyword = ControlFrame.oldInterpretAndScores(controlFrame, keyword);
            controlFrame.state = keyword2;
        }
        if (keyword == Logic.KWD_DOWN) {
            if (clusteredConjunctionProofAdjunct == null) {
                ClusteredConjunctionProofAdjunct clusteredConjunctionProofAdjunct2 = ClusteredConjunctionProofAdjunct.newClusteredConjunctionProofAdjunct();
                clusteredConjunctionProofAdjunct2.clusterFrames = Vector.newVector((int)n);
                clusteredConjunctionProofAdjunct = clusteredConjunctionProofAdjunct2;
                KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_PROOF_ADJUNCT, (Stella_Object)clusteredConjunctionProofAdjunct, null);
            }
            if ((controlFrame2 = (ControlFrame)clusteredConjunctionProofAdjunct.clusterFrames.theArray[controlFrame.argumentCursor]) == null) {
                ControlFrame.createSubgoalFrame(controlFrame, (Proposition)vector.theArray[controlFrame.argumentCursor], null);
            } else {
                controlFrame.down = controlFrame2;
            }
            return Logic.KWD_MOVE_DOWN;
        }
        if (keyword == Logic.KWD_UP_TRUE) {
            TruthValue truthValue = controlFrame.truthValue = controlFrame.truthValue == null ? controlFrame.result.truthValue : TruthValue.conjoinTruthValues(controlFrame.truthValue, controlFrame.result.truthValue);
            if (((Boolean)Logic.$RECORD_JUSTIFICATIONSp$.get()).booleanValue()) {
                ControlFrame.recordAndIntroductionJustification(controlFrame, keyword);
            }
            clusteredConjunctionProofAdjunct.clusterFrames.theArray[controlFrame.argumentCursor] = controlFrame.down;
            if (controlFrame.argumentCursor + 1 == n) {
                boolean bl;
                int n2 = Integer.MIN_VALUE;
                int n3 = 1;
                int n4 = n;
                boolean bl2 = bl = n4 == Integer.MIN_VALUE;
                while (bl || n3 <= n4) {
                    if ((ControlFrame)clusteredConjunctionProofAdjunct.clusterFrames.theArray[n - (n2 = n3++)] == null) continue;
                    controlFrame.argumentCursor = n - n2;
                    controlFrame.down = (ControlFrame)clusteredConjunctionProofAdjunct.clusterFrames.theArray[controlFrame.argumentCursor];
                    return Logic.KWD_CONTINUING_SUCCESS;
                }
                controlFrame.down = null;
                return Logic.KWD_FINAL_SUCCESS;
            }
            ++controlFrame.argumentCursor;
            controlFrame2 = (ControlFrame)clusteredConjunctionProofAdjunct.clusterFrames.theArray[controlFrame.argumentCursor];
            if (controlFrame2 == null) {
                ControlFrame.createSubgoalFrame(controlFrame, (Proposition)vector.theArray[controlFrame.argumentCursor], null);
            } else {
                controlFrame.down = controlFrame2;
            }
            return Logic.KWD_MOVE_DOWN;
        }
        if (keyword == Logic.KWD_UP_FAIL) {
            boolean bl;
            Keyword keyword3;
            if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null) {
                controlFrame.down = null;
                ControlFrame.setFrameTruthValue(controlFrame, null);
                return Logic.KWD_TERMINAL_FAILURE;
            }
            if ((ControlFrame)clusteredConjunctionProofAdjunct.clusterFrames.theArray[controlFrame.argumentCursor] == null && ((keyword3 = ((Proposition)vector.theArray[controlFrame.argumentCursor]).kind) == Logic.KWD_AND || keyword3 == Logic.KWD_FUNCTION || keyword3 == Logic.KWD_PREDICATE || keyword3 == Logic.KWD_IMPLIES)) {
                controlFrame.down = null;
                ControlFrame.setFrameTruthValue(controlFrame, null);
                return Logic.KWD_TERMINAL_FAILURE;
            }
            clusteredConjunctionProofAdjunct.clusterFrames.theArray[controlFrame.argumentCursor] = null;
            int n5 = Integer.MIN_VALUE;
            int n6 = 1;
            int n7 = controlFrame.argumentCursor;
            boolean bl3 = bl = n7 == Integer.MIN_VALUE;
            while (bl || n6 <= n7) {
                if ((ControlFrame)clusteredConjunctionProofAdjunct.clusterFrames.theArray[controlFrame.argumentCursor - (n5 = n6++)] == null) continue;
                controlFrame.argumentCursor -= n5;
                controlFrame.down = (ControlFrame)clusteredConjunctionProofAdjunct.clusterFrames.theArray[controlFrame.argumentCursor];
                return Logic.KWD_MOVE_DOWN;
            }
            controlFrame.down = null;
            ControlFrame.setFrameTruthValue(controlFrame, null);
            return Logic.KWD_TERMINAL_FAILURE;
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    public static Keyword tryEquivalenceProof(ControlFrame controlFrame) {
        Vector vector = controlFrame.proposition.arguments;
        Stella_Object stella_Object = vector.theArray[0];
        Stella_Object stella_Object2 = Logic.argumentBoundTo(stella_Object);
        Stella_Object stella_Object3 = vector.theArray[1];
        Stella_Object stella_Object4 = Logic.argumentBoundTo(stella_Object3);
        boolean bl = false;
        if (controlFrame.reversePolarityP) {
            if (stella_Object2 == null || stella_Object4 == null) {
                return Logic.KWD_FAILURE;
            }
            if (Logic.skolemP(stella_Object2) || Logic.skolemP(stella_Object4)) {
                return Logic.KWD_FAILURE;
            }
            if (Stella_Object.eqlP((Stella_Object)stella_Object2, (Stella_Object)stella_Object4)) {
                ControlFrame.setFrameTruthValue(controlFrame, Logic.FALSE_TRUTH_VALUE);
                return Logic.KWD_TERMINAL_FAILURE;
            }
            ControlFrame.setFrameTruthValue(controlFrame, Logic.TRUE_TRUTH_VALUE);
            return Logic.KWD_FINAL_SUCCESS;
        }
        bl = stella_Object2 != null ? (stella_Object4 != null ? Stella_Object.eqlP((Stella_Object)stella_Object2, (Stella_Object)stella_Object4) : PatternVariable.bindVariableToValueP((PatternVariable)stella_Object3, stella_Object2, true)) : (stella_Object4 != null ? PatternVariable.bindVariableToValueP((PatternVariable)stella_Object, stella_Object4, true) : false);
        return bl ? Logic.KWD_FINAL_SUCCESS : Logic.KWD_FAILURE;
    }

    public static Keyword trySubsumptionTest(ControlFrame controlFrame) {
        int n;
        int n2;
        Vector vector;
        PatternVariable patternVariable;
        boolean bl;
        Proposition proposition = controlFrame.proposition;
        Stella_Object stella_Object = proposition.arguments.theArray[0];
        Stella_Object stella_Object2 = proposition.arguments.theArray[1];
        Description description = (Description)Logic.argumentBoundTo(stella_Object);
        Description description2 = (Description)Logic.argumentBoundTo(stella_Object2);
        if (controlFrame.reversePolarityP) {
            return Logic.KWD_FAILURE;
        }
        if (description != null && (Vector)KeyValueList.dynamicSlotValue((KeyValueList)description.dynamicSlots, (Symbol)Logic.SYM_LOGIC_EXTERNAL_VARIABLES, null) != null) {
            bl = false;
            patternVariable = null;
            vector = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)description.dynamicSlots, (Symbol)Logic.SYM_LOGIC_EXTERNAL_VARIABLES, null);
            n2 = vector.length();
            for (n = 0; n < n2; ++n) {
                patternVariable = (PatternVariable)vector.theArray[n];
                if (Logic.argumentBoundP((Stella_Object)patternVariable)) continue;
                bl = true;
                break;
            }
            if (bl) {
                return Logic.KWD_FAILURE;
            }
            description = (Description)Logic.instantiateExternalBindings((Stella_Object)description);
        }
        if (description2 != null && (Vector)KeyValueList.dynamicSlotValue((KeyValueList)description2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_EXTERNAL_VARIABLES, null) != null) {
            bl = false;
            patternVariable = null;
            vector = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)description2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_EXTERNAL_VARIABLES, null);
            n2 = vector.length();
            for (n = 0; n < n2; ++n) {
                patternVariable = (PatternVariable)vector.theArray[n];
                if (Logic.argumentBoundP((Stella_Object)patternVariable)) continue;
                bl = true;
                break;
            }
            if (bl) {
                return Logic.KWD_FAILURE;
            }
            description2 = (Description)Logic.instantiateExternalBindings((Stella_Object)description2);
        }
        TruthValue truthValue = Description.descriptionSpecializesDescriptionP(description, description2);
        ControlFrame.setFrameTruthValue(controlFrame, truthValue);
        if (truthValue == Logic.TRUE_TRUTH_VALUE || truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE) {
            return Logic.KWD_FINAL_SUCCESS;
        }
        return Logic.KWD_FAILURE;
    }

    public static Keyword continueContainedByProof(ControlFrame controlFrame, Keyword keyword) {
        if (keyword == Logic.KWD_DOWN) {
            if (controlFrame.state == Logic.KWD_CONTAINED_BY) {
                ControlFrame.resetCurrentPatternRecord(controlFrame, Logic.KWD_LOCAL);
            }
            ControlFrame.createDownFrame(controlFrame, (Proposition)controlFrame.proposition.arguments.theArray[0]);
            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_BACK, (Stella_Object)controlFrame.down, null);
            return Logic.KWD_MOVE_DOWN;
        }
        if (keyword == Logic.KWD_UP_TRUE) {
            switch (controlFrame.argumentCursor) {
                case 0: {
                    controlFrame.down = null;
                    controlFrame.argumentCursor = 1;
                    return Logic.KWD_MOVE_DOWN;
                }
                case 1: {
                    if (controlFrame.down != null) {
                        ControlFrame.popFramesUpTo(controlFrame.down);
                    }
                    if (((ControlFrame)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_BACK, null)).state == Logic.KWD_POPPED) {
                        ControlFrame.setFrameTruthValue(controlFrame, Logic.TRUE_TRUTH_VALUE);
                        return Logic.KWD_FINAL_SUCCESS;
                    }
                    controlFrame.down = (ControlFrame)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_BACK, null);
                    controlFrame.argumentCursor = 0;
                    return Logic.KWD_MOVE_DOWN;
                }
            }
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + controlFrame.argumentCursor + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        if (keyword == Logic.KWD_UP_FAIL) {
            switch (controlFrame.argumentCursor) {
                case 0: {
                    ControlFrame.setFrameTruthValue(controlFrame, Logic.TRUE_TRUTH_VALUE);
                    return Logic.KWD_FINAL_SUCCESS;
                }
                case 1: {
                    ControlFrame controlFrame2 = controlFrame.up;
                    Proposition proposition = controlFrame2.proposition;
                    if (proposition.kind == Logic.KWD_IMPLIES && Logic.closedTermP(proposition.arguments.theArray[1])) {
                        ControlFrame.setFrameTruthValue(controlFrame, Logic.FALSE_TRUTH_VALUE);
                        controlFrame2.nextStrategies = Stella.NIL;
                    }
                    if (((ControlFrame)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_BACK, null)).state != Logic.KWD_POPPED) {
                        ControlFrame.popFramesUpTo((ControlFrame)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_BACK, null));
                    }
                    return Logic.KWD_FAILURE;
                }
            }
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + controlFrame.argumentCursor + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    public static Keyword tryContainedByProof(ControlFrame controlFrame) {
        Proposition proposition = controlFrame.proposition;
        Stella_Object stella_Object = Logic.argumentBoundTo(proposition.arguments.theArray[0]);
        Stella_Object stella_Object2 = Logic.argumentBoundTo(proposition.arguments.theArray[1]);
        Proposition proposition2 = Logic.createProposition(Logic.SYM_LOGIC_CONTAINED_BY, 2);
        Description description = Stella_Object.isaP((Stella_Object)stella_Object, (Surrogate)Logic.SGT_LOGIC_DESCRIPTION) ? (Description)stella_Object : (Description)stella_Object2;
        int n = description.arity();
        List list = List.newList();
        ControlFrame controlFrame2 = ControlFrame.createDownFrame(controlFrame, proposition2);
        if (controlFrame.reversePolarityP) {
            return Logic.KWD_FAILURE;
        }
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        PatternVariable patternVariable = null;
        Vector vector = description.ioVariables;
        int n4 = vector.length();
        for (int i = 0; i < n4; ++i) {
            n2 = n3++;
            patternVariable = (PatternVariable)vector.theArray[i];
            PatternVariable patternVariable2 = PatternVariable.newPatternVariable();
            patternVariable2.boundToOffset = n2;
            patternVariable2.skolemName = patternVariable.skolemName;
            patternVariable2.skolemType = patternVariable.skolemType;
            list.insertLast((Stella_Object)patternVariable2);
        }
        controlFrame2.state = Logic.KWD_CONTAINED_BY;
        controlFrame2.proposition = proposition2;
        proposition2.arguments.theArray[0] = Logic.createContainedByArgument(stella_Object, list);
        proposition2.arguments.theArray[1] = Logic.createContainedByArgument(stella_Object2, list);
        ControlFrame.createPatternRecord(controlFrame2, null, null);
        PatternRecord.activatePatternRecord(controlFrame2.patternRecord, n);
        return Logic.KWD_MOVE_DOWN;
    }

    public static Keyword tryImpliesProof(ControlFrame controlFrame) {
        Proposition proposition = controlFrame.proposition;
        Stella_Object stella_Object = proposition.arguments.theArray[0];
        Stella_Object stella_Object2 = proposition.arguments.theArray[1];
        Stella_Object stella_Object3 = Logic.argumentBoundTo(stella_Object);
        Stella_Object stella_Object4 = Logic.argumentBoundTo(stella_Object2);
        if (stella_Object3 == null || stella_Object4 == null) {
            return Logic.KWD_FAILURE;
        }
        if (!Logic.inferableDescriptionP(stella_Object3) && !Logic.inferableDescriptionP(stella_Object4) && (Logic.closedTermP(stella_Object3) || controlFrame.reversePolarityP)) {
            Keyword keyword = Logic.trySimpleContainedByProof(stella_Object3, stella_Object4, controlFrame.reversePolarityP);
            if (keyword == Logic.KWD_FINAL_SUCCESS) {
                ControlFrame.setFrameTruthValue(controlFrame, Logic.TRUE_TRUTH_VALUE);
                return Logic.KWD_FINAL_SUCCESS;
            }
            if (keyword == Logic.KWD_TERMINAL_FAILURE) {
                ControlFrame.setFrameTruthValue(controlFrame, Logic.FALSE_TRUTH_VALUE);
                return Logic.KWD_TERMINAL_FAILURE;
            }
        }
        if (Stella_Object.isaP((Stella_Object)stella_Object3, (Surrogate)Logic.SGT_LOGIC_DESCRIPTION) && Stella_Object.isaP((Stella_Object)stella_Object4, (Surrogate)Logic.SGT_LOGIC_DESCRIPTION)) {
            ControlFrame.pushNextStrategy(controlFrame, Logic.KWD_SUBSUMPTION_TEST);
        }
        if (Logic.closedTermP(stella_Object3)) {
            ControlFrame.pushNextStrategy(controlFrame, Logic.KWD_CONTAINED_BY);
        }
        return Logic.KWD_FAILURE;
    }

    public static Keyword tryScanCollectionProof(ControlFrame controlFrame) {
        Proposition proposition = controlFrame.proposition;
        Vector vector = proposition.arguments;
        Stella_Object stella_Object = vector.theArray[0];
        Iterator iterator = (Iterator)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, null);
        if (iterator == null) {
            NamedDescription namedDescription = Proposition.extractCollectionArgument(proposition);
            List list = null;
            boolean bl = Description.inferableP(namedDescription);
            list = Logic.assertedCollectionMembers((Stella_Object)namedDescription, bl);
            if (!bl) {
                NamedDescription.updateObservedCardinality(namedDescription, list.length());
            }
            if (list == null) {
                return Logic.KWD_FAILURE;
            }
            iterator = (ListIterator)list.allocateIterator();
            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, (Stella_Object)iterator, null);
        }
        while (iterator.nextP()) {
            if (!PatternVariable.bindVariableToValueP((PatternVariable)stella_Object, Logic.valueOf(iterator.value), true)) continue;
            return Logic.KWD_CONTINUING_SUCCESS;
        }
        return Logic.KWD_FAILURE;
    }

    public static Keyword tryIsaPropositionProof(ControlFrame controlFrame) {
        Object object;
        boolean bl;
        Proposition proposition = controlFrame.proposition;
        Vector vector = proposition.arguments;
        Stella_Object stella_Object = vector.theArray[0];
        Stella_Object stella_Object2 = Logic.argumentBoundTo(stella_Object);
        boolean bl2 = bl = (Boolean)Logic.$GENERATE_ALL_PROOFSp$.get() != false || (Boolean)Logic.$REVERSEPOLARITYp$.get() != false;
        if (Logic.$CYC_KLUDGES_ENABLEDp$ && !((Boolean)Logic.$REVERSEPOLARITYp$.get()).booleanValue()) {
            bl = false;
        }
        if (stella_Object2 == null) {
            return ControlFrame.tryScanCollectionProof(controlFrame);
        }
        if (Stella_Object.isaP((Stella_Object)stella_Object2, (Surrogate)Logic.SGT_STELLA_LITERAL_WRAPPER)) {
            object = (Surrogate)proposition.operator;
            boolean bl3 = Logic.logicalSubtypeOfP(Logic.logicalType(stella_Object2), object);
            if (((Boolean)Logic.$REVERSEPOLARITYp$.get()).booleanValue()) {
                boolean bl4 = bl3 = !bl3;
            }
            if (bl3) {
                return Logic.KWD_FINAL_SUCCESS;
            }
            if (!Logic.instanceHasBacklinksP(stella_Object2)) {
                return Logic.KWD_FAILURE;
            }
        }
        if (bl) {
            return ControlFrame.tryScanPropositionsProof(controlFrame);
        }
        object = Proposition.extractCollectionArgument(proposition);
        if (Logic.testIsaP(stella_Object2, object.surrogateValueInverse)) {
            return Logic.KWD_FINAL_SUCCESS;
        }
        return Logic.KWD_FAILURE;
    }

    public static Keyword tryFullSubqueryProof(ControlFrame controlFrame) {
        Vector vector;
        Description description = (Description)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTION, null);
        if (ControlFrame.overlayWithPatternFrameP(controlFrame, description, vector = ControlFrame.findExternalArgumentsForSubgoal(controlFrame))) {
            return Logic.KWD_MOVE_IN_PLACE;
        }
        if (controlFrame.partialMatchFrame == null && (QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null) {
            ControlFrame.createAndLinkPartialMatchFrame(controlFrame, Logic.KWD_ATOMIC_GOAL);
        }
        return Logic.KWD_FAILURE;
    }

    public static Keyword continueConditionalAntecedentProof(ControlFrame controlFrame, Keyword keyword) {
        ConditionalAntecedentProofAdjunct conditionalAntecedentProofAdjunct = (ConditionalAntecedentProofAdjunct)((ProofAdjunct)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_PROOF_ADJUNCT, null));
        Proposition proposition = conditionalAntecedentProofAdjunct.provableRule;
        if (keyword == Logic.KWD_DOWN) {
            ControlFrame.createSubgoalFrame(controlFrame, proposition, Logic.KWD_FORWARD_GOALS);
            return Logic.KWD_MOVE_DOWN;
        }
        if (keyword == Logic.KWD_UP_TRUE) {
            if (conditionalAntecedentProofAdjunct.phase == Logic.KWD_ORIGINAL_GOAL) {
                controlFrame.truthValue = TruthValue.weakenTruthValue(ControlFrame.propagateFrameTruthValue(controlFrame.result, controlFrame), (TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false));
                return Logic.selectProofResult(true, controlFrame.down != null, false);
            }
            Proposition.assignTruthValue(proposition, (Stella_Object)controlFrame.result.truthValue);
            ControlFrame controlFrame2 = ControlFrame.createSubgoalFrame(controlFrame, controlFrame.proposition, Logic.KWD_ANTECEDENTS);
            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, (Stella_Object)Stella.consList((Cons)Stella_Object.cons((Stella_Object)proposition, (Cons)Stella.NIL)).allocateIterator(), null);
            conditionalAntecedentProofAdjunct.phase = Logic.KWD_ORIGINAL_GOAL;
            return Logic.KWD_MOVE_DOWN;
        }
        if (keyword == Logic.KWD_UP_FAIL) {
            ControlFrame.propagateFrameTruthValue(controlFrame.result, controlFrame);
            return Logic.KWD_FAILURE;
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    public static ControlFrame createConditionalAntecedentSubframe(ControlFrame controlFrame, Proposition proposition, Proposition proposition2) {
        ControlFrame controlFrame2 = ControlFrame.createSubgoalFrame(controlFrame, proposition, Logic.KWD_CONDITIONAL_ANTECEDENT);
        ConditionalAntecedentProofAdjunct conditionalAntecedentProofAdjunct = ConditionalAntecedentProofAdjunct.newConditionalAntecedentProofAdjunct();
        KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_PROOF_ADJUNCT, (Stella_Object)conditionalAntecedentProofAdjunct, null);
        conditionalAntecedentProofAdjunct.provableRule = proposition2;
        conditionalAntecedentProofAdjunct.goal = proposition;
        return controlFrame2;
    }

    public static Keyword tryForwardGoalsProof(ControlFrame controlFrame) {
        Object object;
        Iterator iterator = (Iterator)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, null);
        if (iterator == null) {
            object = Proposition.findMatchingConceivedProposition(controlFrame.proposition);
            List list = null;
            if (object == null) {
                return Logic.KWD_FAILURE;
            }
            list = Proposition.getForwardGoals(object);
            if (list.emptyP()) {
                return Logic.KWD_FAILURE;
            }
            if (list.rest() == Stella.NIL && Proposition.trueP(((ForwardGoalRecord)list.first()).forwardRule)) {
                ControlFrame.createSubgoalFrame(controlFrame, ((ForwardGoalRecord)list.first()).forwardGoal, null);
                return Logic.KWD_MOVE_DOWN;
            }
            iterator = (ListIterator)list.allocateIterator();
            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, (Stella_Object)iterator, null);
        } else {
            iterator = (Iterator)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, null);
        }
        if (iterator.nextP()) {
            object = (ForwardGoalRecord)iterator.value;
            if (Proposition.trueP(((ForwardGoalRecord)((Object)object)).forwardRule)) {
                ControlFrame.createSubgoalFrame(controlFrame, ((ForwardGoalRecord)((Object)object)).forwardGoal, null);
            } else {
                ControlFrame.createConditionalAntecedentSubframe(controlFrame, ((ForwardGoalRecord)((Object)object)).forwardGoal, ((ForwardGoalRecord)((Object)object)).forwardRule);
            }
            return Logic.KWD_MOVE_DOWN;
        }
        return Logic.KWD_FAILURE;
    }

    public static Keyword tryGoalComplementProof(ControlFrame controlFrame) {
        Description description = ControlFrame.extractSubgoalDescriptionOfFrame(controlFrame);
        Description description2 = Description.getInferableComplementDescription(description);
        ControlFrame controlFrame2 = ControlFrame.createSubgoalFrame(controlFrame, null, Logic.KWD_ALL_SUBGOAL_STRATEGIES);
        KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTION, (Stella_Object)description2, null);
        controlFrame2.reversePolarityP = false;
        return Logic.KWD_MOVE_DOWN;
    }

    public static Keyword continueAntecedentsProof(ControlFrame controlFrame, Keyword keyword) {
        Iterator iterator = (Iterator)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, null);
        boolean bl = iterator == null;
        boolean bl2 = controlFrame.reversePolarityP;
        if (keyword == Logic.KWD_UP_TRUE) {
            Proposition proposition = (Proposition)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANTECEDENTS_RULE, null);
            Stella_Object stella_Object = proposition.truthValue;
            controlFrame.truthValue = TruthValue.weakenTruthValue(ControlFrame.propagateFrameTruthValue(controlFrame.result, controlFrame), (TruthValue)Stella_Object.accessInContext((Stella_Object)stella_Object, (Context)proposition.homeContext, (boolean)false));
            if (((Boolean)Logic.$RECORD_JUSTIFICATIONSp$.get()).booleanValue()) {
                ControlFrame.recordModusPonensJustification(controlFrame, keyword);
            }
            return Logic.KWD_CONTINUING_SUCCESS;
        }
        if (bl) {
            iterator = Description.allocateAntecedentsIterator(ControlFrame.extractSubgoalDescriptionOfFrame(controlFrame), ControlFrame.findExternalArgumentsForSubgoal(controlFrame), bl2);
            if (iterator == null) {
                return Logic.KWD_FAILURE;
            }
            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, (Stella_Object)iterator, null);
        }
        while (iterator.nextP()) {
            Description description;
            Proposition proposition = (Proposition)iterator.value;
            Description description2 = description = bl2 ? (Description)proposition.arguments.theArray[1] : (Description)proposition.arguments.theArray[0];
            if (ControlFrame.checkForDuplicateRuleP(controlFrame, proposition)) continue;
            if (!Proposition.trueP(proposition)) {
                if (Proposition.getForwardGoals(proposition).emptyP()) continue;
                ControlFrame.createConditionalAntecedentSubframe(controlFrame, controlFrame.proposition, proposition);
                return Logic.KWD_MOVE_DOWN;
            }
            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANTECEDENTS_RULE, (Stella_Object)proposition, null);
            ControlFrame controlFrame2 = ControlFrame.createSubgoalFrame(controlFrame, null, Logic.KWD_FULL_SUBQUERY);
            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTION, (Stella_Object)description, null);
            return Logic.KWD_MOVE_DOWN;
        }
        return Logic.KWD_FAILURE;
    }

    public static boolean checkForDuplicateRuleP(ControlFrame controlFrame, Proposition proposition) {
        boolean bl;
        if (Logic.$DUPLICATE_SUBGOAL_STRATEGY$ != Logic.KWD_DUPLICATE_) {
            return false;
        }
        ControlFrame controlFrame2 = controlFrame.up;
        Cons cons = Proposition.yieldGoalBindings(controlFrame.proposition);
        int n = Integer.MIN_VALUE;
        int n2 = Logic.$DUPLICATE_RULE_SEARCH_DEPTH$;
        boolean bl2 = bl = n2 == Integer.MIN_VALUE;
        for (int i = 1; bl || i <= n2; ++i) {
            n = i;
            if (controlFrame2 == null) {
                return false;
            }
            boolean bl3 = false;
            boolean bl4 = bl3 = (Proposition)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANTECEDENTS_RULE, null) == proposition;
            if (bl3) {
                boolean bl5 = true;
                Stella_Object stella_Object = null;
                Cons cons2 = cons;
                Stella_Object stella_Object2 = null;
                Cons cons3 = Proposition.yieldGoalBindings(controlFrame2.proposition);
                while (cons2 != Stella.NIL && cons3 != Stella.NIL) {
                    stella_Object = cons2.value;
                    stella_Object2 = cons3.value;
                    if (!Stella_Object.eqlP((Stella_Object)stella_Object, (Stella_Object)stella_Object2)) {
                        bl5 = false;
                        break;
                    }
                    cons2 = cons2.rest;
                    cons3 = cons3.rest;
                }
                if (bl3 = bl5) {
                    boolean bl6 = bl3 = controlFrame.reversePolarityP == controlFrame2.reversePolarityP;
                }
            }
            if (bl3) {
                if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_GOAL_CACHES)) {
                    System.out.println("DUPLICATE RULE.  BINDINGS: " + cons);
                }
                return true;
            }
            controlFrame2 = controlFrame2.up;
        }
        return false;
    }

    public static void establishGoalCache(ControlFrame controlFrame) {
        ControlFrame controlFrame2 = null;
        ControlFrame controlFrame3 = null;
        int n = Integer.MIN_VALUE;
        Object[] objectArray = new Object[2];
        controlFrame2 = ControlFrame.findDuplicatedGoal(controlFrame, objectArray);
        controlFrame3 = (ControlFrame)((Object)objectArray[0]);
        n = ((IntegerWrapper)objectArray[1]).wrapperValue;
        if (controlFrame2 != null && ControlFrame.findGoalCache(controlFrame2) == null) {
            ControlFrame.createGoalCacheP(controlFrame2);
        }
    }

    public static Keyword trySubgoalStrategiesProof(ControlFrame controlFrame) {
        Proposition proposition;
        Description description = ControlFrame.extractSubgoalDescriptionOfFrame(controlFrame);
        boolean bl = controlFrame.reversePolarityP;
        Cons cons = Stella.NIL;
        boolean bl2 = false;
        if (bl) {
            boolean bl3 = false;
            ConsIterator consIterator = LogicObject.applicableRulesOfDescription(description, Logic.KWD_FORWARD, true).allocateIterator();
            if (consIterator.nextP()) {
                bl3 = true;
            }
            bl2 = bl3;
        } else {
            bl2 = Description.inferableP(description);
        }
        if (bl2) {
            cons = Stella_Object.cons((Stella_Object)Logic.KWD_ANTECEDENTS, (Cons)cons);
        }
        if (bl && Description.getInferableComplementDescription(description) != null) {
            cons = Stella_Object.cons((Stella_Object)Logic.KWD_GOAL_COMPLEMENT, (Cons)cons);
        }
        if ((proposition = controlFrame.proposition) != null && Proposition.allArgumentsBoundP(proposition) && Proposition.findMatchingConceivedProposition(proposition) != null) {
            cons = Stella_Object.cons((Stella_Object)Logic.KWD_FORWARD_GOALS, (Cons)cons);
        }
        proposition = null;
        Cons cons2 = cons.reverse();
        while (cons2 != Stella.NIL) {
            proposition = cons2.value;
            ControlFrame.pushNextStrategy(controlFrame, (Keyword)proposition);
            cons2 = cons2.rest;
        }
        return Logic.KWD_FAILURE;
    }

    public static Vector findExternalArgumentsForSubgoal(ControlFrame controlFrame) {
        while (controlFrame.state != Logic.KWD_ATOMIC_GOAL) {
            controlFrame = controlFrame.up;
        }
        Proposition proposition = controlFrame.proposition;
        Vector vector = controlFrame.proposition.arguments;
        if (proposition.operator == Logic.SGT_PL_KERNEL_KB_MEMBER_OF && (Description)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTION, null) != null && ((Description)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTION, null)).arity() > 1 && Stella_Object.isaP((Stella_Object)proposition.arguments.theArray[0], (Surrogate)Logic.SGT_STELLA_LIST)) {
            vector = Logic.copyListToArgumentsVector((List)proposition.arguments.theArray[0]);
        }
        return vector;
    }

    public static Description extractSubgoalDescriptionOfFrame(ControlFrame controlFrame) {
        if ((Description)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTION, null) != null) {
            return (Description)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTION, null);
        }
        while (controlFrame.state != Logic.KWD_ATOMIC_GOAL) {
            controlFrame = controlFrame.up;
        }
        return Logic.getDescription((Stella_Object)((Surrogate)controlFrame.proposition.operator));
    }

    public static Proposition extractSubgoalOfFrame(ControlFrame controlFrame) {
        while (controlFrame.state != Logic.KWD_ATOMIC_GOAL) {
            controlFrame = controlFrame.up;
        }
        return controlFrame.proposition;
    }

    public static Keyword tryManufactureSkolemProof(ControlFrame controlFrame) {
        Proposition proposition = controlFrame.proposition;
        NamedDescription namedDescription = Logic.getDescription((Stella_Object)((Surrogate)proposition.operator));
        Cons cons = Stella.NIL;
        if (!Logic.testPropertyP((Stella_Object)namedDescription, Logic.SGT_PL_KERNEL_KB_TOTAL) || controlFrame.reversePolarityP) {
            return Logic.KWD_FAILURE;
        }
        Stella_Object stella_Object = null;
        Object object = proposition.arguments;
        int n = object.length();
        for (int i = 0; i < n; ++i) {
            stella_Object = object.theArray[i];
            cons = Stella_Object.cons((Stella_Object)Logic.argumentBoundTo(stella_Object), (Cons)cons);
        }
        boolean bl = false;
        if (cons.value != null) {
            bl = true;
        } else {
            boolean bl2 = false;
            Stella_Object stella_Object2 = null;
            Cons cons2 = cons.rest;
            while (cons2 != Stella.NIL) {
                stella_Object2 = cons2.value;
                if (stella_Object2 == null) {
                    bl2 = true;
                    break;
                }
                cons2 = cons2.rest;
            }
            bl = bl2;
        }
        if (bl) {
            return Logic.KWD_FAILURE;
        }
        Cons cons3 = cons.rest.reverse();
        object = Logic.createFunctionProposition((GeneralizedSymbol)((Surrogate)proposition.operator), cons3);
        PatternVariable.bindVariableToValueP((PatternVariable)proposition.arguments.theArray[proposition.arguments.length() - 1], object.arguments.theArray[object.arguments.length() - 1], true);
        return Logic.KWD_FINAL_SUCCESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Keyword tryScanForValueClashProof(ControlFrame controlFrame) {
        Object object = Logic.$REVERSEPOLARITYp$.get();
        Object object2 = Logic.$DONTUSEDEFAULTKNOWLEDGEp$.get();
        try {
            TruthValue truthValue;
            Native.setBooleanSpecial((ThreadLocal)Logic.$REVERSEPOLARITYp$, (boolean)false);
            Native.setBooleanSpecial((ThreadLocal)Logic.$DONTUSEDEFAULTKNOWLEDGEp$, (boolean)((Boolean)Logic.$DONTUSEDEFAULTKNOWLEDGEp$.get()));
            Proposition proposition = controlFrame.proposition;
            Iterator iterator = Proposition.allClashingPropositions(proposition);
            TruthValue truthValue2 = truthValue = iterator.nextP() ? Logic.propositionsIteratorTruthValue(iterator) : (TruthValue)null;
            if (truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE || truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
                Native.setBooleanSpecial((ThreadLocal)Logic.$DONTUSEDEFAULTKNOWLEDGEp$, (boolean)true);
                iterator = Proposition.allClashingPropositions(proposition);
                if (iterator.nextP()) {
                    truthValue = Logic.propositionsIteratorTruthValue(iterator);
                }
            }
            controlFrame.truthValue = TruthValue.invertTruthValue(truthValue);
            Keyword keyword = truthValue != null ? Logic.KWD_FINAL_SUCCESS : Logic.KWD_FAILURE;
            return keyword;
        }
        finally {
            Logic.$DONTUSEDEFAULTKNOWLEDGEp$.set(object2);
            Logic.$REVERSEPOLARITYp$.set(object);
        }
    }

    public static Keyword tryShallowDisproof(ControlFrame controlFrame) {
        Proposition proposition = controlFrame.proposition;
        if (!Proposition.allArgumentsBoundP(proposition)) {
            return Logic.KWD_FAILURE;
        }
        if (ControlFrame.hasShallowDisproofP(controlFrame)) {
            boolean bl;
            boolean bl2 = bl = controlFrame.truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE || controlFrame.truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE;
            if (bl) {
                ControlFrame.setFrameTruthValue(controlFrame, null);
            }
            return bl ? Logic.KWD_FAILURE : Logic.KWD_TERMINAL_FAILURE;
        }
        return Logic.KWD_FAILURE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasShallowDisproofP(ControlFrame controlFrame) {
        Iterator iterator = (Iterator)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, null);
        Proposition proposition = controlFrame.proposition;
        TruthValue truthValue = controlFrame.truthValue;
        boolean bl = false;
        KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, null, null);
        Object object = Logic.$REVERSEPOLARITYp$.get();
        try {
            Native.setBooleanSpecial((ThreadLocal)Logic.$REVERSEPOLARITYp$, (!controlFrame.reversePolarityP ? 1 : 0) != 0);
            controlFrame.reversePolarityP = (Boolean)Logic.$REVERSEPOLARITYp$.get();
            ControlFrame.setFrameTruthValue(controlFrame, null);
            if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null && Stella_Object.isaP((Stella_Object)((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy, (Surrogate)Logic.SGT_LOGIC_WHYNOT_PARTIAL_MATCH) && proposition.kind == Logic.KWD_ISA) {
                if (!((Boolean)Logic.$REVERSEPOLARITYp$.get()).booleanValue()) {
                    bl = ControlFrame.tryIsaPropositionProof(controlFrame) == Logic.KWD_FINAL_SUCCESS;
                } else {
                    NamedDescription namedDescription = Logic.getDescription((Stella_Object)proposition.operator);
                    Stella_Object stella_Object = Logic.argumentBoundTo(proposition.arguments.theArray[0]);
                    Cons cons = Stella.NIL;
                    if (stella_Object != null) {
                        Object object2 = Logic.$REVERSEPOLARITYp$.get();
                        try {
                            Native.setBooleanSpecial((ThreadLocal)Logic.$REVERSEPOLARITYp$, (boolean)false);
                            cons = Logic.allAssertedTypes(stella_Object);
                        }
                        finally {
                            Logic.$REVERSEPOLARITYp$.set(object2);
                        }
                        object2 = null;
                        Cons cons2 = cons;
                        while (cons2 != Stella.NIL) {
                            object2 = cons2.value;
                            if (Description.disjointTermsP((Description)((Object)object2), namedDescription)) {
                                bl = true;
                                ControlFrame.setFrameTruthValue(controlFrame, Logic.TRUE_TRUTH_VALUE);
                                break;
                            }
                            cons2 = cons2.rest;
                        }
                    }
                }
            }
            if (!bl) {
                boolean bl2 = bl = ControlFrame.tryScanPropositionsProof(controlFrame) == Logic.KWD_FINAL_SUCCESS;
            }
            if (!bl && ((Boolean)Logic.$REVERSEPOLARITYp$.get()).booleanValue() && (controlFrame.proposition.kind == Logic.KWD_FUNCTION || Proposition.singleValuedPredicateP(controlFrame.proposition))) {
                bl = ControlFrame.tryScanForValueClashProof(controlFrame) == Logic.KWD_FINAL_SUCCESS;
            }
            controlFrame.reversePolarityP = !controlFrame.reversePolarityP;
        }
        finally {
            Logic.$REVERSEPOLARITYp$.set(object);
        }
        if (!bl) {
            controlFrame.truthValue = truthValue;
        }
        KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, (Stella_Object)iterator, null);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Keyword tryScanPropositionsProof(ControlFrame controlFrame) {
        Proposition proposition = controlFrame.proposition;
        boolean bl = false;
        Iterator iterator = (Iterator)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, null);
        Keyword keyword = Logic.KWD_FAILURE;
        if (iterator == null) {
            bl = Proposition.allArgumentsBoundP(proposition) || Proposition.allKeyArgumentsBoundP(proposition);
            iterator = Proposition.allMatchingPropositions(proposition);
            if (iterator == Logic.EMPTY_PROPOSITIONS_ITERATOR) {
                iterator = null;
            } else {
                KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, (Stella_Object)iterator, null);
            }
            if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null && controlFrame.currentStrategy == Logic.KWD_LOOKUP_ASSERTIONS && proposition.arguments.length() > 1 && Logic.nullInstancePropositionsExistP()) {
                ControlFrame.pushNextStrategy(controlFrame, Logic.KWD_SCAN_PARTIAL_PROPOSITIONS);
            }
        }
        if (iterator != null) {
            while (iterator.nextP()) {
                if (!Proposition.argumentsUnifyWithArgumentsP((Proposition)iterator.value, proposition)) continue;
                keyword = bl && ((Boolean)Logic.$GENERATE_ALL_PROOFSp$.get() == false || (QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null && Stella_Object.isaP((Stella_Object)((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy, (Surrogate)Logic.SGT_LOGIC_WHYNOT_PARTIAL_MATCH)) ? Logic.KWD_FINAL_SUCCESS : Logic.KWD_CONTINUING_SUCCESS;
                break;
            }
        }
        if (keyword == Logic.KWD_FAILURE && controlFrame.reversePolarityP && controlFrame.currentStrategy != Logic.KWD_SHALLOW_DISPROOF && (proposition.kind == Logic.KWD_FUNCTION || Proposition.singleValuedPredicateP(proposition)) && Proposition.allArgumentsBoundP(proposition)) {
            ControlFrame.pushNextStrategy(controlFrame, Logic.KWD_SCAN_FOR_VALUE_CLASH);
        }
        if (keyword != Logic.KWD_FAILURE) {
            TruthValue truthValue = Logic.propositionsIteratorTruthValue(iterator);
            double d = ((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)((Proposition)iterator.value).dynamicSlots, (Symbol)Logic.SYM_LOGIC_WEIGHT, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue;
            if (truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE || truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
                Object object = Logic.$DONTUSEDEFAULTKNOWLEDGEp$.get();
                try {
                    Native.setBooleanSpecial((ThreadLocal)Logic.$DONTUSEDEFAULTKNOWLEDGEp$, (boolean)true);
                    iterator = Proposition.allMatchingPropositions(proposition);
                    if (iterator.nextP()) {
                        truthValue = Logic.propositionsIteratorTruthValue(iterator);
                        d = ((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)((Proposition)iterator.value).dynamicSlots, (Symbol)Logic.SYM_LOGIC_WEIGHT, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue;
                    }
                }
                finally {
                    Logic.$DONTUSEDEFAULTKNOWLEDGEp$.set(object);
                }
            }
            controlFrame.truthValue = truthValue;
            if (controlFrame.partialMatchFrame != null) {
                if (d == Double.NEGATIVE_INFINITY) {
                    d = 1.0;
                }
                controlFrame.partialMatchFrame.setFramePartialTruth(truthValue, truthValue.positiveScore * d, Double.NEGATIVE_INFINITY, true);
            }
        }
        return keyword;
    }

    public static Keyword tryLookupGroundAssertionsProof(ControlFrame controlFrame) {
        if (controlFrame.proposition.kind == Logic.KWD_ISA) {
            if (((Boolean)Logic.$REVERSEPOLARITYp$.get()).booleanValue()) {
                return ControlFrame.tryScanPropositionsProof(controlFrame);
            }
            return ControlFrame.tryIsaPropositionProof(controlFrame);
        }
        return ControlFrame.tryScanPropositionsProof(controlFrame);
    }

    public static Keyword tryGoalCachesProof(ControlFrame controlFrame) {
        if ((Iterator)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, null) == null) {
            Proposition proposition = controlFrame.proposition;
            Keyword keyword = ControlFrame.lookupCachedProof(controlFrame);
            if (keyword != Logic.KWD_FAILURE) {
                return keyword;
            }
            if (Proposition.allArgumentsBoundP(proposition) || !Logic.$CACHE_SUCCEEDED_GOALSp$ && !Logic.$CACHE_FAILED_GOALSp$ || Logic.$DUPLICATE_SUBGOAL_STRATEGY$ != Logic.KWD_DUPLICATE_GOALS || (QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null || Proposition.getGoalCacheList(proposition) == null) {
                return Logic.KWD_FAILURE;
            }
        }
        return ControlFrame.scanCachedGoals(controlFrame);
    }

    public static Keyword scanCachedGoals(ControlFrame controlFrame) {
        Proposition proposition = controlFrame.proposition;
        Iterator iterator = (Iterator)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, null);
        AtomicGoalCache atomicGoalCache = null;
        PatternRecord patternRecord = ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord;
        int n = patternRecord.topUnbindingStackOffset;
        if (!((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)Logic.surrogateToDescription((Surrogate)((Surrogate)proposition.operator)).dynamicSlots, (Symbol)Logic.SYM_LOGIC_CHECK_FOR_CACHED_GOALSp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue) {
            return Logic.KWD_FAILURE;
        }
        if (iterator == null) {
            iterator = (Iterator)KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, (Stella_Object)ControlFrame.allCachedPropositions(controlFrame), null);
        }
        while (iterator.nextP()) {
            atomicGoalCache = (AtomicGoalCache)iterator.value;
            boolean bl = true;
            Stella_Object stella_Object = null;
            Vector vector = proposition.arguments;
            int n2 = vector.length();
            Stella_Object stella_Object2 = null;
            Cons cons = atomicGoalCache.bindings;
            for (int i = 0; i < n2 && cons != Stella.NIL; ++i) {
                stella_Object = vector.theArray[i];
                stella_Object2 = cons.value;
                if (!Logic.bindArgumentToValueP(stella_Object, stella_Object2, true)) {
                    bl = false;
                    break;
                }
                cons = cons.rest;
            }
            if (bl) {
                return AtomicGoalCache.finishCachedGoalProcessing(atomicGoalCache, controlFrame, Logic.KWD_SUCCESS, true);
            }
            PatternRecord.unbindVariablesBeginningAt(patternRecord, n + 1);
        }
        return Logic.KWD_FAILURE;
    }

    public static Keyword lookupCachedProof(ControlFrame controlFrame) {
        if (!((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)Logic.surrogateToDescription((Surrogate)((Surrogate)controlFrame.proposition.operator)).dynamicSlots, (Symbol)Logic.SYM_LOGIC_CHECK_FOR_CACHED_GOALSp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue || !Logic.$CACHE_SUCCEEDED_GOALSp$ && !Logic.$CACHE_FAILED_GOALSp$ || Logic.$DUPLICATE_SUBGOAL_STRATEGY$ != Logic.KWD_DUPLICATE_GOALS || (QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null) {
            return Logic.KWD_FAILURE;
        }
        Keyword keyword = Logic.KWD_FAILURE;
        AtomicGoalCache atomicGoalCache = ControlFrame.findCachedGoal(controlFrame, keyword);
        if (atomicGoalCache == null) {
            keyword = Logic.KWD_SUCCESS;
            atomicGoalCache = ControlFrame.findCachedGoal(controlFrame, keyword);
        }
        if (!(atomicGoalCache == null || ((Boolean)Logic.$DONTUSEDEFAULTKNOWLEDGEp$.get()).booleanValue() && atomicGoalCache.truthValue != Logic.TRUE_TRUTH_VALUE && atomicGoalCache.truthValue != Logic.FALSE_TRUTH_VALUE)) {
            return AtomicGoalCache.finishCachedGoalProcessing(atomicGoalCache, controlFrame, keyword, false);
        }
        return Logic.KWD_FAILURE;
    }

    public static Keyword continueSpecialistProof(ControlFrame controlFrame, Keyword keyword) {
        Keyword keyword2;
        Proposition proposition = controlFrame.proposition;
        NamedDescription namedDescription = Logic.getDescription((Stella_Object)((Surrogate)proposition.operator));
        Method method = NamedDescription.lookupSpecialist(namedDescription);
        Keyword keyword3 = keyword2 = method != null ? (Keyword)Native.funcall((Method)method, null, (Object[])new Object[]{controlFrame, keyword}) : Logic.KWD_FAILURE;
        if (controlFrame.truthValue == null && (keyword2 == Logic.KWD_FINAL_SUCCESS || keyword2 == Logic.KWD_CONTINUING_SUCCESS)) {
            ControlFrame.setFrameTruthValue(controlFrame, Logic.TRUE_TRUTH_VALUE);
        }
        return keyword2;
    }

    public static ControlFrame createSubgoalFrame(ControlFrame controlFrame, Proposition proposition, Keyword keyword) {
        ControlFrame controlFrame2 = ControlFrame.createDownFrame(controlFrame, proposition);
        if (keyword != null) {
            controlFrame2.state = proposition != null && proposition != controlFrame.proposition ? Logic.KWD_ATOMIC_GOAL : Logic.KWD_STRATEGY;
            controlFrame2.currentStrategy = keyword;
        }
        controlFrame2.reversePolarityP = controlFrame.reversePolarityP;
        return controlFrame2;
    }

    public static void pushNextStrategy(ControlFrame controlFrame, Keyword keyword) {
        controlFrame.nextStrategies = Stella_Object.cons((Stella_Object)keyword, (Cons)controlFrame.nextStrategies);
    }

    public static Keyword tryParallelThreadProof(ControlFrame controlFrame) {
        ParallelThread parallelThread = ParallelControlFrame.createChildThread((ParallelControlFrame)controlFrame);
        ParallelControlFrame.enterParallelThread((ParallelControlFrame)controlFrame, parallelThread);
        return Logic.KWD_MOVE_DOWN;
    }

    public static Keyword executeProofStrategy(ControlFrame controlFrame) {
        Keyword keyword = controlFrame.currentStrategy;
        if (keyword == Logic.KWD_SPECIALIST) {
            return ControlFrame.continueSpecialistProof(controlFrame, Logic.KWD_DOWN);
        }
        if (keyword == Logic.KWD_LOOKUP_GOAL_CACHES) {
            return ControlFrame.tryGoalCachesProof(controlFrame);
        }
        if (keyword == Logic.KWD_LOOKUP_ASSERTIONS) {
            return ControlFrame.tryLookupGroundAssertionsProof(controlFrame);
        }
        if (keyword == Logic.KWD_SCAN_PROPOSITIONS) {
            return ControlFrame.tryScanPropositionsProof(controlFrame);
        }
        if (keyword == Logic.KWD_SCAN_PARTIAL_PROPOSITIONS) {
            return ControlFrame.tryScanPartialPropositionsProof(controlFrame);
        }
        if (keyword == Logic.KWD_SCAN_COLLECTION) {
            return ControlFrame.tryScanCollectionProof(controlFrame);
        }
        if (keyword == Logic.KWD_SHALLOW_DISPROOF) {
            return ControlFrame.tryShallowDisproof(controlFrame);
        }
        if (keyword == Logic.KWD_SCAN_FOR_VALUE_CLASH) {
            return ControlFrame.tryScanForValueClashProof(controlFrame);
        }
        if (keyword == Logic.KWD_MANUFACTURE_SKOLEM) {
            return ControlFrame.tryManufactureSkolemProof(controlFrame);
        }
        if (keyword == Logic.KWD_ALL_SUBGOAL_STRATEGIES) {
            return ControlFrame.trySubgoalStrategiesProof(controlFrame);
        }
        if (keyword == Logic.KWD_ANTECEDENTS) {
            if (controlFrame.partialMatchFrame != null) {
                return controlFrame.partialMatchFrame.continuePartialAntecedentsProof(Logic.KWD_DOWN);
            }
            return ControlFrame.continueAntecedentsProof(controlFrame, Logic.KWD_DOWN);
        }
        if (keyword == Logic.KWD_FULL_SUBQUERY) {
            return ControlFrame.tryFullSubqueryProof(controlFrame);
        }
        if (keyword == Logic.KWD_GOAL_COMPLEMENT) {
            return ControlFrame.tryGoalComplementProof(controlFrame);
        }
        if (keyword == Logic.KWD_CONDITIONAL_ANTECEDENT) {
            return ControlFrame.continueConditionalAntecedentProof(controlFrame, Logic.KWD_DOWN);
        }
        if (keyword == Logic.KWD_FORWARD_GOALS) {
            return ControlFrame.tryForwardGoalsProof(controlFrame);
        }
        if (keyword == Logic.KWD_IMPLIES) {
            return ControlFrame.tryImpliesProof(controlFrame);
        }
        if (keyword == Logic.KWD_CONTAINED_BY) {
            return ControlFrame.tryContainedByProof(controlFrame);
        }
        if (keyword == Logic.KWD_EQUIVALENCE) {
            return ControlFrame.tryEquivalenceProof(controlFrame);
        }
        if (keyword == Logic.KWD_CLUSTERED_CONJUNCTION) {
            return ControlFrame.continueClusteredConjunctionProof(controlFrame, Logic.KWD_DOWN);
        }
        if (keyword == Logic.KWD_DISJUNCTIVE_IMPLICATION_INTRODUCTION) {
            return ControlFrame.tryDisjunctiveImplicationProof(controlFrame);
        }
        if (keyword == Logic.KWD_UNIVERSAL_INTRODUCTION) {
            return ControlFrame.tryUniversalIntroductionProof(controlFrame);
        }
        if (keyword == Logic.KWD_SUBSUMPTION_TEST) {
            return ControlFrame.trySubsumptionTest(controlFrame);
        }
        if (keyword == Logic.KWD_REFUTATION) {
            return ControlFrame.tryRefutationProof(controlFrame);
        }
        if (keyword == Logic.KWD_SELECT_PARALLEL_THREAD) {
            return ControlFrame.tryParallelThreadProof(controlFrame);
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    public static Keyword resumeProofStrategyAfterSubgoal(ControlFrame controlFrame, Keyword keyword) {
        Keyword keyword2 = null;
        Keyword keyword3 = controlFrame.currentStrategy;
        if (keyword3 == Logic.KWD_SPECIALIST) {
            keyword2 = ControlFrame.continueSpecialistProof(controlFrame, keyword);
        } else if (keyword3 == Logic.KWD_ANTECEDENTS) {
            keyword2 = controlFrame.partialMatchFrame != null ? controlFrame.partialMatchFrame.continuePartialAntecedentsProof(keyword) : ControlFrame.continueAntecedentsProof(controlFrame, keyword);
        } else if (keyword3 == Logic.KWD_CLUSTERED_CONJUNCTION) {
            keyword2 = ControlFrame.continueClusteredConjunctionProof(controlFrame, keyword);
        } else if (keyword3 == Logic.KWD_CONDITIONAL_ANTECEDENT) {
            keyword2 = ControlFrame.continueConditionalAntecedentProof(controlFrame, keyword);
        } else {
            ControlFrame.propagateFrameTruthValue(controlFrame.result, controlFrame);
            if (controlFrame.result.partialMatchFrame != null) {
                controlFrame.result.partialMatchFrame.propagateFramePartialTruth(controlFrame);
            }
            if (keyword == Logic.KWD_UP_TRUE) {
                keyword2 = controlFrame.down != null ? Logic.KWD_CONTINUING_SUCCESS : Logic.KWD_FINAL_SUCCESS;
            } else if (keyword == Logic.KWD_UP_FAIL) {
                keyword2 = controlFrame.truthValue == Logic.FALSE_TRUTH_VALUE || controlFrame.truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE ? Logic.KWD_TERMINAL_FAILURE : Logic.KWD_FAILURE;
            } else {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
            }
        }
        if (keyword2 == Logic.KWD_CONTINUING_SUCCESS) {
            if (((Boolean)Logic.$GENERATE_ALL_PROOFSp$.get()).booleanValue() && controlFrame.state == Logic.KWD_ATOMIC_GOAL && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) == null || ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy == null) && !ControlFrame.newBindingsSinceLastChoicePointP(controlFrame)) {
                controlFrame.justifications.push((Stella_Object)Logic.KWD_DUMMY_JUSTIFICATION);
                keyword2 = Logic.KWD_MOVE_DOWN;
            }
        } else if (keyword2 == Logic.KWD_FINAL_SUCCESS || keyword2 == Logic.KWD_TERMINAL_FAILURE) {
            controlFrame.nextStrategies = Stella.NIL;
            controlFrame.currentStrategy = null;
            if (keyword2 == Logic.KWD_TERMINAL_FAILURE) {
                keyword2 = Logic.KWD_FAILURE;
            }
        } else if (keyword2 == Logic.KWD_FAILURE) {
            controlFrame.currentStrategy = null;
        } else if (keyword2 != Logic.KWD_MOVE_DOWN && keyword2 != Logic.KWD_MOVE_IN_PLACE) {
            keyword3 = OutputStringStream.newOutputStringStream();
            keyword3.nativeStream.print("`" + keyword2 + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)keyword3.theStringReader()).fillInStackTrace();
        }
        return keyword2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Keyword continueCurrentOrNextStrategy(ControlFrame controlFrame) {
        Keyword keyword = null;
        while (true) {
            Object object;
            controlFrame = ControlFrame.selectNextStrategy(controlFrame);
            if (controlFrame.currentStrategy == null) {
                if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_STRATEGIES)) {
                    System.out.println();
                }
                if (controlFrame.justifications.nonEmptyP()) {
                    return Logic.KWD_FINAL_SUCCESS;
                }
                return Logic.KWD_FAILURE;
            }
            if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_STRATEGIES)) {
                System.out.print(" " + controlFrame.currentStrategy);
                OutputStream.flushOutput((OutputStream)Stella.STANDARD_OUTPUT);
            }
            if (Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_STRATEGIES) && (object = (Description)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTION, null)) != null && Description.namedDescriptionP((Description)((Object)object))) {
                System.out.print("(" + ((Description)((Object)object)).surrogateValueInverse.symbolName + ")");
            }
            if (controlFrame.reversePolarityP) {
                object = Logic.$REVERSEPOLARITYp$.get();
                try {
                    Native.setBooleanSpecial((ThreadLocal)Logic.$REVERSEPOLARITYp$, (boolean)true);
                    keyword = ControlFrame.executeProofStrategy(controlFrame);
                }
                finally {
                    Logic.$REVERSEPOLARITYp$.set(object);
                }
            } else {
                keyword = ControlFrame.executeProofStrategy(controlFrame);
            }
            if (keyword == Logic.KWD_TERMINAL_FAILURE) {
                controlFrame.nextStrategies = Stella.NIL;
                keyword = Logic.KWD_FAILURE;
            } else if (keyword == Logic.KWD_MOVE_DOWN || keyword == Logic.KWD_MOVE_IN_PLACE || keyword == Logic.KWD_TIME_OUT) {
                if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_STRATEGIES)) {
                    System.out.println();
                }
                return keyword;
            }
            ControlFrame.recordBasePartialMatchTruth(controlFrame, keyword);
            if (Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_STRATEGIES)) {
                if (keyword == Logic.KWD_FAILURE) {
                    System.out.print(" ");
                } else {
                    System.out.println();
                }
            }
            if (keyword != Logic.KWD_FAILURE) break;
            controlFrame.currentStrategy = null;
        }
        return keyword;
    }

    public static void recordBasePartialMatchTruth(ControlFrame controlFrame, Keyword keyword) {
        Keyword keyword2;
        Keyword keyword3 = keyword2 = keyword == Logic.KWD_FAILURE || controlFrame.reversePolarityP ? Logic.KWD_FAIL : Logic.KWD_TRUE;
        if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null) {
            ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy.setBasePartialMatchTruth(controlFrame.proposition, keyword2);
        }
    }

    public static ControlFrame selectNextStrategy(ControlFrame controlFrame) {
        Keyword keyword = null;
        if (controlFrame.currentStrategy != null) {
            keyword = controlFrame.currentStrategy;
        } else if (controlFrame.state == Logic.KWD_PARALLEL_STRATEGIES) {
            keyword = Logic.KWD_SELECT_PARALLEL_THREAD;
        } else {
            do {
                if ((keyword = (Keyword)controlFrame.nextStrategies.value) == null) {
                    return controlFrame;
                }
                controlFrame.nextStrategies = controlFrame.nextStrategies.rest;
            } while (Logic.filterOutStrategyP(keyword, controlFrame));
            if (Logic.parallelStrategyP(keyword)) {
                controlFrame = ControlFrame.parallelizeControlFrame(controlFrame);
                controlFrame.nextStrategies = Stella_Object.cons((Stella_Object)keyword, (Cons)controlFrame.nextStrategies);
                keyword = Logic.KWD_SELECT_PARALLEL_THREAD;
            }
            ControlFrame.clearStrategySlots(controlFrame);
        }
        controlFrame.currentStrategy = keyword;
        return controlFrame;
    }

    public static void clearStrategySlots(ControlFrame controlFrame) {
        if ((Iterator)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, null) != null) {
            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, null, null);
        }
        if ((Proposition)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANTECEDENTS_RULE, null) != null) {
            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANTECEDENTS_RULE, null, null);
        }
        if ((ProofAdjunct)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_PROOF_ADJUNCT, null) != null) {
            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_PROOF_ADJUNCT, null, null);
        }
    }

    public static Keyword continueStrategiesProofs(ControlFrame controlFrame, Keyword keyword) {
        Keyword keyword2 = null;
        if (keyword == Logic.KWD_DOWN) {
            ControlFrame.unwindToChoicePoint(controlFrame);
            controlFrame.justifications.clear();
            if (controlFrame.down != null) {
                return Logic.KWD_MOVE_DOWN;
            }
        } else if (keyword == Logic.KWD_UP_TRUE || keyword == Logic.KWD_UP_FAIL) {
            keyword2 = ControlFrame.resumeProofStrategyAfterSubgoal(controlFrame, keyword);
            if (keyword2 == Logic.KWD_FAILURE) {
                keyword2 = null;
            }
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        while (true) {
            if (keyword2 == null) {
                keyword2 = ControlFrame.continueCurrentOrNextStrategy(controlFrame);
            }
            if (keyword2 != Logic.KWD_FINAL_SUCCESS && keyword2 != Logic.KWD_CONTINUING_SUCCESS || controlFrame.proposition == null || controlFrame.truthValue != Logic.DEFAULT_TRUE_TRUTH_VALUE && controlFrame.truthValue != Logic.DEFAULT_FALSE_TRUTH_VALUE || !ControlFrame.hasShallowDisproofP(controlFrame)) break;
            if (Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_GOAL_TREE)) {
                TruthValue truthValue = controlFrame.truthValue;
                boolean bl = truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE || truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE;
                Logic.printVerticalBars(ControlFrame.computeFrameDepth(controlFrame) + 1);
                System.out.print("CLSH: truth=");
                if (truthValue == Logic.TRUE_TRUTH_VALUE || truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE) {
                    if (bl) {
                        System.out.print("t");
                    } else {
                        System.out.print("T");
                    }
                } else if (bl) {
                    System.out.print("f");
                } else {
                    System.out.print("F");
                }
                System.out.println();
            }
            ControlFrame.unwindToChoicePoint(controlFrame);
            if (controlFrame.truthValue != Logic.DEFAULT_TRUE_TRUTH_VALUE && controlFrame.truthValue != Logic.DEFAULT_FALSE_TRUTH_VALUE && Proposition.allArgumentsBoundP(controlFrame.proposition)) {
                keyword2 = Logic.KWD_FAILURE;
                break;
            }
            ControlFrame.setFrameTruthValue(controlFrame, null);
            controlFrame.justifications.clear();
            if (controlFrame.partialMatchFrame != null) {
                controlFrame.partialMatchFrame.clearFramePartialTruth();
            }
            if (controlFrame.down != null) {
                keyword2 = Logic.KWD_MOVE_DOWN;
                break;
            }
            keyword2 = null;
        }
        if (keyword2 == Logic.KWD_CONTINUING_SUCCESS || keyword2 == Logic.KWD_FINAL_SUCCESS) {
            if (controlFrame.truthValue == null) {
                ControlFrame.setFrameTruthValue(controlFrame, Logic.TRUE_TRUTH_VALUE);
            }
            if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null && (controlFrame.partialMatchFrame == null || controlFrame.partialMatchFrame.positiveScore == Double.NEGATIVE_INFINITY && controlFrame.partialMatchFrame.negativeScore == Double.NEGATIVE_INFINITY)) {
                controlFrame.partialMatchFrame.setFramePartialTruth(Logic.TRUE_TRUTH_VALUE, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, false);
            }
            if (((Boolean)Logic.$RECORD_JUSTIFICATIONSp$.get()).booleanValue() && (Justification)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null) == null) {
                ControlFrame.recordPrimitiveJustification(controlFrame, Logic.KWD_UP_TRUE);
            }
        } else if (keyword2 == Logic.KWD_FAILURE || keyword2 == Logic.KWD_TERMINAL_FAILURE) {
            if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null) {
                if (controlFrame.partialMatchFrame == null || controlFrame.partialMatchFrame.positiveScore == Double.NEGATIVE_INFINITY && controlFrame.partialMatchFrame.negativeScore == Double.NEGATIVE_INFINITY) {
                    controlFrame.partialMatchFrame.setFramePartialTruth(controlFrame.truthValue, controlFrame.truthValue != null ? Double.NEGATIVE_INFINITY : 0.0, Double.NEGATIVE_INFINITY, controlFrame.truthValue != null);
                }
                if (((Boolean)Logic.$RECORD_JUSTIFICATIONSp$.get()).booleanValue() && (Justification)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null) == null) {
                    ControlFrame.recordPrimitiveJustification(controlFrame, Logic.KWD_UP_FAIL);
                }
            } else if ((controlFrame.truthValue == Logic.UNKNOWN_TRUTH_VALUE || controlFrame.truthValue == null) && (Keyword)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_INFERENCE_CUTOFF_REASON, null) == null && controlFrame.proposition != null && Proposition.closedPropositionP(controlFrame.proposition)) {
                ControlFrame.setFrameTruthValue(controlFrame, Logic.FALSE_TRUTH_VALUE);
                if (((Boolean)Logic.$RECORD_JUSTIFICATIONSp$.get()).booleanValue() && (Justification)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null) == null) {
                    ControlFrame.recordClosedNotJustification(controlFrame, Logic.KWD_UP_FAIL);
                }
            }
        }
        return keyword2;
    }

    public static AtomicGoalCacheIterator allCachedPropositions(ControlFrame controlFrame) {
        Proposition proposition = controlFrame.proposition;
        GeneralizedSymbol generalizedSymbol = proposition.operator;
        AtomicGoalCache atomicGoalCache = Proposition.getGoalCacheList(proposition);
        while (atomicGoalCache != null && atomicGoalCache.proposition.operator != generalizedSymbol) {
            atomicGoalCache = atomicGoalCache.next;
        }
        Proposition.setGoalCacheList(proposition, atomicGoalCache);
        AtomicGoalCacheIterator atomicGoalCacheIterator = AtomicGoalCacheIterator.newAtomicGoalCacheIterator();
        atomicGoalCacheIterator.goal = controlFrame;
        atomicGoalCacheIterator.cacheList = atomicGoalCache;
        AtomicGoalCacheIterator atomicGoalCacheIterator2 = atomicGoalCacheIterator;
        return atomicGoalCacheIterator2;
    }

    public static AtomicGoalCache findCachedGoal(ControlFrame controlFrame, Keyword keyword) {
        Keyword keyword2;
        if (controlFrame.state == Logic.KWD_ATOMIC_GOAL && ((keyword2 = controlFrame.proposition.kind) == Logic.KWD_ISA || keyword2 == Logic.KWD_PREDICATE || keyword2 == Logic.KWD_FUNCTION)) {
            AtomicGoalCache atomicGoalCache = null;
            if (keyword == Logic.KWD_SUCCESS) {
                if (!Logic.$CACHE_SUCCEEDED_GOALSp$) {
                    return null;
                }
                atomicGoalCache = (AtomicGoalCache)Logic.$SUCCEEDED_GOALS_CACHE$.theArray[(ControlFrame.goalHashCode(controlFrame) & Integer.MAX_VALUE) % 1541];
                if (atomicGoalCache != null && AtomicGoalCache.cacheMatchesGoalP(atomicGoalCache, controlFrame, true, Logic.KWD_GOAL_INSTANTIATES_CACHE) && (!((Boolean)Logic.$RECORD_JUSTIFICATIONSp$.get()).booleanValue() || atomicGoalCache.justification != null)) {
                    return atomicGoalCache;
                }
            } else if (keyword == Logic.KWD_FAILURE) {
                if (!Logic.$CACHE_FAILED_GOALSp$ || controlFrame.dontCacheGoalFailureP) {
                    return null;
                }
                atomicGoalCache = (AtomicGoalCache)Logic.$FAILED_GOALS_CACHE$.theArray[(ControlFrame.goalHashCode(controlFrame) & Integer.MAX_VALUE) % 1541];
                if (atomicGoalCache != null && AtomicGoalCache.cacheMatchesGoalP(atomicGoalCache, controlFrame, false, Logic.KWD_GOAL_INSTANTIATES_CACHE)) {
                    return atomicGoalCache;
                }
            } else {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
            }
        }
        return null;
    }

    public static void cacheGoal(ControlFrame controlFrame, boolean bl, boolean bl2, int n) {
        if (controlFrame.state == Logic.KWD_ATOMIC_GOAL) {
            Keyword keyword;
            if (controlFrame.goalBindings == null) {
                return;
            }
            if (bl) {
                controlFrame.dontCacheGoalFailureP = true;
            }
            if (controlFrame.cachedGoalResultP) {
                return;
            }
            if (n - controlFrame.startingClockTicks >= Logic.$CACHE_GOAL_QUANTUM$ && ((keyword = controlFrame.proposition.kind) == Logic.KWD_ISA || keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION)) {
                if (Stella.getQuotedTree((String)"((/PL-KERNEL-KB/@FORK /PL-KERNEL-KB/@COLLECT-INTO-SET) \"/LOGIC\")", (String)"/LOGIC").memberP((Stella_Object)controlFrame.proposition.operator)) {
                    return;
                }
                if (Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_GOAL_CACHES)) {
                    System.out.println("=========> CACHED " + (bl ? "SUCCESS" : "FAILURE") + " AT " + (ControlFrame.goalHashCode(controlFrame) & Integer.MAX_VALUE) % 1541 + ": " + (Object)((Object)controlFrame.proposition));
                }
                Logic.updateNowTimestamp(Logic.KWD_EXECUTE_QUERY);
                KeyValueList.setDynamicSlotValue((KeyValueList)Logic.surrogateToDescription((Surrogate)((Surrogate)controlFrame.proposition.operator)).dynamicSlots, (Symbol)Logic.SYM_LOGIC_CHECK_FOR_CACHED_GOALSp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
                int n2 = Integer.MIN_VALUE;
                AtomicGoalCache atomicGoalCache = null;
                if (bl) {
                    if (!Logic.$CACHE_SUCCEEDED_GOALSp$) {
                        return;
                    }
                    n2 = (ControlFrame.goalHashCode(controlFrame) & Integer.MAX_VALUE) % 1541;
                    atomicGoalCache = (AtomicGoalCache)Logic.$SUCCEEDED_GOALS_CACHE$.theArray[n2];
                    if (atomicGoalCache == null || !AtomicGoalCache.cacheMatchesGoalP(atomicGoalCache, controlFrame, true, Logic.KWD_GOAL_INSTANTIATES_CACHE) || ((Boolean)Logic.$RECORD_JUSTIFICATIONSp$.get()).booleanValue() && atomicGoalCache.justification == null) {
                        Logic.$SUCCEEDED_GOALS_CACHE$.theArray[n2] = ControlFrame.createAtomicGoalCache(controlFrame, atomicGoalCache, true);
                    } else if (atomicGoalCache != null) {
                        atomicGoalCache.truthValue = TruthValue.strengthenTruthValue(atomicGoalCache.truthValue, controlFrame.truthValue);
                    }
                } else {
                    if (!Logic.$CACHE_FAILED_GOALSp$ || controlFrame.dontCacheGoalFailureP) {
                        return;
                    }
                    n2 = (ControlFrame.goalHashCode(controlFrame) & Integer.MAX_VALUE) % 1541;
                    atomicGoalCache = (AtomicGoalCache)Logic.$FAILED_GOALS_CACHE$.theArray[n2];
                    if (atomicGoalCache == null || !AtomicGoalCache.cacheMatchesGoalP(atomicGoalCache, controlFrame, false, Logic.KWD_GOAL_INSTANTIATES_CACHE)) {
                        Logic.$FAILED_GOALS_CACHE$.theArray[n2] = ControlFrame.createAtomicGoalCache(controlFrame, atomicGoalCache, false);
                    }
                }
            }
        }
    }

    public static void dontCacheGoalFailureBetweenFrames(ControlFrame controlFrame, ControlFrame controlFrame2) {
        while (true) {
            controlFrame.dontCacheGoalFailureP = true;
            if (controlFrame == controlFrame2) {
                return;
            }
            controlFrame = controlFrame.up;
        }
    }

    public static boolean goalInstantiatesCacheP(ControlFrame controlFrame, AtomicGoalCache atomicGoalCache, boolean bl) {
        return AtomicGoalCache.cacheMatchesGoalP(atomicGoalCache, controlFrame, bl, Logic.KWD_GOAL_INSTANTIATES_CACHE);
    }

    public static AtomicGoalCache createAtomicGoalCache(ControlFrame controlFrame, AtomicGoalCache atomicGoalCache, boolean bl) {
        if (atomicGoalCache == null) {
            atomicGoalCache = AtomicGoalCache.newAtomicGoalCache();
        }
        Proposition proposition = controlFrame.proposition;
        if (bl) {
            if (atomicGoalCache.next != null) {
                atomicGoalCache.next.previous = atomicGoalCache.previous;
                if (atomicGoalCache.previous == null) {
                    Proposition.setGoalCacheList(atomicGoalCache.next.proposition, atomicGoalCache.next);
                }
            }
            if (atomicGoalCache.previous != null) {
                atomicGoalCache.previous.next = atomicGoalCache.next;
            }
            atomicGoalCache.previous = null;
            atomicGoalCache.next = null;
            AtomicGoalCache atomicGoalCache2 = Proposition.getGoalCacheList(proposition);
            if (atomicGoalCache != atomicGoalCache2 && atomicGoalCache2 != null) {
                atomicGoalCache2.previous = atomicGoalCache;
                atomicGoalCache.next = atomicGoalCache2;
            }
            Proposition.setGoalCacheList(proposition, atomicGoalCache);
        }
        atomicGoalCache.goalContext = (Context)Stella.$CONTEXT$.get();
        atomicGoalCache.timestamp = Logic.getNowTimestamp();
        atomicGoalCache.reversePolarityP = controlFrame.reversePolarityP;
        atomicGoalCache.proposition = proposition;
        atomicGoalCache.bindings = Proposition.yieldGoalBindings(proposition);
        atomicGoalCache.justification = bl ? (Justification)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null) : null;
        atomicGoalCache.truthValue = controlFrame.truthValue;
        if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null) {
            controlFrame.setCachePartialTruth(atomicGoalCache);
        }
        controlFrame.cachedGoalResultP = true;
        return atomicGoalCache;
    }

    public static int goalHashCode(ControlFrame controlFrame) {
        Proposition proposition = controlFrame.proposition;
        Surrogate surrogate = Proposition.cachedGoalOperator(proposition);
        Vector vector = proposition.arguments;
        int n = 0;
        n = ((Context)Stella.$CONTEXT$.get()).hashCode_();
        if (controlFrame.reversePolarityP) {
            n = ((n & 1) == 0 ? n >>> 1 : n >> 1 | Integer.MIN_VALUE) ^ 0x2E12EC4;
        }
        n = ((n & 1) == 0 ? n >>> 1 : n >> 1 | Integer.MIN_VALUE) ^ Stella_Object.safeHashCode((Stella_Object)surrogate);
        Stella_Object stella_Object = null;
        Vector vector2 = vector;
        int n2 = vector2.length();
        Stella_Object stella_Object2 = null;
        Cons cons = controlFrame.goalBindings;
        for (int i = 0; i < n2 && cons != Stella.NIL; ++i) {
            stella_Object = vector2.theArray[i];
            stella_Object2 = cons.value;
            n = stella_Object2 == null && (stella_Object2 = ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord.variableBindings.theArray[((PatternVariable)stella_Object).boundToOffset]) == null ? PatternVariable.hashUnboundGoalVariable((PatternVariable)stella_Object, vector, n) : Logic.hashGoalArgument(stella_Object2, n);
            cons = cons.rest;
        }
        return n;
    }

    public static int failedGoalIndex(ControlFrame controlFrame) {
        return (ControlFrame.goalHashCode(controlFrame) & Integer.MAX_VALUE) % 1541;
    }

    public static int succeededGoalIndex(ControlFrame controlFrame) {
        return (ControlFrame.goalHashCode(controlFrame) & Integer.MAX_VALUE) % 1541;
    }

    public static Keyword continueCachedBindingsProof(ControlFrame controlFrame, Keyword keyword) {
        Proposition proposition = controlFrame.proposition;
        Iterator iterator = (Iterator)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_CACHED_BINDINGS_ITERATOR, null);
        if (iterator == null) {
            GoalCache goalCache = ControlFrame.findGoalCache(controlFrame);
            List list = null;
            if (goalCache == null) {
                ControlFrame.createGoalCacheP(controlFrame);
                return Logic.KWD_FAILURE;
            }
            list = goalCache.cachedBindings;
            switch (list.length()) {
                case 0: {
                    Logic.traceGoalCache("EMPTY CACHE: ", controlFrame);
                    return Logic.KWD_FAILURE;
                }
                case 1: {
                    Logic.traceGoalCache("USED CACHED BINDING: ", controlFrame);
                    if (Logic.bindVectorOfArgumentsToValuesP(proposition.arguments, (Cons)list.first())) {
                        return Logic.KWD_FINAL_SUCCESS;
                    }
                    return Logic.KWD_FAILURE;
                }
            }
            Logic.traceGoalCache("USED MANY CACHED BINDINGS: ", controlFrame);
            iterator = (ListIterator)goalCache.cachedBindings.allocateIterator();
            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_CACHED_BINDINGS_ITERATOR, (Stella_Object)iterator, null);
        }
        ControlFrame.createChoicePoint(controlFrame);
        while (iterator.nextP()) {
            if (!Logic.bindVectorOfArgumentsToValuesP(controlFrame.proposition.arguments, (Cons)iterator.value)) continue;
            if (iterator.emptyP()) {
                return Logic.KWD_FINAL_SUCCESS;
            }
            return Logic.KWD_CONTINUING_SUCCESS;
        }
        return Logic.KWD_FAILURE;
    }

    public static Cons yieldRelativeGoalBindings(ControlFrame controlFrame) {
        Proposition proposition = controlFrame.proposition;
        Cons cons = Stella.NIL;
        PatternRecord patternRecord = ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord;
        ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord = ControlFrame.operativePatternRecord(controlFrame);
        Stella_Object stella_Object = null;
        Vector vector = proposition.arguments;
        int n = vector.length();
        Cons cons2 = null;
        for (int i = 0; i < n; ++i) {
            stella_Object = vector.theArray[i];
            if (cons2 == null) {
                cons2 = Stella_Object.cons((Stella_Object)Logic.argumentBoundTo(stella_Object), (Cons)Stella.NIL);
                if (cons == Stella.NIL) {
                    cons = cons2;
                    continue;
                }
                Cons.addConsToEndOfConsList((Cons)cons, (Cons)cons2);
                continue;
            }
            cons2 = cons2.rest = Stella_Object.cons((Stella_Object)Logic.argumentBoundTo(stella_Object), (Cons)Stella.NIL);
        }
        ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord = patternRecord;
        return cons;
    }

    public static void updateGoalCache(ControlFrame controlFrame, boolean bl) {
        if (Logic.$DUPLICATE_SUBGOAL_STRATEGY$ != Logic.KWD_DUPLICATE_GOALS_WITH_CACHING || !bl) {
            return;
        }
        GoalCache goalCache = ControlFrame.findGoalCache(controlFrame);
        if (goalCache != null) {
            List list = goalCache.cachedBindings;
            Cons cons = ControlFrame.yieldRelativeGoalBindings(controlFrame);
            boolean bl2 = false;
            Cons cons2 = null;
            Cons cons3 = list.theConsList;
            while (cons3 != Stella.NIL) {
                cons2 = (Cons)cons3.value;
                boolean bl3 = true;
                Stella_Object stella_Object = null;
                Cons cons4 = cons;
                Stella_Object stella_Object2 = null;
                Cons cons5 = cons2;
                while (cons4 != Stella.NIL && cons5 != Stella.NIL) {
                    stella_Object = cons4.value;
                    stella_Object2 = cons5.value;
                    if (!Stella_Object.eqlP((Stella_Object)stella_Object, (Stella_Object)stella_Object2)) {
                        bl3 = false;
                        break;
                    }
                    cons4 = cons4.rest;
                    cons5 = cons5.rest;
                }
                if (bl3) {
                    bl2 = true;
                    break;
                }
                cons3 = cons3.rest;
            }
            if (bl2) {
                return;
            }
            if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_GOAL_CACHES)) {
                System.out.println("AUGMENT CACHE: " + cons + "  " + (Object)((Object)controlFrame));
            }
            list.push((Stella_Object)cons);
            ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).augmentedGoalCacheP = true;
        }
    }

    public static GoalCache findGoalCache(ControlFrame controlFrame) {
        Proposition proposition = controlFrame.proposition;
        KeyValueList keyValueList = Proposition.findGoalCacheTable(proposition);
        GoalCache goalCache = null;
        if (keyValueList == null) {
            return null;
        }
        goalCache = Logic.lookupGoalCache(keyValueList);
        if (goalCache != null && goalCache.timestamp < Logic.getNowTimestamp()) {
            goalCache.cachedBindings.clear();
            goalCache.timestamp = Logic.getNowTimestamp();
        }
        return goalCache;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean createGoalCacheP(ControlFrame controlFrame) {
        GoalCache goalCache;
        Proposition proposition = controlFrame.proposition;
        KeyValueList keyValueList = Proposition.findGoalCacheTable(proposition);
        if (keyValueList == null) {
            keyValueList = KeyValueList.newKeyValueList();
            goalCache = proposition.kind;
            if (goalCache != Logic.KWD_ISA && goalCache != Logic.KWD_PREDICATE && goalCache != Logic.KWD_FUNCTION) return false;
            if (proposition.operator.primaryType() != Logic.SGT_STELLA_SURROGATE) return false;
            NamedDescription namedDescription = Logic.getDescription((Stella_Object)((Surrogate)proposition.operator));
            if (((Boolean)Logic.$REVERSEPOLARITYp$.get()).booleanValue()) {
                KeyValueList.setDynamicSlotValue((KeyValueList)namedDescription.dynamicSlots, (Symbol)Logic.SYM_LOGIC_NEGATED_GOAL_CACHE_TABLE, (Stella_Object)keyValueList, null);
            } else {
                KeyValueList.setDynamicSlotValue((KeyValueList)namedDescription.dynamicSlots, (Symbol)Logic.SYM_LOGIC_GOAL_CACHE_TABLE, (Stella_Object)keyValueList, null);
            }
        }
        if ((goalCache = Logic.lookupGoalCache(keyValueList)) != null) return true;
        Logic.traceGoalCache("CREATING GOAL CACHE: ", controlFrame);
        goalCache = GoalCache.newGoalCache();
        Logic.removeObsoleteGoalCaches(keyValueList);
        keyValueList.insertAt((Stella_Object)((Context)Stella.$CONTEXT$.get()), (Stella_Object)goalCache);
        KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_GOAL_CACHE, (Stella_Object)goalCache, null);
        goalCache.timestamp = Logic.getNowTimestamp();
        goalCache.proposition = proposition;
        goalCache.reversePolarityP = (Boolean)Logic.$REVERSEPOLARITYp$.get();
        goalCache.cacheContext = (Context)Stella.$CONTEXT$.get();
        ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).activeGoalCaches.insert((Stella_Object)goalCache);
        if (!Logic.topLevelQueryContextP((Context)Stella.$CONTEXT$.get())) return true;
        ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).augmentedGoalCacheP = true;
        return true;
    }

    public static Keyword tryScanPartialPropositionsProof(ControlFrame controlFrame) {
        Proposition proposition = controlFrame.proposition;
        Iterator iterator = (Iterator)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, null);
        Keyword keyword = Logic.KWD_FAILURE;
        if (iterator == null) {
            iterator = Proposition.allMatchingPartialPropositions(proposition);
            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, (Stella_Object)iterator, null);
        }
        if (iterator != null) {
            while (iterator.nextP()) {
                if (!Proposition.partialArgumentsUnifyWithArgumentsP((Proposition)iterator.value, proposition)) continue;
                keyword = Logic.KWD_CONTINUING_SUCCESS;
                break;
            }
        }
        if (keyword != Logic.KWD_FAILURE) {
            TruthValue truthValue = Logic.propositionsIteratorTruthValue(iterator);
            double d = ((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)((Proposition)iterator.value).dynamicSlots, (Symbol)Logic.SYM_LOGIC_WEIGHT, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue;
            controlFrame.truthValue = Logic.UNKNOWN_TRUTH_VALUE;
            if (d == Double.NEGATIVE_INFINITY) {
                d = 1.0;
            }
            controlFrame.partialMatchFrame.setFramePartialTruth(Logic.UNKNOWN_TRUTH_VALUE, truthValue.positiveScore * d, Double.NEGATIVE_INFINITY, true);
        }
        return keyword;
    }

    public static boolean computePartialMatchScoreP(ControlFrame controlFrame) {
        PartialMatchFrame partialMatchFrame = controlFrame.partialMatchFrame;
        double d = Double.NEGATIVE_INFINITY;
        Keyword keyword = partialMatchFrame.kind;
        if (keyword == Logic.KWD_AND) {
            d = partialMatchFrame.computeAndScore();
        } else if (keyword == Logic.KWD_OR) {
            d = partialMatchFrame.computeOrScore();
        } else if (keyword == Logic.KWD_ATOMIC_GOAL) {
            d = partialMatchFrame.computeGoalScore();
        }
        KeyValueList.setDynamicSlotValue((KeyValueList)((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).dynamicSlots, (Symbol)Logic.SYM_LOGIC_LATEST_POSITIVE_SCORE, (Stella_Object)FloatWrapper.wrapFloat((double)d), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
        partialMatchFrame.positiveScore = d;
        KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MATCH_SCORE, (Stella_Object)FloatWrapper.wrapFloat((double)d), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
        if (ControlFrame.unboundVariablesInFrameP(controlFrame)) {
            return false;
        }
        return d > Logic.$MINIMUM_SCORE_CUTOFF$;
    }

    public static boolean computePartialMatchOrSuccessP(ControlFrame controlFrame) {
        return controlFrame.partialMatchFrame.earlyPartialMatchOrSuccessP();
    }

    public static boolean computePartialMatchAndFailureP(ControlFrame controlFrame) {
        return controlFrame.partialMatchFrame.earlyPartialMatchAndFailureP();
    }

    public static void recordLatestPartialMatchScore(ControlFrame controlFrame) {
        Proposition proposition = null;
        double d = ((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).dynamicSlots, (Symbol)Logic.SYM_LOGIC_LATEST_POSITIVE_SCORE, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue;
        PartialMatchFrame partialMatchFrame = controlFrame.partialMatchFrame;
        Keyword keyword = controlFrame.state;
        proposition = keyword == Logic.KWD_AND || keyword == Logic.KWD_OR ? (Proposition)controlFrame.proposition.arguments.theArray[controlFrame.argumentCursor] : controlFrame.proposition;
        if (partialMatchFrame.kind == Logic.KWD_AND && BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)proposition.variableTypeP()) && !partialMatchFrame.successP) {
            Logic.$AND_MISSED_A_BINDING$ = true;
        }
        if (partialMatchFrame.kind == Logic.KWD_AND && d == 0.0 && proposition.kind == Logic.KWD_FUNCTION && Stella_Object.isaP((Stella_Object)proposition.arguments.last(), (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE) && Logic.argumentBoundTo(proposition.arguments.last()) == null) {
            partialMatchFrame.unboundVars = Stella_Object.cons((Stella_Object)((PatternVariable)proposition.arguments.last()), (Cons)partialMatchFrame.unboundVars);
        }
        partialMatchFrame.recordPartialMatchScore(((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).dynamicSlots, (Symbol)Logic.SYM_LOGIC_LATEST_POSITIVE_SCORE, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue, partialMatchFrame.propositionWeight(proposition));
    }

    public static boolean unboundVariablesInFrameP(ControlFrame controlFrame) {
        return Proposition.getUnboundVariables(controlFrame.proposition) != Stella.NIL;
    }

    public static void createAndLinkPartialMatchFrame(ControlFrame controlFrame, Keyword keyword) {
        PartialMatchFrame partialMatchFrame = ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy;
        PartialMatchFrame partialMatchFrame2 = partialMatchFrame.createPartialMatchFrame(controlFrame, keyword);
        partialMatchFrame2.kind = keyword;
        controlFrame.partialMatchFrame = partialMatchFrame2;
        partialMatchFrame2.controlFrame = controlFrame;
    }

    public void setJustificationPartialTruth(Justification justification) {
        ControlFrame controlFrame = this;
        PartialMatchFrame partialMatchFrame = controlFrame.partialMatchFrame;
        if (partialMatchFrame != null) {
            partialMatchFrame.setJustificationPartialTruth(justification);
        }
    }

    public void setCachePartialTruth(AtomicGoalCache atomicGoalCache) {
        ControlFrame controlFrame = this;
        PartialMatchFrame partialMatchFrame = controlFrame.partialMatchFrame;
        if (partialMatchFrame != null) {
            partialMatchFrame.setCachePartialTruth(atomicGoalCache);
        }
    }

    public boolean definedFramePartialTruthP() {
        ControlFrame controlFrame = this;
        return controlFrame.partialMatchFrame != null && (controlFrame.partialMatchFrame.positiveScore != Double.NEGATIVE_INFINITY || controlFrame.partialMatchFrame.negativeScore != Double.NEGATIVE_INFINITY);
    }

    public static Vector allocateCollectionVariables(ControlFrame controlFrame, Description description) {
        int n = description.ioVariables.length();
        Vector vector = Vector.newVector((int)n);
        PatternVariable patternVariable = null;
        Vector vector2 = description.ioVariables;
        int n2 = vector2.length();
        int n3 = Integer.MIN_VALUE;
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            patternVariable = (PatternVariable)vector2.theArray[i];
            n3 = n4++;
            vector.theArray[n3] = Logic.createVariable(patternVariable.skolemType, patternVariable.skolemName, false);
            ((PatternVariable)vector.theArray[n3]).boundToOffset = n3;
        }
        if (controlFrame.patternRecord == null) {
            ControlFrame.createPatternRecord(controlFrame, null, null);
        }
        PatternRecord.activatePatternRecord(controlFrame.patternRecord, n);
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printGoalStack(ControlFrame controlFrame, boolean bl) {
        if (controlFrame.proposition != null) {
            Object object = Logic.$PRINTINFRAME$.get();
            try {
                Native.setSpecial((ThreadLocal)Logic.$PRINTINFRAME$, (Object)((Object)controlFrame));
                if (bl) {
                    ControlFrame.printControlFrame(controlFrame, Stella.STANDARD_OUTPUT.nativeStream);
                    System.out.println();
                } else {
                    System.out.println((Object)controlFrame.proposition);
                }
            }
            finally {
                Logic.$PRINTINFRAME$.set(object);
            }
        }
        if (controlFrame.down != null) {
            ControlFrame.printGoalStack(controlFrame.down, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printControlFrame(ControlFrame controlFrame, PrintStream printStream) {
        Object object;
        if (Surrogate.subtypeOfP((Surrogate)Stella_Object.safePrimaryType((Stella_Object)controlFrame), (Surrogate)Logic.SGT_LOGIC_PARALLEL_CONTROL_FRAME)) {
            object = (ParallelControlFrame)controlFrame;
            printStream.print("|PLL-CF|" + ControlFrame.debugFrameId(object) + "[");
        } else {
            printStream.print("|CF|" + ControlFrame.debugFrameId(controlFrame) + "[");
        }
        if (controlFrame.choicePointUnbindingOffset != Integer.MIN_VALUE) {
            printStream.print(controlFrame.choicePointUnbindingOffset);
        } else {
            printStream.print("_");
        }
        object = Logic.$PRINTINFRAME$.get();
        try {
            Native.setSpecial((ThreadLocal)Logic.$PRINTINFRAME$, (Object)((Object)controlFrame));
            boolean bl = controlFrame.allottedClockTicks != Integer.MIN_VALUE;
            printStream.print(" " + controlFrame.state + " " + controlFrame.currentStrategy);
            if (controlFrame.up != null) {
                printStream.print("  UP: " + ControlFrame.debugFrameId(controlFrame.up));
            } else {
                printStream.print("  UP: -");
            }
            if (controlFrame.down != null) {
                printStream.print("  DOWN: " + ControlFrame.debugFrameId(controlFrame.down));
            } else {
                printStream.print("  DOWN: -");
            }
            printStream.print("  DEPTH: " + ControlFrame.computeFrameDepth(controlFrame));
            if ((Description)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTION, null) != null) {
                printStream.print(" DESC: " + (Object)((Object)((Description)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTION, null))));
            }
            if (bl) {
                printStream.print(" CLOCK: " + ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentClockTicks + " START: " + controlFrame.startingClockTicks + " TICKS: " + controlFrame.allottedClockTicks);
            }
            printStream.print(" " + (Object)((Object)controlFrame.proposition) + "]");
        }
        finally {
            Logic.$PRINTINFRAME$.set(object);
        }
    }

    public static ControlFrame handleTimeout(ControlFrame controlFrame, int n, Object[] objectArray) {
        StandardObject standardObject;
        if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_GOAL_TREE)) {
            System.out.println("*** Timeout: start=" + controlFrame.startingClockTicks + " depth=" + n);
        }
        if ((Logic.$CACHE_SUCCEEDED_GOALSp$ || Logic.$CACHE_FAILED_GOALSp$) && Logic.$DUPLICATE_SUBGOAL_STRATEGY$ == Logic.KWD_DUPLICATE_GOALS && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) == null || ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy == null)) {
            ControlFrame.dontCacheGoalFailureBetweenFrames(controlFrame, ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).baseControlFrame);
        }
        ControlFrame.registerInferenceCutoff(controlFrame, Logic.KWD_TIMEOUT);
        ControlFrame.setFrameTruthValue(controlFrame, Logic.UNKNOWN_TRUTH_VALUE);
        if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null) {
            if (controlFrame.partialMatchFrame == null) {
                ControlFrame.createAndLinkPartialMatchFrame(controlFrame, null);
            }
            controlFrame.partialMatchFrame.setFramePartialTruth(null, 0.0, Double.NEGATIVE_INFINITY, true);
        }
        if (((Boolean)Logic.$RECORD_JUSTIFICATIONSp$.get()).booleanValue()) {
            standardObject = PrimitiveStrategy.newPrimitiveStrategy();
            standardObject.inferenceRule = Logic.KWD_TIMEOUT;
            standardObject.strategy = Logic.KWD_FAILURE;
            ControlFrame.recordGoalJustification(controlFrame, (Justification)standardObject);
        }
        controlFrame.state = Logic.KWD_POPPED;
        controlFrame.up.result = controlFrame;
        controlFrame = controlFrame.up;
        standardObject = controlFrame;
        objectArray[0] = IntegerWrapper.wrapInteger((int)(--n));
        return standardObject;
    }

    public static ControlFrame handleDepthViolation(ControlFrame controlFrame, int n, Object[] objectArray) {
        StandardObject standardObject;
        if (Stella.$TRACED_KEYWORDS$ != null && (Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_GOAL_TREE) || Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_GOAL_CACHES))) {
            System.out.println("*** Inference depth cutoff: depth=" + n);
        }
        ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).triggeredDepthCutoffP = true;
        if ((Logic.$CACHE_SUCCEEDED_GOALSp$ || Logic.$CACHE_FAILED_GOALSp$) && Logic.$DUPLICATE_SUBGOAL_STRATEGY$ == Logic.KWD_DUPLICATE_GOALS && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) == null || ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy == null)) {
            ControlFrame.dontCacheGoalFailureBetweenFrames(controlFrame, ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).baseControlFrame);
        }
        ControlFrame.registerInferenceCutoff(controlFrame, Logic.KWD_DEPTH_VIOLATION);
        if (Logic.$DUPLICATE_SUBGOAL_STRATEGY$ == Logic.KWD_DUPLICATE_GOALS || Logic.$DUPLICATE_SUBGOAL_STRATEGY$ == Logic.KWD_DUPLICATE_GOALS_WITH_CACHING) {
            ControlFrame.setFrameTruthValue(controlFrame, Logic.UNKNOWN_TRUTH_VALUE);
            if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null && controlFrame.partialMatchFrame == null) {
                ControlFrame.createAndLinkPartialMatchFrame(controlFrame, null);
                controlFrame.partialMatchFrame.setFramePartialTruth(null, 0.0, Double.NEGATIVE_INFINITY, true);
            }
            if (((Boolean)Logic.$RECORD_JUSTIFICATIONSp$.get()).booleanValue()) {
                standardObject = PrimitiveStrategy.newPrimitiveStrategy();
                standardObject.inferenceRule = Logic.KWD_DEPTH_CUTOFF;
                standardObject.strategy = Logic.KWD_FAILURE;
                ControlFrame.recordGoalJustification(controlFrame, (Justification)standardObject);
            }
            controlFrame.state = Logic.KWD_POPPED;
            controlFrame.up.result = controlFrame;
            controlFrame = controlFrame.up;
            --n;
        } else {
            standardObject = null;
            ControlFrame controlFrame2 = null;
            int n2 = Integer.MIN_VALUE;
            Object[] objectArray2 = new Object[2];
            standardObject = ControlFrame.findDuplicatedGoal(controlFrame, objectArray2);
            controlFrame2 = (ControlFrame)((Object)objectArray2[0]);
            n2 = ((IntegerWrapper)objectArray2[1]).wrapperValue;
            if (standardObject != null && ControlFrame.findGoalCache((ControlFrame)standardObject) == null && ControlFrame.createGoalCacheP((ControlFrame)standardObject)) {
                if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_GOAL_CACHES)) {
                    System.out.println("*** Inference restart: restartDepth=" + n2);
                }
                if (controlFrame2.down != null) {
                    ControlFrame.popFramesUpTo(controlFrame2.down);
                    controlFrame2.down = null;
                }
                controlFrame = controlFrame2;
                n = n2;
            }
        }
        standardObject = controlFrame;
        objectArray[0] = IntegerWrapper.wrapInteger((int)n);
        return standardObject;
    }

    public static ControlFrame findDuplicatedGoal(ControlFrame controlFrame, Object[] objectArray) {
        Keyword keyword;
        ControlFrame controlFrame2 = controlFrame;
        Proposition proposition = null;
        ControlFrame controlFrame3 = ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).baseControlFrame.down;
        while (controlFrame2 != controlFrame3) {
            proposition = controlFrame2.proposition;
            if (proposition != null && ((keyword = proposition.kind) == Logic.KWD_ISA || keyword == Logic.KWD_PREDICATE || keyword == Logic.KWD_FUNCTION)) {
                ControlFrame controlFrame4 = null;
                ControlFrame controlFrame5 = null;
                int n = Integer.MIN_VALUE;
                Object object = new Object[2];
                controlFrame4 = ControlFrame.helpFindDuplicatedGoal(controlFrame2, object);
                controlFrame5 = (ControlFrame)((Object)object[0]);
                n = ((IntegerWrapper)object[1]).wrapperValue;
                if (controlFrame4 != null) {
                    Logic.traceGoalCache("DUPLICATED GOAL: ", controlFrame2);
                    if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_GOAL_CACHES)) {
                        System.out.println("   RESTART DEPTH " + n);
                    }
                    object = controlFrame4;
                    objectArray[0] = controlFrame5;
                    objectArray[1] = IntegerWrapper.wrapInteger((int)n);
                    return object;
                }
            }
            controlFrame2 = controlFrame2.up;
        }
        if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_GOAL_CACHES)) {
            System.out.println("FAILED TO FIND DUPLICATE GOAL");
        }
        ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).failedToFindDuplicateSubgoalP = true;
        keyword = null;
        objectArray[0] = null;
        objectArray[1] = IntegerWrapper.wrapInteger((int)Integer.MIN_VALUE);
        return keyword;
    }

    public static ControlFrame helpFindDuplicatedGoal(ControlFrame controlFrame, Object[] objectArray) {
        Proposition proposition = controlFrame.proposition;
        Cons cons = controlFrame.goalBindings;
        int n = 1;
        ControlFrame controlFrame2 = null;
        Proposition proposition2 = null;
        ControlFrame controlFrame3 = null;
        ControlFrame controlFrame4 = null;
        int n2 = Integer.MIN_VALUE;
        controlFrame3 = ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).baseControlFrame.down;
        do {
            proposition2 = controlFrame3.proposition;
            boolean bl = false;
            boolean bl2 = bl = proposition2 != null;
            if (bl) {
                boolean bl3 = bl = proposition2.operator == proposition.operator;
                if (bl) {
                    boolean bl4 = bl = controlFrame3.reversePolarityP == controlFrame.reversePolarityP;
                    if (bl) {
                        if (cons == null && controlFrame3.goalBindings == null) {
                            bl = true;
                        } else {
                            boolean bl5 = bl = cons != null;
                            if (bl) {
                                boolean bl6 = bl = controlFrame3.goalBindings != null;
                                if (bl) {
                                    boolean bl7 = true;
                                    Stella_Object stella_Object = null;
                                    Cons cons2 = cons;
                                    Stella_Object stella_Object2 = null;
                                    Cons cons3 = controlFrame3.goalBindings;
                                    while (cons2 != Stella.NIL && cons3 != Stella.NIL) {
                                        stella_Object = cons2.value;
                                        stella_Object2 = cons3.value;
                                        if (!Stella_Object.eqlP((Stella_Object)stella_Object, (Stella_Object)stella_Object2)) {
                                            bl7 = false;
                                            break;
                                        }
                                        cons2 = cons2.rest;
                                        cons3 = cons3.rest;
                                    }
                                    bl = bl7;
                                }
                            }
                        }
                    }
                }
            }
            if (bl) {
                if (controlFrame2 == null) {
                    controlFrame2 = controlFrame3;
                } else {
                    ControlFrame controlFrame5 = controlFrame2;
                    objectArray[0] = controlFrame4;
                    objectArray[1] = IntegerWrapper.wrapInteger((int)n2);
                    return controlFrame5;
                }
            }
            controlFrame4 = controlFrame3;
            n2 = n++;
        } while ((controlFrame3 = controlFrame3.down) != null);
        ControlFrame controlFrame6 = null;
        objectArray[0] = null;
        objectArray[1] = IntegerWrapper.wrapInteger((int)Integer.MIN_VALUE);
        return controlFrame6;
    }

    public static Keyword continuePatternProof(ControlFrame controlFrame, Keyword keyword) {
        if (keyword == Logic.KWD_DOWN) {
            ControlFrame.resetCurrentPatternRecord(controlFrame, Logic.KWD_LOCAL);
            return Logic.KWD_MOVE_DOWN;
        }
        if (keyword == Logic.KWD_UP_TRUE) {
            boolean bl = controlFrame.down != null;
            ControlFrame controlFrame2 = controlFrame.result;
            Proposition proposition = ControlFrame.getRuleOfAntecedentFrame(controlFrame);
            controlFrame.truthValue = TruthValue.weakenTruthValue(ControlFrame.propagateFrameTruthValue(controlFrame2, controlFrame), proposition != null ? (TruthValue)Stella_Object.accessInContext((Stella_Object)proposition.truthValue, (Context)proposition.homeContext, (boolean)false) : Logic.TRUE_TRUTH_VALUE);
            if (controlFrame2.partialMatchFrame != null) {
                controlFrame2.partialMatchFrame.propagateFramePartialTruth(controlFrame);
            }
            if (((Boolean)Logic.$RECORD_JUSTIFICATIONSp$.get()).booleanValue()) {
                ControlFrame.recordPatternJustification(controlFrame, keyword);
            }
            if (controlFrame.patternRecord.collectionList != null) {
                ControlFrame.collectPatternQueryBindings(controlFrame);
                if (bl) {
                    return Logic.KWD_MOVE_DOWN;
                }
                ControlFrame.resetCurrentPatternRecord(controlFrame, Logic.KWD_PARENT);
                return Logic.KWD_CONTINUING_SUCCESS;
            }
            if (ControlFrame.transferPatternQueryBindingsP(controlFrame, bl)) {
                if (bl) {
                    if (((BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_CACHED_SINGLE_VALUEDp, (Stella_Object)Stella.FALSE_WRAPPER)).wrapperValue && !((Boolean)Logic.$GENERATE_ALL_PROOFSp$.get()).booleanValue()) {
                        ControlFrame.popFramesUpTo(controlFrame.down);
                        return Logic.KWD_FINAL_SUCCESS;
                    }
                    return Logic.KWD_CONTINUING_SUCCESS;
                }
                return Logic.KWD_FINAL_SUCCESS;
            }
            if (bl) {
                return Logic.KWD_MOVE_DOWN;
            }
            return Logic.KWD_FAILURE;
        }
        if (keyword == Logic.KWD_UP_FAIL || keyword == Logic.KWD_FAILED_OVERLAY) {
            ControlFrame controlFrame3 = controlFrame.result;
            ControlFrame.propagateFrameTruthValue(controlFrame3, controlFrame);
            if (controlFrame3.partialMatchFrame != null) {
                controlFrame3.partialMatchFrame.propagateFramePartialTruth(controlFrame);
            }
            if (((Boolean)Logic.$RECORD_JUSTIFICATIONSp$.get()).booleanValue()) {
                ControlFrame.recordPatternJustification(controlFrame, keyword);
            }
            if (controlFrame.patternRecord.collectionList != null) {
                ControlFrame.resetCurrentPatternRecord(controlFrame, Logic.KWD_PARENT);
                return Logic.KWD_CONTINUING_SUCCESS;
            }
            return Logic.KWD_FAILURE;
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    public static Proposition getRuleOfAntecedentFrame(ControlFrame controlFrame) {
        ControlFrame controlFrame2;
        if (controlFrame.state == Logic.KWD_PATTERN && (controlFrame2 = controlFrame.up) != null) {
            return (Proposition)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANTECEDENTS_RULE, null);
        }
        return null;
    }

    public static void collectPatternQueryBindings(ControlFrame controlFrame) {
        PatternRecord patternRecord = controlFrame.patternRecord;
        Vector vector = patternRecord.optimalPattern.ioVariables;
        Cons cons = Stella.NIL;
        PatternVariable patternVariable = null;
        Vector vector2 = vector;
        int n = vector2.length();
        Cons cons2 = null;
        for (int i = 0; i < n; ++i) {
            patternVariable = (PatternVariable)vector2.theArray[i];
            if (cons2 == null) {
                cons2 = Stella_Object.cons((Stella_Object)((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord.variableBindings.theArray[patternVariable.boundToOffset], (Cons)Stella.NIL);
                if (cons == Stella.NIL) {
                    cons = cons2;
                    continue;
                }
                Cons.addConsToEndOfConsList((Cons)cons, (Cons)cons2);
                continue;
            }
            cons2 = cons2.rest = Stella_Object.cons((Stella_Object)((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord.variableBindings.theArray[patternVariable.boundToOffset], (Cons)Stella.NIL);
        }
        switch (cons.length()) {
            case 1: {
                if (cons.value == null) {
                    Stella.STANDARD_WARNING.nativeStream.println("Warning: Pushing NULL binding onto collection.  Variable= `" + (Object)((Object)((PatternVariable)vector.theArray[0])) + "'");
                    return;
                }
                patternRecord.collectionList.push(cons.value);
                break;
            }
            default: {
                patternRecord.collectionList.push((Stella_Object)cons);
            }
        }
    }

    public static boolean transferPatternQueryBindingsP(ControlFrame controlFrame, boolean bl) {
        if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_QUERY_STACKS)) {
            System.out.println("TRANSFER-pattern-query-bindings?: ");
        }
        PatternRecord patternRecord = controlFrame.patternRecord;
        BooleanVector booleanVector = patternRecord.booleanVector;
        Vector vector = patternRecord.externalArguments;
        Vector vector2 = patternRecord.optimalPattern.ioVariables;
        int n = booleanVector.length() - 1;
        Cons cons = Stella.NIL;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = n;
        boolean bl2 = n4 == Integer.MIN_VALUE;
        Cons cons2 = null;
        for (int i = 0; bl2 || i <= n4; ++i) {
            n3 = i;
            if (cons2 == null) {
                cons2 = Stella_Object.cons(!BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)((BooleanWrapper)booleanVector.theArray[n3])) ? ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord.variableBindings.theArray[((PatternVariable)vector2.theArray[n3]).boundToOffset] : null, (Cons)Stella.NIL);
                if (cons == Stella.NIL) {
                    cons = cons2;
                    continue;
                }
                Cons.addConsToEndOfConsList((Cons)cons, (Cons)cons2);
                continue;
            }
            cons2 = cons2.rest = Stella_Object.cons(!BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)((BooleanWrapper)booleanVector.theArray[n3])) ? ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord.variableBindings.theArray[((PatternVariable)vector2.theArray[n3]).boundToOffset] : null, (Cons)Stella.NIL);
        }
        ControlFrame.resetCurrentPatternRecord(controlFrame, Logic.KWD_PARENT);
        PatternRecord patternRecord2 = ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord;
        n2 = patternRecord2.topUnbindingStackOffset;
        Stella_Object stella_Object = null;
        Cons cons3 = cons;
        Stella_Object stella_Object2 = null;
        cons2 = vector;
        int n5 = 0;
        int n6 = cons2.length();
        BooleanWrapper booleanWrapper = null;
        BooleanVector booleanVector2 = booleanVector;
        int n7 = booleanVector2.length();
        for (int i = 0; cons3 != Stella.NIL && n5 < n6 && i < n7; ++n5, ++i) {
            stella_Object = cons3.value;
            stella_Object2 = cons2.theArray[n5];
            booleanWrapper = (BooleanWrapper)booleanVector2.theArray[i];
            if (!BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)booleanWrapper) && !Logic.bindArgumentToValueP(stella_Object2, stella_Object, false)) {
                if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_QUERY_STACKS)) {
                    System.out.println("TRANSFER FAILS! ");
                }
                PatternRecord.unbindVariablesBeginningAt(patternRecord2, n2 + 1);
                if (bl) {
                    ControlFrame.resetCurrentPatternRecord(controlFrame, Logic.KWD_LOCAL);
                }
                return false;
            }
            cons3 = cons3.rest;
        }
        return true;
    }

    public static boolean overlayWithPatternFrameP(ControlFrame controlFrame, Description description, Vector vector) {
        int n;
        Cons cons;
        Cons cons2 = Logic.computeExternalBindings(vector);
        Cons cons3 = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)description.dynamicSlots, (Symbol)Logic.SYM_LOGIC_EXTERNAL_VARIABLES, null) != null ? Logic.computeExternalBindings((Vector)KeyValueList.dynamicSlotValue((KeyValueList)description.dynamicSlots, (Symbol)Logic.SYM_LOGIC_EXTERNAL_VARIABLES, null)) : Stella.NIL;
        PatternRecord patternRecord = ControlFrame.createPatternRecord(controlFrame, description, vector);
        Description description2 = null;
        if (vector == null) {
            Iterator iterator = (Iterator)description.ioVariables.allocateIterator();
            cons = null;
            while (iterator.nextP()) {
                if (cons == null) {
                    cons = Stella_Object.cons(null, (Cons)Stella.NIL);
                    if (cons2 == Stella.NIL) {
                        cons2 = cons;
                        continue;
                    }
                    Cons.addConsToEndOfConsList((Cons)cons2, (Cons)cons);
                    continue;
                }
                cons = cons.rest = Stella_Object.cons(null, (Cons)Stella.NIL);
            }
        }
        controlFrame.state = Logic.KWD_PATTERN;
        patternRecord.optimalPattern = description2 = Description.selectOptimalQueryPattern(description, patternRecord.booleanVector, controlFrame);
        if (Description.checkForSingleValuedGoalP(description2, cons2)) {
            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_CACHED_SINGLE_VALUEDp, (Stella_Object)Stella.TRUE_WRAPPER, (Wrapper)Stella.FALSE_WRAPPER);
        }
        controlFrame.proposition = description2.proposition;
        int n2 = cons2.length() + description2.internalVariables.length() + cons3.length();
        PatternRecord.activatePatternRecord(patternRecord, n2);
        PatternVariable patternVariable = null;
        cons = description2.ioVariables;
        int n3 = cons.length();
        Stella_Object stella_Object = null;
        Cons cons4 = cons2;
        for (n = 0; n < n3 && cons4 != Stella.NIL; ++n) {
            patternVariable = (PatternVariable)cons.theArray[n];
            stella_Object = cons4.value;
            if (stella_Object != null && !PatternVariable.bindVariableToValueP(patternVariable, stella_Object, false)) {
                return false;
            }
            cons4 = cons4.rest;
        }
        if (cons3 != Stella.NIL) {
            patternVariable = null;
            cons = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)description2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_EXTERNAL_VARIABLES, null);
            n3 = cons.length();
            stella_Object = null;
            cons4 = cons3;
            for (n = 0; n < n3 && cons4 != Stella.NIL; ++n) {
                patternVariable = (PatternVariable)cons.theArray[n];
                stella_Object = cons4.value;
                if (stella_Object != null && !PatternVariable.bindVariableToValueP(patternVariable, stella_Object, false)) {
                    return false;
                }
                cons4 = cons4.rest;
            }
        }
        if (controlFrame.down == null) {
            ControlFrame.createDownFrame(controlFrame, description2.proposition);
        }
        Proposition.elaborateSurrogatesInProposition(description2.proposition);
        return true;
    }

    public static PatternRecord createPatternRecord(ControlFrame controlFrame, Description description, Vector vector) {
        PatternRecord patternRecord = PatternRecord.newPatternRecord();
        if (description != null) {
            patternRecord.description = description;
            if (vector != null) {
                Vector vector2;
                patternRecord.externalArguments = vector2 = Logic.copyPatternArguments(vector, description);
                patternRecord.booleanVector = Logic.argumentsVectorToBooleanVector(vector2);
            } else {
                List list = List.newList();
                Iterator iterator = (Iterator)description.ioVariables.allocateIterator();
                Cons cons = null;
                while (iterator.nextP()) {
                    if (cons == null) {
                        cons = Stella_Object.cons((Stella_Object)Stella.ZERO_WRAPPER, (Cons)Stella.NIL);
                        if (list.theConsList == Stella.NIL) {
                            list.theConsList = cons;
                            continue;
                        }
                        Cons.addConsToEndOfConsList((Cons)list.theConsList, (Cons)cons);
                        continue;
                    }
                    cons = cons.rest = Stella_Object.cons((Stella_Object)Stella.ZERO_WRAPPER, (Cons)Stella.NIL);
                }
                patternRecord.booleanVector = Logic.zeroOneListToBooleanVector(list);
                list.free();
            }
        }
        patternRecord.collectionList = null;
        controlFrame.patternRecord = patternRecord;
        patternRecord.controlFrame = controlFrame;
        return patternRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Keyword initiateAtomicGoalProofs(ControlFrame controlFrame) {
        Object object = Logic.$REVERSEPOLARITYp$.get();
        try {
            Native.setBooleanSpecial((ThreadLocal)Logic.$REVERSEPOLARITYp$, (boolean)controlFrame.reversePolarityP);
            Proposition proposition = controlFrame.proposition;
            Keyword keyword = Logic.currentInferenceLevel().keyword;
            Cons cons = null;
            Keyword keyword2 = proposition.kind;
            if (keyword2 == Logic.KWD_PREDICATE || keyword2 == Logic.KWD_ISA || keyword2 == Logic.KWD_FUNCTION) {
                controlFrame.goalBindings = Proposition.yieldGoalBindings(proposition);
                if (ControlFrame.checkForDuplicateGoalP(controlFrame)) {
                    if (Logic.$DUPLICATE_SUBGOAL_STRATEGY$ == Logic.KWD_DUPLICATE_GOALS) {
                        keyword = Logic.KWD_SHALLOW;
                    } else {
                        if (Logic.$DUPLICATE_SUBGOAL_STRATEGY$ == Logic.KWD_DUPLICATE_GOALS_WITH_CACHING) {
                            controlFrame.state = Logic.KWD_SCAN_CACHED_BINDINGS;
                            Keyword keyword3 = Logic.KWD_MOVE_IN_PLACE;
                            return keyword3;
                        }
                        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                        outputStringStream.nativeStream.print("`" + Logic.$DUPLICATE_SUBGOAL_STRATEGY$ + "' is not a valid case option");
                        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
                    }
                }
                cons = keyword == Logic.KWD_NORMAL || keyword == Logic.KWD_BACKTRACKING ? Stella.getQuotedTree((String)"((:SPECIALIST :LOOKUP-GOAL-CACHES :LOOKUP-ASSERTIONS :SHALLOW-DISPROOF :ALL-SUBGOAL-STRATEGIES) \"/LOGIC\")", (String)"/LOGIC") : (keyword == Logic.KWD_REFUTATION ? Stella.getQuotedTree((String)"((:SPECIALIST :LOOKUP-GOAL-CACHES :LOOKUP-ASSERTIONS :SHALLOW-DISPROOF :ALL-SUBGOAL-STRATEGIES :REFUTATION) \"/LOGIC\")", (String)"/LOGIC") : Stella.getQuotedTree((String)"((:SPECIALIST :LOOKUP-ASSERTIONS :SHALLOW-DISPROOF) \"/LOGIC\")", (String)"/LOGIC"));
                if (proposition.kind == Logic.KWD_FUNCTION && !((Boolean)Logic.$REVERSEPOLARITYp$.get()).booleanValue()) {
                    cons = Cons.copyConsList((Cons)cons).concatenate(Stella.consList((Cons)Stella_Object.cons((Stella_Object)Logic.KWD_MANUFACTURE_SKOLEM, (Cons)Stella.NIL)), Stella.NIL);
                }
            } else if (keyword2 == Logic.KWD_EQUIVALENT) {
                cons = Stella.getQuotedTree((String)"((:EQUIVALENCE) \"/LOGIC\")", (String)"/LOGIC");
            } else if (keyword2 == Logic.KWD_IMPLIES) {
                cons = Stella.getQuotedTree((String)"((:SPECIALIST :ALL-SUBGOAL-STRATEGIES :IMPLIES) \"/LOGIC\")", (String)"/LOGIC");
            } else {
                OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                outputStringStream.nativeStream.print("`" + keyword2 + "' is not a valid case option");
                throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
            }
            controlFrame.nextStrategies = cons;
            controlFrame.state = Logic.KWD_ATOMIC_GOAL;
            keyword2 = Logic.KWD_MOVE_IN_PLACE;
            return keyword2;
        }
        finally {
            Logic.$REVERSEPOLARITYp$.set(object);
        }
    }

    public static boolean checkForDuplicateGoalP(ControlFrame controlFrame) {
        boolean bl;
        if (Logic.$DUPLICATE_SUBGOAL_STRATEGY$ != Logic.KWD_DUPLICATE_GOALS && Logic.$DUPLICATE_SUBGOAL_STRATEGY$ != Logic.KWD_DUPLICATE_GOALS_WITH_CACHING) {
            return false;
        }
        GeneralizedSymbol generalizedSymbol = controlFrame.proposition.operator;
        Cons cons = controlFrame.goalBindings;
        ControlFrame controlFrame2 = controlFrame.up;
        ControlFrame controlFrame3 = null;
        int n = Integer.MIN_VALUE;
        int n2 = Logic.$DUPLICATE_GOAL_SEARCH_DEPTH$;
        boolean bl2 = bl = n2 == Integer.MIN_VALUE;
        for (int i = 1; bl || i <= n2; ++i) {
            n = i;
            if (controlFrame2 == null) break;
            boolean bl3 = false;
            boolean bl4 = bl3 = controlFrame2.goalBindings != null;
            if (bl3) {
                boolean bl5 = bl3 = generalizedSymbol == controlFrame2.proposition.operator;
                if (bl3) {
                    boolean bl6 = true;
                    Stella_Object stella_Object = null;
                    Cons cons2 = cons;
                    Stella_Object stella_Object2 = null;
                    Cons cons3 = controlFrame2.goalBindings;
                    while (cons2 != Stella.NIL && cons3 != Stella.NIL) {
                        stella_Object = cons2.value;
                        stella_Object2 = cons3.value;
                        if (!Stella_Object.eqlP((Stella_Object)stella_Object, (Stella_Object)stella_Object2)) {
                            bl6 = false;
                            break;
                        }
                        cons2 = cons2.rest;
                        cons3 = cons3.rest;
                    }
                    if (bl3 = bl6) {
                        boolean bl7 = bl3 = controlFrame.reversePolarityP == controlFrame2.reversePolarityP;
                    }
                }
            }
            if (bl3) {
                controlFrame3 = controlFrame2;
                break;
            }
            controlFrame2 = controlFrame2.up;
        }
        if (controlFrame3 != null) {
            Logic.traceGoalCache("DUPLICATE GOAL:", controlFrame);
            if ((Logic.$CACHE_SUCCEEDED_GOALSp$ || Logic.$CACHE_FAILED_GOALSp$) && Logic.$DUPLICATE_SUBGOAL_STRATEGY$ == Logic.KWD_DUPLICATE_GOALS && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) == null || ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy == null)) {
                ControlFrame.dontCacheGoalFailureBetweenFrames(controlFrame, controlFrame3.down);
            }
            return true;
        }
        return false;
    }

    public static Keyword overlayWithStrategyFrame(ControlFrame controlFrame, Keyword keyword) {
        controlFrame.nextStrategies = Stella.consList((Cons)Stella_Object.cons((Stella_Object)keyword, (Cons)Stella.NIL));
        controlFrame.state = Logic.KWD_STRATEGY;
        return Logic.KWD_MOVE_IN_PLACE;
    }

    public static Keyword overlayWithFailFrame(ControlFrame controlFrame, Proposition proposition) {
        Proposition proposition2 = Logic.createProposition(Logic.SYM_LOGIC_FAIL, 1);
        proposition2.arguments.theArray[0] = proposition;
        controlFrame.proposition = proposition2;
        controlFrame.state = Logic.KWD_FAIL;
        controlFrame.reversePolarityP = false;
        return Logic.KWD_MOVE_IN_PLACE;
    }

    public static Keyword continueNotProof(ControlFrame controlFrame, Keyword keyword) {
        if (keyword == Logic.KWD_DOWN) {
            if (controlFrame.down != null) {
                return Logic.KWD_MOVE_DOWN;
            }
            Proposition proposition = (Proposition)controlFrame.proposition.arguments.theArray[0];
            if (!controlFrame.reversePolarityP && Proposition.closedPropositionP(proposition)) {
                return ControlFrame.overlayWithFailFrame(controlFrame, proposition);
            }
            ControlFrame.createDownFrame(controlFrame, proposition);
            controlFrame.down.reversePolarityP = !controlFrame.reversePolarityP;
            return Logic.KWD_MOVE_DOWN;
        }
        if (keyword == Logic.KWD_UP_TRUE) {
            controlFrame.truthValue = TruthValue.invertTruthValue(controlFrame.result.truthValue);
            if (((Boolean)Logic.$RECORD_JUSTIFICATIONSp$.get()).booleanValue()) {
                ControlFrame.recordDisproofJustification(controlFrame, keyword);
            }
            if (controlFrame.down == null) {
                return Logic.KWD_FINAL_SUCCESS;
            }
            return Logic.KWD_CONTINUING_SUCCESS;
        }
        if (keyword == Logic.KWD_UP_FAIL) {
            controlFrame.truthValue = TruthValue.invertTruthValue(controlFrame.result.truthValue);
            if (((Boolean)Logic.$RECORD_JUSTIFICATIONSp$.get()).booleanValue()) {
                ControlFrame.recordDisproofJustification(controlFrame, keyword);
            }
            return Logic.KWD_FAILURE;
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    public static Keyword continueOrProof(ControlFrame controlFrame, Keyword keyword) {
        Proposition proposition = controlFrame.proposition;
        if (keyword == Logic.KWD_DOWN) {
            if (controlFrame.reversePolarityP && Proposition.closedPropositionP(proposition)) {
                return ControlFrame.overlayWithFailFrame(controlFrame, proposition);
            }
            ControlFrame.createChoicePoint(controlFrame);
            return Logic.KWD_MOVE_DOWN;
        }
        if (keyword == Logic.KWD_UP_TRUE) {
            controlFrame.truthValue = controlFrame.result.truthValue;
            if (((Boolean)Logic.$RECORD_JUSTIFICATIONSp$.get()).booleanValue()) {
                ControlFrame.recordOrIntroductionJustification(controlFrame, keyword);
            }
            if (controlFrame.down == null) {
                ++controlFrame.argumentCursor;
            }
            if (controlFrame.argumentCursor >= proposition.arguments.length() || !ControlFrame.newBindingsSinceLastChoicePointP(controlFrame) && !((Boolean)Logic.$GENERATE_ALL_PROOFSp$.get()).booleanValue()) {
                if (controlFrame.down != null) {
                    ControlFrame.popFramesUpTo(controlFrame.down);
                }
                return Logic.KWD_FINAL_SUCCESS;
            }
            return Logic.KWD_CONTINUING_SUCCESS;
        }
        if (keyword == Logic.KWD_UP_FAIL) {
            TruthValue truthValue;
            TruthValue truthValue2 = null;
            truthValue2 = controlFrame.truthValue == null ? ((truthValue = controlFrame.result.truthValue) != null ? truthValue : Logic.UNKNOWN_TRUTH_VALUE) : TruthValue.disjoinTruthValues(controlFrame.truthValue, controlFrame.result.truthValue);
            controlFrame.truthValue = truthValue2;
            ++controlFrame.argumentCursor;
            if (controlFrame.argumentCursor < proposition.arguments.length()) {
                ControlFrame.createChoicePoint(controlFrame);
                return Logic.KWD_MOVE_DOWN;
            }
            if (Logic.currentInferenceLevel().keyword == Logic.KWD_REFUTATION) {
                ControlFrame.overlayWithStrategyFrame(controlFrame, Logic.KWD_DISJUNCTIVE_IMPLICATION_INTRODUCTION);
                return Logic.KWD_MOVE_IN_PLACE;
            }
            return Logic.KWD_FAILURE;
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    public static Keyword continueAndProof(ControlFrame controlFrame, Keyword keyword) {
        Proposition proposition = controlFrame.proposition;
        Vector vector = null;
        if (keyword == Logic.KWD_DOWN) {
            if (proposition.clusteredConjunctionP()) {
                ControlFrame.overlayWithStrategyFrame(controlFrame, Logic.KWD_CLUSTERED_CONJUNCTION);
                return Logic.KWD_MOVE_IN_PLACE;
            }
            if (controlFrame.reversePolarityP && Proposition.closedPropositionP(proposition)) {
                return ControlFrame.overlayWithFailFrame(controlFrame, proposition);
            }
            vector = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ARGUMENTS, null);
            if (vector == null) {
                vector = Vector.newVector((int)proposition.arguments.length());
                KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ARGUMENTS, (Stella_Object)vector, null);
                if (Proposition.dynamicallyOptimizePropositionP(proposition)) {
                    controlFrame.proposition = proposition = Proposition.shallowCopyProposition(proposition);
                }
            }
            if (Proposition.dynamicallyOptimizePropositionP(proposition) && controlFrame.down == null) {
                Logic.dynamicallyReoptimizeArguments(proposition.arguments, controlFrame.argumentCursor);
            }
            return Logic.KWD_MOVE_DOWN;
        }
        if (keyword == Logic.KWD_UP_TRUE) {
            vector = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ARGUMENTS, null);
            vector.theArray[controlFrame.argumentCursor] = controlFrame.result;
            if (controlFrame.argumentCursor == vector.length() - 1) {
                controlFrame.down = null;
                ControlFrame controlFrame2 = null;
                Vector vector2 = vector;
                int n = 0;
                int n2 = vector2.length();
                int n3 = Integer.MIN_VALUE;
                int n4 = 0;
                while (n < n2) {
                    controlFrame2 = (ControlFrame)vector2.theArray[n];
                    n3 = n4;
                    TruthValue truthValue = controlFrame.truthValue = n3 == 0 ? controlFrame2.truthValue : TruthValue.conjoinTruthValues(controlFrame.truthValue, controlFrame2.truthValue);
                    if (controlFrame2.state != Logic.KWD_POPPED) {
                        controlFrame.argumentCursor = n3;
                        controlFrame.down = controlFrame2;
                    }
                    ++n;
                    ++n4;
                }
                if (((Boolean)Logic.$RECORD_JUSTIFICATIONSp$.get()).booleanValue()) {
                    ControlFrame.recordAndIntroductionJustification(controlFrame, keyword);
                }
                if (controlFrame.down != null) {
                    return Logic.KWD_CONTINUING_SUCCESS;
                }
                return Logic.KWD_FINAL_SUCCESS;
            }
            controlFrame.down = null;
            ++controlFrame.argumentCursor;
            if (Proposition.dynamicallyOptimizePropositionP(proposition)) {
                Logic.dynamicallyReoptimizeArguments(proposition.arguments, controlFrame.argumentCursor);
            }
            return Logic.KWD_MOVE_DOWN;
        }
        if (keyword == Logic.KWD_UP_FAIL) {
            boolean bl;
            vector = (Vector)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ARGUMENTS, null);
            if (vector == null) {
                controlFrame.truthValue = TruthValue.conjoinTruthValues(Logic.UNKNOWN_TRUTH_VALUE, controlFrame.result.truthValue);
                return Logic.KWD_FAILURE;
            }
            controlFrame.down = null;
            ControlFrame controlFrame3 = null;
            Vector vector3 = vector;
            int n = 0;
            int n5 = vector3.length();
            int n6 = Integer.MIN_VALUE;
            int n7 = 0;
            while (n < n5) {
                controlFrame3 = (ControlFrame)vector3.theArray[n];
                n6 = n7;
                if (controlFrame3 == null) break;
                if (controlFrame3.state != Logic.KWD_POPPED) {
                    controlFrame.argumentCursor = n6;
                    controlFrame.down = controlFrame3;
                }
                ++n;
                ++n7;
            }
            if (controlFrame.down != null) {
                return Logic.KWD_MOVE_DOWN;
            }
            ControlFrame.propagateFrameTruthValue(controlFrame.result, controlFrame);
            vector.theArray[controlFrame.argumentCursor] = controlFrame.result;
            controlFrame3 = null;
            vector3 = vector;
            n = 0;
            n5 = vector3.length();
            n6 = Integer.MIN_VALUE;
            int n8 = controlFrame.argumentCursor;
            boolean bl2 = bl = n8 == Integer.MIN_VALUE;
            for (n7 = 0; n < n5 && (bl || n7 <= n8); ++n, ++n7) {
                controlFrame3 = (ControlFrame)vector3.theArray[n];
                n6 = n7;
                if (controlFrame3 == null) break;
                controlFrame.truthValue = TruthValue.conjoinTruthValues(controlFrame.truthValue, controlFrame3.truthValue);
            }
            return Logic.KWD_FAILURE;
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
        throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
    }

    public static Keyword evaluateNextMove(ControlFrame controlFrame, Keyword keyword, int n) {
        Keyword keyword2 = controlFrame.state;
        if (keyword2 == Logic.KWD_AND) {
            if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null) {
                return controlFrame.continuePartialAndProof(controlFrame, keyword);
            }
            return ControlFrame.continueAndProof(controlFrame, keyword);
        }
        if (keyword2 == Logic.KWD_OR) {
            if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null) {
                return controlFrame.continuePartialOrProof(keyword);
            }
            return ControlFrame.continueOrProof(controlFrame, keyword);
        }
        if (keyword2 == Logic.KWD_NOT) {
            if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null) {
                return controlFrame.continuePartialNotProof(keyword);
            }
            return ControlFrame.continueNotProof(controlFrame, keyword);
        }
        if (keyword2 == Logic.KWD_ISA || keyword2 == Logic.KWD_FUNCTION || keyword2 == Logic.KWD_PREDICATE || keyword2 == Logic.KWD_EQUIVALENT || keyword2 == Logic.KWD_IMPLIES) {
            ControlFrame.createChoicePoint(controlFrame);
            return ControlFrame.initiateAtomicGoalProofs(controlFrame);
        }
        if (keyword2 == Logic.KWD_ATOMIC_GOAL || keyword2 == Logic.KWD_STRATEGY) {
            if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null) {
                return controlFrame.continuePartialStrategiesProofs(keyword);
            }
            return ControlFrame.continueStrategiesProofs(controlFrame, keyword);
        }
        if (keyword2 == Logic.KWD_SCAN_CACHED_BINDINGS) {
            return ControlFrame.continueCachedBindingsProof(controlFrame, keyword);
        }
        if (keyword2 == Logic.KWD_PATTERN) {
            return ControlFrame.continuePatternProof(controlFrame, keyword);
        }
        if (keyword2 == Logic.KWD_FORALL) {
            return ControlFrame.continueForallProof(controlFrame, keyword);
        }
        if (keyword2 == Logic.KWD_CONTAINED_BY || keyword2 == Logic.KWD_ITERATIVE_FORALL) {
            if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null) {
                keyword = ControlFrame.interpretIterativeForallScores(controlFrame, keyword);
            }
            return ControlFrame.continueContainedByProof(controlFrame, keyword);
        }
        if (keyword2 == Logic.KWD_EXISTS) {
            return ControlFrame.continueExistsProof(controlFrame, keyword);
        }
        if (keyword2 == Logic.KWD_CONSTANT) {
            return ControlFrame.continueConstantProof(controlFrame, keyword);
        }
        if (keyword2 == Logic.KWD_FAIL) {
            if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null) {
                return controlFrame.continuePartialFailProof(keyword);
            }
            return ControlFrame.continueFailProof(controlFrame, keyword);
        }
        if (keyword2 == Logic.KWD_PARALLEL_STRATEGIES) {
            return ParallelControlFrame.continueParallelStrategiesProofs((ParallelControlFrame)controlFrame, keyword);
        }
        OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
        outputStringStream.nativeStream.println("Error.  No query state implemented for operator `" + controlFrame.state + "'");
        throw (FailException)((Object)FailException.newFailException(outputStringStream.theStringReader()).fillInStackTrace());
    }

    public static ParallelControlFrame parallelizeControlFrame(ControlFrame controlFrame) {
        if (controlFrame.state == Logic.KWD_PARALLEL_STRATEGIES) {
            return (ParallelControlFrame)controlFrame;
        }
        ParallelControlFrame parallelControlFrame = ParallelControlFrame.newParallelControlFrame();
        parallelControlFrame.state = Logic.KWD_PARALLEL_STRATEGIES;
        ControlFrame.copyFrameState(controlFrame, parallelControlFrame);
        controlFrame.up.down = parallelControlFrame;
        controlFrame.nextStrategies = Stella.NIL;
        KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_CACHED_BINDINGS_ITERATOR, null, null);
        KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_GOAL_CACHE, null, null);
        boolean bl = parallelControlFrame.unboundVariablesP = !Proposition.allArgumentsBoundP(parallelControlFrame.proposition);
        if (controlFrame.down != null || (Iterator)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, null) != null) {
            ParallelThread parallelThread = ParallelThread.newParallelThread();
            controlFrame.up = parallelControlFrame;
            parallelThread.topControlFrame = controlFrame;
            parallelControlFrame.childThreads.insert((Stella_Object)parallelThread);
            if (parallelControlFrame.unboundVariablesP) {
                PatternRecord patternRecord = controlFrame.inheritedPatternRecord;
                parallelThread.variableBindings = patternRecord.variableBindings.copy();
                parallelThread.unbindingStack = (IntegerVector)patternRecord.unbindingStack.copy();
                parallelThread.topUnbindingStackOffset = patternRecord.topUnbindingStackOffset;
            }
        }
        if (((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentControlFrame == controlFrame) {
            ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentControlFrame = parallelControlFrame;
        }
        return parallelControlFrame;
    }

    public static void copyFrameState(ControlFrame controlFrame, ControlFrame controlFrame2) {
        controlFrame2.proposition = controlFrame.proposition;
        KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTION, (Stella_Object)((Description)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DESCRIPTION, null)), null);
        controlFrame2.reversePolarityP = controlFrame.reversePolarityP;
        controlFrame2.up = controlFrame.up;
        controlFrame2.partialMatchFrame = controlFrame.partialMatchFrame;
        controlFrame2.inheritedPatternRecord = controlFrame.inheritedPatternRecord;
        controlFrame2.choicePointUnbindingOffset = controlFrame.choicePointUnbindingOffset;
        controlFrame2.nextStrategies = controlFrame.nextStrategies;
        KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_CACHED_BINDINGS_ITERATOR, (Stella_Object)((Iterator)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_CACHED_BINDINGS_ITERATOR, null)), null);
        controlFrame2.goalBindings = controlFrame.goalBindings;
        KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_GOAL_CACHE, (Stella_Object)((GoalCache)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_GOAL_CACHE, null)), null);
    }

    public static int debugFrameId(ControlFrame controlFrame) {
        int n = ((IntegerWrapper)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DEBUG_FRAME_ID_INTERNAL, (Stella_Object)Stella.NULL_INTEGER_WRAPPER)).wrapperValue;
        if (n == Integer.MIN_VALUE) {
            n = ++Logic.$CONTROL_FRAME_ID_COUNTER$;
            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_DEBUG_FRAME_ID_INTERNAL, (Stella_Object)IntegerWrapper.wrapInteger((int)n), (Wrapper)Stella.NULL_INTEGER_WRAPPER);
        }
        return n;
    }

    public static TruthValue propagateFrameTruthValue(ControlFrame controlFrame, ControlFrame controlFrame2) {
        controlFrame2.truthValue = controlFrame.reversePolarityP != controlFrame2.reversePolarityP ? TruthValue.invertTruthValue(controlFrame.truthValue) : controlFrame.truthValue;
        return controlFrame2.truthValue;
    }

    public static TruthValue setFrameTruthValue(ControlFrame controlFrame, TruthValue truthValue) {
        controlFrame.truthValue = controlFrame.reversePolarityP ? TruthValue.invertTruthValue(truthValue) : truthValue;
        return controlFrame.truthValue;
    }

    public static ControlFrame createDownFrame(ControlFrame controlFrame, Proposition proposition) {
        ControlFrame controlFrame2;
        controlFrame.down = controlFrame2 = ControlFrame.newControlFrame();
        controlFrame2.up = controlFrame;
        controlFrame2.reversePolarityP = controlFrame.reversePolarityP;
        controlFrame2.proposition = proposition;
        controlFrame2.down = null;
        KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_BACK, null, null);
        controlFrame2.patternRecord = null;
        controlFrame2.truthValue = null;
        controlFrame2.justifications.clear();
        KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_JUSTIFICATION, null, null);
        KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_GOAL_CACHE, null, null);
        controlFrame2.goalBindings = null;
        KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_CACHED_BINDINGS_ITERATOR, null, null);
        if (proposition != null) {
            controlFrame2.state = proposition.kind;
            if (controlFrame2.reversePolarityP) {
                Keyword keyword = controlFrame2.state;
                if (keyword == Logic.KWD_AND) {
                    controlFrame2.state = Logic.KWD_OR;
                } else if (keyword == Logic.KWD_OR) {
                    controlFrame2.state = Logic.KWD_AND;
                }
            }
            controlFrame2.argumentCursor = 0;
        }
        controlFrame2.inheritedPatternRecord = ControlFrame.operativePatternRecord(controlFrame);
        return controlFrame2;
    }

    public static PatternRecord operativePatternRecord(ControlFrame controlFrame) {
        return controlFrame.patternRecord != null ? controlFrame.patternRecord : controlFrame.inheritedPatternRecord;
    }

    public Keyword continuePartialStrategiesProofs(Keyword keyword) {
        ControlFrame controlFrame = this;
        if (controlFrame.currentStrategy == Logic.KWD_FULL_SUBQUERY) {
            return ControlFrame.continueStrategiesProofs(controlFrame, keyword);
        }
        PartialMatchFrame partialMatchFrame = controlFrame.partialMatchFrame;
        if (partialMatchFrame == null) {
            ControlFrame.createAndLinkPartialMatchFrame(controlFrame, Logic.KWD_ATOMIC_GOAL);
        }
        return controlFrame.partialMatchFrame.continuePartialStrategiesProofs(keyword);
    }

    public static void attachSupport(ControlFrame controlFrame, Keyword keyword) {
        if (keyword != Logic.KWD_DOWN && controlFrame.currentStrategy == Logic.KWD_ANTECEDENTS && Stella_Object.isaP((Stella_Object)controlFrame.partialMatchFrame, (Surrogate)Logic.SGT_LOGIC_NN_PARTIAL_MATCH) && controlFrame.partialMatchFrame.child != null) {
            NnPartialMatch nnPartialMatch = (NnPartialMatch)controlFrame.partialMatchFrame;
            PartialSupport partialSupport = PartialSupport.newPartialSupport();
            partialSupport.id = ++Logic.$PARTIAL_SUPPORT_COUNTER$;
            partialSupport.axiom = (Proposition)nnPartialMatch.rules.value;
            partialSupport.fact = ((NnPartialMatch)nnPartialMatch.child).controlFrame.proposition;
            partialSupport.argumentScores = Cons.copyConsList((Cons)((NnPartialMatch)nnPartialMatch.child).argumentScores).reverse();
            partialSupport.score = ((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)partialSupport.fact.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MATCH_SCORE, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue;
            if (controlFrame.proposition.support() != null) {
                KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_SUPPORT, (Stella_Object)Stella_Object.cons((Stella_Object)partialSupport, (Cons)controlFrame.proposition.support()), null);
            } else {
                KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_SUPPORT, (Stella_Object)Stella.consList((Cons)Stella_Object.cons((Stella_Object)partialSupport, (Cons)Stella.NIL)), null);
            }
        } else {
            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_SUPPORT, null, null);
        }
    }

    public static Keyword oldInterpretGoalScores(ControlFrame controlFrame, Keyword keyword) {
        PartialMatchFrame partialMatchFrame;
        if (keyword == Logic.KWD_DOWN) {
            partialMatchFrame = controlFrame.partialMatchFrame;
            if (partialMatchFrame == null) {
                ControlFrame.createAndLinkPartialMatchFrame(controlFrame, Logic.KWD_ATOMIC_GOAL);
            } else {
                partialMatchFrame.setDynamicCutoff();
            }
        } else if (keyword == Logic.KWD_UP_TRUE || keyword == Logic.KWD_UP_FAIL) {
            if (Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_GOAL_TREE)) {
                System.out.println(((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).dynamicSlots, (Symbol)Logic.SYM_LOGIC_LATEST_POSITIVE_SCORE, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue);
            }
            if (controlFrame.currentStrategy == Logic.KWD_FULL_SUBQUERY || controlFrame.currentStrategy == Logic.KWD_ANTECEDENTS) {
                ControlFrame.recordLatestPartialMatchScore(controlFrame);
                keyword = ControlFrame.computePartialMatchOrSuccessP(controlFrame) && !ControlFrame.unboundVariablesInFrameP(controlFrame) ? Logic.KWD_UP_TRUE : (((Iterator)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_ITERATOR, null)).emptyP() && !ControlFrame.unboundVariablesInFrameP(controlFrame) && ControlFrame.computePartialMatchScoreP(controlFrame) ? Logic.KWD_UP_TRUE : Logic.KWD_UP_FAIL);
            }
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        ControlFrame.attachSupport(controlFrame, keyword);
        if (keyword == Logic.KWD_UP_FAIL && controlFrame.down != null) {
            controlFrame.down = null;
        }
        if ((partialMatchFrame = ControlFrame.continueStrategiesProofs(controlFrame, keyword)) == Logic.KWD_FAILURE && ControlFrame.computePartialMatchScoreP(controlFrame)) {
            keyword = Logic.KWD_UP_TRUE;
            return Logic.KWD_FINAL_SUCCESS;
        }
        return partialMatchFrame;
    }

    public Keyword continuePartialNotProof(Keyword keyword) {
        ControlFrame controlFrame = this;
        PartialMatchFrame partialMatchFrame = controlFrame.partialMatchFrame;
        if (partialMatchFrame == null) {
            ControlFrame.createAndLinkPartialMatchFrame(controlFrame, Logic.KWD_NOT);
        }
        return controlFrame.partialMatchFrame.continuePartialNotProof(keyword);
    }

    public static Keyword oldInterpretFailScore(ControlFrame controlFrame, Keyword keyword) {
        if (keyword == Logic.KWD_DOWN) {
            KeyValueList.setDynamicSlotValue((KeyValueList)((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).dynamicSlots, (Symbol)Logic.SYM_LOGIC_LATEST_POSITIVE_SCORE, (Stella_Object)FloatWrapper.wrapFloat((double)0.0), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
            if (controlFrame.partialMatchFrame == null) {
                ControlFrame.createAndLinkPartialMatchFrame(controlFrame, Logic.KWD_NOT);
            }
        } else if (keyword == Logic.KWD_UP_TRUE || keyword == Logic.KWD_UP_FAIL) {
            ControlFrame.recordLatestPartialMatchScore(controlFrame);
            keyword = ControlFrame.computePartialMatchScoreP(controlFrame) ? Logic.KWD_UP_TRUE : Logic.KWD_UP_FAIL;
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        return keyword;
    }

    public Keyword continuePartialOrProof(Keyword keyword) {
        ControlFrame controlFrame = this;
        PartialMatchFrame partialMatchFrame = controlFrame.partialMatchFrame;
        if (partialMatchFrame == null) {
            ControlFrame.createAndLinkPartialMatchFrame(controlFrame, Logic.KWD_OR);
        }
        return controlFrame.partialMatchFrame.continuePartialOrProof(keyword);
    }

    public static Keyword oldInterpretOrScores(ControlFrame controlFrame, Keyword keyword) {
        if (keyword == Logic.KWD_DOWN) {
            PartialMatchFrame partialMatchFrame = controlFrame.partialMatchFrame;
            if (partialMatchFrame == null) {
                ControlFrame.createAndLinkPartialMatchFrame(controlFrame, Logic.KWD_OR);
            } else {
                while (controlFrame.partialMatchFrame.argumentScores.length() > controlFrame.argumentCursor) {
                    controlFrame.partialMatchFrame.popPartialMatchScore();
                }
                partialMatchFrame.setDynamicCutoff();
            }
        } else if (keyword == Logic.KWD_UP_TRUE || keyword == Logic.KWD_UP_FAIL) {
            ControlFrame.recordLatestPartialMatchScore(controlFrame);
            if (Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_GOAL_TREE)) {
                System.out.println(((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).dynamicSlots, (Symbol)Logic.SYM_LOGIC_LATEST_POSITIVE_SCORE, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue + ", " + controlFrame.partialMatchFrame.computeOrScore());
            }
            keyword = ControlFrame.computePartialMatchOrSuccessP(controlFrame) ? Logic.KWD_UP_TRUE : (controlFrame.argumentCursor + 1 == controlFrame.proposition.arguments.length() && ControlFrame.computePartialMatchScoreP(controlFrame) ? Logic.KWD_UP_TRUE : Logic.KWD_UP_FAIL);
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        return keyword;
    }

    public static Keyword interpretIterativeForallScores(ControlFrame controlFrame, Keyword keyword) {
        if (keyword == Logic.KWD_DOWN) {
            if (controlFrame.partialMatchFrame == null) {
                ControlFrame.createAndLinkPartialMatchFrame(controlFrame, Logic.KWD_ITERATIVE_FORALL);
            } else {
                while (controlFrame.partialMatchFrame.argumentScores.length() > controlFrame.argumentCursor) {
                    controlFrame.partialMatchFrame.popPartialMatchScore();
                }
            }
        } else if (keyword == Logic.KWD_UP_TRUE || keyword == Logic.KWD_UP_FAIL) {
            ControlFrame.recordLatestPartialMatchScore(controlFrame);
            if (Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_GOAL_TREE)) {
                System.out.println("ITERATIVE-FORALL " + ((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).dynamicSlots, (Symbol)Logic.SYM_LOGIC_LATEST_POSITIVE_SCORE, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue);
            }
            if (((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).dynamicSlots, (Symbol)Logic.SYM_LOGIC_LATEST_POSITIVE_SCORE, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue < 0.9) {
                keyword = Logic.KWD_UP_FAIL;
            }
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        return keyword;
    }

    public Keyword continuePartialAndProof(ControlFrame controlFrame, Keyword keyword) {
        ControlFrame controlFrame2 = this;
        PartialMatchFrame partialMatchFrame = controlFrame2.partialMatchFrame;
        if (partialMatchFrame == null) {
            ControlFrame.createAndLinkPartialMatchFrame(controlFrame2, Logic.KWD_AND);
        }
        return controlFrame2.partialMatchFrame.continuePartialAndProof(controlFrame, keyword);
    }

    public static Keyword oldInterpretAndScores(ControlFrame controlFrame, Keyword keyword) {
        if (keyword == Logic.KWD_DOWN) {
            PartialMatchFrame partialMatchFrame = controlFrame.partialMatchFrame;
            if (partialMatchFrame == null) {
                ControlFrame.createAndLinkPartialMatchFrame(controlFrame, Logic.KWD_AND);
            } else {
                while (controlFrame.partialMatchFrame.argumentScores.length() > controlFrame.argumentCursor) {
                    controlFrame.partialMatchFrame.popPartialMatchScore();
                }
                partialMatchFrame.setDynamicCutoff();
            }
        } else if (keyword == Logic.KWD_UP_TRUE || keyword == Logic.KWD_UP_FAIL) {
            PartialMatchFrame partialMatchFrame = controlFrame.partialMatchFrame;
            int n = controlFrame.proposition.arguments.length();
            int n2 = 0;
            partialMatchFrame.successP = keyword == Logic.KWD_UP_TRUE;
            ControlFrame.recordLatestPartialMatchScore(controlFrame);
            if (Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_GOAL_TREE)) {
                System.out.println(((FloatWrapper)KeyValueList.dynamicSlotValue((KeyValueList)((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).dynamicSlots, (Symbol)Logic.SYM_LOGIC_LATEST_POSITIVE_SCORE, (Stella_Object)Stella.NULL_FLOAT_WRAPPER)).wrapperValue + ", " + controlFrame.partialMatchFrame.computeAndScore());
            }
            if (partialMatchFrame.unboundVars != Stella.NIL) {
                KeyValueList.setDynamicSlotValue((KeyValueList)((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).dynamicSlots, (Symbol)Logic.SYM_LOGIC_LATEST_POSITIVE_SCORE, (Stella_Object)FloatWrapper.wrapFloat((double)0.0), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
                while (true) {
                    boolean bl = false;
                    boolean bl2 = bl = controlFrame.argumentCursor + 1 < n;
                    if (bl) {
                        boolean bl3 = false;
                        Stella_Object stella_Object = null;
                        Cons cons = Proposition.getUnboundVariables((Proposition)controlFrame.proposition.arguments.theArray[controlFrame.argumentCursor + 1]);
                        while (cons != Stella.NIL) {
                            stella_Object = cons.value;
                            if (Stella_Object.searchConsTreeP((Stella_Object)partialMatchFrame.unboundVars, (Stella_Object)stella_Object)) {
                                bl3 = true;
                                break;
                            }
                            cons = cons.rest;
                        }
                        bl = bl3;
                    }
                    if (!bl) break;
                    ++n2;
                    ++controlFrame.argumentCursor;
                    ControlFrame.recordLatestPartialMatchScore(controlFrame);
                }
                partialMatchFrame.unboundVars = Stella.NIL;
                if (Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_GOAL_TREE)) {
                    System.out.println("   *** Skipping " + n2 + " propositions . . .");
                }
            }
            if (Logic.$FAIL_UNBOUND_CLAUSESp$) {
                while (controlFrame.argumentCursor + 1 < n && Proposition.allVariablesUnboundP((Proposition)controlFrame.proposition.arguments.theArray[controlFrame.argumentCursor + 1])) {
                    ++n2;
                    ++controlFrame.argumentCursor;
                    KeyValueList.setDynamicSlotValue((KeyValueList)((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).dynamicSlots, (Symbol)Logic.SYM_LOGIC_LATEST_POSITIVE_SCORE, (Stella_Object)FloatWrapper.wrapFloat((double)0.0), (Wrapper)Stella.NULL_FLOAT_WRAPPER);
                    ControlFrame.recordLatestPartialMatchScore(controlFrame);
                }
                if (n2 > 0 && Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_GOAL_TREE)) {
                    System.out.println("   *** Skipping " + n2 + " propositions . . .");
                }
            }
            keyword = ControlFrame.computePartialMatchAndFailureP(controlFrame) ? Logic.KWD_UP_FAIL : (controlFrame.argumentCursor + 1 == n && !ControlFrame.computePartialMatchScoreP(controlFrame) ? Logic.KWD_UP_FAIL : Logic.KWD_UP_TRUE);
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
        if (keyword == Logic.KWD_UP_FAIL && controlFrame.down != null) {
            controlFrame.down = null;
        }
        return keyword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traceGoalTree(ControlFrame controlFrame, int n, Keyword keyword) {
        Object object;
        if (keyword == Logic.KWD_DOWN) {
            ControlFrame.unwindToChoicePointsBelowFrame(controlFrame);
        }
        if (controlFrame.state == Logic.KWD_ITERATIVE_FORALL && keyword == Logic.KWD_DOWN) {
            return;
        }
        if (Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_STATE_MACHINE)) {
            if (Surrogate.subtypeOfP((Surrogate)Stella_Object.safePrimaryType((Stella_Object)controlFrame), (Surrogate)Logic.SGT_LOGIC_PARALLEL_CONTROL_FRAME)) {
                object = (ParallelControlFrame)controlFrame;
                System.out.print("P" + ControlFrame.debugFrameId(object));
            } else {
                System.out.print("F" + ControlFrame.debugFrameId(controlFrame));
            }
            if (controlFrame.choicePointUnbindingOffset != Integer.MIN_VALUE) {
                System.out.print("," + controlFrame.choicePointUnbindingOffset + " ");
            } else {
                System.out.print("   ");
            }
            System.out.print(controlFrame.truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE || controlFrame.truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE ? "D " : "S ");
        }
        if (controlFrame.state == Logic.KWD_PARALLEL_STRATEGIES || controlFrame.state == Logic.KWD_STRATEGY && controlFrame.currentStrategy == null) {
            return;
        }
        if (keyword != Logic.KWD_DOWN || !Stella.getQuotedTree((String)"((:ATOMIC-GOAL :STRATEGY) \"/LOGIC\")", (String)"/LOGIC").memberP((Stella_Object)controlFrame.state) || (Keyword)controlFrame.nextStrategies.value != Logic.KWD_SPECIALIST || Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_STRATEGIES)) {
            Logic.printVerticalBars(n);
        }
        if (keyword == Logic.KWD_DOWN) {
            object = controlFrame.state;
            if (object == Logic.KWD_ATOMIC_GOAL || object == Logic.KWD_STRATEGY) {
                if ((Keyword)controlFrame.nextStrategies.value == Logic.KWD_SPECIALIST) {
                    if (Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_STRATEGIES)) {
                        System.out.print("TRY STRATEGIES: ");
                    }
                    return;
                }
                ControlFrame.printGoalInGoalTree(controlFrame, n);
                if (Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_STRATEGIES)) {
                    System.out.println();
                    Logic.printVerticalBars(n);
                    System.out.print("STRATEGY: ");
                    return;
                }
            } else if (object == Logic.KWD_PATTERN) {
                ControlFrame controlFrame2;
                if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_STRATEGIES)) {
                    System.out.println();
                }
                if ((controlFrame2 = controlFrame.up) != null && (Proposition)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANTECEDENTS_RULE, null) != null) {
                    ControlFrame.printRuleInGoalTree(controlFrame, (Proposition)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame2.dynamicSlots, (Symbol)Logic.SYM_LOGIC_ANTECEDENTS_RULE, null), n);
                } else {
                    if ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null && ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).partialMatchStrategy != null) {
                        System.out.println();
                    }
                    if (controlFrame.patternRecord.collectionList != null) {
                        System.out.print("COLLECTION: [");
                    } else {
                        System.out.print("PATTERN: [");
                    }
                    boolean bl = true;
                    BooleanWrapper booleanWrapper = null;
                    BooleanVector booleanVector = controlFrame.patternRecord.booleanVector;
                    int n2 = booleanVector.length();
                    for (int i = 0; i < n2; ++i) {
                        booleanWrapper = (BooleanWrapper)booleanVector.theArray[i];
                        if (bl) {
                            bl = false;
                        } else {
                            System.out.print(",");
                        }
                        if (BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)booleanWrapper)) {
                            System.out.print("T");
                            continue;
                        }
                        System.out.print("F");
                    }
                    System.out.print("]");
                }
            } else {
                ControlFrame.printGoalInGoalTree(controlFrame, n);
            }
        } else if (keyword == Logic.KWD_UP_TRUE) {
            System.out.print("| SUCC: ");
            object = Logic.$PRINTINFRAME$.get();
            try {
                Native.setSpecial((ThreadLocal)Logic.$PRINTINFRAME$, (Object)((Object)controlFrame));
                ControlFrame.printVariableBindings(controlFrame);
            }
            finally {
                Logic.$PRINTINFRAME$.set(object);
            }
            object = controlFrame.truthValue;
            if (object != null) {
                System.out.print("truth=");
                if (object == Logic.TRUE_TRUTH_VALUE || object == Logic.DEFAULT_TRUE_TRUTH_VALUE) {
                    if (object == Logic.DEFAULT_TRUE_TRUTH_VALUE || object == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
                        System.out.print("t");
                    } else {
                        System.out.print("T");
                    }
                } else if (object == Logic.FALSE_TRUTH_VALUE || object == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
                    if (object == Logic.DEFAULT_TRUE_TRUTH_VALUE || object == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
                        System.out.print("f");
                    } else {
                        System.out.print("F");
                    }
                } else if (object == Logic.UNKNOWN_TRUTH_VALUE || object == null) {
                    System.out.print("U");
                } else {
                    System.out.print("?");
                }
            }
        } else if (keyword == Logic.KWD_UP_FAIL) {
            System.out.print("| FAIL");
            object = controlFrame.state;
            if ((object == Logic.KWD_ATOMIC_GOAL || object == Logic.KWD_STRATEGY) && Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_STRATEGIES) && controlFrame.nextStrategies != Stella.NIL) {
                System.out.println();
                Logic.printVerticalBars(n);
                System.out.print("TRY STRATEGIES: ");
                return;
            }
            object = controlFrame.truthValue;
            if (object != null || controlFrame.partialMatchFrame != null) {
                System.out.print(":");
            }
            if (object != null) {
                System.out.print(" truth=");
                if (object == Logic.TRUE_TRUTH_VALUE || object == Logic.DEFAULT_TRUE_TRUTH_VALUE) {
                    if (object == Logic.DEFAULT_TRUE_TRUTH_VALUE || object == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
                        System.out.print("t");
                    } else {
                        System.out.print("T");
                    }
                } else if (object == Logic.FALSE_TRUTH_VALUE || object == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
                    if (object == Logic.DEFAULT_TRUE_TRUTH_VALUE || object == Logic.DEFAULT_FALSE_TRUTH_VALUE) {
                        System.out.print("f");
                    } else {
                        System.out.print("F");
                    }
                } else if (object == Logic.UNKNOWN_TRUTH_VALUE || object == null) {
                    System.out.print("U");
                } else {
                    System.out.print("?");
                }
            }
        } else {
            System.out.print("????: ");
        }
        if (Stella_Object.traceKeywordP((Stella_Object)Logic.KWD_STATE_MACHINE)) {
            System.out.print(" state= " + controlFrame.state + "  lastMove= " + keyword + " depth= " + n + " revPty?= " + controlFrame.reversePolarityP);
        }
        if (controlFrame.partialMatchFrame == null) {
            System.out.println();
        } else {
            System.out.print(" ");
            if (keyword == Logic.KWD_DOWN || keyword == Logic.KWD_UP_TRUE || keyword == Logic.KWD_UP_FAIL) {
                controlFrame.partialMatchFrame.traceFramePartialTruth(keyword, Stella.STANDARD_OUTPUT);
                System.out.println();
            }
        }
    }

    public static void unwindToChoicePointsBelowFrame(ControlFrame controlFrame) {
        if (controlFrame != null) {
            ControlFrame.unwindToChoicePoint(controlFrame);
            ControlFrame.unwindToChoicePointsBelowFrame(controlFrame.down);
        }
    }

    public static int computeFrameDepth(ControlFrame controlFrame) {
        ControlFrame controlFrame2;
        int n = 0;
        ControlFrame controlFrame3 = controlFrame2 = (QueryIterator)((Object)Logic.$QUERYITERATOR$.get()) != null ? ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).baseControlFrame : (ControlFrame)null;
        while (controlFrame2 != null && controlFrame2 != controlFrame) {
            controlFrame2 = controlFrame2.down;
            ++n;
        }
        if (controlFrame2 == controlFrame) {
            return n;
        }
        return Integer.MIN_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printGoalInGoalTree(ControlFrame controlFrame, int n) {
        block5: {
            if (controlFrame.proposition != null) {
                boolean bl = controlFrame.reversePolarityP;
                System.out.print("GOAL: ");
                if (bl) {
                    System.out.print("~");
                }
                Object object = Logic.$PRINTMODE$.get();
                Object object2 = Logic.$PRINTLOGICALFORMSTREAM$.get();
                Object object3 = Logic.$INDENTCOUNTER$.get();
                try {
                    Native.setSpecial((ThreadLocal)Logic.$PRINTMODE$, (Object)Logic.KWD_REALISTIC);
                    Native.setSpecial((ThreadLocal)Logic.$PRINTLOGICALFORMSTREAM$, (Object)Stella.STANDARD_OUTPUT);
                    Native.setIntSpecial((ThreadLocal)Logic.$INDENTCOUNTER$, (int)(2 * n + 7));
                    Logic.printUnformattedLogicalForm((Stella_Object)controlFrame.proposition, Stella.STANDARD_OUTPUT);
                    if (controlFrame.allottedClockTicks != Integer.MIN_VALUE) {
                        System.out.print(" ticks=" + controlFrame.allottedClockTicks);
                    }
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    Logic.$INDENTCOUNTER$.set(object3);
                    Logic.$PRINTLOGICALFORMSTREAM$.set(object2);
                    Logic.$PRINTMODE$.set(object);
                    throw throwable;
                }
                Logic.$INDENTCOUNTER$.set(object3);
                Logic.$PRINTLOGICALFORMSTREAM$.set(object2);
                Logic.$PRINTMODE$.set(object);
                {
                    break block5;
                }
            }
            System.out.print("STRATEGY: " + controlFrame.up.currentStrategy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printRuleInGoalTree(ControlFrame controlFrame, Proposition proposition, int n) {
        PatternRecord patternRecord = controlFrame.patternRecord;
        boolean bl = controlFrame.reversePolarityP;
        System.out.print("RULE: ");
        Object object = (Surrogate)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_STELLA_SURROGATE_VALUE_INVERSE, null);
        if (object == null && (Proposition)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MASTER_PROPOSITION, null) != null) {
            object = (Surrogate)KeyValueList.dynamicSlotValue((KeyValueList)((Proposition)KeyValueList.dynamicSlotValue((KeyValueList)proposition.dynamicSlots, (Symbol)Logic.SYM_LOGIC_MASTER_PROPOSITION, null)).dynamicSlots, (Symbol)Logic.SYM_STELLA_SURROGATE_VALUE_INVERSE, null);
        }
        if (object != null) {
            System.out.println(object.symbolName);
            Logic.printIndent(Stella.STANDARD_OUTPUT, 2 * n + 6);
        }
        object = Logic.$PRINTMODE$.get();
        Object object2 = Logic.$PRINTLOGICALFORMSTREAM$.get();
        Object object3 = Logic.$INDENTCOUNTER$.get();
        Object object4 = Logic.$QUERYITERATOR$.get();
        try {
            Description description;
            Description description2;
            Native.setSpecial((ThreadLocal)Logic.$PRINTMODE$, (Object)Logic.KWD_FLAT);
            Native.setSpecial((ThreadLocal)Logic.$PRINTLOGICALFORMSTREAM$, (Object)Stella.STANDARD_OUTPUT);
            Native.setIntSpecial((ThreadLocal)Logic.$INDENTCOUNTER$, (int)(2 * n + 7));
            Native.setSpecial((ThreadLocal)Logic.$QUERYITERATOR$, null);
            Description description3 = null;
            description3 = bl ? ((description2 = patternRecord.optimalPattern) != null ? description2 : patternRecord.description) : (Description)proposition.arguments.theArray[1];
            description2 = null;
            description2 = bl ? (Description)proposition.arguments.theArray[0] : ((description = patternRecord.optimalPattern) != null ? description : patternRecord.description);
            Description.printDescriptionsAsKifRule(description3, description2, proposition, bl);
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            Logic.$QUERYITERATOR$.set(object4);
            Logic.$INDENTCOUNTER$.set(object3);
            Logic.$PRINTLOGICALFORMSTREAM$.set(object2);
            Logic.$PRINTMODE$.set(object);
            throw throwable;
        }
        Logic.$QUERYITERATOR$.set(object4);
        Logic.$INDENTCOUNTER$.set(object3);
        Logic.$PRINTLOGICALFORMSTREAM$.set(object2);
        Logic.$PRINTMODE$.set(object);
    }

    public static void printVariableBindings(ControlFrame controlFrame) {
        PatternRecord patternRecord = ControlFrame.operativePatternRecord(controlFrame);
        Description description = null;
        if (patternRecord != null) {
            if (controlFrame.state == Logic.KWD_CONTAINED_BY) {
                Proposition proposition = (Proposition)controlFrame.proposition.arguments.theArray[0];
                Stella_Object stella_Object = proposition.arguments.theArray[0];
                Surrogate surrogate = Stella_Object.safePrimaryType((Stella_Object)stella_Object);
                if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_LOGIC_PATTERN_VARIABLE)) {
                    PatternVariable patternVariable = (PatternVariable)stella_Object;
                    PatternVariable.printOneVariableBinding(patternVariable);
                } else if (Surrogate.subtypeOfP((Surrogate)surrogate, (Surrogate)Logic.SGT_STELLA_LIST)) {
                    List list = (List)stella_Object;
                    Stella_Object stella_Object2 = null;
                    Cons cons = list.theConsList;
                    while (cons != Stella.NIL) {
                        stella_Object2 = cons.value;
                        PatternVariable.printOneVariableBinding((PatternVariable)stella_Object2);
                        cons = cons.rest;
                    }
                } else {
                    OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
                    outputStringStream.nativeStream.print("`" + surrogate + "' is not a valid case option");
                    throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
                }
                return;
            }
            description = patternRecord.optimalPattern;
            if (description != null) {
                int n;
                PatternVariable patternVariable = null;
                Vector vector = description.ioVariables;
                int n2 = vector.length();
                for (n = 0; n < n2; ++n) {
                    patternVariable = (PatternVariable)vector.theArray[n];
                    if (patternRecord.variableBindings.theArray[patternVariable.boundToOffset] == null) continue;
                    PatternVariable.printOneVariableBinding(patternVariable);
                }
                patternVariable = null;
                vector = description.internalVariables;
                n2 = vector.length();
                for (n = 0; n < n2; ++n) {
                    patternVariable = (PatternVariable)vector.theArray[n];
                    if (patternRecord.variableBindings.theArray[patternVariable.boundToOffset] == null) continue;
                    PatternVariable.printOneVariableBinding(patternVariable);
                }
            }
        }
    }

    public static void printControlFrameStack(ControlFrame controlFrame) {
        System.out.println((Object)controlFrame);
        if (controlFrame.down != null) {
            ControlFrame.printControlFrameStack(controlFrame.down);
        }
    }

    public static boolean newBindingsSinceLastChoicePointP(ControlFrame controlFrame) {
        return controlFrame.choicePointUnbindingOffset <= controlFrame.inheritedPatternRecord.topUnbindingStackOffset;
    }

    public static void unwindToChoicePoint(ControlFrame controlFrame) {
        int n = controlFrame.choicePointUnbindingOffset;
        if (n != Integer.MIN_VALUE) {
            PatternRecord.unbindVariablesBeginningAt(controlFrame.inheritedPatternRecord, n);
        }
    }

    public static void createChoicePoint(ControlFrame controlFrame) {
        PatternRecord patternRecord = controlFrame.inheritedPatternRecord;
        if (Stella.$TRACED_KEYWORDS$ != null && Stella.$TRACED_KEYWORDS$.membP((Stella_Object)Logic.KWD_QUERY_STACKS)) {
            System.out.println("create-choice-point: F " + ControlFrame.debugFrameId(controlFrame) + " CP= " + controlFrame.choicePointUnbindingOffset + " NEWCP= " + (patternRecord.topUnbindingStackOffset + 1));
        }
        if (controlFrame.choicePointUnbindingOffset == Integer.MIN_VALUE) {
            controlFrame.choicePointUnbindingOffset = patternRecord.topUnbindingStackOffset + 1;
        } else {
            PatternRecord.unbindVariablesBeginningAt(patternRecord, controlFrame.choicePointUnbindingOffset);
        }
    }

    public static void resetCurrentPatternRecord(ControlFrame controlFrame, Keyword keyword) {
        if (keyword == Logic.KWD_LOCAL) {
            ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord = controlFrame.patternRecord;
        } else if (keyword == Logic.KWD_PARENT) {
            ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).currentPatternRecord = controlFrame.inheritedPatternRecord != null ? controlFrame.inheritedPatternRecord : ((QueryIterator)((Object)Logic.$QUERYITERATOR$.get())).baseControlFrame.patternRecord;
        } else {
            OutputStringStream outputStringStream = OutputStringStream.newOutputStringStream();
            outputStringStream.nativeStream.print("`" + keyword + "' is not a valid case option");
            throw (StellaException)StellaException.newStellaException((String)outputStringStream.theStringReader()).fillInStackTrace();
        }
    }

    public static void popDownFrame(ControlFrame controlFrame) {
        ControlFrame.popControlFrame(controlFrame.down);
        controlFrame.down = null;
    }

    public static void popFramesUpTo(ControlFrame controlFrame) {
        if (controlFrame.down != null) {
            ControlFrame.popFramesUpTo(controlFrame.down);
        }
        if (controlFrame.up != null) {
            controlFrame.up.down = null;
        }
        ControlFrame.popControlFrame(controlFrame);
    }

    public static void popControlFrame(ControlFrame controlFrame) {
        if (controlFrame.state == Logic.KWD_PATTERN || controlFrame.state == Logic.KWD_CONTAINED_BY) {
            ControlFrame.resetCurrentPatternRecord(controlFrame, Logic.KWD_PARENT);
        }
        if ((Iterator)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_CACHED_BINDINGS_ITERATOR, null) != null) {
            ((Iterator)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_CACHED_BINDINGS_ITERATOR, null)).free();
            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_LOGIC_CACHED_BINDINGS_ITERATOR, null, null);
        }
        controlFrame.choicePointUnbindingOffset = Integer.MIN_VALUE;
        controlFrame.free();
        controlFrame.state = Logic.KWD_POPPED;
    }

    public void printObject(PrintStream printStream) {
        ControlFrame controlFrame = this;
        ControlFrame.printControlFrame(controlFrame, printStream);
    }

    public boolean deletedPSetter(boolean bl) {
        ControlFrame controlFrame = this;
        KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_DELETED_OBJECTp, (Stella_Object)(bl ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER), null);
        return bl;
    }

    public boolean deletedP() {
        ControlFrame controlFrame = this;
        BooleanWrapper booleanWrapper = (BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_DELETED_OBJECTp, null);
        if (booleanWrapper != null) {
            return BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)booleanWrapper);
        }
        return false;
    }

    public static Stella_Object accessControlFrameSlotValue(ControlFrame controlFrame, Symbol symbol, Stella_Object object, boolean bl) {
        if (symbol == Logic.SYM_STELLA_STATE) {
            if (bl) {
                controlFrame.state = (Keyword)object;
            } else {
                object = controlFrame.state;
            }
        } else if (symbol == Logic.SYM_LOGIC_PROPOSITION) {
            if (bl) {
                controlFrame.proposition = (Proposition)((Object)object);
            } else {
                object = controlFrame.proposition;
            }
        } else if (symbol == Logic.SYM_LOGIC_TRUTH_VALUE) {
            if (bl) {
                controlFrame.truthValue = (TruthValue)((Object)object);
            } else {
                object = controlFrame.truthValue;
            }
        } else if (symbol == Logic.SYM_LOGIC_REVERSE_POLARITYp) {
            if (bl) {
                controlFrame.reversePolarityP = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)((BooleanWrapper)object));
            } else {
                object = controlFrame.reversePolarityP ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else if (symbol == Logic.SYM_LOGIC_STARTING_CLOCK_TICKS) {
            if (bl) {
                controlFrame.startingClockTicks = ((IntegerWrapper)object).wrapperValue;
            } else {
                object = IntegerWrapper.wrapInteger((int)controlFrame.startingClockTicks);
            }
        } else if (symbol == Logic.SYM_LOGIC_ALLOTTED_CLOCK_TICKS) {
            if (bl) {
                controlFrame.allottedClockTicks = ((IntegerWrapper)object).wrapperValue;
            } else {
                object = IntegerWrapper.wrapInteger((int)controlFrame.allottedClockTicks);
            }
        } else if (symbol == Logic.SYM_LOGIC_UP) {
            if (bl) {
                controlFrame.up = (ControlFrame)((Object)object);
            } else {
                object = controlFrame.up;
            }
        } else if (symbol == Logic.SYM_LOGIC_DOWN) {
            if (bl) {
                controlFrame.down = (ControlFrame)((Object)object);
            } else {
                object = controlFrame.down;
            }
        } else if (symbol == Logic.SYM_STELLA_RESULT) {
            if (bl) {
                controlFrame.result = (ControlFrame)((Object)object);
            } else {
                object = controlFrame.result;
            }
        } else if (symbol == Logic.SYM_LOGIC_ARGUMENT_CURSOR) {
            if (bl) {
                controlFrame.argumentCursor = ((IntegerWrapper)object).wrapperValue;
            } else {
                object = IntegerWrapper.wrapInteger((int)controlFrame.argumentCursor);
            }
        } else if (symbol == Logic.SYM_LOGIC_PATTERN_RECORD) {
            if (bl) {
                controlFrame.patternRecord = (PatternRecord)((Object)object);
            } else {
                object = controlFrame.patternRecord;
            }
        } else if (symbol == Logic.SYM_LOGIC_INHERITED_PATTERN_RECORD) {
            if (bl) {
                controlFrame.inheritedPatternRecord = (PatternRecord)((Object)object);
            } else {
                object = controlFrame.inheritedPatternRecord;
            }
        } else if (symbol == Logic.SYM_LOGIC_CHOICE_POINT_UNBINDING_OFFSET) {
            if (bl) {
                controlFrame.choicePointUnbindingOffset = ((IntegerWrapper)object).wrapperValue;
            } else {
                object = IntegerWrapper.wrapInteger((int)controlFrame.choicePointUnbindingOffset);
            }
        } else if (symbol == Logic.SYM_LOGIC_CURRENT_STRATEGY) {
            if (bl) {
                controlFrame.currentStrategy = (Keyword)object;
            } else {
                object = controlFrame.currentStrategy;
            }
        } else if (symbol == Logic.SYM_LOGIC_NEXT_STRATEGIES) {
            if (bl) {
                controlFrame.nextStrategies = (Cons)object;
            } else {
                object = controlFrame.nextStrategies;
            }
        } else if (symbol == Logic.SYM_LOGIC_PARTIAL_MATCH_FRAME) {
            if (bl) {
                controlFrame.partialMatchFrame = (PartialMatchFrame)((Object)object);
            } else {
                object = controlFrame.partialMatchFrame;
            }
        } else if (symbol == Logic.SYM_LOGIC_JUSTIFICATIONS) {
            if (bl) {
                controlFrame.justifications = (List)object;
            } else {
                object = controlFrame.justifications;
            }
        } else if (symbol == Logic.SYM_LOGIC_GOAL_BINDINGS) {
            if (bl) {
                controlFrame.goalBindings = (Cons)object;
            } else {
                object = controlFrame.goalBindings;
            }
        } else if (symbol == Logic.SYM_LOGIC_CACHED_GOAL_RESULTp) {
            if (bl) {
                controlFrame.cachedGoalResultP = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)((BooleanWrapper)object));
            } else {
                object = controlFrame.cachedGoalResultP ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else if (symbol == Logic.SYM_LOGIC_DONT_CACHE_GOAL_FAILUREp) {
            if (bl) {
                controlFrame.dontCacheGoalFailureP = BooleanWrapper.coerceWrappedBooleanToBoolean((BooleanWrapper)((BooleanWrapper)object));
            } else {
                object = controlFrame.dontCacheGoalFailureP ? Stella.TRUE_WRAPPER : Stella.FALSE_WRAPPER;
            }
        } else if (bl) {
            KeyValueList.setDynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)symbol, (Stella_Object)object, null);
        } else {
            object = controlFrame.dynamicSlots.lookup((Stella_Object)symbol);
        }
        return object;
    }

    public BooleanWrapper badP() {
        ControlFrame controlFrame = this;
        BooleanWrapper booleanWrapper = (BooleanWrapper)KeyValueList.dynamicSlotValue((KeyValueList)controlFrame.dynamicSlots, (Symbol)Logic.SYM_STELLA_BADp, null);
        if (booleanWrapper == null) {
            return Stella.FALSE_WRAPPER;
        }
        return booleanWrapper;
    }

    public boolean holdsByDefaultP() {
        ControlFrame controlFrame = this;
        return controlFrame.truthValue == Logic.DEFAULT_TRUE_TRUTH_VALUE || controlFrame.truthValue == Logic.DEFAULT_FALSE_TRUTH_VALUE;
    }

    public Surrogate primaryType() {
        ControlFrame controlFrame = this;
        return Logic.SGT_LOGIC_CONTROL_FRAME;
    }
}

