/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator.sg.impl.ccsg;

import org.apache.ws.jaxme.generator.sg.ComplexContentSG;
import org.apache.ws.jaxme.generator.sg.ComplexTypeSG;
import org.apache.ws.jaxme.generator.sg.GroupSG;
import org.apache.ws.jaxme.generator.sg.ParticleSG;
import org.apache.ws.jaxme.generator.sg.TypeSG;
import org.apache.ws.jaxme.generator.sg.impl.ccsg.ParticleVisitor;
import org.xml.sax.SAXException;

public class ParticleWalker {
    private final ParticleVisitor visitor;

    public ParticleWalker(ParticleVisitor pVisitor) {
        this.visitor = pVisitor;
    }

    public void walk(ComplexTypeSG pType) throws SAXException {
        if (pType.hasSimpleContent()) {
            this.visitor.simpleContent(pType);
        } else {
            ComplexContentSG ccSG = pType.getComplexContentSG();
            if (ccSG.isEmpty()) {
                this.visitor.emptyType(pType);
            } else {
                this.visitor.startComplexContent(pType);
                this.walkGroup(ccSG.getRootParticle().getGroupSG());
                this.visitor.endComplexContent(pType);
            }
        }
    }

    private void walkGroup(GroupSG pGroup) throws SAXException {
        if (pGroup.isSequence()) {
            this.visitor.startSequence(pGroup);
            this.walkParticles(pGroup);
            this.visitor.endSequence(pGroup);
        } else if (pGroup.isChoice()) {
            this.visitor.startChoice(pGroup);
            this.walkParticles(pGroup);
            this.visitor.endChoice(pGroup);
        } else if (pGroup.isAll()) {
            this.visitor.startAll(pGroup);
            this.walkParticles(pGroup);
            this.visitor.endAll(pGroup);
        } else {
            throw new IllegalStateException("Invalid group type");
        }
    }

    private void walkParticles(GroupSG pGroup) throws SAXException {
        ParticleSG[] particles = pGroup.getParticles();
        for (int i = 0; i < particles.length; ++i) {
            ParticleSG particle = particles[i];
            if (particle.isElement()) {
                TypeSG type = particle.getObjectSG().getTypeSG();
                if (type.isComplex()) {
                    this.visitor.complexElementParticle(pGroup, particle);
                    continue;
                }
                this.visitor.simpleElementParticle(pGroup, particle);
                continue;
            }
            if (particle.isGroup()) {
                this.walkGroup(particle.getGroupSG());
                continue;
            }
            if (particle.isWildcard()) {
                this.visitor.wildcardParticle(particle);
                continue;
            }
            throw new IllegalStateException("Invalid particle type");
        }
    }
}

