/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator.sg.impl;

import org.apache.ws.jaxme.generator.sg.Context;
import org.apache.ws.jaxme.generator.sg.GroupSG;
import org.apache.ws.jaxme.generator.sg.GroupSGChain;
import org.apache.ws.jaxme.generator.sg.ParticleSG;
import org.apache.ws.jaxme.generator.sg.ParticleSGChain;
import org.apache.ws.jaxme.generator.sg.SGFactory;
import org.apache.ws.jaxme.generator.sg.SchemaSG;
import org.apache.ws.jaxme.generator.sg.impl.GlobalContext;
import org.apache.ws.jaxme.generator.sg.impl.JAXBParticleSG;
import org.apache.ws.jaxme.generator.sg.impl.JAXBSGItem;
import org.apache.ws.jaxme.generator.sg.impl.ParticleSGImpl;
import org.apache.ws.jaxme.xs.XSGroup;
import org.apache.ws.jaxme.xs.XSObject;
import org.apache.ws.jaxme.xs.XSParticle;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class JAXBGroupSG
extends JAXBSGItem
implements GroupSGChain {
    private ParticleSG[] particles;
    private final boolean isGlobal;
    private final boolean isAll;
    private final boolean isSequence;
    private final boolean isChoice;
    private final Context classContext;
    private final XsQName qName;

    protected JAXBGroupSG(SGFactory pFactory, SchemaSG pSchema, XSGroup pGroup) throws SAXException {
        super(pFactory, pSchema, (XSObject)pGroup);
        this.isGlobal = true;
        this.qName = pGroup.getName();
        this.isAll = pGroup.isAll();
        this.isSequence = pGroup.isSequence();
        this.isChoice = pGroup.isChoice();
        this.classContext = new GlobalContext(pGroup.getName(), (XSObject)pGroup, null, "Group", pSchema);
    }

    protected JAXBGroupSG(SGFactory pFactory, SchemaSG pSchema, XSGroup pGroup, Context pContext) throws SAXException {
        super(pFactory, pSchema, (XSObject)pGroup);
        this.isGlobal = pGroup.isGlobal();
        this.qName = this.isGlobal ? pGroup.getName() : null;
        this.isAll = pGroup.isAll();
        this.isSequence = pGroup.isSequence();
        this.isChoice = pGroup.isChoice();
        this.classContext = pContext;
    }

    public Object newParticleSG(GroupSG pController, XSParticle pParticle) throws SAXException {
        return new JAXBParticleSG(pController.getFactory(), pParticle, this.classContext);
    }

    public Context getClassContext(GroupSG pController) {
        return this.classContext;
    }

    public SGFactory getFactory(GroupSG pController) {
        return this.getFactory();
    }

    public SchemaSG getSchema(GroupSG pController) {
        return this.getSchema();
    }

    public Locator getLocator(GroupSG pController) {
        return this.getLocator();
    }

    public ParticleSG[] getParticles(GroupSG pController) throws SAXException {
        if (this.particles == null) {
            XSParticle[] xsParticles = ((XSGroup)this.getXSObject()).getParticles();
            this.particles = new ParticleSG[xsParticles.length];
            for (int i = 0; i < xsParticles.length; ++i) {
                ParticleSGChain chain = (ParticleSGChain)pController.newParticleSG(xsParticles[i]);
                ParticleSGImpl particle = new ParticleSGImpl(chain);
                particle.init();
                this.particles[i] = particle;
            }
        }
        return this.particles;
    }

    public void init(GroupSG pController) throws SAXException {
    }

    public boolean isAll(GroupSG pController) {
        return this.isAll;
    }

    public boolean isGlobal(GroupSG pController) {
        return this.isGlobal;
    }

    public boolean isChoice(GroupSG pController) {
        return this.isChoice;
    }

    public boolean isSequence(GroupSG pController) {
        return this.isSequence;
    }

    public XsQName getName(GroupSG pController) {
        if (this.qName == null) {
            throw new IllegalStateException("Attempt to obtain a local groups name.");
        }
        return this.qName;
    }
}

