/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator.sg.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.ws.jaxme.generator.sg.ComplexContentSG;
import org.apache.ws.jaxme.generator.sg.ComplexContentSGChain;
import org.apache.ws.jaxme.generator.sg.ComplexTypeSG;
import org.apache.ws.jaxme.generator.sg.Context;
import org.apache.ws.jaxme.generator.sg.GroupSG;
import org.apache.ws.jaxme.generator.sg.ObjectSG;
import org.apache.ws.jaxme.generator.sg.ParticleSG;
import org.apache.ws.jaxme.generator.sg.SGFactory;
import org.apache.ws.jaxme.generator.sg.impl.JAXBParticleSG;
import org.apache.ws.jaxme.generator.sg.impl.ParticleSGImpl;
import org.apache.ws.jaxme.logging.Logger;
import org.apache.ws.jaxme.logging.LoggerAccess;
import org.apache.ws.jaxme.xs.XSParticle;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.types.XSAnyType;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JAXBComplexContentTypeSG
implements ComplexContentSGChain {
    private static final Logger log = LoggerAccess.getLogger((Class)(class$org$apache$ws$jaxme$generator$sg$impl$JAXBComplexContentTypeSG == null ? (class$org$apache$ws$jaxme$generator$sg$impl$JAXBComplexContentTypeSG = JAXBComplexContentTypeSG.class$("org.apache.ws.jaxme.generator.sg.impl.JAXBComplexContentTypeSG")) : class$org$apache$ws$jaxme$generator$sg$impl$JAXBComplexContentTypeSG));
    private final boolean isEmpty;
    private final boolean isMixed;
    private final ParticleSG rootParticle;
    private boolean isInitialized;
    private final Locator locator;
    private final List elementParticles = new ArrayList();
    private Particle[] elementParticleArray;
    private final List mixedContentParticles = new ArrayList();
    private final List groupParticlesWithMultiplicityGreaterOne = new ArrayList();
    private final List wildcardParticles = new ArrayList();
    private final List stack = new ArrayList();
    static /* synthetic */ Class class$org$apache$ws$jaxme$generator$sg$impl$JAXBComplexContentTypeSG;

    protected JAXBComplexContentTypeSG(ComplexTypeSG pComplexTypeSG, XSType pType) throws SAXException {
        if (pType == XSAnyType.getInstance()) {
            throw new SAXException("The type xs:anyType is not supported.");
        }
        this.locator = pType.getLocator();
        if (pType.getComplexType().isEmpty()) {
            this.isEmpty = true;
            this.isMixed = false;
            this.rootParticle = null;
        } else {
            XSParticle particle = pType.getComplexType().getParticle();
            if (particle == null) {
                throw new NullPointerException("Missing group particle for type = " + pType.getName());
            }
            if (!particle.isGroup()) {
                throw new IllegalStateException("Expected internal group");
            }
            this.rootParticle = this.newParticleSG(pComplexTypeSG.getTypeSG().getFactory(), particle, pComplexTypeSG.getClassContext());
            this.isEmpty = false;
            this.isMixed = pType.getComplexType().isMixed();
        }
    }

    protected ParticleSG newParticleSG(SGFactory pFactory, XSParticle pParticle, Context pContext) throws SAXException {
        JAXBParticleSG chain = new JAXBParticleSG(pFactory, pParticle, pContext);
        ParticleSGImpl result = new ParticleSGImpl(chain);
        result.init();
        return result;
    }

    public Locator getLocator(ComplexContentSG pController) {
        return this.locator;
    }

    public void init(ComplexContentSG pController) throws SAXException {
    }

    private void initialize(ComplexContentSG pController) throws SAXException {
        if (!this.isInitialized && !this.isEmpty) {
            this.isInitialized = true;
            this.verify(pController);
        }
    }

    private Particle[] getLocalElementParticles(ComplexContentSG pController) throws SAXException {
        this.initialize(pController);
        return this.elementParticleArray;
    }

    public ParticleSG[] getElementParticles(ComplexContentSG pController) throws SAXException {
        Particle[] particles = this.getLocalElementParticles(pController);
        if (particles == null) {
            return new ParticleSG[0];
        }
        ParticleSG[] result = new ParticleSG[particles.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = particles[i].getParticleSG();
        }
        return result;
    }

    public ParticleSG getRootParticle(ComplexContentSG pController) {
        return this.rootParticle;
    }

    public boolean isEmpty(ComplexContentSG pController) {
        return this.isEmpty;
    }

    public boolean isMixed(ComplexContentSG pController) {
        return this.isMixed;
    }

    private void findParticles(GroupSG[] pStack, ParticleSG pParticle) throws SAXException {
        if (pParticle.isGroup()) {
            if (pParticle.isMultiple()) {
                this.groupParticlesWithMultiplicityGreaterOne.add(new Particle(pStack, pParticle));
            } else if (this.isMixed) {
                this.mixedContentParticles.add(new Particle(pStack, pParticle));
            } else {
                this.findParticles(pParticle.getGroupSG());
            }
        } else if (pParticle.isWildcard()) {
            this.wildcardParticles.add(new Particle(pStack, pParticle));
        } else if (pParticle.isElement()) {
            Particle p = new Particle(pStack, pParticle);
            this.elementParticles.add(p);
        } else {
            throw new SAXParseException("Invalid particle type", pParticle.getLocator());
        }
    }

    private void findParticles(GroupSG pGroup) throws SAXException {
        this.stack.add(pGroup);
        ParticleSG[] particles = pGroup.getParticles();
        GroupSG[] groups = this.stack.toArray(new GroupSG[this.stack.size()]);
        for (int i = 0; i < particles.length; ++i) {
            this.findParticles(groups, particles[i]);
        }
        this.stack.remove(this.stack.size() - 1);
    }

    private void verify(ComplexContentSG pController) throws SAXException {
        this.findParticles(new GroupSG[0], pController.getRootParticle());
        if (pController.isMixed()) {
            // empty if block
        }
        if (this.groupParticlesWithMultiplicityGreaterOne.size() > 0) {
            Particle particle = (Particle)this.groupParticlesWithMultiplicityGreaterOne.get(0);
            throw new SAXParseException("Model groups with maxOccurs > 1 are not yet supported.", particle.getParticleSG().getLocator());
        }
        if (this.wildcardParticles.size() > 0) {
            Particle particle = (Particle)this.wildcardParticles.get(0);
            throw new SAXParseException("Wildcards are unsupported", particle.getParticleSG().getLocator());
        }
        this.elementParticleArray = this.elementParticles.toArray(new Particle[this.elementParticles.size()]);
        for (int i = 0; i < this.elementParticleArray.length; ++i) {
            Particle pParticle = this.elementParticleArray[i];
            ParticleSG p = pParticle.getParticleSG();
            String name = p.getPropertySG().getXMLFieldName();
            for (int j = i + 1; j < this.elementParticles.size(); ++j) {
                Particle qParticle = this.elementParticleArray[j];
                ParticleSG q = qParticle.getParticleSG();
                if (!name.equals(q.getPropertySG().getXMLFieldName())) continue;
                ObjectSG pObject = p.getObjectSG();
                ObjectSG qObject = q.getObjectSG();
                if (!pObject.isGlobal() || !qObject.isGlobal() || pObject != qObject) {
                    throw new SAXParseException("Multiple element particles named " + name + ", which aren't references to " + " a common global element, are present in a common" + " complex type. (JAXB 1.0, 5.9.7.4.a) Use jaxb:property/@name" + " for customization.", pController.getLocator());
                }
                GroupSG group = pParticle.getClosestCommonAnchestor(pParticle);
                if (!group.isSequence()) continue;
                throw new SAXParseException("Multiple element particles named " + name + " are contained in a common sequence." + " (JAXB 1.0, 5.9.7.4.b) Use jaxb:property/@name" + " for customization.", pController.getLocator());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Particle {
        private final GroupSG[] stack;
        private final ParticleSG particle;

        Particle(GroupSG[] pStack, ParticleSG pParticle) {
            this.stack = pStack;
            this.particle = pParticle;
        }

        ParticleSG getParticleSG() {
            return this.particle;
        }

        Object[] getStack() {
            return this.stack;
        }

        GroupSG getClosestCommonAnchestor(Particle pParticle) {
            int len = Math.min(this.stack.length, pParticle.stack.length);
            GroupSG anchestor = this.stack[0];
            for (int i = 1; i < len && this.stack[i] == pParticle.stack[i]; ++i) {
            }
            return anchestor;
        }
    }
}

