/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.ws.jaxme.util.DOMSerializer;
import org.apache.ws.jaxme.xs.SchemaTransformer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class Inliner
implements SchemaTransformer {
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    private final Document[] bindings;
    private XMLReader transformedXMLReader;
    private InputSource transformedInputSource;

    public Inliner(Document[] pBindings) {
        this.bindings = pBindings;
    }

    private Document read(InputSource pSource, XMLReader pReader) throws SAXException, ParserConfigurationException, IOException {
        DocumentBuilder db = dbf.newDocumentBuilder();
        db.setEntityResolver(pReader.getEntityResolver());
        db.setErrorHandler(pReader.getErrorHandler());
        return db.parse(pSource);
    }

    private void apply(Document pSchema, Document pBindings, String pURI) throws XPathExpressionException {
        Iterator iter = this.getBindingElements(pBindings, pURI);
        while (iter.hasNext()) {
            Element e = (Element)iter.next();
            String xpathQuery = e.getAttribute("node");
            XPathFactory xpathFactory = XPathFactory.newInstance();
            XPath xpath = xpathFactory.newXPath();
            NodeList nodes = (NodeList)xpath.evaluate(xpathQuery, e, XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element match;
                Node node = nodes.item(i);
                if (node.getNodeType() != 1 || !"http://www.w3.org/2001/XMLSchema".equals((match = (Element)node).getNamespaceURI())) continue;
                String prefix = match.getPrefix();
                Element annotationElement = this.getChild(match, prefix, "annotation");
                Element appInfoElement = this.getChild(annotationElement, prefix, "appInfo");
                for (Node child = e.getFirstChild(); child != null; child = child.getNextSibling()) {
                    appInfoElement.appendChild(pSchema.importNode(child, true));
                }
            }
        }
    }

    private Iterator getBindingElements(Document pBindings, String pURI) {
        Element root = pBindings.getDocumentElement();
        ArrayList<Element> result = new ArrayList<Element>();
        for (Node child = root.getFirstChild(); child != null; child = child.getNextSibling()) {
            Element e;
            if (child.getNodeType() != 1 || !"http://java.sun.com/xml/ns/jaxb".equals((e = (Element)child).getNamespaceURI()) || !"bindings".equals(e.getLocalName()) || !pURI.equals(e.getAttribute("schemaLocation"))) continue;
            result.add(e);
        }
        return result.iterator();
    }

    private Element getChild(Element pParent, String pPrefix, String pName) {
        Element e;
        for (Node child = pParent.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getNodeType() != 1 || !pName.equals((e = (Element)child).getLocalName()) || !"http://www.w3.org/2001/XMLSchema".equals(e.getNamespaceURI())) continue;
            return e;
        }
        String qName = pPrefix == null || pPrefix.length() == 0 ? pName : pPrefix + ":" + pName;
        e = pParent.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", qName);
        pParent.insertBefore(e, pParent.getFirstChild());
        return e;
    }

    public void parse(InputSource pSource, XMLReader pReader) throws ParserConfigurationException, SAXException, IOException {
        final Document schema = this.read(pSource, pReader);
        String uri = pSource.getSystemId();
        if (uri != null) {
            try {
                for (int i = 0; i < this.bindings.length; ++i) {
                    this.apply(schema, this.bindings[i], uri);
                }
            }
            catch (XPathExpressionException e) {
                throw new SAXException(e);
            }
        }
        this.transformedInputSource = new InputSource();
        this.transformedXMLReader = new XMLFilterImpl(){

            public void parse(InputSource pInput) throws SAXException, IOException {
                new DOMSerializer().serialize(schema, this);
            }

            public void parse(String pSystemId) throws SAXException, IOException {
                throw new IllegalStateException("Not implemented");
            }
        };
    }

    public InputSource getTransformedInputSource() {
        return this.transformedInputSource;
    }

    public XMLReader getTransformedXMLReader() {
        return this.transformedXMLReader;
    }

    static {
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
    }
}

