/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.compat;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import ptolemy.plot.CmdLineArgException;
import ptolemy.plot.Plot;
import ptolemy.plot.PlotApplet;
import ptolemy.plot.compat.PxgraphParser;

public class PxgraphApplet
extends PlotApplet {
    private PxgraphParser _parser;

    public String getAppletInfo() {
        return "PxgraphApplet 5.2: A data plotter.\nBy: Edward A. Lee, eal@eecs.berkeley.edu and\n Christopher Hylands, cxh@eecs.berkeley.edu\n($Id: PxgraphApplet.java,v 1.11.2.2 2002/06/14 17:12:37 cxh Exp $)";
    }

    public String[][] getParameterInfo() {
        String[][] pinfo = new String[][]{{"background", "hexcolor value", "background color"}, {"foreground", "hexcolor value", "foreground color"}, {"dataurl", "url", "the URL of the data to plot"}, {"pxgraphargs", "args", "pxgraph style command line arguments"}};
        return pinfo;
    }

    public void init() {
        super.init();
        this._parser = new PxgraphParser((Plot)this.plot());
        String pxgraphargs = null;
        pxgraphargs = this.getParameter("pxgraphargs");
        if (pxgraphargs != null) {
            try {
                this.showStatus("Reading arguments");
                this._parser.parsePxgraphargs(pxgraphargs, this.getDocumentBase());
                this.showStatus("Done reading arguments");
            }
            catch (CmdLineArgException e) {
                System.err.println("PxgraphApplet: failed to parse `" + pxgraphargs + "': " + e);
            }
            catch (FileNotFoundException e) {
                System.err.println(e.toString());
            }
            catch (IOException e) {
                System.err.println(e.toString());
            }
        }
        this.plot().repaint();
    }

    protected void _read(InputStream in) throws IOException {
        this._parser.read(in);
    }
}

