/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.junit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.TestCase;
import org.apache.ws.jaxme.sqls.BooleanConstraint;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.ColumnReference;
import org.apache.ws.jaxme.sqls.CombinedConstraint;
import org.apache.ws.jaxme.sqls.DeleteStatement;
import org.apache.ws.jaxme.sqls.Expression;
import org.apache.ws.jaxme.sqls.ForeignKey;
import org.apache.ws.jaxme.sqls.Index;
import org.apache.ws.jaxme.sqls.InsertStatement;
import org.apache.ws.jaxme.sqls.JoinReference;
import org.apache.ws.jaxme.sqls.SQLFactory;
import org.apache.ws.jaxme.sqls.SQLGenerator;
import org.apache.ws.jaxme.sqls.Schema;
import org.apache.ws.jaxme.sqls.SelectStatement;
import org.apache.ws.jaxme.sqls.SelectTableReference;
import org.apache.ws.jaxme.sqls.StringColumn;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.UpdateStatement;
import org.apache.ws.jaxme.sqls.impl.SQLFactoryImpl;
import org.apache.ws.jaxme.sqls.impl.VirtualColumn;

public class CreateTest
extends TestCase {
    private SQLFactory sqlFactory;
    private SQLGenerator sqlGenerator;
    private Schema schema;

    protected SQLFactory newSQLFactory() {
        return new SQLFactoryImpl();
    }

    protected SQLGenerator newSQLGenerator() {
        return this.sqlFactory.newSQLGenerator();
    }

    protected SQLFactory getSQLFactory() {
        return this.sqlFactory;
    }

    protected SQLGenerator getSQLGenerator() {
        return this.sqlGenerator;
    }

    public void setUp() {
        this.sqlFactory = this.newSQLFactory();
        this.sqlGenerator = this.newSQLGenerator();
        this.schema = this.sqlFactory.newSchema("MySchema");
    }

    public CreateTest(String pName) {
        super(pName);
    }

    protected Table getBasicTable() {
        Table table = this.schema.newTable("MyTable");
        Column myIndex = table.newColumn("MyIndex", Column.Type.INTEGER);
        CreateTest.assertTrue((!myIndex.isStringColumn() ? 1 : 0) != 0);
        CreateTest.assertTrue((!myIndex.isBinaryColumn() ? 1 : 0) != 0);
        Column myName = table.newColumn("MyName", Column.Type.VARCHAR);
        CreateTest.assertTrue((boolean)myName.isStringColumn());
        CreateTest.assertTrue((!myName.isBinaryColumn() ? 1 : 0) != 0);
        ((StringColumn)myName).setLength(60L);
        Column myDate = table.newColumn("MyDate", Column.Type.DATE);
        CreateTest.assertTrue((!myDate.isStringColumn() ? 1 : 0) != 0);
        CreateTest.assertTrue((!myDate.isBinaryColumn() ? 1 : 0) != 0);
        myDate.setNullable(true);
        return table;
    }

    protected Table getPrimaryKeyTable() {
        Table table = this.getBasicTable();
        Index index = table.newPrimaryKey();
        index.addColumn("MyIndex");
        return table;
    }

    protected Table getForeignKeyTable(Table pTable) {
        Table otherTable = pTable.getSchema().newTable("OtherTable");
        Column otherIndex = otherTable.newColumn("MyIndex", Column.Type.INTEGER);
        Column referenceColumn = otherTable.newColumn("RefIndex", Column.Type.INTEGER);
        Column companyColumn = otherTable.newColumn("Company", Column.Type.VARCHAR);
        ((StringColumn)companyColumn).setLength(60L);
        otherTable.newPrimaryKey().addColumn(otherIndex);
        ForeignKey reference = otherTable.newForeignKey(pTable);
        reference.addColumnLink(referenceColumn, pTable.getColumn("MyIndex"));
        return otherTable;
    }

    public void testBasicCreate() {
        Table table = this.getBasicTable();
        SQLGenerator generator = this.getSQLGenerator();
        generator.setLineTerminator("\n");
        Collection statements = generator.getCreate(table.getSchema(), true);
        Iterator iter = statements.iterator();
        CreateTest.assertTrue((boolean)iter.hasNext());
        CreateTest.assertEquals((Object)"CREATE SCHEMA MySchema", iter.next());
        CreateTest.assertTrue((boolean)iter.hasNext());
        CreateTest.assertEquals((Object)"CREATE TABLE MySchema.MyTable (\n  MyIndex INT NOT NULL,\n  MyName VARCHAR(60) NOT NULL,\n  MyDate DATE\n)\n", iter.next());
        CreateTest.assertTrue((!iter.hasNext() ? 1 : 0) != 0);
    }

    public void testBasicInsert() {
        Table table = this.getBasicTable();
        InsertStatement insertStatement = table.getInsertStatement();
        SQLGenerator generator = this.getSQLGenerator();
        generator.setLineTerminator("\n");
        String s = generator.getQuery(insertStatement);
        CreateTest.assertEquals((String)"INSERT INTO MySchema.MyTable (MyIndex, MyName, MyDate) VALUES (?, ?, ?)", (String)s);
    }

    protected String getBulkInsertResult() {
        return "INSERT INTO MySchema.MyTable (MyTable.MyIndex, MyTable.MyName, MyTable.MyDate) (SELECT MyTable0.MyIndex, MyTable0.MyName, MyTable0.MyDate FROM MySchema.MyTable AS MyTable0)";
    }

    public void testBulkInsert() {
        Table table = this.getBasicTable();
        InsertStatement insertStatement = this.getSQLFactory().newInsertStatement();
        insertStatement.setTable(table);
        SelectStatement st = table.getSelectStatement();
        SQLGenerator generator = this.getSQLGenerator();
        generator.setLineTerminator("\n");
        insertStatement.setSubSelect(st);
        String got = generator.getQuery(insertStatement);
        String expect = this.getBulkInsertResult();
        CreateTest.assertEquals((String)expect, (String)got);
    }

    public void testBasicSelect() {
        Table table = this.getBasicTable();
        SelectStatement selectStatement = table.getSelectStatement();
        SQLGenerator generator = this.getSQLGenerator();
        generator.setLineTerminator("\n");
        String s = generator.getQuery(selectStatement);
        CreateTest.assertEquals((String)"SELECT MyIndex, MyName, MyDate FROM MySchema.MyTable", (String)s);
    }

    public void testBasicUpdate() {
        Table table = this.getPrimaryKeyTable();
        UpdateStatement updateStatement = table.getUpdateStatement();
        SQLGenerator generator = this.getSQLGenerator();
        generator.setLineTerminator("\n");
        String s = generator.getQuery(updateStatement);
        CreateTest.assertEquals((String)"UPDATE MySchema.MyTable SET MyName=?, MyDate=? WHERE MyIndex=?", (String)s);
    }

    public void testBasicDelete() {
        Table table = this.getPrimaryKeyTable();
        DeleteStatement deleteStatement = table.getDeleteStatement();
        SQLGenerator generator = this.getSQLGenerator();
        generator.setLineTerminator("\n");
        String s = generator.getQuery(deleteStatement);
        CreateTest.assertEquals((String)"DELETE FROM MySchema.MyTable WHERE MyIndex=?", (String)s);
    }

    protected String getCreateForeignKeyResult() {
        return "CREATE TABLE MySchema.OtherTable (  MyIndex INT NOT NULL,  RefIndex INT NOT NULL,  Company VARCHAR(60) NOT NULL)";
    }

    public void testCreateForeignKey() {
        Table table = this.getPrimaryKeyTable();
        Table otherTable = this.getForeignKeyTable(table);
        SQLGenerator generator = this.getSQLGenerator();
        Collection c = generator.getCreate(otherTable);
        CreateTest.assertEquals((int)1, (int)c.size());
        String expect = this.getCreateForeignKeyResult();
        String got = (String)c.iterator().next();
        CreateTest.assertEquals((String)expect, (String)got);
    }

    protected String getTestJoinResult() {
        return "SELECT OtherTable.MyIndex, RefIndex, Company FROM MySchema.OtherTable JOIN MySchema.MyTable ON RefIndex=MyTable.MyIndex WHERE OtherTable.MyIndex=?";
    }

    protected SelectStatement getJoinStatement() {
        Table table = this.getPrimaryKeyTable();
        Table otherTable = this.getForeignKeyTable(table);
        SelectStatement statement = otherTable.getSelectStatement();
        SelectTableReference tableReference = statement.getSelectTableReference();
        JoinReference joinReference = tableReference.join(table);
        SelectTableReference refLocal = tableReference;
        JoinReference refRef = tableReference.getRightJoinedTableReference();
        joinReference.getOn().addJoin((ForeignKey)otherTable.getForeignKeys().next(), refLocal, refRef);
        CombinedConstraint cc = statement.getWhere();
        BooleanConstraint bc = cc.createEQ();
        bc.addPart(tableReference.newColumnReference("MyIndex"));
        bc.addPlaceholder();
        return statement;
    }

    public void testJoin() {
        SelectStatement statement = this.getJoinStatement();
        SQLGenerator generator = this.getSQLGenerator();
        generator.setLineTerminator("\n");
        String got = generator.getQuery(statement);
        String expect = this.getTestJoinResult();
        CreateTest.assertEquals((String)expect, (String)got);
    }

    protected String getTestLeftOuterJoinResult() {
        return "SELECT OtherTable.MyIndex, RefIndex, Company FROM MySchema.OtherTable LEFT OUTER JOIN MySchema.MyTable ON RefIndex=MyTable.MyIndex WHERE OtherTable.MyIndex=?";
    }

    public void testLeftOuterJoin() {
        Table table = this.getPrimaryKeyTable();
        Table otherTable = this.getForeignKeyTable(table);
        SelectStatement statement = otherTable.getSelectStatement();
        SelectTableReference tableReference = statement.getSelectTableReference();
        JoinReference joinReference = tableReference.leftOuterJoin(table);
        SelectTableReference refLocal = tableReference;
        JoinReference refRef = tableReference.getRightJoinedTableReference();
        joinReference.getOn().addJoin((ForeignKey)otherTable.getForeignKeys().next(), refLocal, refRef);
        CombinedConstraint cc = statement.getWhere();
        BooleanConstraint bc = cc.createEQ();
        bc.addPart(tableReference.newColumnReference("MyIndex"));
        bc.addPlaceholder();
        SQLGenerator generator = this.getSQLGenerator();
        generator.setLineTerminator("\n");
        String got = generator.getQuery(statement);
        String expect = this.getTestLeftOuterJoinResult();
        CreateTest.assertEquals((String)expect, (String)got);
    }

    public void testExists() {
        Table table = this.getPrimaryKeyTable();
        Table otherTable = this.getForeignKeyTable(table);
        SelectStatement statement = table.getSelectStatement();
        SelectTableReference tableReference = statement.getSelectTableReference();
        SelectStatement existsStatement = otherTable.getSelectStatement();
        SelectTableReference existsTableReference = existsStatement.getSelectTableReference();
        BooleanConstraint bc = existsStatement.getWhere().createEQ();
        bc.addPart(existsTableReference.newColumnReference("RefIndex"));
        bc.addPart(tableReference.newColumnReference("MyIndex"));
        statement.getWhere().createEXISTS(existsStatement);
        SQLGenerator generator = this.getSQLGenerator();
        generator.setLineTerminator("\n");
        String got = generator.getQuery(statement);
        String expect = "SELECT MyTable.MyIndex, MyName, MyDate FROM MySchema.MyTable WHERE EXISTS(SELECT OtherTable.MyIndex, RefIndex, Company FROM MySchema.OtherTable WHERE RefIndex=MyTable.MyIndex)";
        CreateTest.assertEquals((String)expect, (String)got);
    }

    public void testBetween() {
        Table table = this.getBasicTable();
        SelectStatement statement = table.getSelectStatement();
        BooleanConstraint between = statement.getWhere().createBETWEEN();
        between.addPart(statement.getTableReference().newColumnReference("MyIndex"));
        between.addPart(3);
        between.addPart(5);
        SQLGenerator generator = this.getSQLGenerator();
        generator.setLineTerminator("\n");
        String got = generator.getQuery(statement);
        String expect = "SELECT MyIndex, MyName, MyDate FROM MySchema.MyTable WHERE MyIndex BETWEEN 3 AND 5";
        CreateTest.assertEquals((String)expect, (String)got);
    }

    protected Table getComposedKeyTable() {
        Table table = this.getPrimaryKeyTable();
        Column verNumColumn = table.newColumn("VerNum", Column.Type.INTEGER);
        CreateTest.assertTrue((!verNumColumn.isStringColumn() ? 1 : 0) != 0);
        CreateTest.assertTrue((!verNumColumn.isBinaryColumn() ? 1 : 0) != 0);
        Index index = table.getPrimaryKey();
        index.addColumn("VerNum");
        return table;
    }

    public void testComposedPrimaryKey() {
        Table table = this.getComposedKeyTable();
        SelectStatement statement = table.getSelectStatement();
        statement.getWhere().addColumnSetQuery(table.getPrimaryKey(), statement.getTableReference());
        SQLGenerator generator = this.getSQLGenerator();
        generator.setLineTerminator("\n");
        String s = generator.getQuery(statement);
        CreateTest.assertEquals((String)"SELECT MyIndex, MyName, MyDate, VerNum FROM MySchema.MyTable WHERE (MyIndex=? AND VerNum=?)", (String)s);
    }

    public void testIndexNames() {
        SQLGenerator gen = this.getSQLGenerator();
        Table table = this.getBasicTable();
        for (int i = 0; i < 10; ++i) {
            Index index = table.newIndex();
            index.addColumn("MyName");
            String s = (String)gen.getCreate(index).iterator().next();
            CreateTest.assertEquals((String)("CREATE INDEX MyTable_I" + i + " ON MySchema.MyTable (MyName)"), (String)s);
        }
        Collection coll = gen.getCreate(this.schema, true);
        String[] cmds = coll.toArray(new String[coll.size()]);
        CreateTest.assertEquals((int)12, (int)cmds.length);
        CreateTest.assertEquals((String)"CREATE SCHEMA MySchema", (String)cmds[0]);
        CreateTest.assertEquals((String)"CREATE TABLE MySchema.MyTable (  MyIndex INT NOT NULL,  MyName VARCHAR(60) NOT NULL,  MyDate DATE)", (String)cmds[1]);
        for (int i = 0; i < 10; ++i) {
            CreateTest.assertEquals((String)("CREATE INDEX MyTable_I" + i + " ON MySchema.MyTable (MyName)"), (String)cmds[i + 2]);
        }
    }

    public void testSubSelect() {
        SQLGenerator gen = this.getSQLGenerator();
        Table table = this.getComposedKeyTable();
        Table otherTable = table.getSchema().newTable("OtherTable");
        Column otherIndex = otherTable.newColumn("MyIndex", Column.Type.INTEGER);
        otherTable.newPrimaryKey().addColumn(otherIndex);
        ForeignKey foreignKey = otherTable.newForeignKey(table);
        SelectStatement selectStatement = this.sqlFactory.newSelectStatement();
        selectStatement.setTable(otherTable);
        DeleteStatement deleteStatement = this.sqlFactory.newDeleteStatement();
        deleteStatement.setTable(table);
        ArrayList<ColumnReference> columns = new ArrayList<ColumnReference>();
        Iterator iter = table.getColumns();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            Column refColumn = otherTable.newColumn("Ref" + column.getName(), column.getType());
            foreignKey.addColumnLink(refColumn, column);
            if (!column.isPrimaryKeyPart()) continue;
            selectStatement.addResultColumn(selectStatement.getTableReference().newColumnReference(refColumn));
            columns.add(deleteStatement.getTableReference().newColumnReference(column));
        }
        BooleanConstraint eq = selectStatement.getWhere().createEQ();
        eq.addPart(selectStatement.getTableReference().newColumnReference("RefMyName"));
        eq.addPlaceholder();
        BooleanConstraint bc = deleteStatement.getWhere().createIN();
        bc.addPart(columns.toArray(new ColumnReference[columns.size()]));
        bc.addPart(selectStatement);
        String expect = "DELETE FROM MySchema.MyTable WHERE (MyTable.MyIndex, VerNum) IN ((SELECT RefMyIndex, RefVerNum FROM MySchema.OtherTable WHERE RefMyName=?))";
        String got = gen.getQuery(deleteStatement);
        CreateTest.assertEquals((String)expect, (String)got);
    }

    public void testVirtualColumn() {
        Table table = this.getBasicTable();
        SelectStatement selectStatement = table.getSelectStatement();
        VirtualColumn col = new VirtualColumn("virtCol", Column.Type.VARCHAR);
        selectStatement.addResultColumn(col);
        col.setValue("null");
        SQLGenerator gen = this.getSQLGenerator();
        String query = gen.getQuery(selectStatement);
        CreateTest.assertEquals((String)"SELECT MyIndex, MyName, MyDate, null AS virtCol FROM MySchema.MyTable", (String)query);
    }

    public void testNOT() {
        Table table = this.getBasicTable();
        SelectStatement selectStatement = table.getSelectStatement();
        SelectTableReference ref = selectStatement.getSelectTableReference();
        CombinedConstraint and = selectStatement.getWhere();
        BooleanConstraint bc = and.createLIKE();
        bc.addPart(ref.newColumnReference("MyName"));
        bc.addPart("%a%");
        CombinedConstraint or = and.createOrConstraint();
        or.setNOT(true);
        bc = or.createEQ();
        bc.addPart(ref.newColumnReference("MyIndex"));
        bc.addPart(1);
        SQLGenerator gen = this.getSQLGenerator();
        String query = gen.getQuery(selectStatement);
        CreateTest.assertEquals((String)"SELECT MyIndex, MyName, MyDate FROM MySchema.MyTable WHERE (MyName LIKE '%a%' AND NOT (MyIndex=1))", (String)query);
        bc = or.createEQ();
        bc.addPart(ref.newColumnReference("MyIndex"));
        bc.addPart(2);
        query = gen.getQuery(selectStatement);
        CreateTest.assertEquals((String)"SELECT MyIndex, MyName, MyDate FROM MySchema.MyTable WHERE (MyName LIKE '%a%' AND (NOT (MyIndex=1 OR MyIndex=2)))", (String)query);
    }

    public void testExpressions() {
        Table t = this.getBasicTable();
        SelectStatement st = t.getSelectStatement();
        SelectTableReference ref = st.getSelectTableReference();
        BooleanConstraint bc = st.getWhere().createGT();
        Expression e1 = bc.createSUM();
        e1.addPart(ref.newColumnReference("MyIndex"));
        e1.addPart(3);
        Expression e2 = bc.createSUM();
        e2.addPart(5);
        SQLGenerator gen = this.getSQLGenerator();
        String got = gen.getQuery(st);
        String expect = "SELECT MyIndex, MyName, MyDate FROM MySchema.MyTable WHERE (MyIndex+3)>5";
        CreateTest.assertEquals((String)expect, (String)got);
    }
}

