/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.tools.ant.Task;
import org.apache.ws.jaxme.logging.Logger;

public class AntProjectLogger
implements Logger {
    private final String cName;
    private final Task task;

    public AntProjectLogger(String pName, Task pTask) {
        this.cName = pName;
        this.task = pTask;
    }

    public boolean isFinestEnabled() {
        return true;
    }

    public boolean isFinerEnabled() {
        return true;
    }

    public boolean isFineEnabled() {
        return true;
    }

    public boolean isInfoEnabled() {
        return true;
    }

    public boolean isWarnEnabled() {
        return true;
    }

    public boolean isErrorEnabled() {
        return true;
    }

    protected String asString(Object[] pDetails) {
        if (pDetails == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < pDetails.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(pDetails[i]);
        }
        return sb.toString();
    }

    protected void log(int pLevel, String mName, String pMsg) {
        this.task.log(this.cName + "." + mName + ": " + pMsg, pLevel);
    }

    public void entering(String mName, Object[] pDetails) {
        this.log(3, mName, "-> " + this.asString(pDetails));
    }

    public void entering(String mName) {
        this.log(3, mName, "->");
    }

    public void entering(String mName, Object pDetails) {
        this.log(3, mName, "-> " + pDetails);
    }

    public void exiting(String mName, Object[] pDetails) {
        this.log(3, mName, "<- " + this.asString(pDetails));
    }

    public void exiting(String mName) {
        this.log(3, mName, "<-");
    }

    public void exiting(String mName, Object pDetails) {
        this.log(3, mName, "<- " + pDetails);
    }

    public void throwing(String mName, Throwable pThrowable) {
        StringWriter sw = new StringWriter();
        pThrowable.printStackTrace(new PrintWriter(sw));
        this.error(mName, sw.toString());
    }

    public void finest(String mName, String pMsg, Object[] pDetails) {
        this.finest(mName, pMsg + ", " + this.asString(pDetails));
    }

    public void finest(String mName, String pMsg) {
        this.log(4, mName, pMsg);
    }

    public void finest(String mName, String pMsg, Object pDetails) {
        this.finest(mName, pMsg + ", " + pDetails);
    }

    public void finer(String mName, String pMsg, Object[] pDetails) {
        this.finer(mName, pMsg + ", " + this.asString(pDetails));
    }

    public void finer(String mName, String pMsg) {
        this.log(4, mName, pMsg);
    }

    public void finer(String mName, String pMsg, Object pDetails) {
        this.finer(mName, pMsg + ", " + pDetails);
    }

    public void fine(String mName, String pMsg, Object[] pDetails) {
        this.fine(mName, pMsg + ", " + this.asString(pDetails));
    }

    public void fine(String mName, String pMsg) {
        this.log(3, mName, pMsg);
    }

    public void fine(String mName, String pMsg, Object pDetails) {
        this.fine(mName, pMsg + ", " + pDetails);
    }

    public void info(String mName, String pMsg, Object[] pDetails) {
        this.info(mName, pMsg + ", " + this.asString(pDetails));
    }

    public void info(String mName, String pMsg) {
        this.log(2, mName, pMsg);
    }

    public void info(String mName, String pMsg, Object pDetails) {
        this.info(mName, pMsg + ", " + pDetails);
    }

    public void warn(String mName, String pMsg, Object[] pDetails) {
        this.warn(mName, pMsg + ", " + this.asString(pDetails));
    }

    public void warn(String mName, String pMsg) {
        this.log(1, mName, pMsg);
    }

    public void warn(String mName, String pMsg, Object pDetails) {
        this.warn(mName, pMsg + ", " + pDetails);
    }

    public void error(String mName, String pMsg, Object[] pDetails) {
        this.error(mName, pMsg + ", " + this.asString(pDetails));
    }

    public void error(String mName, String pMsg) {
        this.log(0, mName, pMsg);
    }

    public void error(String mName, String pMsg, Object pDetails) {
        this.error(mName, pMsg + ", " + pDetails);
    }
}

