/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owlx.examples;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.KnowledgeBase;
import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class FormInStandAloneApplicationExample {
    public static void main(String[] stringArray) {
        JFileChooser jFileChooser = ComponentFactory.createFileChooser((String)"Project Files", (String)".pprj");
        if (jFileChooser.showOpenDialog(null) == 0) {
            File file = jFileChooser.getSelectedFile();
            ArrayList arrayList = new ArrayList();
            Project project = Project.loadProjectFromFile((String)file.getAbsolutePath(), arrayList);
            if (!arrayList.isEmpty()) {
                JOptionPane.showMessageDialog(null, "Could not load " + file, "Error", 0);
                return;
            }
            KnowledgeBase knowledgeBase = project.getKnowledgeBase();
            if (!(knowledgeBase instanceof OWLModel)) {
                JOptionPane.showMessageDialog(null, "This is not an OWL project.", "Error", 0);
                return;
            }
            OWLModel oWLModel = (OWLModel)knowledgeBase;
            RDFResource rDFResource = ProtegeUI.getSelectionDialogFactory().selectResourceByType(null, oWLModel, Collections.singleton(oWLModel.getOWLThingClass()));
            if (rDFResource != null) {
                FormInStandAloneApplicationExample.editResourceInForm(rDFResource);
            } else {
                System.exit(0);
            }
        } else {
            System.exit(0);
        }
    }

    private static void handleClose(OWLModel oWLModel) {
        if (JOptionPane.showConfirmDialog(null, "Do you want to save your changes?", "Confirm Save", 0) == 0) {
            ArrayList arrayList = new ArrayList();
            oWLModel.getProject().save(arrayList);
            if (!arrayList.isEmpty()) {
                ProtegeUI.getModalDialogFactory().showErrorMessageDialog(oWLModel, "Could not save project.");
            }
        }
        System.exit(0);
    }

    private static void editResourceInForm(final RDFResource rDFResource) {
        Project project = rDFResource.getProject();
        JFrame jFrame = project.show((Instance)rDFResource);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent windowEvent) {
                FormInStandAloneApplicationExample.handleClose(rDFResource.getOWLModel());
            }
        });
    }
}

