/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.writer.rdfxml.renderer;

import edu.stanford.smi.protege.util.Log;
import edu.stanford.smi.protegex.owl.model.OWLAllValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLCardinality;
import edu.stanford.smi.protegex.owl.model.OWLComplementClass;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLEnumeratedClass;
import edu.stanford.smi.protegex.owl.model.OWLHasValue;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLIntersectionClass;
import edu.stanford.smi.protegex.owl.model.OWLMaxCardinality;
import edu.stanford.smi.protegex.owl.model.OWLMinCardinality;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.OWLSomeValuesFrom;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFIndividual;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSNamedClass;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.visitor.OWLModelVisitorAdapter;
import edu.stanford.smi.protegex.owl.writer.rdfxml.util.Util;
import edu.stanford.smi.protegex.owl.writer.xml.XMLWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Level;

public class RDFAxiomRenderer
extends OWLModelVisitorAdapter {
    private XMLWriter writer;
    private RDFResource resource;
    private TripleStore tripleStore;

    public RDFAxiomRenderer(RDFResource rDFResource, TripleStore tripleStore, XMLWriter xMLWriter) {
        this.writer = xMLWriter;
        this.tripleStore = tripleStore;
        this.resource = rDFResource;
    }

    protected RDFAxiomRenderer() {
    }

    public static RenderableAxiomsChecker getChecker() {
        return new RDFAxiomRenderer().new RenderableAxiomsChecker();
    }

    public void write() {
        this.resource.accept(this);
    }

    public void visitOWLAllValuesFrom(OWLAllValuesFrom oWLAllValuesFrom) {
        this.renderClassAxioms(oWLAllValuesFrom);
    }

    public void visitOWLCardinality(OWLCardinality oWLCardinality) {
        this.renderClassAxioms(oWLCardinality);
    }

    public void visitOWLComplementClass(OWLComplementClass oWLComplementClass) {
        this.renderClassAxioms(oWLComplementClass);
    }

    public void visitOWLEnumeratedClass(OWLEnumeratedClass oWLEnumeratedClass) {
        this.renderClassAxioms(oWLEnumeratedClass);
    }

    public void visitOWLHasValue(OWLHasValue oWLHasValue) {
        this.renderClassAxioms(oWLHasValue);
    }

    public void visitOWLIntersectionClass(OWLIntersectionClass oWLIntersectionClass) {
        this.renderClassAxioms(oWLIntersectionClass);
    }

    public void visitOWLMaxCardinality(OWLMaxCardinality oWLMaxCardinality) {
        this.renderClassAxioms(oWLMaxCardinality);
    }

    public void visitOWLMinCardinality(OWLMinCardinality oWLMinCardinality) {
        this.renderClassAxioms(oWLMinCardinality);
    }

    public void visitOWLSomeValuesFrom(OWLSomeValuesFrom oWLSomeValuesFrom) {
        this.renderClassAxioms(oWLSomeValuesFrom);
    }

    public void visitOWLUnionClass(OWLUnionClass oWLUnionClass) {
        this.renderClassAxioms(oWLUnionClass);
    }

    public void visitOWLDatatypeProperty(OWLDatatypeProperty oWLDatatypeProperty) {
        this.renderPropertyAxioms(oWLDatatypeProperty);
    }

    public void visitOWLIndividual(OWLIndividual oWLIndividual) {
        this.renderIndividualAxioms(oWLIndividual);
    }

    public void visitOWLNamedClass(OWLNamedClass oWLNamedClass) {
        this.renderClassAxioms(oWLNamedClass);
    }

    public void visitOWLObjectProperty(OWLObjectProperty oWLObjectProperty) {
        this.renderPropertyAxioms(oWLObjectProperty);
    }

    public void visitRDFIndividual(RDFIndividual rDFIndividual) {
        this.renderIndividualAxioms(rDFIndividual);
    }

    public void visitRDFProperty(RDFProperty rDFProperty) {
        this.renderPropertyAxioms(rDFProperty);
    }

    public void visitRDFSNamedClass(RDFSNamedClass rDFSNamedClass) {
        this.renderClassAxioms(rDFSNamedClass);
    }

    private void renderClassAxioms(RDFSClass rDFSClass) {
        try {
            RDFResource rDFResource;
            RDFResource rDFResource2 = Util.getType(rDFSClass, this.tripleStore);
            if (rDFResource2 != null) {
                Util.insertResourceAsElement(rDFResource2, this.writer);
            } else {
                this.writer.writeStartElement("rdf:Description");
            }
            Util.insertIDOrAboutAttribute(rDFSClass, this.tripleStore, this.writer);
            this.renderTypes(rDFSClass, rDFResource2);
            HashSet<RDFResource> hashSet = new HashSet<RDFResource>();
            HashSet<RDFResource> hashSet2 = new HashSet<RDFResource>();
            RDFProperty rDFProperty = rDFSClass.getOWLModel().getRDFProperty("owl:equivalentClass");
            Iterator iterator = this.tripleStore.listObjects(rDFSClass, rDFProperty);
            while (iterator.hasNext()) {
                rDFResource = (RDFResource)iterator.next();
                if (rDFResource instanceof OWLNamedClass) {
                    hashSet2.add(rDFResource);
                } else if (rDFResource instanceof OWLIntersectionClass) {
                    for (RDFSClass rDFSClass2 : ((OWLIntersectionClass)rDFResource).getOperands()) {
                        if (!(rDFSClass2 instanceof OWLNamedClass)) continue;
                        hashSet2.add(rDFSClass2);
                    }
                }
                hashSet.add(rDFResource);
                this.writer.writeStartElement("owl:equivalentClass");
                Util.inlineObject(rDFResource, this.tripleStore, this.writer);
                this.writer.writeEndElement();
            }
            int n = 0;
            rDFResource = rDFSClass.getOWLModel().getRDFProperty("rdfs:subClassOf");
            Iterator iterator2 = this.tripleStore.listObjects(rDFSClass, (RDFProperty)rDFResource);
            while (iterator2.hasNext()) {
                boolean bl;
                RDFSClass rDFSClass2;
                rDFSClass2 = (RDFSClass)iterator2.next();
                if (!hashSet.contains(rDFSClass2) && !hashSet2.contains(rDFSClass2) && (!(bl = rDFSClass2.equals(rDFSClass2.getOWLModel().getOWLThingClass())) || bl && iterator2.hasNext() || bl && n > 0)) {
                    this.writer.writeStartElement("rdfs:subClassOf");
                    Util.inlineObject(rDFSClass2, this.tripleStore, this.writer);
                    this.writer.writeEndElement();
                }
                ++n;
            }
            Util.insertProperties(rDFSClass, this.tripleStore, this.writer);
            this.writer.writeEndElement();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    private void renderPropertyAxioms(RDFProperty rDFProperty) {
        try {
            RDFResource rDFResource = Util.getType(rDFProperty, this.tripleStore);
            if (rDFResource != null) {
                Util.insertResourceAsElement(rDFResource, this.writer);
            } else {
                this.writer.writeStartElement("rdf:Description");
            }
            Util.insertIDOrAboutAttribute(rDFProperty, this.tripleStore, this.writer);
            this.renderTypes(rDFProperty, rDFResource);
            RDFSClass rDFSClass = rDFProperty.getDomain(false);
            if (rDFSClass != null && !rDFSClass.equals(rDFProperty.getOWLModel().getOWLThingClass())) {
                this.writer.writeStartElement("rdfs:domain");
                Util.inlineObject(rDFSClass, this.tripleStore, this.writer);
                this.writer.writeEndElement();
            }
            Util.insertProperties(rDFProperty, this.tripleStore, this.writer);
            this.writer.writeEndElement();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    private void renderIndividualAxioms(RDFIndividual rDFIndividual) {
        try {
            RDFResource rDFResource = Util.getType(rDFIndividual, this.tripleStore);
            if (rDFResource != null) {
                Util.insertResourceAsElement(rDFResource, this.writer);
            } else {
                this.writer.writeStartElement("rdf:Description");
            }
            Util.insertIDOrAboutAttribute(rDFIndividual, this.tripleStore, this.writer);
            this.renderTypes(rDFIndividual, rDFResource);
            Util.insertProperties(rDFIndividual, this.tripleStore, this.writer);
            this.writer.writeEndElement();
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Exception caught", iOException);
        }
    }

    private void renderTypes(RDFResource rDFResource, RDFResource rDFResource2) throws IOException {
        Util.renderTypes(rDFResource, this.tripleStore, rDFResource2, this.writer);
    }

    public class RenderableAxiomsChecker
    extends OWLModelVisitorAdapter {
        private boolean renderable;

        public boolean isRenderable(RDFResource rDFResource) {
            this.renderable = false;
            rDFResource.accept(this);
            return this.renderable;
        }

        public void visitOWLAllValuesFrom(OWLAllValuesFrom oWLAllValuesFrom) {
            this.renderable = true;
        }

        public void visitOWLCardinality(OWLCardinality oWLCardinality) {
            this.renderable = true;
        }

        public void visitOWLComplementClass(OWLComplementClass oWLComplementClass) {
            this.renderable = true;
        }

        public void visitOWLDatatypeProperty(OWLDatatypeProperty oWLDatatypeProperty) {
            this.renderable = true;
        }

        public void visitOWLEnumeratedClass(OWLEnumeratedClass oWLEnumeratedClass) {
            this.renderable = true;
        }

        public void visitOWLHasValue(OWLHasValue oWLHasValue) {
            this.renderable = true;
        }

        public void visitOWLIndividual(OWLIndividual oWLIndividual) {
            this.renderable = true;
        }

        public void visitOWLIntersectionClass(OWLIntersectionClass oWLIntersectionClass) {
            this.renderable = true;
        }

        public void visitOWLMaxCardinality(OWLMaxCardinality oWLMaxCardinality) {
            this.renderable = true;
        }

        public void visitOWLMinCardinality(OWLMinCardinality oWLMinCardinality) {
            this.renderable = true;
        }

        public void visitOWLNamedClass(OWLNamedClass oWLNamedClass) {
            this.renderable = true;
        }

        public void visitOWLObjectProperty(OWLObjectProperty oWLObjectProperty) {
            this.renderable = true;
        }

        public void visitOWLSomeValuesFrom(OWLSomeValuesFrom oWLSomeValuesFrom) {
            this.renderable = true;
        }

        public void visitOWLUnionClass(OWLUnionClass oWLUnionClass) {
            this.renderable = true;
        }

        public void visitRDFIndividual(RDFIndividual rDFIndividual) {
            this.renderable = true;
        }

        public void visitRDFProperty(RDFProperty rDFProperty) {
            this.renderable = true;
        }

        public void visitRDFSNamedClass(RDFSNamedClass rDFSNamedClass) {
            this.renderable = true;
        }
    }
}

