/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.widget;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.widget.AbstractSlotWidget;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.components.PropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Component;
import java.util.Collection;

public abstract class AbstractPropertyValuesWidget
extends AbstractSlotWidget {
    private PropertyValuesComponent component;

    protected abstract PropertyValuesComponent createComponent(RDFProperty var1);

    public void initialize() {
        this.component = this.createComponent((RDFProperty)this.getSlot());
        this.add((Component)((Object)this.component));
    }

    public static boolean isInvalid(RDFResource rDFResource, RDFProperty rDFProperty, Collection collection) {
        for (Object object : collection) {
            if (rDFResource.isValidPropertyValue(rDFProperty, object)) continue;
            return true;
        }
        RDFSClass rDFSClass = rDFResource.getRDFType();
        if (rDFSClass instanceof OWLNamedClass) {
            Object object;
            object = (OWLNamedClass)rDFSClass;
            int n = object.getMinCardinality(rDFProperty);
            if (n >= 0 && collection.size() < n) {
                return true;
            }
            int n2 = object.getMaxCardinality(rDFProperty);
            if (n2 >= 0 && collection.size() > n2) {
                return true;
            }
            if (collection.size() == 0 && object.getSomeValuesFrom(rDFProperty) != null) {
                return true;
            }
        }
        return false;
    }

    public void setInstance(Instance instance) {
        RDFResource rDFResource = null;
        if (instance instanceof RDFResource) {
            rDFResource = (RDFResource)instance;
        }
        this.component.setSubject(rDFResource);
        super.setInstance(instance);
    }

    public void setValues(Collection collection) {
        super.setValues(collection);
        this.component.valuesChanged();
    }

    protected void updateBorder(Collection collection) {
        if (OWLUI.isConstraintChecking((OWLModel)this.getKnowledgeBase())) {
            RDFResource rDFResource = (RDFResource)this.getInstance();
            RDFProperty rDFProperty = (RDFProperty)this.getSlot();
            if (rDFResource != null && rDFProperty != null) {
                boolean bl = AbstractPropertyValuesWidget.isInvalid(rDFResource, rDFProperty, collection);
                if (bl) {
                    this.setInvalidValueBorder();
                } else {
                    this.setNormalBorder();
                }
                this.repaint();
            }
        }
    }
}

