/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.triplestore;

import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStore;
import edu.stanford.smi.protegex.owl.model.triplestore.TripleStoreUtil;
import edu.stanford.smi.protegex.owl.repository.Repository;
import edu.stanford.smi.protegex.owl.repository.RepositoryManager;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.table.AbstractTableModel;

class TripleStoreTableModel
extends AbstractTableModel {
    public static final int COL_EDITABLE = 0;
    public static final int COL_ACTIVE = 1;
    public static final int COL_URI = 2;
    public static final int COL_COUNT = 3;
    private OWLModel owlModel;
    public static final String MAIN_FILE_NAME = "<Main File>";

    TripleStoreTableModel(OWLModel oWLModel) {
        this.owlModel = oWLModel;
    }

    public int getColumnCount() {
        return 3;
    }

    public Class getColumnClass(int n) {
        if (n == 1 || n == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    public String getColumnName(int n) {
        if (n == 1) {
            return "Active";
        }
        if (n == 2) {
            return "URI";
        }
        if (n == 0) {
            return "Editable";
        }
        return null;
    }

    public int getRowCount() {
        return this.owlModel.getTripleStoreModel().getTripleStores().size() - 1;
    }

    public int getSelectedTripleStoreRow() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!Boolean.TRUE.equals(this.getValueAt(i, 1))) continue;
            return i;
        }
        return -1;
    }

    TripleStore getTripleStore(int n) {
        return (TripleStore)this.owlModel.getTripleStoreModel().getTripleStores().get(n + 1);
    }

    public Object getValueAt(int n, int n2) {
        TripleStore tripleStore = this.getTripleStore(n);
        String string = tripleStore.getName();
        if (n2 == 1) {
            return tripleStore == this.owlModel.getTripleStoreModel().getActiveTripleStore();
        }
        if (n2 == 2) {
            if (n == 0) {
                return "<Main ontology>";
            }
            return string;
        }
        if (n2 == 0) {
            if (n == 0) {
                return Boolean.TRUE;
            }
            try {
                RepositoryManager repositoryManager = this.owlModel.getRepositoryManager();
                URI uRI = new URI(string);
                Repository repository = repositoryManager.getRepository(uRI);
                if (repository != null) {
                    return repository.isWritable(uRI);
                }
                return Boolean.FALSE;
            }
            catch (URISyntaxException uRISyntaxException) {
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        if (n2 == 1) {
            return Boolean.TRUE.equals(this.getValueAt(n, 0));
        }
        if (n2 == 0) {
            return false;
        }
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 1 && Boolean.TRUE.equals(object)) {
            TripleStore tripleStore = this.getTripleStore(n);
            TripleStoreUtil.switchTripleStore(this.owlModel, tripleStore);
            for (int i = 0; i < this.getRowCount(); ++i) {
                this.fireTableCellUpdated(i, n2);
            }
        }
    }
}

