/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.testing;

import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.testing.OWLTest;
import edu.stanford.smi.protegex.owl.testing.OWLTestResult;
import edu.stanford.smi.protegex.owl.testing.RepairableOWLTest;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.cls.OWLClassesTab;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.individuals.OWLIndividualsTab;
import edu.stanford.smi.protegex.owl.ui.properties.OWLPropertiesTab;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanel;
import edu.stanford.smi.protegex.owl.ui.testing.OWLTestResultsTableModel;
import edu.stanford.smi.protegex.owl.ui.testing.OWLTestResultsTableModelColumns;
import edu.stanford.smi.protegex.owl.ui.testing.OWLTestSettingsPanel;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class OWLTestResultsPanel
extends ResultsPanel
implements OWLTestResultsTableModelColumns {
    private JFileChooser fileChooser;
    private OWLModel owlModel;
    private OWLTestResultsTableModel tableModel;
    private JTable table;
    private Instance testSource;
    private Action repairAction = new AbstractAction("Repair selected item", OWLIcons.getImageIcon("Repair")){

        public void actionPerformed(ActionEvent actionEvent) {
            OWLTestResultsPanel.this.repairSelectedTestResult();
        }
    };
    private Action repairAllAction = new AbstractAction("Repair all repairable items", OWLIcons.getImageIcon("RepairAll")){

        public void actionPerformed(ActionEvent actionEvent) {
            OWLTestResultsPanel.this.repairAllTestResults();
        }
    };
    private Action saveAction = new AbstractAction("Save list to file...", OWLIcons.getImageIcon("TestSave")){

        public void actionPerformed(ActionEvent actionEvent) {
            OWLTestResultsPanel.this.save();
        }
    };
    private Action settingsAction = new AbstractAction("Test settings...", OWLIcons.getTestSettingsIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            OWLTestSettingsPanel.showOWLTestSettingsDialog(OWLTestResultsPanel.this.owlModel);
        }
    };
    private Action viewAction = new AbstractAction("View resource", OWLIcons.getViewIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            OWLTestResultsPanel.this.viewSelectedHostInstance();
        }
    };
    public static MouseListener mouseListener = new MouseAdapter(){

        public void mouseEntered(MouseEvent mouseEvent) {
            AbstractButton abstractButton = this.getButton(mouseEvent);
            abstractButton.setBorderPainted(abstractButton.isEnabled());
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.getButton(mouseEvent).setBorderPainted(false);
        }

        private AbstractButton getButton(MouseEvent mouseEvent) {
            return (AbstractButton)mouseEvent.getSource();
        }
    };

    public OWLTestResultsPanel(OWLModel oWLModel, Collection collection, Instance instance, boolean bl) {
        super(oWLModel);
        this.owlModel = oWLModel;
        this.testSource = instance;
        this.tableModel = new OWLTestResultsTableModel(oWLModel, collection);
        this.table = new JTable(this.tableModel);
        this.table.setRowHeight(this.getFontMetrics(this.getFont()).getHeight());
        this.table.setAutoResizeMode(3);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setShowGrid(false);
        this.table.setRowMargin(0);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                OWLTestResultsPanel.this.enableActions();
            }
        });
        this.table.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)((Object)new ResourceRenderer()));
        this.table.getColumnModel().getColumn(1).setPreferredWidth(60);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(64);
        tableColumn.setMaxWidth(64);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(400);
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && OWLTestResultsPanel.this.viewAction.isEnabled()) {
                    OWLTestResultsPanel.this.viewAction.actionPerformed(null);
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.getViewport().setBackground(this.table.getBackground());
        this.viewAction.setEnabled(false);
        this.repairAction.setEnabled(false);
        this.repairAllAction.setEnabled(true);
        if (bl) {
            this.addButton(this.repairAction);
            this.addButton(this.repairAllAction);
            this.addButton(this.settingsAction);
            this.addButton(this.saveAction);
        }
        this.setCenterComponent(jScrollPane);
    }

    public void dispose() {
        this.tableModel.dispose();
    }

    private void enableActions() {
        int n = this.table.getSelectedRow();
        if (n >= 0) {
            OWLTestResult oWLTestResult = this.tableModel.getOWLTestResult(n);
            OWLTest oWLTest = oWLTestResult.getOWLTest();
            this.repairAction.setEnabled(oWLTest instanceof RepairableOWLTest);
        } else {
            this.repairAction.setEnabled(false);
        }
        this.viewAction.setEnabled(n >= 0);
        this.repairAllAction.setEnabled(n >= 0);
    }

    protected String[] getDisplayTabClassNames(RDFResource rDFResource) {
        if (rDFResource instanceof RDFSClass) {
            return new String[]{OWLClassesTab.class.getName()};
        }
        if (rDFResource instanceof OWLProperty) {
            return new String[]{OWLPropertiesTab.class.getName()};
        }
        return new String[]{OWLIndividualsTab.class.getName()};
    }

    public Icon getIcon() {
        return OWLIcons.getTestIcon();
    }

    public String getTabName() {
        if (this.testSource == null) {
            return "Test Results";
        }
        return "Tests of " + this.testSource.getBrowserText();
    }

    protected OWLTestResultsTableModel getTableModel() {
        return this.tableModel;
    }

    protected JTable getTable() {
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairSelectedTestResult() {
        int n = this.table.getSelectedRow();
        OWLTestResult oWLTestResult = this.tableModel.getOWLTestResult(n);
        RepairableOWLTest repairableOWLTest = (RepairableOWLTest)oWLTestResult.getOWLTest();
        try {
            this.owlModel.beginTransaction("Repair test for " + oWLTestResult.getHost().getBrowserText() + ": " + oWLTestResult.getMessage());
            boolean bl = repairableOWLTest.repair(oWLTestResult);
            if (bl) {
                this.tableModel.removeRow(n);
            }
        }
        catch (Exception exception) {
            OWLUI.handleError(this.owlModel, exception);
        }
        finally {
            this.owlModel.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void repairAllTestResults() {
        int n = this.tableModel.getRowCount();
        for (int i = n - 1; i >= 0; --i) {
            OWLTestResult oWLTestResult = this.tableModel.getOWLTestResult(i);
            OWLTest oWLTest = oWLTestResult.getOWLTest();
            if (!(oWLTest instanceof RepairableOWLTest)) continue;
            try {
                this.owlModel.beginTransaction("Repair test for " + oWLTestResult.getHost().getBrowserText() + ": " + oWLTestResult.getMessage());
                boolean bl = ((RepairableOWLTest)oWLTest).repair(oWLTestResult);
                if (!bl) continue;
                this.tableModel.removeRow(i);
                continue;
            }
            catch (Exception exception) {
                OWLUI.handleError(this.owlModel, exception);
                continue;
            }
            finally {
                this.owlModel.endTransaction();
            }
        }
    }

    private void save() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser(".");
        }
        if (this.fileChooser.showSaveDialog(this) == 0) {
            File file = this.fileChooser.getSelectedFile();
            String string = this.tableModel.saveToFile(file);
            if (string == null) {
                JOptionPane.showMessageDialog(this, "The list has been saved to " + file);
            } else {
                JOptionPane.showMessageDialog(this, "Could not save list:\n" + string, "Error", 0);
            }
        }
    }

    public void setResults(List list) {
        this.tableModel.setItems(list);
    }

    private void viewSelectedHostInstance() {
        int n = this.table.getSelectedRow();
        RDFResource rDFResource = this.tableModel.getSource(n);
        if (rDFResource != null) {
            this.showHostResource(rDFResource);
        }
    }
}

