/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search.finder;

import edu.stanford.smi.protege.model.Frame;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protegex.owl.model.OWLIndividual;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLNamedClass;
import edu.stanford.smi.protegex.owl.model.OWLProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.search.finder.Find;
import edu.stanford.smi.protegex.owl.ui.search.finder.FindResult;
import edu.stanford.smi.protegex.owl.ui.search.finder.SearchListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicFind
implements Find {
    private static final int MAX_MATCHES = -1;
    protected OWLModel owlModel;
    protected Map results = new HashMap();
    protected String string;
    protected int searchType;
    private List listeners;
    private boolean running = false;

    public BasicFind(OWLModel oWLModel, int n) {
        this.owlModel = oWLModel;
        this.searchType = n;
    }

    @Override
    public void startSearch(String string) {
        this.startSearch(string, this.searchType);
    }

    @Override
    public void startSearch(String string, int n) {
        this.notifySearchStarted();
        this.string = string;
        this.searchType = n;
        this.results.clear();
        if (this.string != null && this.string.length() > 0) {
            List list = this.getSearchProperties();
            Object object = list.iterator();
            while (object.hasNext()) {
                this.results.putAll(this.searchOnSlot((Slot)object.next(), this.string, null, this.searchType));
            }
            object = this.owlModel.getDefaultLanguage();
            if (object != null) {
                for (Slot slot : list) {
                    if (slot.equals(this.owlModel.getNameSlot())) continue;
                    this.results.putAll(this.searchOnSlot(slot, this.string, (String)object, this.searchType));
                }
            }
        }
        this.notifySearchComplete();
    }

    @Override
    public void cancelSearch() {
    }

    protected Map searchOnSlot(Slot slot, String string, String string2, int n) {
        HashMap<RDFResource, FindResult> hashMap = new HashMap<RDFResource, FindResult>();
        Collection collection = null;
        String string3 = string;
        switch (n) {
            case 0: {
                string3 = string3 + "*";
            }
            case 3: {
                if (string2 == null) break;
                string3 = "~#" + string2 + " " + string3;
                break;
            }
            case 1: {
                string3 = string3 + "*";
            }
            case 2: {
                string3 = "*" + string3;
            }
        }
        collection = this.owlModel.getMatchingFrames(slot, null, false, string3, -1);
        if (collection != null) {
            for (Frame frame : collection) {
                RDFResource rDFResource;
                FindResult findResult;
                if (!this.isValidFrameToSearch(frame) || (findResult = FindResult.createFindResult(rDFResource = (RDFResource)frame, slot, string)) == null) continue;
                hashMap.put(rDFResource, findResult);
            }
        }
        return hashMap;
    }

    protected List getSearchProperties() {
        ArrayList<Slot> arrayList = new ArrayList<Slot>();
        Collection collection = this.owlModel.getSearchSynonymProperties();
        arrayList.addAll(collection);
        arrayList.add(this.owlModel.getNameSlot());
        Slot slot = this.owlModel.getOWLNamedClassClass().getBrowserSlotPattern().getFirstSlot();
        if (!slot.equals(this.owlModel.getNameSlot()) && !collection.contains(slot)) {
            arrayList.add(slot);
        }
        return arrayList;
    }

    @Override
    public Map<RDFResource, FindResult> getResults() {
        return this.results;
    }

    @Override
    public Set getResultResources() {
        return this.results.keySet();
    }

    @Override
    public int getResultCount() {
        return this.results.size();
    }

    @Override
    public String getSummaryText() {
        if (this.running) {
            return "Searching for \"" + this.string + "\" : (" + this.results.size() + " matches)";
        }
        return "Results for \"" + this.string + "\" : (" + this.results.size() + " matches)";
    }

    @Override
    public String getLastSearch() {
        return this.string;
    }

    @Override
    public String getDescription() {
        return "Find Resource";
    }

    @Override
    public OWLModel getModel() {
        return this.owlModel;
    }

    @Override
    public int getNumSearchProperties() {
        return this.getSearchProperties().size();
    }

    protected boolean isValidFrameToSearch(Frame frame) {
        Class<?> clazz = frame.getClass();
        return OWLNamedClass.class.isAssignableFrom(clazz) || OWLProperty.class.isAssignableFrom(clazz) || OWLIndividual.class.isAssignableFrom(clazz);
    }

    @Override
    public int getSearchType() {
        return this.searchType;
    }

    protected void notifySearchStarted() {
        this.running = true;
        for (SearchListener searchListener : this.listeners) {
            searchListener.searchStartedEvent(this);
            searchListener.searchEvent(this);
        }
        Thread.yield();
    }

    protected void notifyResultsUpdated() {
        for (SearchListener searchListener : this.listeners) {
            searchListener.resultsUpdatedEvent(this.results.size(), this);
            searchListener.searchEvent(this);
        }
        Thread.yield();
    }

    protected void notifySearchComplete() {
        this.running = false;
        for (SearchListener searchListener : this.listeners) {
            searchListener.searchCompleteEvent(this.results.size(), this);
            searchListener.searchEvent(this);
        }
        Thread.yield();
    }

    protected void notifySearchCancelled() {
        for (SearchListener searchListener : this.listeners) {
            searchListener.searchCancelledEvent(this);
            searchListener.searchEvent(this);
        }
        this.running = false;
        Thread.yield();
    }

    @Override
    public void addResultListener(SearchListener searchListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(searchListener);
    }

    @Override
    public boolean removeResultListener(SearchListener searchListener) {
        if (this.listeners != null) {
            return this.listeners.remove(searchListener);
        }
        return false;
    }
}

