/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.search;

import edu.stanford.smi.protegex.owl.model.OWLAnonymousClass;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.event.ModelAdapter;
import edu.stanford.smi.protegex.owl.model.event.ModelListener;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.ResourceRenderer;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.results.ResultsPanel;
import edu.stanford.smi.protegex.owl.ui.search.FindUsage;
import edu.stanford.smi.protegex.owl.ui.search.FindUsageTableModel;
import edu.stanford.smi.protegex.owl.ui.search.FindUsageTableModelColumns;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FindUsagePanel
extends ResultsPanel
implements FindUsageTableModelColumns {
    private ModelListener listener = new ModelAdapter(){

        public void classDeleted(RDFSClass rDFSClass) {
            if (FindUsagePanel.this.searchResource.equals(rDFSClass)) {
                FindUsagePanel.this.close();
            }
        }

        public void individualDeleted(RDFResource rDFResource) {
            if (FindUsagePanel.this.searchResource.equals(rDFResource)) {
                FindUsagePanel.this.close();
            }
        }

        public void propertyDeleted(RDFProperty rDFProperty) {
            if (FindUsagePanel.this.searchResource.equals(rDFProperty)) {
                FindUsagePanel.this.close();
            }
        }
    };
    private OWLModel owlModel;
    private RDFResource searchResource;
    private FindUsageTableModel tableModel;
    private JTable table;
    private Action refreshAction = new AbstractAction("Refresh", OWLIcons.getImageIcon("Refresh")){

        public void actionPerformed(ActionEvent actionEvent) {
            FindUsagePanel.this.refresh();
        }
    };
    private Action viewAction = new AbstractAction("View resource", OWLIcons.getViewIcon()){

        public void actionPerformed(ActionEvent actionEvent) {
            FindUsagePanel.this.viewSelectedHostCls();
        }
    };

    public FindUsagePanel(RDFResource rDFResource, Collection collection) {
        super(rDFResource.getOWLModel());
        this.searchResource = rDFResource;
        this.owlModel = rDFResource.getOWLModel();
        this.owlModel.addModelListener(this.listener);
        this.tableModel = new FindUsageTableModel(this.owlModel, collection);
        this.table = new JTable(this.tableModel);
        this.table.setRowHeight(this.getFontMetrics(this.getFont()).getHeight());
        this.table.setAutoResizeMode(3);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setShowGrid(false);
        this.table.setRowMargin(0);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FindUsagePanel.this.enableActions();
            }
        });
        this.updateColumns();
        this.table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && FindUsagePanel.this.viewAction.isEnabled()) {
                    FindUsagePanel.this.viewAction.actionPerformed(null);
                }
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                TableColumnModel tableColumnModel = jTableHeader.getColumnModel();
                int n2 = tableColumnModel.getColumn(n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX())).getModelIndex();
                if (n2 != -1) {
                    FindUsagePanel.this.tableModel.setSortColumn(n2);
                    FindUsagePanel.this.updateColumns();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.getViewport().setBackground(this.table.getBackground());
        this.viewAction.setEnabled(false);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(new JLabel("Usage of "));
        JLabel jLabel = new JLabel(rDFResource.getBrowserText());
        jLabel.setIcon(ProtegeUI.getIcon(rDFResource));
        jPanel.add(jLabel);
        this.addButton(this.refreshAction);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add("North", jPanel);
        jPanel2.add("Center", jScrollPane);
        this.setCenterComponent(jPanel2);
    }

    public static FindUsagePanel create(RDFResource rDFResource) {
        Collection collection = FindUsage.getItems(rDFResource);
        return new FindUsagePanel(rDFResource, collection);
    }

    public void dispose() {
        this.owlModel.removeModelListener(this.listener);
        this.tableModel.dispose();
    }

    private void enableActions() {
        this.viewAction.setEnabled(this.table.getSelectedRow() >= 0);
    }

    public Icon getIcon() {
        return OWLIcons.getFindUsageIcon();
    }

    public String getTabName() {
        return "Usage of " + this.searchResource.getBrowserText();
    }

    private void refresh() {
        this.tableModel.setItems(FindUsage.getItems(this.searchResource));
    }

    private void updateColumns() {
        this.table.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)((Object)new ResourceRenderer()));
        this.table.getColumnModel().getColumn(2).setCellRenderer((TableCellRenderer)((Object)new ResourceRenderer()));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(60);
        TableColumn tableColumn = this.table.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(64);
        tableColumn.setMaxWidth(64);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(300);
    }

    private void viewSelectedHostCls() {
        int n = this.table.getSelectedRow();
        RDFResource rDFResource = this.tableModel.getUsage(n);
        if (rDFResource instanceof OWLAnonymousClass) {
            this.showHostResource(rDFResource);
        } else {
            RDFResource rDFResource2 = this.tableModel.getHost(n);
            this.showHostResource(rDFResource2);
        }
    }
}

