/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.range;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.ui.FrameComparator;
import edu.stanford.smi.protege.ui.FrameRenderer;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protegex.owl.model.OWLDataRange;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLObjectProperty;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.model.RDFSDatatype;
import edu.stanford.smi.protegex.owl.model.impl.OWLUtil;
import edu.stanford.smi.protegex.owl.ui.menu.preferences.ProtegeSettingsPanel;
import edu.stanford.smi.protegex.owl.ui.properties.range.FacetsPanel;
import edu.stanford.smi.protegex.owl.ui.properties.range.NumericFacetsPanel;
import edu.stanford.smi.protegex.owl.ui.properties.range.OWLDataRangeComponent;
import edu.stanford.smi.protegex.owl.ui.properties.range.StringFacetsPanel;
import edu.stanford.smi.protegex.owl.ui.properties.range.UnionRangeClassesComponent;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class OWLRangeWidget
extends AbstractPropertyWidget {
    private static final String ANY = "Any";
    private UnionRangeClassesComponent classesComponent;
    private JComboBox comboBox;
    private OWLDataRangeComponent dataRangeComponent;
    private FacetsPanel facetsPanel;
    private LabeledComponent lc;
    private JPanel mainPanel;
    private JPanel northPanel;
    private static final String OBJECTS = "Objects";
    private boolean ignore = false;

    public static void addDatatypes(OWLModel oWLModel, Vector vector) {
        vector.add(oWLModel.getXSDboolean());
        vector.add(oWLModel.getXSDfloat());
        vector.add(oWLModel.getXSDint());
        vector.add(oWLModel.getXSDstring());
        List list = new ArrayList(oWLModel.getRDFSDatatypes());
        list.removeAll(vector);
        list = OWLUtil.removeInvisibleResources(list.iterator());
        Collections.sort(list, new FrameComparator());
        vector.add(" ");
        vector.addAll(list);
    }

    private FacetsPanel createFacetsPanel(RDFSDatatype rDFSDatatype) {
        if (rDFSDatatype != null) {
            RDFSDatatype rDFSDatatype2 = rDFSDatatype.getBaseDatatype();
            if (rDFSDatatype2 != null) {
                return this.createFacetsPanel(rDFSDatatype2);
            }
            if (rDFSDatatype.equals(this.getOWLModel().getXSDstring())) {
                return new StringFacetsPanel(this);
            }
            if (rDFSDatatype.isNumericDatatype()) {
                return new NumericFacetsPanel(this);
            }
        }
        return null;
    }

    public void initialize() {
        this.classesComponent = new UnionRangeClassesComponent(this.getOWLModel(), this);
        this.comboBox = new JComboBox();
        this.comboBox.setRenderer(new FrameRenderer());
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OWLRangeWidget.this.handleComboBoxChanged();
            }
        });
        this.northPanel = new JPanel(new BorderLayout());
        this.northPanel.add("North", this.comboBox);
        this.dataRangeComponent = new OWLDataRangeComponent(this);
        this.mainPanel = new JPanel(new BorderLayout(0, 4));
        this.mainPanel.add("North", this.northPanel);
        this.mainPanel.add("Center", this.dataRangeComponent);
        this.lc = new LabeledComponent("Range", (Component)this.mainPanel);
        this.lc.setVerticallyStretchable(true);
        this.add("Center", (Component)this.lc);
    }

    RDFProperty getEditedProperty() {
        return (RDFProperty)this.getEditedResource();
    }

    private void handleComboBoxChanged() {
        Object object = this.comboBox.getSelectedItem();
        if (" ".equals(object)) {
            this.comboBox.setSelectedItem(ANY);
            object = ANY;
        }
        if (ANY.equals(object)) {
            this.setRange(null);
        } else if (OBJECTS.equals(object)) {
            if (this.getEditedProperty().getRange() != null) {
                this.setRange(null);
            }
            this.mainPanel.remove(this.dataRangeComponent);
            this.mainPanel.add("Center", this.classesComponent);
            this.mainPanel.revalidate();
        } else if (object instanceof RDFSDatatype) {
            RDFSDatatype rDFSDatatype = (RDFSDatatype)object;
            if (!rDFSDatatype.equals(this.getEditedProperty().getRange())) {
                this.setRange(rDFSDatatype);
            }
            this.dataRangeComponent.setDatatype(rDFSDatatype);
            if (this.dataRangeComponent.getParent() != this.mainPanel) {
                this.mainPanel.remove(this.classesComponent);
                this.mainPanel.add("Center", this.dataRangeComponent);
                this.mainPanel.revalidate();
            }
        }
        this.updateFacetsPanel();
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return cls.getKnowledgeBase() instanceof OWLModel && slot.getName().equals("rdfs:range");
    }

    private void refillAll() {
        this.refillComboBox();
        this.dataRangeComponent.refill();
        this.classesComponent.refill();
        this.updateFacetsPanel();
    }

    private void refillComboBox() {
        if (this.getEditedResource() instanceof OWLObjectProperty) {
            this.removeAll();
            this.add("Center", this.classesComponent);
        } else if (this.getEditedResource() instanceof RDFProperty) {
            this.add("Center", (Component)this.lc);
            Vector<String> vector = new Vector<String>();
            OWLModel oWLModel = this.getOWLModel();
            vector.add(ANY);
            if (!(this.getEditedResource() instanceof OWLDatatypeProperty)) {
                vector.add(OBJECTS);
            }
            OWLRangeWidget.addDatatypes(oWLModel, vector);
            this.comboBox.setModel(new DefaultComboBoxModel(vector));
            this.selectComboBoxValue();
            this.dataRangeComponent.setEditable(!ANY.equals(this.comboBox.getSelectedItem()) && this.getEditedProperty().isEditable());
        }
    }

    private void selectComboBoxValue() {
        RDFProperty rDFProperty = (RDFProperty)this.getEditedResource();
        if (rDFProperty != null) {
            this.ignore = true;
            this.selectComboBoxValue(rDFProperty);
            this.ignore = false;
        }
    }

    private void selectComboBoxValue(RDFProperty rDFProperty) {
        RDFResource rDFResource = rDFProperty.getRange();
        if (rDFResource instanceof RDFSDatatype) {
            RDFSDatatype rDFSDatatype = (RDFSDatatype)rDFResource;
            if (rDFSDatatype.getBaseDatatype() != null) {
                rDFSDatatype = rDFSDatatype.getBaseDatatype();
            }
            this.comboBox.setSelectedItem(rDFSDatatype);
        } else if (rDFResource instanceof OWLDataRange) {
            RDFSDatatype rDFSDatatype = ((OWLDataRange)rDFResource).getRDFDatatype();
            if (rDFSDatatype != null && !rDFSDatatype.equals(this.comboBox.getSelectedItem())) {
                this.comboBox.setSelectedItem(rDFSDatatype);
            }
        } else if (rDFResource instanceof RDFSClass) {
            this.comboBox.setSelectedItem(OBJECTS);
        } else if (rDFResource == null && rDFProperty.getSuperpropertyCount() > 0) {
            RDFProperty rDFProperty2 = rDFProperty.getFirstSuperproperty();
            this.selectComboBoxValue(rDFProperty2);
        }
    }

    public void setEditable(boolean bl) {
        this.dataRangeComponent.setEditable(bl);
        this.classesComponent.setEditable(bl);
        this.comboBox.setEnabled(bl);
        if (this.facetsPanel != null) {
            this.facetsPanel.setEditable(bl);
        }
    }

    public void setInstance(Instance instance) {
        super.setInstance(instance);
        this.refillAll();
    }

    void setRange(RDFSDatatype rDFSDatatype) {
        RDFResource rDFResource;
        if (!(this.ignore || (rDFResource = this.getEditedProperty().getRange()) != null && rDFResource.equals(rDFSDatatype))) {
            if (rDFResource instanceof RDFSDatatype && rDFResource.isAnonymous()) {
                rDFResource.delete();
            }
            this.getEditedProperty().setRange(rDFSDatatype);
        }
    }

    public void setValues(Collection collection) {
        this.refillAll();
    }

    private void updateFacetsPanel() {
        if (ProtegeSettingsPanel.isUserDefinedDatatypesSupported(this.getOWLModel())) {
            RDFResource rDFResource = this.getEditedProperty().getRange();
            if (this.facetsPanel != null) {
                this.northPanel.remove(this.facetsPanel);
                this.mainPanel.revalidate();
            }
            if (rDFResource instanceof RDFSDatatype) {
                RDFSDatatype rDFSDatatype = (RDFSDatatype)rDFResource;
                this.facetsPanel = this.createFacetsPanel(rDFSDatatype);
                if (this.facetsPanel != null) {
                    this.northPanel.add("South", this.facetsPanel);
                    this.mainPanel.revalidate();
                    this.facetsPanel.update(rDFSDatatype);
                }
            }
        }
    }
}

