/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.properties.domain;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Instance;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.util.AllowableAction;
import edu.stanford.smi.protege.util.Selectable;
import edu.stanford.smi.protege.util.SelectionEvent;
import edu.stanford.smi.protege.util.SelectionListener;
import edu.stanford.smi.protege.util.ViewAction;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLUnionClass;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFSClass;
import edu.stanford.smi.protegex.owl.ui.OWLLabeledComponent;
import edu.stanford.smi.protegex.owl.ui.icons.OWLIcons;
import edu.stanford.smi.protegex.owl.ui.properties.domain.AddClassToDomainAction;
import edu.stanford.smi.protegex.owl.ui.properties.domain.OWLDomainTable;
import edu.stanford.smi.protegex.owl.ui.properties.domain.OWLDomainTableModel;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import edu.stanford.smi.protegex.owl.ui.widget.WidgetUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class OWLDomainWidget
extends AbstractPropertyWidget {
    private AddClassToDomainAction addAction;
    private AllowableAction removeAction;
    private OWLDomainTable table;
    private OWLDomainTableModel tableModel;

    public void initialize() {
        this.tableModel = new OWLDomainTableModel(null);
        this.table = new OWLDomainTable(this.tableModel);
        this.table.addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent selectionEvent) {
                OWLDomainWidget.this.updateActions();
            }
        });
        JScrollPane jScrollPane = new JScrollPane((Component)((Object)this.table));
        JViewport jViewport = jScrollPane.getViewport();
        jViewport.setBackground(this.table.getBackground());
        OWLLabeledComponent oWLLabeledComponent = new OWLLabeledComponent("Domain  \u2294", jScrollPane);
        WidgetUtilities.addViewButton(oWLLabeledComponent, (Action)new ViewAction("View class", (Selectable)this.table){

            public void onView(Object object) {
                OWLDomainWidget.this.getProject().show((Instance)object);
            }
        });
        this.addAction = new AddClassToDomainAction(this);
        this.updateActions();
        oWLLabeledComponent.addHeaderButton(this.addAction);
        this.removeAction = new AllowableAction("Remove from Domain", OWLIcons.getRemoveIcon("PrimitiveClass"), (Selectable)this.table){

            public void actionPerformed(ActionEvent actionEvent) {
                RDFProperty rDFProperty = (RDFProperty)OWLDomainWidget.this.getEditedResource();
                Collection collection = OWLDomainWidget.this.table.getSelection();
                for (RDFSClass rDFSClass : collection) {
                    OWLDomainWidget.this.removeFromDomain(rDFSClass, rDFProperty);
                }
            }

            public void onSelectionChange() {
                Collection collection = OWLDomainWidget.this.table.getSelection();
                boolean bl = false;
                if (!collection.isEmpty()) {
                    RDFProperty rDFProperty = (RDFProperty)OWLDomainWidget.this.getEditedResource();
                    for (RDFSClass rDFSClass : collection) {
                        if (rDFSClass == rDFSClass.getOWLModel().getOWLThingClass() || !rDFProperty.getUnionDomain(false).contains(rDFSClass)) continue;
                        bl = true;
                    }
                }
                this.setAllowed(bl);
            }
        };
        oWLLabeledComponent.addHeaderButton((Action)this.removeAction);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)((Object)oWLLabeledComponent));
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return cls.getKnowledgeBase() instanceof OWLModel && slot.getName().equals(":DIRECT-DOMAIN");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromDomain(RDFSClass rDFSClass, RDFProperty rDFProperty) {
        try {
            this.beginTransaction("Remove " + rDFSClass.getBrowserText() + " from the domain of " + rDFProperty.getBrowserText());
            if (rDFProperty.isDomainDefined()) {
                rDFProperty.removeUnionDomainClass(rDFSClass);
            } else {
                ArrayList arrayList = new ArrayList(rDFProperty.getUnionDomain(true));
                if (arrayList.remove(rDFSClass)) {
                    if (arrayList.size() == 1) {
                        rDFProperty.setDomain((RDFSClass)arrayList.iterator().next());
                    } else {
                        System.out.println("classes = " + arrayList);
                        OWLUnionClass oWLUnionClass = rDFSClass.getOWLModel().createOWLUnionClass(arrayList);
                        rDFProperty.setDomain(oWLUnionClass);
                    }
                }
            }
            rDFProperty.synchronizeDomainAndRangeOfInverse();
        }
        catch (Exception exception) {
            OWLUI.handleError(this.getOWLModel(), exception);
        }
        finally {
            this.endTransaction();
        }
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.addAction.setEnabled(bl);
        this.removeAction.setAllowed(bl);
    }

    public void setInstance(Instance instance) {
        super.setInstance(instance);
        if (instance instanceof RDFProperty) {
            RDFProperty rDFProperty = (RDFProperty)instance;
            this.tableModel.setSlot(rDFProperty);
        } else {
            this.tableModel.setSlot(null);
        }
        this.updateActions();
    }

    public void setValues(Collection collection) {
        super.setValues(collection);
        this.updateActions();
    }

    private void updateActions() {
        RDFProperty rDFProperty = this.tableModel.getSlot();
        boolean bl = rDFProperty != null && rDFProperty.isEditable();
        this.addAction.setEnabled(bl);
    }
}

