/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.projectview;

import edu.stanford.smi.protege.model.Project;
import edu.stanford.smi.protege.model.WidgetDescriptor;
import edu.stanford.smi.protege.resource.Icons;
import edu.stanford.smi.protege.ui.CheckBoxRenderer;
import edu.stanford.smi.protege.ui.ProjectManager;
import edu.stanford.smi.protege.ui.ProjectView;
import edu.stanford.smi.protege.util.AbstractValidatableComponent;
import edu.stanford.smi.protege.util.ComponentFactory;
import edu.stanford.smi.protege.util.ComponentUtilities;
import edu.stanford.smi.protege.util.LabeledComponent;
import edu.stanford.smi.protege.util.StringUtilities;
import edu.stanford.smi.protege.widget.TabWidget;
import edu.stanford.smi.protege.widget.WidgetDescriptorRenderer;
import edu.stanford.smi.protege.widget.WidgetUtilities;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class ConfigureTabsPanel
extends AbstractValidatableComponent {
    private boolean dirty;
    private Project project;
    private ProjectView projectView;
    private JTable table;

    public ConfigureTabsPanel(ProjectView projectView) {
        this.setLayout(new BorderLayout());
        this.projectView = projectView;
        this.project = projectView.getProject();
        this.table = ComponentFactory.createTable((Action)this.getConfigureAction());
        this.table.setModel(this.createTableModel());
        ComponentUtilities.addColumn((JTable)this.table, (TableCellRenderer)((Object)new WidgetDescriptorEnableRenderer()));
        this.table.getColumnModel().getColumn(0).setMaxWidth(50);
        ComponentUtilities.addColumn((JTable)this.table, (TableCellRenderer)new WidgetDescriptorRenderer(this.project));
        this.table.addMouseListener(new ClickListener());
        JScrollPane jScrollPane = ComponentFactory.createScrollPane((JTable)this.table);
        jScrollPane.setColumnHeaderView(this.table.getTableHeader());
        jScrollPane.setBackground(this.table.getBackground());
        LabeledComponent labeledComponent = new LabeledComponent("Tabs", jScrollPane);
        labeledComponent.addHeaderButton((Action)new MoveTabUp());
        labeledComponent.addHeaderButton((Action)new MoveTabDown());
        this.add((Component)labeledComponent);
    }

    private boolean canMoveUp(int n) {
        return n > 0 && this.isEnabled(n);
    }

    private boolean canMoveDown(int n) {
        boolean bl;
        boolean bl2 = bl = 0 <= n && n < this.table.getRowCount() - 1;
        if (bl) {
            bl = this.isEnabled(n) && this.canEnable(n + 1);
        }
        return bl;
    }

    public boolean getRequiresReloadUI() {
        return this.dirty;
    }

    private boolean isEnabled(int n) {
        Boolean bl = (Boolean)this.getTabModel().getValueAt(n, 0);
        return bl;
    }

    private void setEnabled(int n, boolean bl) {
        this.getTabModel().setValueAt(bl, n, 0);
    }

    private boolean isEditable(int n) {
        WidgetDescriptor widgetDescriptor = this.getDescriptor(n);
        ArrayList arrayList = new ArrayList();
        return WidgetUtilities.isSuitableTab((String)widgetDescriptor.getWidgetClassName(), (Project)this.project, arrayList);
    }

    private TableModel createTableModel() {
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        defaultTableModel.addColumn("Visible");
        defaultTableModel.addColumn("Tab Widget");
        boolean bl = true;
        Collection collection = new ArrayList(this.project.getTabWidgetDescriptors());
        collection = this.sort(collection);
        for (WidgetDescriptor widgetDescriptor : collection) {
            if (!bl && !this.canEnable(widgetDescriptor)) continue;
            defaultTableModel.addRow(new Object[]{widgetDescriptor.isVisible(), widgetDescriptor});
        }
        return defaultTableModel;
    }

    private Collection sort(Collection collection) {
        WidgetDescriptor widgetDescriptor;
        ArrayList arrayList = new ArrayList(collection);
        for (int i = 0; i < arrayList.size() && (widgetDescriptor = (WidgetDescriptor)arrayList.get(i)).isVisible(); ++i) {
        }
        Collections.sort(arrayList, new WidgetDescriptorComparator());
        return arrayList;
    }

    private Action getConfigureAction() {
        return new AbstractAction("Configure"){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = ConfigureTabsPanel.this.table.getSelectedRow();
                WidgetDescriptor widgetDescriptor = ConfigureTabsPanel.this.getDescriptor(n);
                if (widgetDescriptor.isVisible()) {
                    TabWidget tabWidget = ProjectManager.getProjectManager().getCurrentProjectView().getTabByClassName(widgetDescriptor.getWidgetClassName());
                    tabWidget.configure();
                }
            }
        };
    }

    private DefaultTableModel getTabModel() {
        return (DefaultTableModel)this.table.getModel();
    }

    public void saveContents() {
        if (this.dirty) {
            ArrayList<WidgetDescriptor> arrayList = new ArrayList<WidgetDescriptor>();
            for (int i = 0; i < this.getTabModel().getRowCount(); ++i) {
                boolean bl = this.isEnabled(i);
                WidgetDescriptor widgetDescriptor = this.getDescriptor(i);
                widgetDescriptor.setVisible(bl);
                arrayList.add(widgetDescriptor);
            }
            this.project.setTabWidgetDescriptorOrder(arrayList);
        }
    }

    public boolean validateContents() {
        return true;
    }

    private boolean canEnable(String string) {
        return WidgetUtilities.isSuitableTab((String)string, (Project)this.project, new ArrayList()) && !OWLUI.isUnsuitableTab(string);
    }

    private WidgetDescriptor getDescriptor(int n) {
        return (WidgetDescriptor)this.getTabModel().getValueAt(n, 1);
    }

    private boolean canEnable(int n) {
        WidgetDescriptor widgetDescriptor = this.getDescriptor(n);
        return this.canEnable(widgetDescriptor);
    }

    private boolean canEnable(WidgetDescriptor widgetDescriptor) {
        return this.canEnable(widgetDescriptor.getWidgetClassName());
    }

    class WidgetDescriptorEnableRenderer
    extends CheckBoxRenderer {
        private final Component EMPTY = new JPanel(){

            public boolean isOpaque() {
                return false;
            }
        };

        WidgetDescriptorEnableRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = ConfigureTabsPanel.this.canEnable(n) ? super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2) : this.EMPTY;
            return component;
        }
    }

    class WidgetDescriptorComparator
    implements Comparator {
        WidgetDescriptorComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            WidgetDescriptor widgetDescriptor = (WidgetDescriptor)object;
            WidgetDescriptor widgetDescriptor2 = (WidgetDescriptor)object2;
            boolean bl = widgetDescriptor.isVisible();
            boolean bl2 = widgetDescriptor2.isVisible();
            if (bl) {
                n = bl2 ? 0 : -1;
            } else {
                int n2 = n = bl2 ? 1 : 0;
            }
            if (!bl && !bl2) {
                String string = widgetDescriptor.getWidgetClassName();
                String string2 = widgetDescriptor2.getWidgetClassName();
                boolean bl3 = ConfigureTabsPanel.this.canEnable(string);
                boolean bl4 = ConfigureTabsPanel.this.canEnable(string2);
                if (bl3) {
                    n = bl4 ? 0 : -1;
                } else {
                    int n3 = n = bl4 ? 1 : 0;
                }
                if (n == 0) {
                    String string3 = StringUtilities.getShortClassName((String)string);
                    String string4 = StringUtilities.getShortClassName((String)string2);
                    n = string3.compareToIgnoreCase(string4);
                }
            }
            return n;
        }
    }

    private class ClickListener
    extends MouseAdapter {
        private ClickListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            Point point = mouseEvent.getPoint();
            int n2 = ConfigureTabsPanel.this.table.columnAtPoint(point);
            if (n2 == 0 && ConfigureTabsPanel.this.isEditable(n = ConfigureTabsPanel.this.table.rowAtPoint(point))) {
                boolean bl = ConfigureTabsPanel.this.isEnabled(n);
                ConfigureTabsPanel.this.setEnabled(n, !bl);
                ConfigureTabsPanel.this.dirty = true;
            }
        }
    }

    private class MoveTabDown
    extends AbstractAction {
        MoveTabDown() {
            super("Move selected tab down", Icons.getDownIcon());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ConfigureTabsPanel.this.table.getSelectedRow();
            if (ConfigureTabsPanel.this.canMoveDown(n)) {
                ConfigureTabsPanel.this.getTabModel().moveRow(n, n, n + 1);
                int n2 = n + 1;
                ConfigureTabsPanel.this.table.getSelectionModel().setSelectionInterval(n2, n2);
                ConfigureTabsPanel.this.dirty = true;
            }
        }
    }

    private class MoveTabUp
    extends AbstractAction {
        MoveTabUp() {
            super("Move selected tab up", Icons.getUpIcon());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = ConfigureTabsPanel.this.table.getSelectedRow();
            if (ConfigureTabsPanel.this.canMoveUp(n)) {
                ConfigureTabsPanel.this.getTabModel().moveRow(n, n, n - 1);
                int n2 = n - 1;
                ConfigureTabsPanel.this.table.getSelectionModel().setSelectionInterval(n2, n2);
                ConfigureTabsPanel.this.dirty = true;
            }
        }
    }
}

