/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadatatab.prefixes;

import edu.stanford.smi.protege.util.Disposable;
import edu.stanford.smi.protegex.owl.jena.Jena;
import edu.stanford.smi.protegex.owl.model.NamespaceManager;
import edu.stanford.smi.protegex.owl.model.NamespaceManagerListener;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.OWLOntology;
import edu.stanford.smi.protegex.owl.model.impl.OWLNamespaceManager;
import edu.stanford.smi.protegex.owl.ui.widget.OWLUI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class PrefixesTableModel
extends AbstractTableModel
implements Disposable {
    private NamespaceManagerListener listener = new NamespaceManagerListener(){

        public void defaultNamespaceChanged(String string, String string2) {
        }

        public void namespaceChanged(String string, String string2, String string3) {
            int n = PrefixesTableModel.this.getPrefixRow(string);
            PrefixesTableModel.this.fireTableCellUpdated(n, 1);
        }

        public void prefixAdded(String string) {
            int n = PrefixesTableModel.this.prefixes.size();
            PrefixesTableModel.this.prefixes.add(string);
            PrefixesTableModel.this.fireTableRowsInserted(n, n);
        }

        public void prefixChanged(String string, String string2, String string3) {
            int n = PrefixesTableModel.this.getPrefixRow(string2);
            if (n >= 0) {
                PrefixesTableModel.this.prefixes.remove(n);
                PrefixesTableModel.this.prefixes.add(n, string3);
                PrefixesTableModel.this.fireTableCellUpdated(n, 0);
            }
        }

        public void prefixRemoved(String string) {
            int n = PrefixesTableModel.this.getPrefixRow(string);
            if (n >= 0) {
                PrefixesTableModel.this.prefixes.remove(n);
                PrefixesTableModel.this.fireTableRowsDeleted(n, n);
            }
        }
    };
    private OWLOntology ontology;
    public static final int COL_PREFIX = 0;
    public static final int COL_NAMESPACE = 1;
    public static final int COL_COUNT = 2;
    private List prefixes = new ArrayList();

    public PrefixesTableModel(OWLOntology oWLOntology) {
        this.ontology = oWLOntology;
        this.getNamespaceManager().addNamespaceManagerListener(this.listener);
        this.fill();
    }

    public void dispose() {
        this.getNamespaceManager().removeNamespaceManagerListener(this.listener);
    }

    private void fill() {
        this.prefixes = new ArrayList(this.getNamespaceManager().getPrefixes());
    }

    public int getColumnCount() {
        return 2;
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    public String getColumnName(int n) {
        if (n == 0) {
            return "Prefix";
        }
        if (n == 1) {
            return "Namespace";
        }
        return null;
    }

    public String getNamespace(int n) {
        String string = this.getPrefix(n);
        return this.getNamespaceManager().getNamespaceForPrefix(string);
    }

    NamespaceManager getNamespaceManager() {
        return this.ontology.getOWLModel().getNamespaceManager();
    }

    public String getPrefix(int n) {
        return (String)this.prefixes.get(n);
    }

    int getPrefixRow(String string) {
        return this.prefixes.indexOf(string);
    }

    public int getRowCount() {
        return this.prefixes.size();
    }

    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.getPrefix(n);
        }
        if (n2 == 1) {
            return this.getNamespace(n);
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        String string = this.getPrefix(n);
        return this.isPrefixEditable(string);
    }

    public boolean isNamespaceEditable(String string) {
        String string2 = this.getNamespaceManager().getPrefix(string);
        return this.isPrefixEditable(string2);
    }

    boolean isPrefixEditable(String string) {
        return this.getNamespaceManager().isModifiable(string);
    }

    public void setValueAt(Object object, int n, int n2) {
        String string;
        NamespaceManager namespaceManager = this.getNamespaceManager();
        if (n2 == 0) {
            String string2 = (String)object;
            if (namespaceManager.getNamespaceForPrefix(string2) == null && OWLNamespaceManager.isValidPrefix(string2)) {
                String string3 = this.getNamespace(n);
                this.setPrefixOfNamespace(string3, string2);
            }
        } else if (n2 == 1 && namespaceManager.getPrefix(string = (String)object) == null && !namespaceManager.getDefaultNamespace().equals(string) && Jena.isNamespaceWithSeparator(string)) {
            String string4 = this.getPrefix(n);
            this.setNamespaceOfPrefix(string4, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNamespaceOfPrefix(String string, String string2) {
        OWLModel oWLModel = this.ontology.getOWLModel();
        try {
            oWLModel.beginTransaction("Change namespace of " + string + " to " + string2);
            oWLModel.getNamespaceManager().setPrefix(string2, string);
        }
        catch (Exception exception) {
            OWLUI.handleError(oWLModel, exception);
        }
        finally {
            oWLModel.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPrefixOfNamespace(String string, String string2) {
        OWLModel oWLModel = this.ontology.getOWLModel();
        try {
            oWLModel.beginTransaction("Change prefix of " + string + " to " + string2);
            oWLModel.getNamespaceManager().setPrefix(string, string2);
        }
        catch (Exception exception) {
            OWLUI.handleError(oWLModel, exception);
        }
        finally {
            oWLModel.endTransaction();
        }
    }
}

