/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.smi.protegex.owl.ui.metadata;

import edu.stanford.smi.protege.model.Cls;
import edu.stanford.smi.protege.model.Facet;
import edu.stanford.smi.protege.model.Slot;
import edu.stanford.smi.protege.widget.ClsWidget;
import edu.stanford.smi.protege.widget.SlotWidget;
import edu.stanford.smi.protegex.owl.model.OWLDatatypeProperty;
import edu.stanford.smi.protegex.owl.model.OWLModel;
import edu.stanford.smi.protegex.owl.model.RDFProperty;
import edu.stanford.smi.protegex.owl.model.RDFResource;
import edu.stanford.smi.protegex.owl.ui.ProtegeUI;
import edu.stanford.smi.protegex.owl.ui.components.PropertyValuesComponent;
import edu.stanford.smi.protegex.owl.ui.components.annotations.AnnotationsComponent;
import edu.stanford.smi.protegex.owl.ui.components.triples.TriplesTableModel;
import edu.stanford.smi.protegex.owl.ui.metadata.AnnotationTextAreaWidget;
import edu.stanford.smi.protegex.owl.ui.metadata.NameDocumentationWidget;
import edu.stanford.smi.protegex.owl.ui.metadata.OWLMetadataWidget;
import edu.stanford.smi.protegex.owl.ui.widget.AbstractPropertyValuesWidget;
import edu.stanford.smi.protegex.owl.ui.widget.OWLWidgetMapper;
import java.awt.Component;

public class AnnotationsWidget
extends AbstractPropertyValuesWidget {
    protected PropertyValuesComponent createComponent(RDFProperty rDFProperty) {
        return new AnnotationsComponent(rDFProperty){

            protected void handleSelectionChanged() {
                super.handleSelectionChanged();
                this.updateTextAreaWidget();
            }

            private void updateTextAreaWidget() {
                ClsWidget clsWidget = AnnotationsWidget.this.getClsWidget();
                if (clsWidget != null) {
                    OWLModel oWLModel = this.getOWLModel();
                    TriplesTableModel triplesTableModel = this.getTableModel();
                    Slot slot = oWLModel.getSlot(":NAME");
                    SlotWidget slotWidget = clsWidget.getSlotWidget(slot);
                    if (slotWidget instanceof OWLMetadataWidget) {
                        NameDocumentationWidget nameDocumentationWidget = ((OWLMetadataWidget)slotWidget).getNameDocumentationWidget();
                        AnnotationTextAreaWidget annotationTextAreaWidget = nameDocumentationWidget.getAnnotationTextAreaWidget();
                        int n = this.getTable().getSelectedRow();
                        if (n >= 0) {
                            RDFResource rDFResource;
                            RDFProperty rDFProperty = triplesTableModel.getPredicate(n);
                            if (rDFProperty instanceof OWLDatatypeProperty && ((rDFResource = rDFProperty.getRange()) == null || oWLModel.getXSDstring().equals(rDFResource) || oWLModel.getRDFXMLLiteralType().equals(rDFResource))) {
                                OWLDatatypeProperty oWLDatatypeProperty = (OWLDatatypeProperty)rDFProperty;
                                String string = triplesTableModel.getLanguage(n);
                                Object object = triplesTableModel.getDisplayValue(n);
                                if (object instanceof String) {
                                    String string2 = (String)object;
                                    annotationTextAreaWidget.setEditedValue(oWLDatatypeProperty, string2, string, triplesTableModel.getValue(n));
                                }
                            }
                        } else {
                            annotationTextAreaWidget.resetEditedValue();
                        }
                    }
                }
            }
        };
    }

    public static void editAnnotations(Component component, RDFResource rDFResource) {
        AnnotationsWidget annotationsWidget = new AnnotationsWidget();
        annotationsWidget.setup(null, false, rDFResource.getProject());
        annotationsWidget.initialize();
        annotationsWidget.setCls(rDFResource.getOWLModel().getOWLThingClass());
        annotationsWidget.setInstance(rDFResource);
        ProtegeUI.getModalDialogFactory().showDialog(component, (Component)((Object)annotationsWidget), "Annotations", 14);
    }

    public static boolean isSuitable(Cls cls, Slot slot, Facet facet) {
        return OWLWidgetMapper.isSuitable(AnnotationsWidget.class, cls, slot);
    }
}

